/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrame;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.model.Local;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CallStackFrameImpl
implements CallStackFrame {
    private CallStackFrame sf;
    private RemoteDebugger debugger;
    private int lineNumber;
    private String func;
    private String file;
    private String fullname;
    private String frameNumber;
    private String address;
    private int state;
    private LocalVariable[] cachedVisibleLocalVariables = null;
    private List cachedLocalVariables = null;

    public CallStackFrameImpl(RemoteDebugger remoteDebugger, String string, String string2, String string3, String string4, String string5) {
        this.debugger = remoteDebugger;
        this.set(string, string2, string3, string4, string5);
        this.frameNumber = null;
    }

    public void set(String string, String string2, String string3, String string4, String string5) {
        this.func = string;
        this.file = string2;
        this.fullname = string3;
        this.address = string5;
        if (string4 != null) {
            try {
                this.lineNumber = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                this.lineNumber = 1;
            }
        } else {
            this.lineNumber = -1;
        }
        this.setState(2);
    }

    public void setFrameNumber(String string) {
        this.frameNumber = string;
    }

    public String getFrameNumber() {
        return this.frameNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public String getFunctionName() {
        return this.func;
    }

    public String getFileName() {
        return this.file;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getAddr() {
        return this.address;
    }

    public void makeCurrent() {
    }

    public void setState(int n) {
        if (n != this.state && (n == 1 || n == 2)) {
            this.state = n;
        }
    }

    public boolean isObsolete() {
        return this.state == 1;
    }

    public void popFrame() {
    }

    public CallStackFrame getStackFrame() {
        return this.sf;
    }

    private List fillLocalVariables(List list) {
        Iterator iterator = list.iterator();
        ArrayList<Local> arrayList = new ArrayList<Local>();
        while (iterator.hasNext()) {
            Local local;
            String string;
            List list2 = (List)iterator.next();
            String string2 = (String)list2.get(0);
            String string3 = (String)list2.get(1);
            if (list2.get(2) instanceof String) {
                string = (String)list2.get(2);
                local = new Local(this.debugger, string2, string3, string, this);
                arrayList.add(local);
                continue;
            }
            string = "#(length=" + ((List)list2.get(2)).size() + ")";
            local = new Local(this.debugger, string2, string3, string, this);
            List list3 = this.fillLocalVariables((List)list2.get(2));
            for (int i = 0; i < list3.size(); ++i) {
                local.addField((Local)list3.get(i));
            }
            arrayList.add(local);
        }
        return arrayList;
    }

    public LocalVariable[] getLocalVariables() {
        List list = this.debugger.getLocalVariables();
        if (list == null) {
            this.cachedLocalVariables = list;
            return new LocalVariable[0];
        }
        int n = list.size();
        boolean bl = false;
        if (this.cachedVisibleLocalVariables != null && this.cachedLocalVariables == list) {
            return this.cachedVisibleLocalVariables;
        }
        List list2 = this.fillLocalVariables(list);
        LocalVariable[] localVariableArray = list2.toArray(new LocalVariable[0]);
        this.cachedVisibleLocalVariables = localVariableArray;
        this.cachedLocalVariables = list;
        return localVariableArray;
    }

    public LocalVariable[] visibleVariables() {
        if (this.cachedVisibleLocalVariables != null) {
            return this.cachedVisibleLocalVariables;
        }
        return new LocalVariable[0];
    }
}

