/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointAnnotationListener;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class RemoteBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private RemoteDebugger debugger;
    private BreakpointAnnotationListener breakpointAnnotationListener;

    public RemoteBreakpointActionProvider() {
        EditorContextBridge.getContext().addPropertyChangeListener(this);
    }

    public RemoteBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (RemoteDebugger)contextProvider.lookupFirst(null, RemoteDebugger.class);
        EditorContextBridge.getContext().addPropertyChangeListener(this);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentURL();
        if (string.trim().equals("")) {
            return;
        }
        RemoteBreakpoint remoteBreakpoint = this.getBreakpointAnnotationListener().findBreakpoint(string, n);
        if (remoteBreakpoint != null) {
            debuggerManager.removeBreakpoint((Breakpoint)remoteBreakpoint);
            return;
        }
        remoteBreakpoint = LineBreakpoint.create(string, n);
        remoteBreakpoint.setPrintText(NbBundle.getBundle((Class)RemoteBreakpointActionProvider.class).getString("CTL_Line_Breakpoint_Print_Text"));
        debuggerManager.addBreakpoint((Breakpoint)remoteBreakpoint);
    }

    private BreakpointAnnotationListener getBreakpointAnnotationListener() {
        if (this.breakpointAnnotationListener == null) {
            this.breakpointAnnotationListener = (BreakpointAnnotationListener)((Object)DebuggerManager.getDebuggerManager().lookupFirst(null, BreakpointAnnotationListener.class));
        }
        return this.breakpointAnnotationListener;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentMIMEType();
        boolean bl = string.startsWith("text/x-hp+openvms");
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }
}

