/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointEvent;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointListener;
import com.hp.openvms.netbeans.debugsupport.model.BreakpointsNodeModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeModel;

public class BreakpointOutput
extends LazyActionsManagerListener
implements DebuggerManagerListener,
RemoteBreakpointListener,
PropertyChangeListener {
    private static final Pattern backslashEscapePattern = Pattern.compile("\\\\");
    private static final Pattern threadNamePattern = Pattern.compile("\\{threadName\\}");
    private static final Pattern fileNamePattern = Pattern.compile("\\{fileName\\}");
    private static final Pattern functionNamePattern = Pattern.compile("\\{functionName\\}");
    private static final Pattern lineNumberPattern = Pattern.compile("\\{lineNumber\\}");
    private static final Pattern expressionPattern = Pattern.compile("\\{=(.*?)\\}");
    private RemoteDebugger debugger;
    private ContextProvider contextProvider;
    private Object lock = new Object();
    private BreakpointsNodeModel breakpointsNodeModel;

    public BreakpointOutput(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (RemoteDebugger)contextProvider.lookupFirst(null, RemoteDebugger.class);
        this.debugger.addPropertyChangeListener("state", this);
        this.hookBreakpoints();
        DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.unhookBreakpoints();
        Object object = this.lock;
        synchronized (object) {
            this.debugger = null;
        }
    }

    public String[] getProperties() {
        return new String[]{"actionPerformed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointReached(RemoteBreakpointEvent remoteBreakpointEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (remoteBreakpointEvent.getDebugger() != this.debugger) {
                return;
            }
        }
        if (remoteBreakpointEvent.getConditionResult() == 2) {
            return;
        }
        object = (RemoteBreakpoint)((Object)remoteBreakpointEvent.getSource());
        this.getBreakpointsNodeModel().setCurrentBreakpoint((RemoteBreakpoint)((Object)object));
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.hookBreakpoint(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.unhookBreakpoint(breakpoint);
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block6: {
            Object object = this.lock;
            synchronized (object) {
                block5: {
                    if (this.debugger == null) break block5;
                    if (propertyChangeEvent.getPropertyName() != "state") break block5;
                    if (this.debugger.getState() == "state_running") break block6;
                }
                return;
            }
        }
        this.getBreakpointsNodeModel().setCurrentBreakpoint(null);
    }

    private String substitute(String string, RemoteBreakpointEvent remoteBreakpointEvent) {
        Object object;
        Object object2 = remoteBreakpointEvent.getSource();
        if (object2 instanceof LineBreakpoint) {
            object = (LineBreakpoint)((Object)object2);
            String string2 = this.basename(((LineBreakpoint)((Object)object)).getURL());
            String string3 = Integer.toString(((LineBreakpoint)((Object)object)).getLineNumber());
            string = fileNamePattern.matcher(string).replaceAll(string2);
            string = lineNumberPattern.matcher(string).replaceAll(string3);
        } else {
            string = fileNamePattern.matcher(string).replaceAll("?");
            string = lineNumberPattern.matcher(string).replaceAll("-1");
        }
        object = remoteBreakpointEvent.getConditionException();
        if (object != null) {
            string = string + "\n***\n" + ((Throwable)object).getLocalizedMessage() + "\n***\n";
        }
        return string;
    }

    private String basename(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        String string2 = n > 0 ? string.substring(n + 1) : string.substring(5);
        return string2;
    }

    private void hookBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            Breakpoint breakpoint = breakpointArray[i];
            this.hookBreakpoint(breakpoint);
        }
    }

    private void unhookBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            Breakpoint breakpoint = breakpointArray[i];
            this.unhookBreakpoint(breakpoint);
        }
    }

    private void hookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof RemoteBreakpoint) {
            RemoteBreakpoint remoteBreakpoint = (RemoteBreakpoint)breakpoint;
            remoteBreakpoint.addRemoteBreakpointListener(this);
        }
    }

    private void unhookBreakpoint(Breakpoint breakpoint) {
        if (breakpoint instanceof RemoteBreakpoint) {
            RemoteBreakpoint remoteBreakpoint = (RemoteBreakpoint)breakpoint;
            remoteBreakpoint.removeRemoteBreakpointListener(this);
        }
    }

    private BreakpointsNodeModel getBreakpointsNodeModel() {
        if (this.breakpointsNodeModel == null) {
            List list = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NodeModel nodeModel = (NodeModel)iterator.next();
                if (!(nodeModel instanceof BreakpointsNodeModel)) continue;
                this.breakpointsNodeModel = (BreakpointsNodeModel)nodeModel;
                break;
            }
        }
        return this.breakpointsNodeModel;
    }
}

