/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointsReader;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;

public abstract class BreakpointImpl
implements PropertyChangeListener {
    private static boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;
    private RemoteDebugger debugger;
    private RemoteBreakpoint breakpoint;
    private BreakpointsReader reader;
    private final Session session;
    private List requests = new ArrayList();

    protected BreakpointImpl(RemoteBreakpoint remoteBreakpoint, BreakpointsReader breakpointsReader, RemoteDebugger remoteDebugger, Session session) {
        this.debugger = remoteDebugger;
        this.reader = breakpointsReader;
        this.breakpoint = remoteBreakpoint;
        this.session = session;
    }

    final void set() {
        this.breakpoint.setDebugger(this.debugger);
        this.breakpoint.addPropertyChangeListener(this);
        this.update();
    }

    protected abstract void setRequests();

    void fixed() {
        this.update();
    }

    final void update() {
        if (this.getDebugger().getState() != "state_none") {
            this.setRequests();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("disposed".equals(propertyChangeEvent.getPropertyName())) {
            this.remove();
        }
        this.update();
    }

    protected final void remove() {
        this.breakpoint.removePropertyChangeListener(this);
        this.breakpoint.setState(3);
    }

    protected RemoteBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected RemoteDebugger getDebugger() {
        return this.debugger;
    }

    public boolean perform(String string) {
        boolean bl = false;
        if (string == null || string.equals("")) {
            RemoteBreakpointEvent remoteBreakpointEvent = new RemoteBreakpointEvent(this.getBreakpoint(), this.debugger, 0, this.debugger.getVariable(null));
            this.getDebugger().fireRemoteBreakpointEvent(this.getBreakpoint(), remoteBreakpointEvent);
        }
        if (!bl) {
            DebuggerManager.getDebuggerManager().setCurrentSession(this.session);
        }
        return bl;
    }

    static boolean match(String string, String string2) {
        if (string2.startsWith("*")) {
            return string.endsWith(string2.substring(1));
        }
        if (string2.endsWith("*")) {
            return string.startsWith(string2.substring(0, string2.length() - 1));
        }
        return string.equals(string2);
    }
}

