/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.ccpp.datasys;

import com.hp.openvms.netbeans.cppsupport.ccpp.CCppCompilerType;
import com.hp.openvms.netbeans.cppsupport.ccpp.cc.CCompilerType;
import com.hp.openvms.netbeans.cppsupport.ccpp.cpp.CppCompilerType;
import com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CDataNode;
import com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CppCompilerSupport;
import com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CppDataNode;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.propertyeditors.BoolEditor;
import org.netbeans.modules.distributed.common.propertyeditors.StringEditor2;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.FileEditor;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.ErrorManager;
import org.openide.compiler.CompilerSupport;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class CCppCompilerSupport
extends CompilerSupport {
    public static final String PROP_EXTERNAL_COMPILER = "cpqCcppExternalCompiler";
    public static final String PROP_MAKEFILE_COMPILER = "cpqCcppMakefileCompiler";
    public static final String PROP_DEFINE = "cpqCcppDefine";
    public static final String PROP_UNDEFINE = "cpqCcppUndefine";
    public static final String PROP_INCLUDE = "cpqCppInclude";
    public static final String PROP_LIBRARY = "cpqCcppLibrary";
    public static final String PROP_OPTIMIZE = "cpqCcppOptimize";
    public static final String PROP_OBJECT = "cpqCcppObject";
    public static final String PROP_DEBUG = "cpqCcppDebug";
    public static final String PROP_WARNING = "cpqCcppWarning";
    public static final String PROP_BUILD_DIR = "cpqCcppBuildDirectory";
    public static final String PROP_BUILD_OPTION = "cpqCcppBuildOption";
    public static final String PROP_CCPP_OPTION = "cpqCcppOption";
    public static final String PROP_RESET = "cpqCcppReset";
    public static final String PROP_BUILD_COMMAND = "cpqBuildCommand";
    public static final String PROP_OUTPUT_SWITCH = "cpqOutputSwitch";
    public static final String PROP_CCPP_GLOBAL_QUALIFIER = "cpqCcppGlobalQualifier";
    public static final String PROP_CCPP_LOCAL_QUALIFIER = "cpqCcppLocalQualifier";
    public static final String UPDATED = "updated";
    protected MultiDataObject.Entry entry;
    protected static final ResourceBundle bundle = NbBundle.getBundle((Class)CCppCompilerSupport.class);
    protected int compilerTypeEnum;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;

    protected CCppCompilerSupport(MultiDataObject.Entry entry, Class clazz) {
        super(entry, clazz);
        this.entry = entry;
        this.compilerTypeEnum = this instanceof CppCompilerSupport ? CCppCompilerType.CPP_TYPE : CCppCompilerType.C_TYPE;
    }

    public FileObject getFileObject() {
        return this.entry.getFile();
    }

    protected CCppCompilerType getProjCompilerType() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.getFileObject());
        if (project != null) {
            RemoteProjectSettings remoteProjectSettings = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (this instanceof CppCompilerSupport) {
                if (remoteProjectSettings == null) {
                    return new CppCompilerType(this.getFileObject());
                }
                return (CCppCompilerType)((Object)remoteProjectSettings.getCompilerSettings("cpp"));
            }
            if (remoteProjectSettings == null) {
                return new CCompilerType(this.getFileObject());
            }
            return (CCppCompilerType)((Object)remoteProjectSettings.getCompilerSettings("c"));
        }
        return null;
    }

    protected String getString(String string) {
        return bundle.getString(string);
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createCCppLocalQualifierProperty());
        set.put((Node.Property)this.createCCppGlobalQualifierProperty());
    }

    public void addRemoteProperties(Sheet.Set set) {
        set.put((Node.Property)this.createRemoteFilePathProperty());
        try {
            if (this.entry.getFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public void addMakefileProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildDirectoryProperty());
        set.put((Node.Property)this.createMakefileCompilerProperty());
        set.put((Node.Property)this.createBuildCommandProperty());
        set.put((Node.Property)this.createOutputSwitchProperty());
        set.put((Node.Property)this.createXDisplayDeviceNumber());
    }

    public void addBuildOptionProperty(Sheet.Set set) {
        set.put((Node.Property)this.createBuildOptionProperty());
    }

    public void addCompilerTypeProperty(Sheet.Set set, Sheet sheet) {
        super.addProperties(set);
    }

    public abstract NbProcessDescriptor getExternalCompiler();

    private String getCurrentFileDir() {
        try {
            String string = FileUtil.toFile((FileObject)this.entry.getDataObject().getPrimaryFile().getFileSystem().getRoot()).getAbsolutePath();
            String string2 = this.entry.getDataObject().getPrimaryFile().getParent().getPath();
            Object var3_4 = null;
            return string + '/' + string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getReset() {
        String string = (String)this.entry.getFile().getAttribute(PROP_RESET);
        if (string == null) {
            return "Reset";
        }
        return string;
    }

    private void changeResetProp(String string, Object object) {
        Node node = this.entry.getDataObject().getNodeDelegate();
        if (node instanceof CppDataNode) {
            ((CppDataNode)node).firePropertyChange2(string, null, object);
        } else {
            ((CDataNode)node).firePropertyChange2(string, null, object);
        }
    }

    protected void flagProperty(String string, String string2) {
    }

    public String getGlobalQualifier() {
        String string = (String)this.entry.getFile().getAttribute(PROP_CCPP_GLOBAL_QUALIFIER);
        if (string == null) {
            return this.getProjCompilerType().getGlobalQualifier();
        }
        return string;
    }

    private void setGlobalQualifier(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_CCPP_GLOBAL_QUALIFIER, (Object)string);
    }

    public String getLocalQualifier() {
        String string = (String)this.entry.getFile().getAttribute(PROP_CCPP_LOCAL_QUALIFIER);
        if (string == null) {
            return this.getProjCompilerType().getLocalQualifier();
        }
        return string;
    }

    private void setLocalQualifier(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_CCPP_LOCAL_QUALIFIER, (Object)string);
    }

    public RemoteFSFile getBuildDirectory() {
        Object object = this.entry.getFile().getAttribute(PROP_BUILD_DIR);
        if (object == null || object instanceof RemoteFSFile && ((RemoteFSFile)object).getAbsolutePath().equals("")) {
            return this.getProjCompilerType().getBuildDirectory();
        }
        if (object != null && !(object instanceof RemoteFSFile)) {
            try {
                this.entry.getFile().setAttribute(PROP_BUILD_DIR, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getBuildDirectory();
        }
        return (RemoteFSFile)object;
    }

    public String getBuildCommand() {
        String string = (String)this.entry.getFile().getAttribute(PROP_BUILD_COMMAND);
        if (string == null) {
            return this.getProjCompilerType().getBuildCommand();
        }
        return string;
    }

    private void setBuildCommand(String string) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_COMMAND, (Object)string);
    }

    public Boolean getOutputSwitch() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (bl == null) {
            return this.getProjCompilerType().outputSwitch();
        }
        return bl;
    }

    private void setOutputSwitch(Boolean bl) throws IOException {
        this.entry.getFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)bl);
    }

    public Integer getXDisplayNumber() {
        Integer n = (Integer)this.entry.getFile().getAttribute("xDisplayDeviceNumber");
        if (n == null) {
            return this.getProjCompilerType().xDisplayNumber();
        }
        return n;
    }

    private synchronized void setXDisplayNumber(Integer n) throws IOException {
        this.entry.getFile().setAttribute("xDisplayDeviceNumber", (Object)n);
    }

    public Boolean getBuildOption() {
        Boolean bl = (Boolean)this.entry.getFile().getAttribute(PROP_BUILD_OPTION);
        if (bl == null) {
            return (Boolean)this.getProjCompilerType().getBuildOption();
        }
        return bl;
    }

    private void setBuildOption(Boolean bl) throws IOException {
        Node node = this.entry.getDataObject().getNodeDelegate();
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        if (bl == null) {
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, null);
        } else if (node instanceof CppDataNode) {
            if (bl.equals(Boolean.TRUE)) {
                propertySetArray[1].setHidden(true);
                propertySetArray[2].setHidden(false);
            } else {
                propertySetArray[1].setHidden(false);
                propertySetArray[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)bl);
            ((CppDataNode)node).firePropertySetChange2(null, propertySetArray);
        } else if (node instanceof CDataNode) {
            if (bl.equals(Boolean.TRUE)) {
                propertySetArray[1].setHidden(true);
                propertySetArray[2].setHidden(false);
            } else {
                propertySetArray[1].setHidden(false);
                propertySetArray[2].setHidden(true);
            }
            this.entry.getFile().setAttribute(PROP_BUILD_OPTION, (Object)bl);
            ((CDataNode)node).firePropertySetChange2(null, propertySetArray);
        }
    }

    private void setBuildDirectory(RemoteFSFile remoteFSFile) throws IOException {
        this.entry.getFile().setAttribute(PROP_BUILD_DIR, (Object)remoteFSFile);
    }

    public RemoteFSFile getMakefileCompiler() {
        Object object = this.entry.getFile().getAttribute(PROP_MAKEFILE_COMPILER);
        if (object != null && object instanceof RemoteFSFile) {
            return (RemoteFSFile)object;
        }
        if (object != null && object instanceof String) {
            try {
                this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.getProjCompilerType().getMakefileCompiler();
        }
        return this.getProjCompilerType().getMakefileCompiler();
    }

    private void setMakefileCompiler(RemoteFSFile remoteFSFile) throws IOException {
        this.entry.getFile().setAttribute(PROP_MAKEFILE_COMPILER, (Object)remoteFSFile);
    }

    protected String getFlaggedName(String string, String string2) {
        return string;
    }

    private String getFlaggedNameMakefile(String string, String string2) {
        return string;
    }

    private String getFlaggedNameBuildOption(String string, String string2) {
        return string;
    }

    private String getFlaggedNameOutputSwitch(String string, String string2) {
        return string;
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", class$java$lang$String == null ? (class$java$lang$String = CCppCompilerSupport.class$("java.lang.String")) : class$java$lang$String, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                Object object;
                FileObject fileObject = CCppCompilerSupport.this.entry.getFile();
                Object object2 = fileObject.getAttribute("file_residence_mode");
                try {
                    object = (RemoteFileSystem)fileObject.getFileSystem();
                    if (object.getServerOnlyFileExts().isRegistered(fileObject.getExt())) {
                        return "Server Only";
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
                if (object2 != null) {
                    object = (Integer)object2;
                    String string = "Make Client and Server";
                    switch ((Integer)object) {
                        case 1: {
                            string = "Client Only";
                            break;
                        }
                        case 0: {
                            string = "Server Only";
                            break;
                        }
                        case 2: {
                            string = "Client and Server";
                        }
                    }
                    return string;
                }
                return "Client and Server";
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", class$java$lang$String == null ? (class$java$lang$String = CCppCompilerSupport.class$("java.lang.String")) : class$java$lang$String, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                FileObject fileObject = CCppCompilerSupport.this.entry.getFile();
                Object object = fileObject.getAttribute("REMOTE_FILEPATH");
                if (object != null) {
                    return object;
                }
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    FileObject fileObject = CCppCompilerSupport.this.entry.getFile();
                    fileObject.setAttribute("REMOTE_FILEPATH", object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                FileObject fileObject = CCppCompilerSupport.this.entry.getFile();
                String string = fileObject.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (Utilities.isWindows()) {
                        string = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        string = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
                    }
                    this.setValue(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createMakefileCompilerProperty() {
        class MakefileProperty
        extends PropertySupport.ReadWrite {
            public MakefileProperty() {
                super(CCppCompilerSupport.PROP_MAKEFILE_COMPILER, class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile == null ? (class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile = CCppCompilerSupport.class$("org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile")) : class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile, CCppCompilerSupport.this.getFlaggedNameMakefile(CCppCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), CCppCompilerSupport.PROP_MAKEFILE_COMPILER), CCppCompilerSupport.this.getString("HINT_MAKEFILE_COMPILER"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.TRUE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", CCppCompilerSupport.this.entry.getFile().getNameExt());
                if (CCppCompilerSupport.this.getProjCompilerType().getMakefileCompiler() != null) {
                    this.setValue("projvalue", CCppCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                }
                try {
                    if (CCppCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", CCppCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_MAKEFILE_COMPILER, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getMakefileCompiler();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof RemoteFSFile || object == null) {
                    try {
                        CCppCompilerSupport.this.setMakefileCompiler((RemoteFSFile)object);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedNameMakefile(CCppCompilerSupport.this.getString("PROP_MAKEFILE_COMPILER"), CCppCompilerSupport.PROP_MAKEFILE_COMPILER), CCppCompilerSupport.PROP_MAKEFILE_COMPILER);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(CCppCompilerSupport.this.getProjCompilerType().getMakefileCompiler());
                CCppCompilerSupport.this.changeResetProp(CCppCompilerSupport.PROP_MAKEFILE_COMPILER, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new MakefileProperty();
    }

    private PropertySupport createBuildOptionProperty() {
        class BuildOptionPropertySupport
        extends PropertySupport.ReadWrite {
            public BuildOptionPropertySupport() {
                super(CCppCompilerSupport.PROP_BUILD_OPTION, class$java$lang$Object == null ? (class$java$lang$Object = CCppCompilerSupport.class$("java.lang.Object")) : class$java$lang$Object, CCppCompilerSupport.this.getFlaggedNameBuildOption(CCppCompilerSupport.this.getString("PROP_BUILD_OPTION"), CCppCompilerSupport.PROP_BUILD_OPTION), CCppCompilerSupport.this.getString("HINT_BUILD_OPTION"));
                if (CCppCompilerSupport.this.getProjCompilerType().getBuildOption() != null) {
                    this.setValue("projValue", CCppCompilerSupport.this.getProjCompilerType().getBuildOption());
                }
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_BUILD_OPTION, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getBuildOption();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Boolean || object == null) {
                    try {
                        CCppCompilerSupport.this.setBuildOption((Boolean)object);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedNameBuildOption(CCppCompilerSupport.this.getString("PROP_BUILD_OPTION"), CCppCompilerSupport.PROP_BUILD_OPTION), CCppCompilerSupport.PROP_BUILD_OPTION);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getBuildOption());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new BuildOptionPropertySupport();
    }

    private PropertySupport createXDisplayDeviceNumber() {
        class XDisplayDeviceNumberPropertySupport
        extends PropertySupport.ReadWrite {
            public XDisplayDeviceNumberPropertySupport() {
                super("X Display Device Number", class$java$lang$Integer == null ? (class$java$lang$Integer = CCppCompilerSupport.class$("java.lang.Integer")) : class$java$lang$Integer, "X Display Device Number", "Defines the screen associated with the display device");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getXDisplayNumber();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Integer || object == null) {
                    try {
                        CCppCompilerSupport.this.setXDisplayNumber((Integer)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new XDisplayDeviceNumberPropertySupport();
    }

    private PropertySupport createOutputSwitchProperty() {
        class OutputSwitchPropertySupport
        extends PropertySupport.ReadWrite {
            public OutputSwitchPropertySupport() {
                super(CCppCompilerSupport.PROP_OUTPUT_SWITCH, class$java$lang$Object == null ? (class$java$lang$Object = CCppCompilerSupport.class$("java.lang.Object")) : class$java$lang$Object, CCppCompilerSupport.this.getFlaggedNameOutputSwitch(CCppCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), CCppCompilerSupport.PROP_OUTPUT_SWITCH), CCppCompilerSupport.this.getString("HINT_OUTPUT_SWITCH"));
                this.setValue("helpID", "com.hp.openvms.netbeans.cppsupport.settings.CCppFileGeneralSettings");
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_OUTPUT_SWITCH, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
                if (CCppCompilerSupport.this.getProjCompilerType().outputSwitch() != null) {
                    this.setValue("projValue", CCppCompilerSupport.this.getProjCompilerType().outputSwitch());
                }
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getOutputSwitch();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof Boolean || object == null) {
                    try {
                        CCppCompilerSupport.this.setOutputSwitch((Boolean)object);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedNameOutputSwitch(CCppCompilerSupport.this.getString("PROP_OUTPUT_SWITCH"), CCppCompilerSupport.PROP_OUTPUT_SWITCH), CCppCompilerSupport.PROP_OUTPUT_SWITCH);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getOutputSwitch());
            }

            public PropertyEditor getPropertyEditor() {
                return new BoolEditor();
            }
        }
        return new OutputSwitchPropertySupport();
    }

    private PropertySupport createCCppLocalQualifierProperty() {
        class CppLocalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public CppLocalQualifierPropertySupport() {
                super(CCppCompilerSupport.PROP_CCPP_LOCAL_QUALIFIER, class$java$lang$String == null ? (class$java$lang$String = CCppCompilerSupport.class$("java.lang.String")) : class$java$lang$String, CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_CCPP_LOCAL_QUALIFIER"), CCppCompilerSupport.PROP_CCPP_LOCAL_QUALIFIER), CCppCompilerSupport.this.getString("HINT_CCPP_LOCAL_QUALIFIER"));
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_CCPP_LOCAL_QUALIFIER, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getLocalQualifier();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        CCppCompilerSupport.this.setLocalQualifier((String)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getLocalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new CppLocalQualifierPropertySupport();
    }

    private PropertySupport createCCppGlobalQualifierProperty() {
        class CppGlobalQualifierPropertySupport
        extends PropertySupport.ReadWrite {
            public CppGlobalQualifierPropertySupport() {
                super(CCppCompilerSupport.PROP_CCPP_GLOBAL_QUALIFIER, class$java$lang$String == null ? (class$java$lang$String = CCppCompilerSupport.class$("java.lang.String")) : class$java$lang$String, CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_CCPP_GLOBAL_QUALIFIER"), CCppCompilerSupport.PROP_CCPP_GLOBAL_QUALIFIER), CCppCompilerSupport.this.getString("HINT_CCPP_GLOBAL_QUALIFIER"));
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_CCPP_GLOBAL_QUALIFIER, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getGlobalQualifier();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        CCppCompilerSupport.this.setGlobalQualifier((String)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getGlobalQualifier());
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new CppGlobalQualifierPropertySupport();
    }

    protected void setDefaultFunction(PropertySupport propertySupport, String string, String string2) {
        try {
            propertySupport.setValue("method", (Object)FileObject.class.getMethod("getAttribute", String.class));
            propertySupport.setValue("param", (Object)string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        propertySupport.setValue("object", (Object)this.entry.getFile());
        propertySupport.setValue("helpID", (Object)string2);
    }

    private PropertySupport createBuildDirectoryProperty() {
        class PropertySupportBuildDirectory
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildDirectory() {
                super(CCppCompilerSupport.PROP_BUILD_DIR, class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile == null ? (class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile = CCppCompilerSupport.class$("org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile")) : class$org$netbeans$modules$distributed$remotefs$propertyeditor$RemoteFSFile, CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_BUILD_DIR"), CCppCompilerSupport.PROP_BUILD_DIR), CCppCompilerSupport.this.getString("HINT_BUILD_DIR"));
                this.setValue("directories", Boolean.TRUE);
                this.setValue("files", Boolean.FALSE);
                this.setValue("3gl", Boolean.TRUE);
                this.setValue("fileName", CCppCompilerSupport.this.entry.getFile().getNameExt());
                if (CCppCompilerSupport.this.getProjCompilerType().getBuildDirectory() != null) {
                    this.setValue("projvalue", CCppCompilerSupport.this.getProjCompilerType().getBuildDirectory());
                }
                try {
                    if (CCppCompilerSupport.this.entry.getFile().getFileSystem() instanceof AbstractNetworkFileSystem) {
                        this.setValue("remoteFS", CCppCompilerSupport.this.entry.getFile().getFileSystem());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_BUILD_DIR, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getBuildDirectory();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof RemoteFSFile || object == null) {
                    try {
                        CCppCompilerSupport.this.setBuildDirectory((RemoteFSFile)object);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_BUILD_DIR"), CCppCompilerSupport.PROP_BUILD_DIR), CCppCompilerSupport.PROP_BUILD_DIR);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getBuildDirectory());
                CCppCompilerSupport.this.changeResetProp(CCppCompilerSupport.PROP_BUILD_DIR, this.getValue());
            }

            public PropertyEditor getPropertyEditor() {
                return new FileEditor();
            }
        }
        return new PropertySupportBuildDirectory();
    }

    private PropertySupport createBuildCommandProperty() {
        class PropertySupportBuildCommand
        extends PropertySupport.ReadWrite {
            public PropertySupportBuildCommand() {
                super(CCppCompilerSupport.PROP_BUILD_COMMAND, class$java$lang$String == null ? (class$java$lang$String = CCppCompilerSupport.class$("java.lang.String")) : class$java$lang$String, CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_BUILD_COMMAND"), CCppCompilerSupport.PROP_BUILD_COMMAND), CCppCompilerSupport.this.getString("HINT_BUILD_COMMAND"));
                CCppCompilerSupport.this.setDefaultFunction((PropertySupport)this, CCppCompilerSupport.PROP_BUILD_COMMAND, "com.hp.openvms.netbeans.cppsupport.settings.CCppFileCompilerSettings");
            }

            public Object getValue() {
                return CCppCompilerSupport.this.getBuildCommand();
            }

            public void setValue(Object object) throws InvocationTargetException {
                if (object instanceof String || object == null) {
                    try {
                        CCppCompilerSupport.this.setBuildCommand((String)object);
                        CCppCompilerSupport.this.flagProperty(CCppCompilerSupport.this.getFlaggedName(CCppCompilerSupport.this.getString("PROP_BUILD_COMMAND"), CCppCompilerSupport.PROP_BUILD_COMMAND), CCppCompilerSupport.PROP_BUILD_COMMAND);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
                this.setValue(CCppCompilerSupport.this.getBuildCommand());
                CCppCompilerSupport.this.changeResetProp(CCppCompilerSupport.PROP_BUILD_COMMAND, this.getValue());
            }

            public boolean canWrite() {
                return !CCppCompilerSupport.this.entry.getFile().isReadOnly();
            }

            public PropertyEditor getPropertyEditor() {
                return new StringEditor2();
            }
        }
        return new PropertySupportBuildCommand();
    }
}

