/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.cobol.datasys;

import com.hp.openvms.netbeans.baseclasses.dataobjects.AlphaVMSDataObject;
import com.hp.openvms.netbeans.cobolsupport.cobol.RemotePropertiesAction;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolCompilerSupport;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataEditor;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataEditorSupport;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataLoader;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataNode;
import org.netbeans.modules.distributed.common.cookies.RemotePropertyCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class CobolDataObject
extends AlphaVMSDataObject {
    private static final long serialVersionUID = 7950969510179979629L;
    public static final String COBOL_ICON_BASE = "/com/hp/openvms/netbeans/cobolsupport/cobol/resources/CobolObject";

    public CobolDataObject(FileObject fileObject, CobolDataLoader cobolDataLoader) throws DataObjectExistsException {
        super(fileObject, cobolDataLoader);
        this.init();
    }

    protected String getMIMEType() {
        return "text/x-hp+openvms+cob";
    }

    String getIconBase() {
        return COBOL_ICON_BASE;
    }

    private void init() {
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)new CobolDataEditor(this));
        cookieSet.add((Node.Cookie)new CobolDataEditorSupport(this));
        if (!Utilities.isUnix() && !Utilities.isWindows()) {
            cookieSet.add((Node.Cookie)new CobolCompilerSupport.Compile(this.getPrimaryEntry()));
            cookieSet.add((Node.Cookie)new CobolCompilerSupport.Build(this.getPrimaryEntry()));
        }
        cookieSet.add((Node.Cookie)new CobolCompilerSupport.Clean(this.getPrimaryEntry()));
        cookieSet.add((Node.Cookie)new CobolCompilerSupport.RemoteCompile(this.getPrimaryEntry()));
        cookieSet.add((Node.Cookie)new CobolCompilerSupport.RemoteBuild(this.getPrimaryEntry()));
        cookieSet.add((Node.Cookie)new RemotePropertyCookie(){

            public void operations(Node[] nodeArray) {
                RemotePropertiesAction.doAction(nodeArray);
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("openvms_cobol_compiler_support_module_help_htm");
    }

    protected Node createNodeDelegate() {
        return new CobolDataNode(this);
    }

    void enableSave(SaveCookie saveCookie) {
        if (saveCookie != null && this.getCookie(SaveCookie.class) == null) {
            this.getCookieSet().add((Node.Cookie)saveCookie);
            this.setModified(true);
        }
    }

    void disableSave(SaveCookie saveCookie) {
        if (this.getCookie(SaveCookie.class) == saveCookie) {
            this.getCookieSet().remove((Node.Cookie)saveCookie);
        }
    }
}

