/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectVisualPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRuntimePanel;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RemoteFTPSelectPanel
implements WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    public static final String WIZARD_KEY_TARGET_FOLDER = "targetFolder";
    public static final String WIZARD_KEY_TARGET_NAME = "targetName";
    public static final int MAX_FILE_COUNT_LIMIT = 200;
    protected RemoteFTPSelectVisualPanel component;
    private RemoteRuntimeType rrt;
    private char[] retPass;
    private ArrayList listeners = new ArrayList();
    private String projectDirectory;
    private boolean editable = false;
    private boolean checkLocalDir = false;
    private String title;
    protected ArrayList rootsHistory;
    protected int panelIndex;
    protected boolean ods2allowed;
    private int count;
    private RemoteFTPSelectPanel remoteftpselectpanel;

    public RemoteFTPSelectPanel(String string, String string2) {
        this.projectDirectory = string;
        this.title = string2;
    }

    public RemoteFTPSelectPanel(String string, boolean bl, String string2) {
        this.projectDirectory = string;
        this.editable = bl;
        this.checkLocalDir = bl;
        this.title = string2;
    }

    public RemoteFTPSelectPanel(String string, RemoteRuntimeType remoteRuntimeType, String string2) {
        this.projectDirectory = string;
        this.rrt = remoteRuntimeType;
        this.title = string2;
    }

    public boolean isFinishPanel() {
        return this.editable;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteFTPSelectVisualPanel(this, this.projectDirectory, this.editable, this.title);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValidLocal() {
        String string = this.component.getLocalCacheRoot();
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!new File(string).exists()) {
            return false;
        }
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        while (iterator.hasNext()) {
            String string2;
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (!(fileSystem instanceof LocalFileSystem && !(fileSystem instanceof AbstractNetworkFileSystem) ? (string2 = ((LocalFileSystem)fileSystem).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(string) : fileSystem instanceof AbstractNetworkFileSystem && (string2 = ((AbstractNetworkFileSystem)fileSystem).getLocalRoot()).equalsIgnoreCase(string))) continue;
            return false;
        }
        return true;
    }

    public boolean isValidLocal(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return false;
        }
        if (string.length() < string2.length()) {
            if (string.charAt(string.length() - 1) == File.separatorChar) {
                string = string.substring(0, string.length() - 1);
            }
            if (string2.toUpperCase().indexOf(string.toUpperCase()) == 0 && string2.charAt(string.length()) == File.separatorChar) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidRemote(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return false;
        }
        if (string.length() < string2.length()) {
            if (string.indexOf(93) != -1) {
                string = string.substring(0, string.indexOf(93));
            }
            if (string2.toUpperCase().indexOf(string.toUpperCase()) == 0 && (string2.charAt(string.length()) == '.' || string2.charAt(string.length()) == ']')) {
                return false;
            }
        }
        return true;
    }

    public boolean isInRootsHistory(String string, String string2) throws WizardValidationException {
        if (this.rootsHistory != null) {
            for (int i = 0; i < this.rootsHistory.size(); ++i) {
                String string3;
                if (i == this.panelIndex) continue;
                Map map = (Map)this.rootsHistory.get(i);
                String string4 = ((String)map.get("remote_directory")).toUpperCase();
                String string5 = ((String)map.get("local_directory")).toUpperCase();
                if (string4.trim().length() == 0 || string5.trim().length() == 0) continue;
                if (!(this.isValidRemote(string4, string) && this.isValidRemote(string, string4) || this.isOverwriteConfirmed("MSG_DIR_ALREADY_IN_THIS_REMOTE_PROJECT", string3 = string.substring(string.lastIndexOf(46) + 1, string.indexOf(93))))) {
                    throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_REMOTE_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_PROJECT"));
                }
                if (this.isValidLocal(string5, string2) && this.isValidLocal(string2, string5) || this.isOverwriteConfirmed("MSG_DIR_ALREADY_IN_THIS_LOCAL_PROJECT", string3 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1, string2.length()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return true;
    }

    private boolean isOverwriteConfirmed(String string, String string2) {
        String string3 = NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)string);
        if (string2 != null) {
            string3 = string3 + " (";
            string3 = string3 + string2;
            string3 = string3 + ").  ";
        }
        string3 = string3 + "Do you want to overwrite ?";
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string3, "Question", 0, 3));
        return NotifyDescriptor.OK_OPTION.equals(object);
    }

    private boolean is3GLProject(String string) throws WizardValidationException {
        try {
            if (null == string || string.equals("")) {
                return false;
            }
            File file = new File(string);
            Project project = OpenProjectList.fileToProject((File)file);
            RemoteProjectSettings remoteProjectSettings = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (remoteProjectSettings == null) {
                return false;
            }
        }
        catch (Exception exception) {
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"ERR_FIND_3GL_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"ERR_FIND_3GL_PROJECT"));
        }
        return true;
    }

    public boolean isValidPath() throws WizardValidationException {
        try {
            String string;
            Object object;
            String string2 = this.component.getLocalCacheRoot();
            String string3 = this.component.getRemoteFTPRoot();
            if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_LENGTH0"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_LENGTH0"));
            }
            if (this.checkLocalDir && !new File(string2).exists()) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_NO_LOCAL_DIR"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_NO_LOCAL_DIR"));
            }
            if (!this.getRemoteRuntimeType().getRemoteFileService().fileExists(string3)) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_NO_REMOTE_DIR"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_NO_REMOTE_DIR"));
            }
            Iterator iterator = OpenProjectList.getFsSet().iterator();
            while (iterator.hasNext()) {
                object = (FileSystem)iterator.next();
                if (!(object instanceof AbstractNetworkFileSystem)) continue;
                string = ((AbstractNetworkFileSystem)object).getLocalRoot().toUpperCase();
                String string4 = ((AbstractNetworkFileSystem)object).getRemoteRoot().toUpperCase();
                if (!this.isValidLocal(string, string2.toUpperCase())) {
                    throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT"));
                }
                if (this.isValidRemote(string4, string3.toUpperCase())) continue;
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT"));
            }
            if (this.isInRootsHistory(string3.toUpperCase(), string2.toUpperCase())) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_LOCAL_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_LOCAL_PROJECT"));
            }
            if ((new File(string2 + File.separatorChar + "nbproject").exists() || new File(string2 + File.separatorChar + "NBPROJECT").exists() || string2.toUpperCase().indexOf("NBPROJECT") != -1) && this.is3GLProject(string2) && !this.isOverwriteConfirmed("MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT", (String)(object = string2.substring(string2.lastIndexOf(File.separatorChar) + 1, string2.length())))) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT"));
            }
            String string5 = object = string3.endsWith("]") ? string3.substring(0, string3.length() - 1) + "." + "nbproject]" : string3 + "[nbproject]";
            if ((this.getRemoteRuntimeType().getRemoteFileService().fileExists((String)object) || string3.toUpperCase().indexOf("NBPROJECT") != -1) && !this.isOverwriteConfirmed("MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT", string = string3.substring(string3.lastIndexOf(46) + 1, string3.indexOf(93)))) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT"));
            }
        }
        catch (WizardValidationException wizardValidationException) {
            throw wizardValidationException;
        }
        catch (IOException iOException) {
            throw new WizardValidationException((JComponent)this.getComponent(), iOException.getMessage(), iOException.getMessage());
        }
        return true;
    }

    public final void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeState() {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < arrayList.size(); ++i) {
            ((ChangeListener)arrayList.get(i)).stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        if (this.rrt == null) {
            this.rrt = (RemoteRuntimeType)wizardDescriptor.getProperty("remote_runtime");
        }
        if (this.projectDirectory == null) {
            this.component.setLocalDirectory(((File)wizardDescriptor.getProperty(WIZARD_KEY_TARGET_FOLDER)).getAbsolutePath() + File.separatorChar + (String)wizardDescriptor.getProperty(WIZARD_KEY_TARGET_NAME));
        }
        this.rootsHistory = (ArrayList)wizardDescriptor.getProperty("remotefs_list");
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        wizardDescriptor.putProperty("remote_directory", (Object)this.component.getRemoteFTPRoot());
        wizardDescriptor.putProperty("local_directory", (Object)this.component.getLocalCacheRoot());
        wizardDescriptor.putProperty("FTP_PORT", (Object)this.component.getFTPPortValue());
        wizardDescriptor.putProperty("AUTO_SYNC", (Object)this.component.getAutoSync());
        wizardDescriptor.putProperty("READ_ONLY", (Object)this.component.getReadOnly());
        wizardDescriptor.putProperty("IS_PASSIVE", (Object)this.component.getUsePassiveMode());
        wizardDescriptor.putProperty("SSH_FORWARD", (Object)this.component.getUseSSHForwarding());
        wizardDescriptor.putProperty("FTP_PASS", (Object)this.remoteftpselectpanel.getFtpPass());
    }

    private void countFiles(File file, ArrayList arrayList) throws Exception {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                arrayList.add(fileArray[i]);
            }
            ++this.count;
            if (this.count != 200) continue;
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_FILE_COUNT_LIMIT_EXCEED"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"TITLE_LOCAL_ROOT"), 2));
            if (object.equals(NotifyDescriptor.OK_OPTION)) {
                throw new Exception("OK");
            }
            throw new Exception("Cancel");
        }
        if (arrayList.size() > 0) {
            File file2 = (File)arrayList.get(0);
            arrayList.remove(0);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.countFiles(file2, arrayList);
            }
        }
    }

    private boolean isLargeRoot(String string) {
        block2: {
            try {
                ArrayList arrayList = new ArrayList();
                this.countFiles(new File(string), arrayList);
            }
            catch (Exception exception) {
                if (exception.getMessage().equals("OK")) break block2;
                return true;
            }
        }
        return false;
    }

    public void validate() throws WizardValidationException {
        String string;
        String string2;
        block11: {
            string2 = this.component.getRemoteFTPRoot();
            String string3 = this.component.getLocalCacheRoot();
            this.isValidPath();
            if (this.isLargeRoot(string3)) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_FILE_COUNT_TOO_MANY"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_FILE_COUNT_TOO_MANY"));
            }
            if (!this.ods2allowed) {
                try {
                    if (this.rrt.getRemoteFileService().checkIfODS2(string2)) {
                        throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_ODS2_DISK_NOT_ALLOWED"), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_ODS2_DISK_NOT_ALLOWED"));
                    }
                    break block11;
                }
                catch (RemoteException remoteException) {
                    throw new WizardValidationException((JComponent)this.getComponent(), remoteException.getMessage(), remoteException.getMessage());
                }
            }
            string = string3.endsWith(File.separator) ? string3 + "nbproject" : string3 + File.separatorChar + "nbproject";
        }
        string = string2.endsWith("]") ? string2.substring(0, string2.length() - 1) + "." + "nbproject]" : string2 + "[nbproject]";
        try {
            String string4;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("USER", this.rrt.getUserName());
            if (!this.rrt.getSavePassword()) {
                this.retPass = this.rrt.getFTPCredentials((Component)this.component);
                if (this.retPass == null) {
                    return;
                }
            } else {
                hashMap.put("PASSWD", this.rrt.getPassword());
            }
            if ((string4 = this.rrt.getRemoteFileService().getDefaultDirectory()) != null && string4.length() > 0 && string4.trim().equalsIgnoreCase(FileUtility.openVMSPathToUnixPath((String)string2, (boolean)true))) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_NO_SYSLOGIN", (Object)string2), NbBundle.getMessage((Class)RemoteRuntimePanel.class, (String)"MSG_NO_SYSLOGIN", (Object)string2));
            }
        }
        catch (RemoteException remoteException) {
            throw new WizardValidationException((JComponent)this.getComponent(), remoteException.getMessage(), remoteException.getMessage());
        }
    }

    public char[] getFtpPass() {
        return this.retPass;
    }
}

