/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.smb;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.remotefs.ftpfs.FileStatusInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteCompileAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteExecuteAction;
import org.netbeans.modules.distributed.remotefs.smb.ConfirmDeleteDialog;
import org.netbeans.modules.distributed.remotefs.smb.ExLocalFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.property.RemoteRootProperty;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class NetworkFileSystem
extends ExLocalFileSystem
implements AbstractNetworkFileSystem,
LookupListener,
FileStatusListener,
FileSystem.HtmlStatus {
    private static final long serialVersionUID = -8339230545913502376L;
    private static final String nl2 = "\n\n";
    private static final String cvtline1 = "The RMS record format of";
    private static final String cvtline2 = "is not STREAM_LF.";
    private static final String cvtline3 = "Editing this file in its current format from within NetBeans will cause the file to become corrupted.";
    private static final String cvtline4 = "Click OK to convert the file on the OpenVMS machine to STREAM_LF record format.";
    private static final String cvtline5 = "Click CANCEL to skip the conversion (file will not be opened).";
    private static final String NON_STMLF_MSG1 = "The selected SMB share {0} is not configured to have a default RMS file format of STREAM_LF.\n\n";
    private static final String NON_STMLF_MSG2 = "Distributed NetBeans requires that writeable SMB shares used for remote filesystems\nhave STREAM_LF as the default RMS record format.\n\nThe remote filesystem is being mounted as read-only.\n\nIn order to mount this remote filesystem as writeable, you must\n    - modify the SMB share on your OpenVMS server to have STREAM_LF as the default format,\n    - then unmount and re-mount the remote filesystem in Distributed NetBeans.\n\nPlese see the user documentation for your SMB server for more details on setting the\ndefault record format for files.";
    private static final String MOUNT_READONLY_MSG = "The remote filesystem is being mounted as a read-only filesystem.";
    public static final String NON_STMLF_MSG = "The selected SMB share {0} is not configured to have a default RMS file format of STREAM_LF.\n\nDistributed NetBeans requires that writeable SMB shares used for remote filesystems\nhave STREAM_LF as the default RMS record format.\n\nThe remote filesystem is being mounted as read-only.\n\nIn order to mount this remote filesystem as writeable, you must\n    - modify the SMB share on your OpenVMS server to have STREAM_LF as the default format,\n    - then unmount and re-mount the remote filesystem in Distributed NetBeans.\n\nPlese see the user documentation for your SMB server for more details on setting the\ndefault record format for files.";
    public static final String NOT_WRITABLE_MSG1 = "The selected SMB share {0} is not writable.";
    public static final String NOT_WRITABLE_MSG = "The selected SMB share {0} is not writable.\n\nThe remote filesystem is being mounted as a read-only filesystem.";
    public static final int NON_STREAMLF = 0;
    public static final int STREAMLF = 1;
    public static final int NOT_WRITABLE = 2;
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 1;
    private static RequestProcessor statusRequestProcessor;
    private static final Object STATUS_REQUEST_PROCESSOR_LOCK;
    private RemoteRootProperty remoteRoot;
    private RemoteRuntimeType remoteRuntimeType;
    private Boolean useXtermCompile;
    private Boolean useXtermExecution;
    private Integer xDisplayNumber = new Integer(-1);
    private int refCount;
    private transient boolean readOnce = false;
    private transient Lookup.Result annotationProviders;
    private transient Collection previousProviders;
    static /* synthetic */ Class class$org$openide$cookies$CloseCookie;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditCookie;

    private static String createRemoteDirectory(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        String string4 = null;
        if (Utilities.isWindows()) {
            if (string2.length() == 3) {
                return string;
            }
            if (string2.endsWith("\\")) {
                stringBuffer.deleteCharAt(string2.length() - 1);
            }
            stringBuffer.delete(0, 2);
            string4 = stringBuffer.toString().replace('\\', '.');
        } else {
            if (string2.length() == string3.length()) {
                return string;
            }
            if (string2.endsWith("/")) {
                stringBuffer.deleteCharAt(string2.length() - 1);
            }
            stringBuffer.delete(0, string3.length());
            string4 = stringBuffer.toString().replace('/', '.');
        }
        if (string.endsWith("]")) {
            stringBuffer2.deleteCharAt(string.length() - 1);
        } else {
            stringBuffer2.append('[');
        }
        stringBuffer2.append(string4);
        stringBuffer2.append("]");
        return stringBuffer2.toString();
    }

    public static String getRemoteDirectoryShare(RemoteRuntimeType remoteRuntimeType, String string) {
        String string2 = FileUtility.getShareName((String)string);
        String string3 = "";
        String string4 = "";
        if (string2.length() > 0) {
            if (Utilities.isWindows()) {
                string3 = string2;
            } else {
                string3 = string2.substring(0, string2.indexOf(10));
                string4 = string2.substring(string2.indexOf(10) + 1, string2.length());
            }
            try {
                String string5 = remoteRuntimeType.getNetworkShareRoot(string3);
                if (string5 != null) {
                    return NetworkFileSystem.createRemoteDirectory(string5, string, string4);
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return "";
    }

    public NetworkFileSystem() {
        this.addedFS((FileSystem)this);
    }

    public NetworkFileSystem(RemoteRuntimeType remoteRuntimeType) {
        this.remoteRuntimeType = remoteRuntimeType;
        this.addedFS((FileSystem)this);
    }

    public void addedFS(FileSystem fileSystem) {
        if (fileSystem == this) {
            this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Object object;
        Object object2;
        HashSet hashSet;
        HashSet hashSet2 = this.annotationProviders.allInstances();
        if (this.previousProviders != null) {
            hashSet = new HashSet(hashSet2);
            hashSet.removeAll(this.previousProviders);
            object2 = new HashSet(this.previousProviders);
            ((AbstractSet)object2).removeAll(hashSet2);
            object = ((HashSet)object2).iterator();
            while (object.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)object.next();
                if (annotationProvider.getInterceptionListener() instanceof FileChangeListener) {
                    this.removeFileChangeListener((FileChangeListener)annotationProvider.getInterceptionListener());
                }
                annotationProvider.removeFileStatusListener((FileStatusListener)this);
            }
        } else {
            hashSet = hashSet2;
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (AnnotationProvider)object2.next();
            if (object.getInterceptionListener() instanceof FileChangeListener) {
                this.addFileChangeListener((FileChangeListener)object.getInterceptionListener());
            }
            try {
                object.addFileStatusListener((FileStatusListener)this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                ErrorManager.getDefault().notify((Throwable)tooManyListenersException);
            }
        }
        this.previousProviders = hashSet2;
    }

    public Date lastModified(String string) {
        return super.lastModified(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
        this.annotationProviders.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public SystemAction[] getActions() {
        SystemAction[] systemActionArray = super.getActions();
        SystemAction[] systemActionArray2 = new SystemAction[systemActionArray.length + 2];
        System.arraycopy(systemActionArray, 0, systemActionArray2, 0, systemActionArray.length);
        SystemAction[] systemActionArray3 = new SystemAction[]{SystemAction.get((Class)RemoteCompileAction.class), SystemAction.get((Class)RemoteExecuteAction.class)};
        System.arraycopy(systemActionArray3, 0, systemActionArray2, systemActionArray.length, 2);
        return systemActionArray2;
    }

    public SystemAction[] getActions(Set set) {
        AnnotationProvider annotationProvider;
        Action[] actionArray = null;
        Iterator iterator = this.annotationProviders.allInstances().iterator();
        while (actionArray == null && iterator.hasNext()) {
            annotationProvider = (AnnotationProvider)iterator.next();
            actionArray = annotationProvider.actions(set);
        }
        if (actionArray == null) {
            actionArray = new Action[]{};
        }
        annotationProvider = new SystemAction[actionArray.length];
        for (int i = 0; i < actionArray.length; ++i) {
            annotationProvider[i] = (SystemAction)actionArray[i];
        }
        SystemAction[] systemActionArray = super.getActions();
        SystemAction[] systemActionArray2 = new SystemAction[systemActionArray.length + ((AnnotationProvider)annotationProvider).length + 2];
        System.arraycopy(systemActionArray, 0, systemActionArray2, 0, systemActionArray.length);
        SystemAction[] systemActionArray3 = new SystemAction[]{SystemAction.get((Class)RemoteCompileAction.class), SystemAction.get((Class)RemoteExecuteAction.class)};
        System.arraycopy(systemActionArray3, 0, systemActionArray2, systemActionArray.length, 2);
        System.arraycopy(annotationProvider, 0, systemActionArray2, systemActionArray.length + 2, ((AnnotationProvider)annotationProvider).length);
        return systemActionArray2;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        RemoteRuntimeType remoteRuntimeType = DistributedSettings.getDefault().findRemoteRuntime(this.remoteRuntimeType.getHostName(), this.remoteRuntimeType.getUserName());
        return remoteRuntimeType;
    }

    public String getServer() {
        return this.getRemoteRuntimeType().getHostName();
    }

    public void setRemoteRuntimeType(RemoteRuntimeType remoteRuntimeType) {
        this.remoteRuntimeType = remoteRuntimeType;
    }

    public boolean getUseXtermCompile() {
        if (this.useXtermCompile == null) {
            return DistributedSettings.getDefault().getUseXtermCompile();
        }
        return this.useXtermCompile;
    }

    public void setUseXtermCompile(boolean bl) {
        this.useXtermCompile = new Boolean(bl);
        this.firePropertyChange("useXtermCompile", null, this.useXtermCompile);
    }

    public boolean getUseXtermExecution() {
        if (this.useXtermExecution == null) {
            return DistributedSettings.getDefault().getUseXtermExecution();
        }
        return this.useXtermExecution;
    }

    public void setUseXtermExecution(boolean bl) {
        this.useXtermExecution = new Boolean(bl);
        this.firePropertyChange("useXtermExecution", null, this.useXtermExecution);
    }

    public int getXDisplayDeviceNumber() {
        if (this.xDisplayNumber == -1) {
            return DistributedSettings.getDefault().getXDisplayDeviceNumber();
        }
        return this.xDisplayNumber;
    }

    public void setXDisplayDeviceNumber(int n) {
        this.xDisplayNumber = new Integer(n);
        this.firePropertyChange("xDisplayNumber", null, this.xDisplayNumber);
    }

    public String getRemoteRoot() {
        return this.remoteRoot.getRemoteRoot();
    }

    public String getLocalRoot() {
        return this.getRootDirectory().getAbsolutePath();
    }

    public void setRemoteRoot(RemoteRootProperty remoteRootProperty) {
        try {
            this.remoteRoot = remoteRootProperty;
            this.setRootDirectory(new File(remoteRootProperty.getLocalRoot()));
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        if (Utilities.isWindows()) {
            String string = this.getRootDirectory().getAbsolutePath();
            string = string.substring(0, 2);
            String string2 = FileSystemView.getFileSystemView().getSystemDisplayName(new File(string));
            if (string2.lastIndexOf(40) > 0) {
                string2 = string2.substring(0, string2.lastIndexOf(40) - 1);
            }
            return " " + super.getDisplayName();
        }
        return " " + super.getDisplayName();
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(super.getRootDirectory().toString());
    }

    public void annotationChanged(FileStatusEvent fileStatusEvent) {
        this.fireFileStatusChanged(fileStatusEvent);
    }

    private static String getSearchRoot(String string, NetworkFileSystem networkFileSystem) {
        RemoteRuntimeType remoteRuntimeType = networkFileSystem.getRemoteRuntimeType();
        String string2 = string;
        if (RemoteFSUtils.getServerOS(remoteRuntimeType).equals(Utils.OS_VMS)) {
            string2 = string.endsWith(":") ? string : string.substring(0, string.length() - 1);
        }
        return string2;
    }

    private static String getClientPath(String string, String string2, NetworkFileSystem networkFileSystem) {
        RemoteRuntimeType remoteRuntimeType = networkFileSystem.getRemoteRuntimeType();
        if (RemoteFSUtils.getServerOS(remoteRuntimeType).equals(Utils.OS_VMS)) {
            if (Utilities.isWindows()) {
                return FileUtility.openVMSPathToWinPath((String)string, (boolean)false, (String)networkFileSystem.getRootDirectory().getAbsolutePath(), (String)string2);
            }
            if (Utilities.isUnix()) {
                return FileUtility.openVMSPathToUnixPath((String)string, (boolean)false);
            }
            if (Utilities.getOperatingSystem() == 16384) {
                return FileUtility.openVMSPathToUnixPath((String)string, (boolean)false);
            }
        }
        return string;
    }

    public static void refreshParent(String string, String string2, char c, FileSystem fileSystem) {
        String string3 = string.substring(string2.length() + 1);
        string3 = string3.lastIndexOf(c) > 0 ? string3.substring(0, string3.lastIndexOf(c)).replace(c, '/') : "";
        FileObject fileObject = fileSystem.findResource(string3);
        if (fileObject != null) {
            fileObject.refresh();
        }
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void addNotify() {
        super.addNotify();
        this.incRefCount();
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
    }

    public void removeNotify() {
        super.removeNotify();
        this.decRefCount();
    }

    public static File toFile(FileObject fileObject) {
        return (File)fileObject.getAttribute("java.io.File");
    }

    public static FileObject[] fromFile(String string) {
        FileObject[] fileObjectArray;
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        while (iterator.hasNext()) {
            fileObjectArray = (FileObject[])iterator.next();
            if (!(fileObjectArray instanceof NetworkFileSystem)) continue;
            try {
                File file;
                FileObject fileObject;
                String string2;
                NetworkFileSystem networkFileSystem = (NetworkFileSystem)fileObjectArray;
                File file2 = NetworkFileSystem.toFile(fileObjectArray.getRoot());
                if (file2 == null) continue;
                String string3 = file2.getCanonicalPath();
                String string4 = networkFileSystem.getRemoteRoot();
                String string5 = NetworkFileSystem.getSearchRoot(string4, networkFileSystem);
                if (string.toLowerCase().indexOf(string5.toLowerCase()) == 0 && (string.charAt(string4.length() - 1) == '.' || string.charAt(string4.length() - 1) == ']')) {
                    string = NetworkFileSystem.getClientPath(string, string4, networkFileSystem);
                    string2 = string.substring(string3.length()).replace(File.separatorChar, '/');
                    NetworkFileSystem.refreshParent(string, string3, File.separatorChar, (FileSystem)fileObjectArray);
                    fileObject = fileObjectArray.findResource(string2);
                    File file3 = file = fileObject != null ? NetworkFileSystem.toFile(fileObject) : null;
                    if (fileObject == null || file == null) continue;
                    arrayList.add(fileObject);
                    continue;
                }
                if (!RemoteFSUtils.getServerOS(networkFileSystem.getRemoteRuntimeType()).equals(Utils.OS_VMS)) continue;
                string4 = FileUtility.openVMSPathToUnixPath((String)string4, (boolean)true);
                if (string.toLowerCase().indexOf(string4.toLowerCase()) != 0 || string.charAt(string4.length()) != '/') continue;
                string2 = string.substring(string4.length() + 1);
                NetworkFileSystem.refreshParent(string, string4, '/', (FileSystem)fileObjectArray);
                fileObject = fileObjectArray.findResource(string2);
                File file4 = file = fileObject != null ? NetworkFileSystem.toFile(fileObject) : null;
                if (fileObject == null || file == null) continue;
                arrayList.add(fileObject);
            }
            catch (IOException iOException) {}
        }
        fileObjectArray = new FileObject[arrayList.size()];
        arrayList.toArray(fileObjectArray);
        return fileObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkIfFSStreamLF(String string, String string2, RemoteRuntimeType remoteRuntimeType) {
        File file = null;
        try {
            file = File.createTempFile("distnbstmlftest", ".txt", new File(string));
            if (remoteRuntimeType.isFileSTRMLF(string2 + file.getName())) {
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (IOException iOException) {
            int n = 2;
            return n;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAccessible(String string, String string2, RemoteRuntimeType remoteRuntimeType) {
        File file = null;
        try {
            file = File.createTempFile("distnbstmlftest", ".txt", new File(string));
            if (remoteRuntimeType != null && remoteRuntimeType.getRemoteRuntime() != null) {
                boolean bl = remoteRuntimeType.fileExists(string2 + file.getName());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public void doSTRMLFConversion(final FileObject fileObject) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = null;
        if (Utilities.isWindows()) {
            string = RemoteFSUtils._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            string = RemoteFSUtils.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
        }
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!Utils.isEditorFile((String)fileObject.getPath())) {
                    return;
                }
                try {
                    DataObject dataObject = null;
                    CloseCookie closeCookie = null;
                    try {
                        dataObject = DataObject.find((FileObject)fileObject);
                        if (dataObject != null) {
                            closeCookie = (CloseCookie)dataObject.getCookie(class$org$openide$cookies$CloseCookie == null ? (class$org$openide$cookies$CloseCookie = NetworkFileSystem.class$("org.openide.cookies.CloseCookie")) : class$org$openide$cookies$CloseCookie);
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                    }
                    if (dataObject == null) {
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Error Opening " + string2 + ". Please close it now. The file can be corrupted if continue using"), -1, 2));
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText("Connecting to the remote server:" + NetworkFileSystem.this.getRemoteRuntimeType().getHostName() + ":" + NetworkFileSystem.this.getRemoteRuntimeType().getUserName());
                    RemoteRuntime remoteRuntime = NetworkFileSystem.this.getRemoteRuntimeType().getRemoteRuntime();
                    if (remoteRuntime == null) {
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Can't determine the file type of " + string2 + "\nbecause Remote IDE Server is not connected.\n"), -1, 2));
                        if (closeCookie != null) {
                            closeCookie.close();
                        } else {
                            Utils.closeEditorFile((String)fileObject.getPath());
                        }
                        return;
                    }
                    if (!remoteRuntime.getRemoteFileService().isFileSTRMLF(string2)) {
                        if (closeCookie != null) {
                            closeCookie.close();
                        } else {
                            Utils.closeEditorFile((String)fileObject.getPath());
                        }
                        String string = "The RMS record format of\n\n         " + string2 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline2 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline3 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline4 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline5;
                        String string22 = "File Format Not STREAM_LF";
                        ConfirmDeleteDialog confirmDeleteDialog = new ConfirmDeleteDialog(string, string22, "xxx");
                        confirmDeleteDialog.openChooseDialog();
                        if (!confirmDeleteDialog.isCancel()) {
                            remoteRuntime.getRemoteFileService().changeTxtFileToSTRMLF(string2, string2);
                            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = NetworkFileSystem.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                            if (openCookie == null) {
                                EditCookie editCookie = (EditCookie)dataObject.getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = NetworkFileSystem.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
                                editCookie.edit();
                            } else {
                                openCookie.open();
                            }
                        } else if (closeCookie != null) {
                            closeCookie.close();
                        } else {
                            Utils.closeEditorFile((String)fileObject.getPath());
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    ErrorManager.getDefault().notify((Throwable)remoteException);
                }
            }
        });
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        InputStream inputStream = super.inputStream(string);
        if (!string.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) && !string.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
            try {
                this.doSTRMLFConversion(this.findResource(string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    public FileObject getFSRoot() {
        return this.getRoot();
    }

    private static String htmlEncode(String string) {
        Pattern pattern = Pattern.compile("<");
        Pattern pattern2 = Pattern.compile(">");
        String string2 = string;
        if (string2.indexOf(60) != -1) {
            string2 = pattern.matcher(string2).replaceAll("&lt;");
        }
        if (string2.indexOf(62) != -1) {
            string2 = pattern2.matcher(string2).replaceAll("&gt;");
        }
        return string2;
    }

    public String annotateNameHtml(String string, Set set) {
        string = NetworkFileSystem.htmlEncode(string);
        string = this.annotateName(string, set);
        String string2 = null;
        Iterator iterator = this.annotationProviders.allInstances().iterator();
        while (string2 == null && iterator.hasNext()) {
            AnnotationProvider annotationProvider = (AnnotationProvider)iterator.next();
            string2 = annotationProvider.annotateNameHtml(string, set);
        }
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public String annotateName(String string, Set set) {
        return string;
    }

    public Image annotateIcon(Image image, int n, Set set) {
        Object[] objectArray = set.toArray();
        int n2 = objectArray.length;
        Image image2 = null;
        if (n2 == 0) {
            return image;
        }
        ArrayList arrayList = new ArrayList(set);
        n2 = arrayList.size();
        FileObject fileObject = (FileObject)arrayList.get(0);
        Image image3 = null;
        if (this.annotationProviders != null) {
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (image3 == null && iterator.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)iterator.next();
                image3 = annotationProvider.annotateIcon(image, n, set);
            }
            if (image3 != null) {
                image = image3;
            }
        }
        try {
            if ("".equals(fileObject.getName()) && fileObject.isFolder()) {
                image2 = FileStatusInfo.REMOTE_PRJ.getIcon();
                image = Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)1);
                return image;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (((FileObject)arrayList.get(0)).isFolder()) {
            return image;
        }
        if (image2 != null) {
            image = Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)1);
        }
        return image;
    }

    public void copyReadableProps(NetworkFileSystem networkFileSystem) {
        try {
            this.setReadOnly(networkFileSystem.isReadOnly());
            this.setIgnoredFiles(networkFileSystem.getIgnoredFiles());
            this.setBackupExtensions(networkFileSystem.getBackupExtensions());
            this.setRefreshTime2(networkFileSystem.getRefreshTime2());
            this.setXDisplayDeviceNumber(networkFileSystem.getXDisplayDeviceNumber());
            this.setUseXtermCompile(networkFileSystem.getUseXtermCompile());
            this.setUseXtermExecution(networkFileSystem.getUseXtermExecution());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestProcessor getStatusChangeRequestProcessor() {
        Object object = STATUS_REQUEST_PROCESSOR_LOCK;
        synchronized (object) {
            if (statusRequestProcessor == null) {
                statusRequestProcessor = new RequestProcessor("SMB FS Status Update Request Processor");
            }
        }
        return statusRequestProcessor;
    }

    public FileObject findExistingResource(String string) {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        FileObject fileObject = null;
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string.equalsIgnoreCase(fileObject2.getPath())) continue;
            fileObject = fileObject2;
            break;
        }
        return fileObject;
    }

    public void statusChanged(final String string, final boolean bl) {
        NetworkFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fileObject;
                FileObject fileObject2 = NetworkFileSystem.this.findExistingResource(string);
                if (fileObject2 == null) {
                    return;
                }
                Enumeration enumeration = NetworkFileSystem.this.existingFileObjects(fileObject2);
                HashSet hashSet = new HashSet();
                if (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
                while (enumeration.hasMoreElements()) {
                    fileObject = (FileObject)enumeration.nextElement();
                    if (!bl && !fileObject2.equals(fileObject.getParent())) break;
                    hashSet.add(fileObject);
                }
                fileObject = Collections.synchronizedSet(hashSet);
                NetworkFileSystem.this.fireFileStatusChanged(new FileStatusEvent((FileSystem)NetworkFileSystem.this, (Set)fileObject, true, true));
            }
        });
    }

    static {
        STATUS_REQUEST_PROCESSOR_LOCK = new Object();
    }
}

