/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.io.IOException;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class FTPRecurseRefreshAction
extends NodeAction {
    static final long serialVersionUID = -7910677883191530523L;
    private RemoteFileSystem fs = null;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? FTPRecurseRefreshAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject == null) continue;
            FileObject fileObject = dataObject.getPrimaryFile();
            try {
                if (!fileObject.isFolder()) {
                    return false;
                }
                FileSystem fileSystem = fileObject.getFileSystem();
                if (!(fileSystem instanceof RemoteFileSystem)) {
                    return false;
                }
                if (((RemoteFileSystem)fileSystem).isConnected()) continue;
                return false;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return true;
    }

    private void refreshRecurse(String string, RemoteFileSystem remoteFileSystem) {
        String[] stringArray = remoteFileSystem.children(string);
        if (stringArray == null) {
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (remoteFileSystem.getRemoteFile(string + (string.equals("") ? "" : "/") + stringArray[i]) == null || !remoteFileSystem.getRemoteFile(string + (string.equals("") ? "" : "/") + stringArray[i]).isDirectory()) continue;
                this.refreshRecurse(string + (string.equals("") ? "" : "/") + stringArray[i], remoteFileSystem);
                FileObject fileObject = remoteFileSystem.findResource(string + (string.equals("") ? "" : "/") + stringArray[i]);
                if (fileObject == null) continue;
                fileObject.refresh();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        final Node[] nodeArray2 = nodeArray;
        boolean bl = true;
        Thread thread = new Thread("FTP-Refresh"){

            public void run() {
                for (int i = 0; i < nodeArray2.length; ++i) {
                    DataFolder dataFolder = (DataFolder)nodeArray2[i].getCookie(class$org$openide$loaders$DataFolder == null ? FTPRecurseRefreshAction.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                    if (dataFolder == null) continue;
                    FileObject fileObject = dataFolder.getPrimaryFile();
                    try {
                        FileSystem fileSystem = fileObject.getFileSystem();
                        FTPRecurseRefreshAction.this.refreshRecurse(fileObject.getParent().getPath(), (RemoteFileSystem)fileSystem);
                        fileObject.refresh();
                        continue;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                    }
                }
            }
        };
        thread.start();
    }

    protected void setFS(RemoteFileSystem remoteFileSystem) {
        this.fs = remoteFileSystem;
    }

    public String getName() {
        return "Refresh Recursively";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

