/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPClient;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class ConnectAction
extends NodeAction {
    static final long serialVersionUID = -7910677883191530621L;
    private RemoteFileSystem fs = null;

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        DataFolder dataFolder = (DataFolder)nodeArray[0].getCookie(DataFolder.class);
        if (dataFolder != null && nodeArray.length == 1) {
            FileObject fileObject = dataFolder.getPrimaryFile();
            return fileObject.isRoot();
        }
        return false;
    }

    protected void performAction(Node[] nodeArray) {
        DataFolder dataFolder = (DataFolder)nodeArray[0].getCookie(DataFolder.class);
        if (dataFolder != null) {
            FileObject fileObject = dataFolder.getPrimaryFile();
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                FTPClient.removeFromFailedAttempts(((FTPFileSystem)fileSystem).getServer(), ((FTPFileSystem)fileSystem).getUsername());
                if (fileSystem instanceof RemoteFileSystem) {
                    if (!((RemoteFileSystem)fileSystem).isConnected()) {
                        ((RemoteFileSystem)fileSystem).connectOnBackground();
                    } else {
                        ((RemoteFileSystem)fileSystem).disconnectOnBackground();
                    }
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
    }

    public void setFS(RemoteFileSystem remoteFileSystem) {
        this.fs = remoteFileSystem;
    }

    public String getName() {
        if (this.fs == null) {
            return "Connect/Disconnect";
        }
        if (this.fs.isConnected()) {
            return "Go Offline";
        }
        return "Go Online";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean asynchronous() {
        return false;
    }
}

