/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.execution.NbClassLoader;
import org.openide.util.NbBundle;

class NbResourceStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL_BOOT_RESOURCE = "nbresboot";
    public static final String PROTOCOL_CURRENT_RESOURCE = "nbrescurr";
    public static final String PROTOCOL_LOCALIZED_BOOT_RESOURCE = "nbresbootloc";
    public static final String PROTOCOL_LOCALIZED_CURRENT_RESOURCE = "nbrescurrloc";
    static /* synthetic */ Class class$org$openide$execution$NbResourceStreamHandler;

    NbResourceStreamHandler() {
    }

    public URLConnection openConnection(URL u) throws IOException {
        if (u.getProtocol().equals(PROTOCOL_BOOT_RESOURCE)) {
            return new Connection(u, 0, false);
        }
        if (u.getProtocol().equals(PROTOCOL_CURRENT_RESOURCE)) {
            return new Connection(u, 2, false);
        }
        if (u.getProtocol().equals(PROTOCOL_LOCALIZED_BOOT_RESOURCE)) {
            return new Connection(u, 0, true);
        }
        if (u.getProtocol().equals(PROTOCOL_LOCALIZED_CURRENT_RESOURCE)) {
            return new Connection(u, 2, true);
        }
        throw new IOException(NbBundle.getMessage((Class)(class$org$openide$execution$NbResourceStreamHandler == null ? (class$org$openide$execution$NbResourceStreamHandler = NbResourceStreamHandler.class$("org.openide.execution.NbResourceStreamHandler")) : class$org$openide$execution$NbResourceStreamHandler), (String)"EXC_UnrecognizedProtocol"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Connection
    extends URLConnection {
        private final boolean localized;
        private final int current;
        private URLConnection real;
        private IOException exception = null;
        private static final Set warnedURLs = new HashSet();

        public Connection(URL u, int current, boolean localized) {
            super(u);
            this.current = current;
            this.localized = localized;
            if (current == 0 && warnedURLs.add(u.toExternalForm())) {
                ErrorManager.getDefault().log(16, "Warning: in " + u.toExternalForm() + ", the " + u.getProtocol() + " URL protocol has been deprecated in favor of nbres/nbresloc which is less implementation-dependent.");
            } else if (current == 2 && warnedURLs.add(u.toExternalForm())) {
                ErrorManager.getDefault().log(16, "Warning: in " + u.toExternalForm() + ", the " + u.getProtocol() + " URL protocol has been deprecated as it assumes Filesystems == classpath.");
            }
        }

        /*
         * WARNING - void declaration
         */
        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException e = this.exception;
                this.exception = null;
                throw e;
            }
            if (!this.connected) {
                URL target;
                void var2_3;
                String resource = this.url.getFile();
                if (resource.startsWith("/")) {
                    resource = resource.substring(1);
                }
                switch (this.current) {
                    case 2: {
                        ClassLoader loader = new NbClassLoader();
                        break;
                    }
                    case 0: {
                        ClassLoader loader = (class$org$openide$execution$NbResourceStreamHandler == null ? (class$org$openide$execution$NbResourceStreamHandler = NbResourceStreamHandler.class$("org.openide.execution.NbResourceStreamHandler")) : class$org$openide$execution$NbResourceStreamHandler).getClassLoader();
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                if (this.localized) {
                    String basename;
                    String ext;
                    int index = resource.lastIndexOf(46);
                    if (index != -1) {
                        ext = resource.substring(index + 1);
                        basename = resource.substring(0, index).replace('/', '.');
                    } else {
                        ext = null;
                        basename = resource.replace('/', '.');
                    }
                    try {
                        target = NbBundle.getLocalizedFile((String)basename, (String)ext, (Locale)Locale.getDefault(), (ClassLoader)var2_3);
                    }
                    catch (MissingResourceException mre) {
                        throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(NbBundle.getMessage((Class)(class$org$openide$execution$NbResourceStreamHandler == null ? (class$org$openide$execution$NbResourceStreamHandler = NbResourceStreamHandler.class$("org.openide.execution.NbResourceStreamHandler")) : class$org$openide$execution$NbResourceStreamHandler), (String)"EXC_nbres_cannot_connect", (Object)this.url)), (Throwable)mre);
                    }
                } else {
                    target = var2_3.getResource(resource);
                    if (target == null) {
                        throw new IOException(NbBundle.getMessage((Class)(class$org$openide$execution$NbResourceStreamHandler == null ? (class$org$openide$execution$NbResourceStreamHandler = NbResourceStreamHandler.class$("org.openide.execution.NbResourceStreamHandler")) : class$org$openide$execution$NbResourceStreamHandler), (String)"EXC_nbres_cannot_connect", (Object)this.url));
                    }
                }
                this.real = target.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
        }

        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        public String getHeaderField(String key) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(key);
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }
    }
}

