/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ExternalCompiler
extends Compiler {
    private static ResourceBundle bundle;
    static final String SUN_ERROR_EXPR = "^([^ ][^\n]+):([0-9]+): (.*)";
    static final String MICROSOFT_ERROR_EXPR = "^([^\\(]+)\\(([0-9]+),([0-9]+)\\) : (.*)";
    static final String JIKES_ERROR_EXPR = "^([^ ]+):([0-9]+):([0-9]+):[0-9]+:[0-9]+:( |.*\n^)(.*)";
    public static final ErrorExpression JAVAC;
    public static final ErrorExpression JVC;
    public static final ErrorExpression JIKES;
    public static final Object COMPILE;
    public static final Object BUILD;
    public static final Object CLEAN;
    protected static final String CLASS_EXTENSION = "class";
    private FNP fileNameProducer;
    private NbProcessDescriptor nbDescriptor;
    private ErrorExpression errorExpression;
    private Object type;

    public ExternalCompiler(FileObject fileObject, Object object, NbProcessDescriptor nbProcessDescriptor, ErrorExpression errorExpression) {
        this.init(fileObject, object, nbProcessDescriptor, errorExpression);
    }

    public ExternalCompiler(CompilerJob compilerJob, FileObject fileObject, Object object, NbProcessDescriptor nbProcessDescriptor, ErrorExpression errorExpression) {
        this.init(fileObject, object, nbProcessDescriptor, errorExpression);
        compilerJob.add(this);
        this.registerInJob(compilerJob);
    }

    public ExternalCompiler(Compiler[] compilerArray, FileObject fileObject, Object object, NbProcessDescriptor nbProcessDescriptor, ErrorExpression errorExpression) {
        this.init(fileObject, object, nbProcessDescriptor, errorExpression);
        this.dependsOn(Arrays.asList(compilerArray));
        this.registerInJob(compilerArray[0]);
    }

    public ExternalCompiler(final File file, Object object, NbProcessDescriptor nbProcessDescriptor, ErrorExpression errorExpression) {
        if (file == null || object != COMPILE && object != BUILD || nbProcessDescriptor == null || errorExpression == null) {
            throw new IllegalArgumentException();
        }
        this.fileNameProducer = new FNP(){

            public String getFileName() {
                return file.toString();
            }

            public FileObject getFileObject() {
                return null;
            }

            public boolean equalTo(FNP fNP) {
                return fNP.equalToFile(file);
            }

            public boolean equalToFile(File file2) {
                return file.equals(file2);
            }

            public boolean equalToResource(String string) {
                return false;
            }

            public boolean equalToResourceAndFS(String string, FileSystem fileSystem) {
                return false;
            }

            public boolean equalToFileObject(FileObject fileObject) {
                return false;
            }
        };
        this.nbDescriptor = nbProcessDescriptor;
        this.errorExpression = errorExpression;
        this.type = object;
    }

    public ExternalCompiler(final FileSystem fileSystem, final String string, Object object, NbProcessDescriptor nbProcessDescriptor, ErrorExpression errorExpression) {
        if (fileSystem == null || string == null || object != COMPILE && object != BUILD || nbProcessDescriptor == null || errorExpression == null) {
            throw new IllegalArgumentException();
        }
        this.fileNameProducer = new FNP(){

            public String getFileName() {
                FileObject fileObject = fileSystem.findResource(string);
                if (fileObject == null) {
                    return "";
                }
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    return "";
                }
                return file.toString();
            }

            public FileObject getFileObject() {
                return fileSystem.findResource(string);
            }

            public boolean equalTo(FNP fNP) {
                return fNP.equalToResourceAndFS(string, fileSystem);
            }

            public boolean equalToFile(File file) {
                return false;
            }

            public boolean equalToResource(String string2) {
                return false;
            }

            public boolean equalToResourceAndFS(String string2, FileSystem fileSystem2) {
                return fileSystem.equals(fileSystem2) && string2.equals(string);
            }

            public boolean equalToFileObject(FileObject fileObject) {
                return false;
            }
        };
        this.nbDescriptor = nbProcessDescriptor;
        this.errorExpression = errorExpression;
        this.type = object;
    }

    public ExternalCompiler(final String string, Object object, NbProcessDescriptor nbProcessDescriptor, ErrorExpression errorExpression) {
        if (string == null || object != COMPILE && object != BUILD || nbProcessDescriptor == null || errorExpression == null) {
            throw new IllegalArgumentException();
        }
        this.fileNameProducer = new FNP(){

            public String getFileName() {
                FileObject fileObject = FileSystemCapability.ALL.findResource(string);
                if (fileObject == null) {
                    return "";
                }
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    return "";
                }
                return file.toString();
            }

            public FileObject getFileObject() {
                return FileSystemCapability.ALL.findResource(string);
            }

            public boolean equalTo(FNP fNP) {
                return fNP.equalToResource(string);
            }

            public boolean equalToFile(File file) {
                return false;
            }

            public boolean equalToResource(String string2) {
                return string2.equals(string);
            }

            public boolean equalToResourceAndFS(String string2, FileSystem fileSystem) {
                return false;
            }

            public boolean equalToFileObject(FileObject fileObject) {
                return false;
            }
        };
        this.nbDescriptor = nbProcessDescriptor;
        this.errorExpression = errorExpression;
        this.type = object;
    }

    private void init(final FileObject fileObject, Object object, NbProcessDescriptor nbProcessDescriptor, ErrorExpression errorExpression) {
        if (fileObject == null || object != COMPILE && object != BUILD || nbProcessDescriptor == null || errorExpression == null) {
            throw new IllegalArgumentException();
        }
        final File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("no such java.io.File: " + fileObject);
            ErrorManager errorManager = ErrorManager.getDefault();
            try {
                errorManager.annotate((Throwable)illegalArgumentException, NbBundle.getMessage((Class)ExternalCompiler.class, (String)"EXC_no_such_java_io_File", (Object)fileObject.getPath(), (Object)fileObject.getFileSystem().getDisplayName()));
                try {
                    fileObject.getInputStream().close();
                }
                catch (IOException iOException) {
                    errorManager.annotate((Throwable)illegalArgumentException, (Throwable)iOException);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                errorManager.annotate((Throwable)illegalArgumentException, (Throwable)fileStateInvalidException);
            }
            throw illegalArgumentException;
        }
        this.fileNameProducer = new FNP(){

            public String getFileName() {
                return file.toString();
            }

            public FileObject getFileObject() {
                return fileObject;
            }

            public boolean equalTo(FNP fNP) {
                return fNP.equalToFileObject(fileObject);
            }

            public boolean equalToFile(File file2) {
                return false;
            }

            public boolean equalToResource(String string) {
                return false;
            }

            public boolean equalToResourceAndFS(String string, FileSystem fileSystem) {
                return false;
            }

            public boolean equalToFileObject(FileObject fileObject2) {
                return fileObject2.equals(fileObject);
            }
        };
        this.nbDescriptor = nbProcessDescriptor;
        this.errorExpression = errorExpression;
        this.type = object;
    }

    public final NbProcessDescriptor getCompilerDescriptor() {
        return this.nbDescriptor;
    }

    public final ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    protected final FileObject getFileObject() {
        return this.fileNameProducer.getFileObject();
    }

    public String getFileName() {
        return this.fileNameProducer.getFileName();
    }

    private static boolean isUpToDate(FileObject fileObject, Date[] dateArray) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            Set set = dataObject.files();
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                FileObject fileObject2 = (FileObject)iterator.next();
                if (!fileObject2.getExt().equals(CLASS_EXTENSION)) continue;
                ++n;
                if (dateArray != null) {
                    dateArray[0] = fileObject2.lastModified();
                }
                if (fileObject2.lastModified().compareTo(fileObject.lastModified()) >= 0) continue;
                return false;
            }
            return n != 0;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    protected boolean isUpToDate() {
        if (this.type == BUILD) {
            return false;
        }
        FileObject fileObject = this.getFileObject();
        return fileObject == null || ExternalCompiler.isUpToDate(fileObject, null);
    }

    protected Date getTimeStamp() {
        if (this.type == BUILD) {
            return null;
        }
        FileObject fileObject = this.getFileObject();
        if (fileObject == null) {
            return null;
        }
        Date[] dateArray = new Date[1];
        ExternalCompiler.isUpToDate(fileObject, dateArray);
        return dateArray[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(" for ");
        stringBuffer.append(this.getFileName());
        stringBuffer.append(" ");
        if (this.type == COMPILE) {
            stringBuffer.append("COMPILE");
        } else {
            stringBuffer.append("BUILD");
        }
        return stringBuffer.toString();
    }

    public Class compilerGroupClass() {
        return ExternalCompilerGroup.class;
    }

    protected Object compilerType() {
        return this.nbDescriptor;
    }

    public Object compilerGroupKey() {
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        arrayList.add(super.compilerGroupKey());
        arrayList.add(this.compilerType());
        arrayList.add(this.errorExpression);
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object instanceof ExternalCompiler) {
            ExternalCompiler externalCompiler = (ExternalCompiler)object;
            return this.fileNameProducer.equalTo(externalCompiler.fileNameProducer) && this.compilerGroupKey().equals(externalCompiler.compilerGroupKey());
        }
        return false;
    }

    public int hashCode() {
        String string = this.getFileName();
        return string == null ? 0 : string.hashCode();
    }

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)ExternalCompiler.class);
        }
        return bundle.getString(string);
    }

    static {
        JAVAC = new ErrorExpression("CTL_Sun", SUN_ERROR_EXPR, 1, 2, -1, 3, false);
        JVC = new ErrorExpression("CTL_Microsoft", MICROSOFT_ERROR_EXPR, 1, 2, 3, 4, false);
        JIKES = new ErrorExpression("CTL_Jikes", JIKES_ERROR_EXPR, 1, 2, 3, 5, false);
        COMPILE = CompilerCookie.Compile.class;
        BUILD = CompilerCookie.Build.class;
        CLEAN = CompilerCookie.Clean.class;
    }

    static interface FNP {
        public String getFileName();

        public FileObject getFileObject();

        public boolean equalTo(FNP var1);

        public boolean equalToFile(File var1);

        public boolean equalToResource(String var1);

        public boolean equalToResourceAndFS(String var1, FileSystem var2);

        public boolean equalToFileObject(FileObject var1);
    }

    public static class ErrorExpression
    implements Serializable,
    Cloneable {
        private String name;
        private String errordesc;
        private int filepos;
        private int linepos;
        private int columnpos;
        private int descpos;
        private boolean resolved;
        static final long serialVersionUID = -2647801563993403964L;

        public ErrorExpression(String string, String string2, int n, int n2, int n3, int n4) {
            this(string, string2, n, n2, n3, n4, true);
        }

        ErrorExpression(String string, String string2, int n, int n2, int n3, int n4, boolean bl) {
            this.name = string;
            this.errordesc = string2;
            this.filepos = n;
            this.linepos = n2;
            this.columnpos = n3;
            this.descpos = n4;
            this.resolved = bl;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public String getName() {
            if (!this.resolved) {
                this.name = ExternalCompiler.getLocalizedString(this.name);
                this.resolved = true;
            }
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getErrorExpression() {
            return this.errordesc;
        }

        public void setErrorExpression(String string) {
            this.errordesc = string;
        }

        public int getFilePos() {
            return this.filepos;
        }

        public void setFilePos(int n) {
            this.filepos = n;
        }

        public int getLinePos() {
            return this.linepos;
        }

        public void setLinePos(int n) {
            this.linepos = n;
        }

        public int getColumnPos() {
            return this.columnpos;
        }

        public void setColumnPos(int n) {
            this.columnpos = n;
        }

        public int getDescriptionPos() {
            return this.descpos;
        }

        public void setDescriptionPos(int n) {
            this.descpos = n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ErrorExpression)) {
                return false;
            }
            ErrorExpression errorExpression = (ErrorExpression)object;
            return this.getName().equals(errorExpression.getName()) && this.errordesc.equals(errorExpression.errordesc) && this.filepos == errorExpression.filepos && this.linepos == errorExpression.linepos && this.columnpos == errorExpression.columnpos && this.descpos == errorExpression.descpos;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

