/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lexer.editorbridge;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.swing.FlyChildrenElement;
import org.netbeans.modules.lexer.editorbridge.OffsetTokenElement;
import org.netbeans.spi.lexer.inc.TextTokenUpdater;
import org.netbeans.spi.lexer.util.Compatibility;
import org.netbeans.spi.lexer.util.LexerUtilities;
import org.openide.ErrorManager;

public class TokenRootElement
extends TextTokenUpdater
implements FlyChildrenElement,
DocumentListener {
    private Segment seg = new Segment();
    protected final Document doc;
    protected final Language language;
    protected final boolean maintainLookbacks;
    private int lastUpdateStartOffset;
    private int lastUpdateEndOffset;
    static /* synthetic */ Class class$org$netbeans$modules$lexer$editorbridge$TokenRootElement;

    public static TokenRootElement get(Document document) {
        return (TokenRootElement)document.getProperty(class$org$netbeans$modules$lexer$editorbridge$TokenRootElement == null ? (class$org$netbeans$modules$lexer$editorbridge$TokenRootElement = TokenRootElement.class$("org.netbeans.modules.lexer.editorbridge.TokenRootElement")) : class$org$netbeans$modules$lexer$editorbridge$TokenRootElement);
    }

    public TokenRootElement(Document document, Language language) {
        this(document, language, true);
    }

    public TokenRootElement(Document document, Language language, boolean bl) {
        this.doc = document;
        this.language = language;
        this.maintainLookbacks = bl;
        this.initDocument();
    }

    private void initDocument() {
        this.doc.putProperty(class$org$netbeans$modules$lexer$editorbridge$TokenRootElement == null ? (class$org$netbeans$modules$lexer$editorbridge$TokenRootElement = TokenRootElement.class$("org.netbeans.modules.lexer.editorbridge.TokenRootElement")) : class$org$netbeans$modules$lexer$editorbridge$TokenRootElement, this);
        this.doc.addDocumentListener(this);
        if (this.doc.getLength() > 0) {
            this.update(this.doc, 0, this.doc.getLength());
        }
    }

    public char textCharAt(int n) {
        Segment segment = this.seg;
        synchronized (segment) {
            try {
                this.doc.getText(n, 1, this.seg);
                return this.seg.array[this.seg.offset];
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException(badLocationException.toString());
            }
        }
    }

    public int textLength() {
        return this.doc.getLength();
    }

    private String getDocumentText(int n, int n2) {
        try {
            return this.doc.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalStateException(badLocationException.getMessage());
        }
    }

    protected Token createToken(TokenId tokenId, int n, int n2) {
        if (this.lastUpdateStartOffset < 0) {
            this.lastUpdateStartOffset = n;
        }
        this.lastUpdateEndOffset = n + n2;
        OffsetTokenElement offsetTokenElement = new OffsetTokenElement(this, tokenId, n, n2);
        return offsetTokenElement;
    }

    protected Lexer createLexer() {
        return this.language.createLexer();
    }

    protected void add(Token token, int n, Object object) {
        this.add(token);
        OffsetTokenElement offsetTokenElement = (OffsetTokenElement)token;
        offsetTokenElement.setLookahead(n);
        offsetTokenElement.setState(object);
    }

    public int getLookahead() {
        return ((OffsetTokenElement)this.getToken(this.getValidPreviousIndex())).getLookahead();
    }

    public Object getState() {
        return ((OffsetTokenElement)this.getToken(this.getValidPreviousIndex())).getState();
    }

    public int getLookback() {
        if (this.maintainLookbacks) {
            return ((OffsetTokenElement)this.getToken(this.getValidPreviousIndex())).getLookback();
        }
        return -1;
    }

    protected void setLookback(int n) {
        if (this.maintainLookbacks) {
            ((OffsetTokenElement)this.getToken(this.getValidPreviousIndex())).setLookback(n);
        }
    }

    public boolean hasNext() {
        return super.hasNext();
    }

    public Token next() {
        return super.next();
    }

    public int relocate(int n) {
        return super.relocate(n);
    }

    public synchronized void update(int n, int n2) {
        this.lastUpdateStartOffset = -1;
        this.lastUpdateEndOffset = -1;
        super.update(n, n2);
        if (this.lastUpdateStartOffset == -1) {
            this.lastUpdateStartOffset = n;
            this.lastUpdateEndOffset = n;
        }
    }

    public synchronized int getLastUpdateStartOffset() {
        if (this.lastUpdateStartOffset == -1) {
            ErrorManager.getDefault().log(1, "TokenRootElement.getLastUpdateStartOffset(): lastUpdateStartOffset == (-1)");
            return 0;
        }
        return this.lastUpdateStartOffset;
    }

    public synchronized int getLastUpdateEndOffset() {
        if (this.lastUpdateEndOffset == -1) {
            ErrorManager.getDefault().log(1, "TokenRootElement.getLastUpdateEndOffset(): lastUpdateEndOffset == (-1)");
            return 0;
        }
        return this.lastUpdateEndOffset;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getParentElement() {
        return null;
    }

    public String getName() {
        return "";
    }

    public AttributeSet getAttributes() {
        return null;
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return this.doc.getLength();
    }

    public synchronized int getElementIndex(int n) {
        return this.findTokenIndex(n);
    }

    public synchronized int getElementOffset(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("elementIndex=" + n);
        }
        return this.findTokenOffset(n);
    }

    public synchronized int getElementCount() {
        return this.getTokenCount();
    }

    public synchronized Element getElement(int n) {
        return (Element)this.getToken(n);
    }

    public boolean isLeaf() {
        return false;
    }

    public synchronized String tokensToString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getTokenCount();
        stringBuffer.append("Token count: " + n + "\n");
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                Token token = this.getToken(i);
                int n3 = Compatibility.getLength((Token)token);
                String string = Compatibility.toString((Token)token);
                stringBuffer.append("[" + i + "] \"" + LexerUtilities.toSource((String)string) + "\", " + token.getId() + ", off=" + n2);
                OffsetTokenElement offsetTokenElement = (OffsetTokenElement)token;
                if (this.getOffset(offsetTokenElement.getRawOffset()) != n2) {
                    throw new IllegalStateException("offsets differ");
                }
                stringBuffer.append(", la=" + offsetTokenElement.getLookahead() + ", lb=" + offsetTokenElement.getLookback() + ", st=" + offsetTokenElement.getState() + "\n");
                n2 += n3;
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println(stringBuffer.toString());
            throw runtimeException;
        }
        return stringBuffer.toString();
    }

    private void update(Document document, int n, int n2) {
        this.update(n, n2);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getLength();
        if (n == 0) {
            n = documentEvent.getDocument().getLength();
        }
        this.update(documentEvent.getDocument(), documentEvent.getOffset(), n);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent.getDocument(), documentEvent.getOffset(), -documentEvent.getLength());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

