/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.rmi.protocol.RemoteData;
import org.netbeans.modules.distributed.rmi.protocol.RemoteErrorStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteInputStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteOutputStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteProcess;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RemoteProcessDescriptor
implements Serializable {
    private static final long serialVersionUID = -4535211234565221486L;
    private static ErrorManager execLog;
    private String processName;
    private String arguments;
    private String info;
    private String[] cmds;
    private RemoteRuntimeType rrt;

    public RemoteProcessDescriptor(String string, String string2) {
        this(string, string2, "");
    }

    public RemoteProcessDescriptor(String string, String string2, String[] stringArray) {
        this(string, string2);
        this.cmds = stringArray;
    }

    public RemoteProcessDescriptor(String string, String string2, String string3) {
        this.processName = string;
        this.arguments = string2;
        this.info = string3;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getInfo() {
        return this.info;
    }

    public String[] getCmds() {
        return this.cmds;
    }

    public Process exec(Format format, String[] stringArray, String string) throws IOException {
        return this.exec(format, stringArray, false, string, false, Utils.getIntendedHostAddress());
    }

    public Process exec(Format format, String[] stringArray, boolean bl, String string, boolean bl2, String string2) throws IOException {
        int n;
        Object object;
        Iterator iterator;
        int n2;
        String string3 = format == null ? this.arguments : format.format(this.arguments);
        String[] stringArray2 = RemoteProcessDescriptor.parseArguments(string3);
        String[] stringArray3 = null;
        stringArray = RemoteProcessDescriptor.substituteEnv(format, stringArray);
        int n3 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i] == null || stringArray2[i].equals("")) continue;
            ++n3;
        }
        String[] stringArray4 = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            if (stringArray2[n2] == null || stringArray2[n2].equals("")) continue;
            stringArray4[n2] = stringArray2[n2];
        }
        stringArray3 = new String[stringArray4.length + 1];
        stringArray3[0] = format == null ? this.processName : format.format(this.processName);
        System.arraycopy(stringArray4, 0, stringArray3, 1, stringArray4.length);
        RemoteProcessDescriptor.logArgs(stringArray3);
        if (stringArray != null && bl) {
            HashMap hashMap = new HashMap(100);
            iterator = System.getProperties().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                object = (String)entry.getKey();
                if (!((String)object).startsWith("Env-")) continue;
                String string4 = ((String)object).substring(4);
                hashMap.put(string4, entry.getValue());
            }
            for (n = 0; n < stringArray.length; ++n) {
                object = stringArray[n];
                int n4 = ((String)object).indexOf(61);
                if (n4 == -1) {
                    throw new IOException("No equal sign in name=value: " + (String)object);
                }
                hashMap.put(((String)object).substring(0, n4), ((String)object).substring(n4 + 1));
            }
            stringArray = new String[hashMap.size()];
            n = 0;
            iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringArray[n++] = (String)object.getKey() + '=' + (String)object.getValue();
            }
        }
        n2 = Utilities.getOperatingSystem();
        iterator = null;
        n = 0;
        try {
            Object object2;
            if (n2 == 4) {
                iterator = Thread.currentThread();
                n = ((Thread)((Object)iterator)).getPriority();
                ((Thread)((Object)iterator)).setPriority(5);
            }
            byte[] byArray = new byte[4 + this.rrt.getSecurityContext().length];
            System.arraycopy(this.rrt.getSecurityContext(), 0, byArray, 4, this.rrt.getSecurityContext().length);
            if (this.isJavaCmd(stringArray3[0])) {
                System.arraycopy("JAVA".getBytes(), 0, byArray, 0, 4);
                object = string != null ? this.rrt.getRemoteRuntime().exec(stringArray3, null, string, bl2, string2, byArray) : this.rrt.getRemoteRuntime().exec(stringArray3, bl2, string2, byArray);
            } else {
                System.arraycopy("DCLC".getBytes(), 0, byArray, 0, 4);
                object2 = stringArray3[0] + " " + string3;
                object = string != null ? this.rrt.getRemoteRuntime().exec(new String[]{object2}, null, string, bl2, string2, byArray) : this.rrt.getRemoteRuntime().exec((String)object2, bl2, string2, byArray);
            }
            object2 = new RemoteProcessWrapper((RemoteProcess)object);
            this.rrt.addRemoteProcess((Process)object2);
            Object object3 = object2;
            return object3;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            throw new IOException(exception.toString());
        }
        finally {
            if (n2 == 4) {
                ((Thread)((Object)iterator)).setPriority(n);
            }
        }
    }

    private static void logArgs(String[] stringArray) {
        try {
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.distributed.remoteexecute.Bundle");
            String string = resourceBundle.getString("CTL_Exec");
            String string2 = resourceBundle.getString("FMT_ExecParams");
            MessageFormat messageFormat = new MessageFormat(string2);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(string);
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(messageFormat.format(new Object[]{new Integer(i), stringArray[i]}));
            }
            printWriter.close();
            RemoteProcessDescriptor.getExecLog().log(1, stringWriter.toString());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public Process exec(String[] stringArray, RemoteRuntimeType remoteRuntimeType, String[] stringArray2, String string, boolean bl, String string2, byte[] byArray) throws IOException {
        this.rrt = remoteRuntimeType;
        byte[] byArray2 = new byte[4 + remoteRuntimeType.getSecurityContext().length];
        System.arraycopy(remoteRuntimeType.getSecurityContext(), 0, byArray2, 4, remoteRuntimeType.getSecurityContext().length);
        System.arraycopy("DCLC".getBytes(), 0, byArray2, 0, 4);
        RemoteProcess remoteProcess = remoteRuntimeType.getRemoteRuntime().exec(stringArray, stringArray2, string, bl, string2, byArray2);
        RemoteProcessWrapper remoteProcessWrapper = new RemoteProcessWrapper(remoteProcess);
        remoteRuntimeType.addRemoteProcess((Process)remoteProcessWrapper);
        return remoteProcessWrapper;
    }

    public Process exec(Format format, RemoteRuntimeType remoteRuntimeType, boolean bl, String string, String string2) throws IOException {
        this.rrt = remoteRuntimeType;
        return this.exec(format, null, false, string, bl, string2);
    }

    public Process exec() throws IOException {
        return this.exec(null, null, false, null, Utils.getIntendedHostAddress());
    }

    public int hashCode() {
        return this.processName.hashCode() + this.arguments.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteProcessDescriptor)) {
            return false;
        }
        RemoteProcessDescriptor remoteProcessDescriptor = (RemoteProcessDescriptor)object;
        return this.processName.equals(remoteProcessDescriptor.processName) && this.arguments.equals(remoteProcessDescriptor.arguments);
    }

    private static String[] parseArguments(String string) {
        return Utilities.parseParameters((String)string);
    }

    private static ErrorManager getExecLog() {
        if (execLog == null) {
            execLog = ErrorManager.getDefault().getInstance("IDE-Exec");
        }
        return execLog;
    }

    private boolean isJavaCmd(String string) {
        return string.endsWith("/java") || string.endsWith("/javac");
    }

    private static String[] substituteEnv(Format format, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || format == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            stringArray2[i] = stringArray[i];
            if (stringArray2[i] == null || (n = stringArray2[i].indexOf(61)) < 0) continue;
            String string = stringArray2[i].substring(n + 1);
            String string2 = stringArray2[i].substring(0, n);
            stringBuffer.append(string2).append('=').append(format.format(string));
            stringArray2[i] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        return stringArray2;
    }

    public class RemoteProcessWrapper
    extends Process {
        RemoteProcess rp;

        public RemoteProcessWrapper(RemoteProcess remoteProcess) {
            this.rp = remoteProcess;
        }

        public void destroy() {
            try {
                this.rp.destroy();
                RemoteProcessDescriptor.this.rrt.removeRemoteProcess((Process)this);
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().log(remoteException.getMessage());
            }
            catch (Exception exception) {
                ErrorManager.getDefault().log(exception.getMessage());
            }
        }

        public int exitValue() {
            try {
                int n = this.rp.exitValue();
                System.err.println("distnb:remoteprocess:vms ret code:" + n);
                if (n % 2 == 0) {
                    return 1;
                }
                return 0;
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                return -1;
            }
        }

        public InputStream getErrorStream() {
            try {
                return new RemoteErrorStreamWrapper(this.rp.getErrorStream());
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                return null;
            }
        }

        public InputStream getInputStream() {
            try {
                return new RemoteInputStreamWrapper(this.rp.getInputStream());
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                return null;
            }
        }

        public OutputStream getOutputStream() {
            try {
                return new RemoteOutputStreamWrapper(this.rp.getOutputStream());
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                return null;
            }
        }

        public int waitFor() {
            try {
                int n = this.rp.waitFor();
                System.err.println("distnb:remoteprocess:vms ret code:" + n);
                if (n == 1076) {
                    return n;
                }
                if (n == 98954) {
                    return n;
                }
                if (n % 2 == 0) {
                    return 1;
                }
                return 0;
            }
            catch (RemoteException remoteException) {
                ErrorManager.getDefault().notify((Throwable)remoteException);
                return -1;
            }
        }
    }

    public static class RemoteOutputStreamWrapper
    extends OutputStream {
        RemoteOutputStream re;

        public RemoteOutputStreamWrapper(RemoteOutputStream remoteOutputStream) {
            this.re = remoteOutputStream;
        }

        public void close() throws IOException {
            try {
                this.re.close();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void flush() throws IOException {
            try {
                this.re.flush();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void write(int n) throws IOException {
            try {
                this.re.write(n);
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.re.write(byArray, n, n2);
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void write(byte[] byArray) throws IOException {
            try {
                this.re.write(byArray);
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }
    }

    public static class RemoteErrorStreamWrapper
    extends InputStream {
        RemoteErrorStream re;

        public RemoteErrorStreamWrapper(RemoteErrorStream remoteErrorStream) {
            this.re = remoteErrorStream;
        }

        public int available() throws IOException {
            try {
                return this.re.available();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                this.re.close();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void mark(int n) {
            try {
                this.re.mark(n);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean markSupported() {
            try {
                return this.re.markSupported();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }

        public int read() throws IOException {
            try {
                return this.re.read();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public int read(byte[] byArray) throws IOException {
            try {
                return this.read(byArray, 0, byArray.length);
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                RemoteData remoteData = this.re.read(byArray, n, n2);
                System.arraycopy(remoteData.getData(), n, byArray, n, n2);
                return remoteData.getReturn();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void reset() throws IOException {
            try {
                this.re.reset();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public long skip(long l) throws IOException {
            try {
                return this.re.skip(l);
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }
    }

    public static class RemoteInputStreamWrapper
    extends InputStream {
        RemoteInputStream re;

        public RemoteInputStreamWrapper(RemoteInputStream remoteInputStream) {
            this.re = remoteInputStream;
        }

        public int available() throws IOException {
            try {
                return this.re.available();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                this.re.close();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void mark(int n) {
            try {
                this.re.mark(n);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean markSupported() {
            try {
                return this.re.markSupported();
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }

        public int read() throws IOException {
            try {
                return this.re.read();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public int read(byte[] byArray) throws IOException {
            try {
                return this.read(byArray, 0, byArray.length);
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                RemoteData remoteData = this.re.read(byArray, n, n2);
                System.arraycopy(remoteData.getData(), n, byArray, n, n2);
                return remoteData.getReturn();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public void reset() throws IOException {
            try {
                this.re.reset();
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }

        public long skip(long l) throws IOException {
            try {
                return this.re.skip(l);
            }
            catch (RemoteException remoteException) {
                throw new IOException(remoteException.getMessage());
            }
        }
    }
}

