/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.lexer.SampleTextMatcher;

public final class TokenId {
    public static final Comparator NAME_COMPARATOR = NameComparator.INSTANCE;
    public static final Comparator INT_ID_COMPARATOR = IntIdComparator.INSTANCE;
    private static final List EMPTY_CATEGORY_NAMES_LIST = new ReadonlyList(new String[0]);
    private static final List categoryCache = new ArrayList();
    private final String name;
    private final int intId;
    private final List categoryNamesList;
    private final SampleTextMatcher sampleTextMatcher;

    public TokenId(String string, int n) {
        this(string, n, null, null);
    }

    public TokenId(String string, int n, String[] stringArray) {
        this(string, n, stringArray, null);
    }

    public TokenId(String string, int n, String[] stringArray, SampleTextMatcher sampleTextMatcher) {
        if (string == null) {
            throw new NullPointerException("TokenId name cannot be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("intId=" + n + " of token=" + string + " is < 0");
        }
        if (string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("TokenId name=" + string + " cannot contain '.' character.");
        }
        this.name = string;
        this.intId = n;
        this.categoryNamesList = this.internCategoryNames(stringArray);
        this.sampleTextMatcher = sampleTextMatcher;
    }

    public String getName() {
        return this.name;
    }

    public int getIntId() {
        return this.intId;
    }

    public List getCategoryNames() {
        return this.categoryNamesList;
    }

    public SampleTextMatcher getSampleTextMatcher() {
        return this.sampleTextMatcher;
    }

    private List internCategoryNames(String[] stringArray) {
        List list = EMPTY_CATEGORY_NAMES_LIST;
        if (stringArray != null && stringArray.length > 0) {
            int n = Collections.binarySearch(categoryCache, stringArray, CategoryNamesComparator.INSTANCE);
            if (n < 0) {
                n = -n - 1;
                categoryCache.add(n, new ReadonlyList((String[])stringArray.clone()));
            }
            list = (List)categoryCache.get(n);
        }
        return list;
    }

    public String toString() {
        return this.getName() + "[" + this.getIntId() + "]";
    }

    public String toStringDetail() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString());
        if (this.categoryNamesList.size() > 0) {
            stringBuffer.append(", cats=");
            stringBuffer.append(this.categoryNamesList.toString());
        }
        if (this.sampleTextMatcher != null) {
            stringBuffer.append(", sampleTextMatcher=");
            stringBuffer.append(this.sampleTextMatcher);
        }
        return stringBuffer.toString();
    }

    public static String categoryCacheToString() {
        return categoryCache.toString();
    }

    private static final class IntIdComparator
    implements Comparator {
        static final Comparator INSTANCE = new IntIdComparator();

        private IntIdComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((TokenId)object).getIntId() - ((TokenId)object2).getIntId();
        }
    }

    private static final class NameComparator
    implements Comparator {
        static final Comparator INSTANCE = new NameComparator();

        private NameComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((TokenId)object).getName().compareTo(((TokenId)object2).getName());
        }
    }

    private static final class CategoryNamesComparator
    implements Comparator {
        static Comparator INSTANCE = new CategoryNamesComparator();

        private CategoryNamesComparator() {
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray;
            Object[] objectArray2 = object instanceof List ? ((ReadonlyList)object).objs : (Object[])object;
            int n = objectArray2.length;
            int n2 = n - (objectArray = object2 instanceof List ? ((ReadonlyList)object2).objs : (Object[])object2).length;
            if (n2 != 0) {
                return n2;
            }
            for (int i = 0; i < n; ++i) {
                int n3 = ((String)objectArray2[i]).compareTo(objectArray[i]);
                if (n3 == 0) continue;
                return n3;
            }
            return 0;
        }
    }

    static final class ReadonlyList
    extends AbstractList {
        Object[] objs;

        ReadonlyList(Object[] objectArray) {
            this.objs = objectArray;
        }

        public int size() {
            return this.objs.length;
        }

        public Object get(int n) {
            return this.objs[n];
        }
    }
}

