/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.utils;

import com.hp.openvms.netbeans.utils.FileUtility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import org.openide.ErrorManager;

public class DCLExecutor {
    private static final int MAX_CMD_LEN = 234;
    public static final int DCL_EXECUTION_DECTERM = 0;
    public static final int DCL_EXECUTION_STDOUT = 1;

    private static String composeDCLCmd(int idx, String cmd) {
        return "$ s" + idx + " := " + "\"" + cmd + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDCLFile(String fname, Vector dclCmds) throws IOException {
        PrintWriter pout = null;
        try {
            FileOutputStream outFile = new FileOutputStream(fname);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outFile));
            pout = new PrintWriter((Writer)out, true);
            for (int i = 0; i < dclCmds.size(); ++i) {
                pout.println((String)dclCmds.get(i));
            }
        }
        finally {
            if (pout != null) {
                pout.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process execute(String fname, int executionType) throws IOException {
        if (executionType == 0) {
            PrintWriter pout = null;
            File tmpDCLFile = File.createTempFile("compilerparams", ".bat");
            tmpDCLFile.deleteOnExit();
            try {
                FileOutputStream outFile = new FileOutputStream(tmpDCLFile.getAbsolutePath());
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outFile));
                pout = new PrintWriter((Writer)out, true);
                pout.println("$ create/term/wait @" + FileUtility.unixPathToOpenVMSPath(fname, false));
                pout.println("$ exit %X10000000");
            }
            finally {
                if (pout != null) {
                    pout.close();
                }
            }
            return Runtime.getRuntime().exec(tmpDCLFile.getAbsolutePath());
        }
        return Runtime.getRuntime().exec(fname);
    }

    public static Vector preprocessDCLCmds(String[] DCLCmds, int executionType) {
        Vector<String> newDCLCmds = new Vector<String>();
        if (DCLCmds.length > 0) {
            newDCLCmds.add("$ set noon");
        }
        for (int i = 0; i < DCLCmds.length; ++i) {
            if (DCLCmds[i] == null) continue;
            DCLExecutor.preprocessDCLCmd(DCLCmds[i], newDCLCmds);
        }
        if (executionType == 0) {
            DCLExecutor.preprocessDCLCmd("inquire/local check \"\"Press enter to exit\"\"", newDCLCmds);
            newDCLCmds.add("$ exit %X10000000");
        } else {
            newDCLCmds.add("$ saved_severity = $severity");
            newDCLCmds.add("$ saved_status = $status");
            newDCLCmds.add("$ if (saved_severity .eq. 4) .or. (saved_severity .eq. 2) then goto done");
            newDCLCmds.add("$ exit %X10000000");
            newDCLCmds.add("$ done :");
            newDCLCmds.add("$ exit saved_status");
        }
        return newDCLCmds;
    }

    public static Process execute(String fname, String[] DCLCmds, int executionType) throws IOException {
        Vector newDCLCmds = DCLExecutor.preprocessDCLCmds(DCLCmds, executionType);
        try {
            DCLExecutor.createDCLFile(fname, newDCLCmds);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            throw new IOException(e.toString());
        }
        return DCLExecutor.execute(fname, executionType);
    }

    public static void preprocessDCLCmd(String cmd, Vector dclCmds) {
        int numSubcmd = (int)Math.ceil((double)cmd.length() / 234.0);
        String fcmd = "$ ";
        int idx = 0;
        for (int i = 0; i < numSubcmd; ++i) {
            int eidx = idx + 234 >= cmd.length() ? cmd.length() : idx + 234;
            dclCmds.add(DCLExecutor.composeDCLCmd(i, cmd.substring(idx, eidx)));
            idx += 234;
            fcmd = fcmd + "'" + "s" + i + "'";
        }
        dclCmds.add("$ define/user/nolog sys$error sys$output");
        dclCmds.add(fcmd);
    }
}

