/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.beans.editors;

import com.hp.openvms.netbeans.beans.editors.CommandCustomEditor;
import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class CommandEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
    static final String PROPERTY_NAME = "propertyName";
    static final String COMPILER_TYPE = "compilerType";
    private String propertyName;
    private Integer compilerType;
    private FeatureDescriptor fd;
    private boolean editable = true;

    public boolean isEditable() {
        return this.editable;
    }

    public void setAsText(String s) {
        this.setValue(s);
    }

    public String getJavaInitializationString() {
        String s = (String)this.getValue();
        return "\"" + CommandEditor.toAscii(s) + "\"";
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        Object val = this.getValue();
        String s = "";
        if (val != null) {
            s = val.toString();
        }
        return new CommandCustomEditor(this, this.isEditable());
    }

    private static String toAscii(String str) {
        StringBuffer buf = new StringBuffer(str.length() * 6);
        char[] chars = str.toCharArray();
        block9: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && (useRaw || c <= '\u007f')) {
                        buf.append(c);
                        continue block9;
                    }
                    buf.append("\\u");
                    String hex = Integer.toHexString(c);
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buf.append('0');
                    }
                    buf.append(hex);
                }
            }
        }
        return buf.toString();
    }

    public void attachEnv(PropertyEnv env) {
        this.fd = env.getFeatureDescriptor();
    }

    public Method getMethod() {
        return (Method)this.fd.getValue("method");
    }

    public String getParam() {
        return (String)this.fd.getValue("param");
    }

    public Object getObject() {
        return this.fd.getValue("object");
    }

    public String getContext() {
        return (String)this.fd.getValue("context");
    }

    public String getHelpID() {
        return (String)this.fd.getValue("helpID");
    }

    public String getInherit() {
        Method m = this.getMethod();
        Object obj = this.getObject();
        String param = this.getParam();
        String value = null;
        try {
            value = (String)m.invoke(obj, param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

