/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.editor.cobol;

import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerType;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.CTokenContext;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.CobolFormatSupport;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.IndentInfo;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.StringLexerInput;
import com.hp.openvms.netbeans.cobolsupport.editor.lang.CobolLanguage;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.openide.compiler.CompilerType;

public class CobolFormatter
extends ExtFormatter {
    static /* synthetic */ Class class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType;

    public CobolFormatter(Class kitClass) {
        super(kitClass);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof PlainSyntax;
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        int[] ret = null;
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        int dotPos = target.getCaret().getDot();
        if (doc != null) {
            if ("e".equals(typedText) | "E".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if (fnw >= 0 && fnw + 4 == dotPos && "else".equals(doc.getText(fnw, 4)) | "ELSE".equals(doc.getText(fnw, 4))) {
                        ret = new int[]{fnw, fnw + 4};
                    }
                }
                catch (BadLocationException e) {}
            } else if ("f".equals(typedText) | "F".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if ("end-if".equals(doc.getText(fnw, 6)) | "END-IF".equals(doc.getText(fnw, 6))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {}
            } else if ("n".equals(typedText) | "N".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if ("then".equals(doc.getText(fnw, 4)) | "THEN".equals(doc.getText(fnw, 4))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
        this.addFormatLayer((FormatLayer)new CobolLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter fw) {
        return new CobolFormatSupport(fw);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class CobolLayer
    extends AbstractFormatLayer {
        public int initialIndentation = 0;
        public boolean procDiv = false;

        public CobolLayer() {
            super("cobol-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new CobolFormatSupport(fw);
        }

        public TokenContextPath getTokenContextPath() {
            return CTokenContext.contextPath;
        }

        public TokenID getWhitespaceTokenID() {
            return CTokenContext.WHITESPACE;
        }

        public TokenContextPath getWhitespaceTokenContextPath() {
            return this.getTokenContextPath();
        }

        public void insertWhiteSpace(FormatWriter fw, FormatTokenPosition pos, int indent) {
            if (pos.getToken() != null) {
                for (int i = 0; i < indent; ++i) {
                    fw.insertString(pos.getToken(), 0, " ");
                }
            } else {
                for (int i = 0; i < indent; ++i) {
                    fw.insertToken(null, null, null, " ");
                }
            }
        }

        public boolean isWhiteSpace(FormatTokenPosition pos) {
            CobolLanguage language = CobolLanguage.get();
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            Token tok = lex.nextToken();
            return tok.getId().getIntId() == 2;
        }

        public TokenItem findLineStartToken(TokenItem token, CobolFormatSupport fs) {
            if (token != null) {
                FormatTokenPosition pos = fs.getPosition(token, 0);
                pos = fs.findLineStart(pos);
                token = pos.getToken();
                while (token.getTokenID() == CTokenContext.WHITESPACE) {
                    token = token.getNext();
                }
            }
            return token;
        }

        public boolean isAnsiFormatLabel(TokenItem token, CobolFormatSupport fs) {
            FormatTokenPosition tp;
            return token != null && fs.isAnsiFormat() && token.getTokenID() == CTokenContext.NUM_LITERAL_INT && fs.getVisualColumnOffset(tp = fs.getPosition(token, 0)) + token.getImage().length() <= 6;
        }

        public void createAnsiFormatedLine(FormatWriter fw, FormatTokenPosition pos, CobolFormatSupport fs) {
            if (pos != null) {
                TokenItem startToken = null;
                if (fs.getVisualColumnOffset(pos) < 7) {
                    String tmpStr;
                    String lblStr = tmpStr = pos.getToken().getImage();
                    if (tmpStr.length() >= 6) {
                        lblStr = tmpStr.substring(0, 6);
                    }
                    if (lblStr.trim().length() >= 1) {
                        try {
                            int n = Integer.parseInt(lblStr);
                        }
                        catch (NumberFormatException nfe) {
                            for (int i = 0; i < 7; ++i) {
                                fw.insertString(pos.getToken(), 0, " ");
                            }
                            pos = fs.findLineFirstNonWhitespace(pos);
                            return;
                        }
                        startToken = fs.splitStart(pos.getToken(), 6, (TokenID)CTokenContext.NUM_LITERAL_INT, this.getTokenContextPath());
                    }
                    if (startToken != null) {
                        TokenItem nextToken = startToken.getNext();
                        if (fs.getVisualColumnOffset(fs.getPosition(nextToken, 0)) == 7 && nextToken.getImage().length() >= 1 && nextToken.getImage().substring(0, 1) != " ") {
                            String cntStr = nextToken.getImage().substring(0, 1);
                            TokenItem cntToken = fs.splitStart(nextToken, 1, (TokenID)new BaseTokenID(cntStr), this.getTokenContextPath());
                            nextToken = cntToken.getNext();
                        }
                        pos = fs.getPosition(nextToken, 0);
                    }
                } else if (fs.getVisualColumnOffset(pos) == 7 && !fs.isComment(pos)) {
                    this.insertWhiteSpace(fw, pos, 7);
                }
            }
        }

        public void removeFirstTabFromLine(FormatWriter fw, FormatTokenPosition pos, CobolFormatSupport fs) {
            FormatTokenPosition tmpPos = pos;
            FormatTokenPosition savPos = pos;
            if (tmpPos != null) {
                while (tmpPos != null && tmpPos.getToken() != null && tmpPos.getToken().getImage() != null && tmpPos.getToken().getImage().charAt(0) != '\n') {
                    savPos = tmpPos;
                    if ((tmpPos = fs.getPreviousPosition(tmpPos)) != null) continue;
                }
                if ((tmpPos = savPos) != null && tmpPos.getToken() != null && tmpPos.getToken().getImage() != null && tmpPos.getToken().getImage().charAt(0) != '\n') {
                    savPos = tmpPos;
                    String tabString = savPos.getToken().getImage();
                    while (tabString.indexOf(9) != -1) {
                        int tabPos = tabString.indexOf(9);
                        tabString = tabString.substring(0, tabPos) + tabString.substring(tabString.indexOf(9) + 1, tabString.length());
                        fw.remove(tmpPos.getToken(), tabPos, 1);
                        for (int i = 0; i < fs.getSpacesPerTab(); ++i) {
                            tabString = tabString.substring(0, tabPos) + " " + tabString.substring(tabPos, tabString.length());
                            fw.insertString(savPos.getToken(), tabPos, " ");
                        }
                    }
                }
            }
        }

        public void removeWhiteSpace(FormatWriter fw, FormatTokenPosition pos, int indent) {
            CobolLanguage language = CobolLanguage.get();
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = ((Language)language).createLexer();
            lex.restart(input, null);
            Token tok = lex.nextToken();
            if (tok != null && tok.getId().getIntId() == 2) {
                for (int i = 0; i < indent; ++i) {
                    fw.remove(pos.getToken(), 0, 1);
                }
            }
        }

        public void AdjustCursor(FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, int indent) {
            this.insertWhiteSpace(fw, pos, indent);
        }

        public int findInlineSpacing(TokenItem token, CobolFormatSupport fs) {
            int additionalIndent = 0;
            TokenItem startToken = this.findLineStartToken(token, fs);
            if (this.isAnsiFormatLabel(startToken, fs)) {
                additionalIndent = 6 - token.getImage().length();
                startToken = startToken.getNext();
            }
            TokenItem indentToken = fs.findImportantToken(token, null, true);
            for (startToken = this.findLineStartToken(indentToken, fs); startToken != null && (this.isAnsiFormatLabel(startToken, fs) || startToken.getTokenID() == CTokenContext.WHITESPACE); startToken = startToken.getNext()) {
            }
            FormatTokenPosition tp1 = fs.getPosition(startToken, 0);
            return Math.max(7, fs.getVisualColumnOffset(tp1) + additionalIndent);
        }

        public void IndentLine(CobolFormatSupport fs, FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, int indent) {
            FormatTokenPosition firstNWS = fs.findLineFirstNonWhitespace(pos);
            int tempIndent = idf.getIndent();
            if (firstNWS != null) {
                if (this.isAnsiFormatLabel(firstNWS.getToken(), fs)) {
                    TokenItem nexToken = firstNWS.getToken().getNext();
                    while (nexToken.getTokenID() == this.getWhitespaceTokenID()) {
                        TokenItem nt = nexToken.getNext();
                        fs.removeToken(nexToken);
                        nexToken = nt;
                    }
                    indent = this.findInlineSpacing(firstNWS.getToken(), fs);
                    for (int i = 0; i < indent - 6; ++i) {
                        fs.insertToken(nexToken, fs.getValidWhitespaceTokenID(), fs.getValidWhitespaceTokenContextPath(), " ");
                    }
                    indent = 1;
                    tempIndent = 1;
                }
                boolean remove = true;
                if (indent != tempIndent) {
                    int temp;
                    if (indent > tempIndent) {
                        temp = indent - tempIndent;
                        if (fs.isAnsiFormat()) {
                            int count;
                            FormatTokenPosition tmpPos = firstNWS;
                            for (count = 0; count < 7 && tmpPos.getToken().getImage() == " "; ++count) {
                                tmpPos = fs.getNextPosition(tmpPos);
                            }
                            temp = temp + count - 7;
                            this.insertWhiteSpace(fw, tmpPos, temp);
                        } else {
                            this.insertWhiteSpace(fw, firstNWS, temp);
                        }
                    } else {
                        temp = tempIndent - indent;
                        if (remove) {
                            this.removeWhiteSpace(fw, pos, temp);
                        }
                    }
                }
            }
        }

        public void IndentLineUnderProcDiv(CobolFormatSupport fs, FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, int indentReqd) {
            FormatTokenPosition tmpPos = pos;
            if (fs.isEndingWithPeriod(tmpPos)) {
                int cursorPos = fs.getVisualColumnOffset(tmpPos);
                String img = pos.getToken().getImage();
                if ((img = img.substring(cursorPos, img.length())).indexOf(" ") == -1) {
                    if (!fs.isReservedWord(pos)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                    }
                    return;
                }
                this.IndentLine(fs, fw, pos, idf, indentReqd);
            }
        }

        public FormatTokenPosition FindMostRecentIFStatement(FormatTokenPosition pos, CobolFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) {
                    pos = current;
                    break;
                }
                if (fs.isIFStatement(temp)) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    break;
                }
                pos = temp;
            }
            return pos;
        }

        public FormatTokenPosition FindMostRecentStatementWithPeriod(FormatTokenPosition pos, CobolFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) {
                    pos = null;
                    break;
                }
                if (fs.isEndingWithPeriod(temp)) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    break;
                }
                pos = temp;
            }
            return pos;
        }

        public FormatTokenPosition FindMostRecentStatementInAreaA(FormatTokenPosition pos, CobolFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) {
                    pos = null;
                    break;
                }
                if (fs.isInAreaA(temp)) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    break;
                }
                pos = temp;
            }
            return pos;
        }

        public boolean IsIfStatementClosed(FormatTokenPosition pos, CobolFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            boolean status = false;
            boolean i = false;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getNextNonEmptyLine(pos)) == null) {
                    pos = current;
                    break;
                }
                if (fs.isENDIFStatement(temp)) {
                    status = true;
                    break;
                }
                if (fs.isIFStatement(temp)) break;
                pos = temp;
            }
            return status;
        }

        public FormatTokenPosition FindCorrespondingIFStatement(FormatTokenPosition pos, CobolFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) {
                    pos = current;
                    break;
                }
                if (fs.isENDIFStatement(temp)) {
                    ++i;
                } else if (fs.isIFStatement(temp)) {
                    FormatTokenPosition ip = fs.getInitialPosition(temp);
                    for (int count = 0; count < i; ++count) {
                        ip = this.FindMostRecentIFStatement(ip, fs);
                        while (this.IsIfStatementClosed(ip, fs)) {
                            ip = this.FindMostRecentIFStatement(ip, fs);
                        }
                    }
                    pos = ip;
                    break;
                }
                pos = temp;
            }
            return pos;
        }

        public boolean isUnderProcedureDivision(FormatTokenPosition pos, CobolFormatSupport fs) {
            if (this.procDiv) {
                return true;
            }
            FormatTokenPosition current = fs.getInitialPosition(pos);
            boolean status = true;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) {
                    status = false;
                    break;
                }
                if (fs.isProcedureDivision(temp)) {
                    status = true;
                    break;
                }
                pos = temp;
            }
            this.procDiv = status;
            return status;
        }

        public void formatCommentLine(FormatWriter fw, FormatTokenPosition pos, CobolFormatSupport fs) {
            int actualPos;
            int commentPos;
            if (pos != null && (commentPos = fs.getCommentPosition()) != (actualPos = pos.getToken().getImage().indexOf(fs.getCommentChar(pos)) + 1)) {
                if (commentPos > actualPos) {
                    FormatTokenPosition tmpPos = fs.getPosition(pos.getToken(), actualPos - 1);
                    this.insertWhiteSpace(fw, tmpPos, commentPos - actualPos);
                } else {
                    FormatTokenPosition tmpPos = fs.getPosition(pos.getToken(), commentPos - 1);
                    this.removeWhiteSpace(fw, tmpPos, actualPos - commentPos);
                }
            }
        }

        public void formatLine(FormatWriter fw, FormatTokenPosition pos, CobolFormatSupport fs) {
            this.removeFirstTabFromLine(fw, pos, fs);
            if (fs.findLineFirstNonWhitespace(pos) != null) {
                if (fs.isAnsiFormat()) {
                    this.createAnsiFormatedLine(fw, pos, fs);
                }
                IndentInfo idf = new IndentInfo();
                fs.getIndentationInfo(pos, idf);
                if (fs.isENDIFStatement(pos)) {
                    FormatTokenPosition CorrespondingIf = this.FindCorrespondingIFStatement(pos, fs);
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(CorrespondingIf));
                } else if (fs.isELSEStatement(pos)) {
                    FormatTokenPosition MostRecentIf = this.FindCorrespondingIFStatement(pos, fs);
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf));
                } else if (fs.isThenStatement(pos)) {
                    FormatTokenPosition MostRecentIf = this.FindMostRecentIFStatement(pos, fs);
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf));
                } else if (fs.isInAreaA(pos)) {
                    FormatTokenPosition MostRecentInAreaA = this.FindMostRecentStatementInAreaA(pos, fs);
                    if (MostRecentInAreaA == null) {
                        this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                    } else {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentInAreaA));
                    }
                } else {
                    FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
                    if (prev != null) {
                        FormatTokenPosition ip = fs.getInitialPosition(prev);
                        if (fs.isEndingWithPeriod(ip)) {
                            if (fs.isInAreaA(ip)) {
                                if (this.isUnderProcedureDivision(ip, fs)) {
                                    this.IndentLineUnderProcDiv(fs, fw, pos, idf, 4 + fs.getFormattedIndentPosition());
                                } else if (fs.isReservedWord(ip)) {
                                    if (!fs.isReservedWord(pos)) {
                                        if (this.isUnderProcedureDivision(pos, fs)) {
                                            this.IndentLineUnderProcDiv(fs, fw, pos, idf, fs.getIndent(ip));
                                        } else {
                                            this.IndentLine(fs, fw, pos, idf, fs.getShiftWidth() + fs.getIndent(ip));
                                        }
                                    } else {
                                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                                    }
                                } else {
                                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                                }
                            } else {
                                FormatTokenPosition MostRecentPeriod = this.FindMostRecentStatementWithPeriod(ip, fs);
                                if (MostRecentPeriod != null) {
                                    FormatTokenPosition NextPosition = fs.getNextNonEmptyLine(MostRecentPeriod);
                                    if (fs.getIndent(fs.getInitialPosition(NextPosition)) != fs.getFormattedIndentPosition()) {
                                        if (this.isUnderProcedureDivision(ip, fs) || this.isUnderProcedureDivision(pos, fs)) {
                                            this.IndentLineUnderProcDiv(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(NextPosition)));
                                        } else if (fs.isReservedWord(pos)) {
                                            this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                                        } else {
                                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(NextPosition)));
                                        }
                                    } else if (this.isUnderProcedureDivision(ip, fs) || this.isUnderProcedureDivision(pos, fs)) {
                                        this.IndentLineUnderProcDiv(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(MostRecentPeriod)));
                                    } else if (fs.isReservedWord(pos)) {
                                        this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                                    } else {
                                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(MostRecentPeriod)));
                                    }
                                } else if (fs.isInAreaA(pos)) {
                                    this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                                } else if (this.isUnderProcedureDivision(pos, fs)) {
                                    this.IndentLineUnderProcDiv(fs, fw, pos, idf, 4 + fs.getFormattedIndentPosition());
                                } else {
                                    this.IndentLine(fs, fw, pos, idf, 4 + fs.getFormattedIndentPosition());
                                }
                            }
                        } else if (fs.isIFStatement(ip) | fs.isELSEStatement(ip) | fs.isThenStatement(ip)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        } else if (fs.isENDIFStatement(ip)) {
                            FormatTokenPosition CorrespondingIf = this.FindCorrespondingIFStatement(ip, fs);
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(CorrespondingIf));
                        } else if (ip.getToken().getImage().indexOf(".") != -1) {
                            String dotContdStr = ip.getToken().getImage();
                            int dotLen = dotContdStr.indexOf(".");
                            int actIndt = ++dotLen;
                            while (dotContdStr.length() > dotLen && (dotContdStr.charAt(dotLen) == ' ' || dotContdStr.charAt(dotLen) == '\t')) {
                                if (dotContdStr.charAt(++dotLen - 1) == '\t') {
                                    actIndt = dotLen + fs.getSpacesPerTab();
                                    continue;
                                }
                                actIndt = dotLen;
                            }
                            this.IndentLine(fs, fw, pos, idf, actIndt);
                        } else if (ip.getToken().getImage().toLowerCase().indexOf("select") != -1) {
                            String selectedStr = ip.getToken().getImage().toLowerCase();
                            int selPos = selectedStr.indexOf("select");
                            int numOfTab = 0;
                            for (int i = 0; i <= selPos; ++i) {
                                if (selectedStr.charAt(i) != '\t') continue;
                                ++numOfTab;
                            }
                            int actualPos = selPos + 1 + numOfTab * fs.getSpacesPerTab();
                            this.IndentLine(fs, fw, pos, idf, actualPos += fs.getShiftWidth());
                        } else if (fs.isAnsiFormat()) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else if (fs.getIndent(ip) == 0) {
                            this.IndentLine(fs, fw, pos, idf, fs.getShiftWidth());
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        }
                    } else {
                        this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                    }
                }
            }
        }

        public void format(FormatWriter fw) {
            block57: {
                try {
                    this.procDiv = false;
                    Document doc = fw.getDocument();
                    String s = Utilities.getLastActiveComponent().getSelectedText();
                    CobolFormatSupport fs = (CobolFormatSupport)this.createFormatSupport(fw);
                    FormatTokenPosition pos = fs.getFormatStartPosition();
                    boolean t = false;
                    if (fs.isIndentOnly()) {
                        IndentInfo idf = new IndentInfo();
                        fs.getIndentationInfo(pos, idf);
                        if (fs.findLineFirstNonWhitespace(pos) != null) {
                            if (fs.isENDIFStatement(pos)) {
                                FormatTokenPosition CorrespondingIf = this.FindCorrespondingIFStatement(pos, fs);
                                this.IndentLine(fs, fw, pos, idf, fs.getIndent(CorrespondingIf));
                            } else if (fs.isELSEStatement(pos)) {
                                FormatTokenPosition MostRecentIf = this.FindCorrespondingIFStatement(pos, fs);
                                this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf));
                            } else if (fs.isThenStatement(pos)) {
                                FormatTokenPosition MostRecentIf = this.FindMostRecentIFStatement(pos, fs);
                                this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf));
                            } else {
                                FormatTokenPosition AnyOther = fs.getPreviousNonEmptyLine(pos);
                                if (AnyOther != null) {
                                    FormatTokenPosition ip = fs.getInitialPosition(AnyOther);
                                    if (fs.isEndingWithPeriod(ip)) {
                                        if (fs.isInAreaA(ip)) {
                                            if (this.isUnderProcedureDivision(ip, fs)) {
                                                this.IndentLineUnderProcDiv(fs, fw, pos, idf, 4 + fs.getFormattedIndentPosition());
                                            } else {
                                                this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                                            }
                                        } else {
                                            FormatTokenPosition MostRecentPeriod = this.FindMostRecentStatementWithPeriod(ip, fs);
                                            if (MostRecentPeriod != null) {
                                                FormatTokenPosition NextPosition = fs.getNextNonEmptyLine(MostRecentPeriod);
                                                if (fs.getIndent(fs.getInitialPosition(NextPosition)) != 0) {
                                                    if (this.isUnderProcedureDivision(ip, fs)) {
                                                        this.IndentLineUnderProcDiv(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(NextPosition)));
                                                    } else {
                                                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(NextPosition)));
                                                    }
                                                } else if (this.isUnderProcedureDivision(ip, fs)) {
                                                    this.IndentLineUnderProcDiv(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(MostRecentPeriod)));
                                                } else {
                                                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(MostRecentPeriod)));
                                                }
                                            } else if (fs.isInAreaA(pos)) {
                                                this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                                            } else if (this.isUnderProcedureDivision(pos, fs)) {
                                                this.IndentLineUnderProcDiv(fs, fw, pos, idf, 4 + fs.getFormattedIndentPosition());
                                            } else {
                                                this.IndentLine(fs, fw, pos, idf, 4 + fs.getFormattedIndentPosition());
                                            }
                                        }
                                    } else if (fs.isIFStatement(ip) | fs.isELSEStatement(ip) | fs.isThenStatement(ip)) {
                                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                                    } else if (ip.getToken().getImage().indexOf(".") != -1) {
                                        String dotContdStr = ip.getToken().getImage();
                                        int dotLen = dotContdStr.indexOf(".");
                                        int actIndt = ++dotLen;
                                        while (dotContdStr.length() > dotLen && (dotContdStr.charAt(dotLen) == ' ' || dotContdStr.charAt(dotLen) == '\t')) {
                                            if (dotContdStr.charAt(++dotLen - 1) == '\t') {
                                                actIndt = dotLen + fs.getSpacesPerTab();
                                                continue;
                                            }
                                            actIndt = dotLen;
                                        }
                                        this.IndentLine(fs, fw, pos, idf, actIndt);
                                    } else if (ip.getToken().getImage().toLowerCase().indexOf("select") != -1) {
                                        String selectedStr = ip.getToken().getImage().toLowerCase();
                                        int selPos = selectedStr.indexOf("select");
                                        int numOfTab = 0;
                                        for (int i = 0; i <= selPos; ++i) {
                                            if (selectedStr.charAt(i) != '\t') continue;
                                            ++numOfTab;
                                        }
                                        int actualPos = selPos + 1 + numOfTab * fs.getSpacesPerTab();
                                        this.IndentLine(fs, fw, pos, idf, actualPos += fs.getShiftWidth());
                                    } else {
                                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                                    }
                                }
                            }
                        } else {
                            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
                            if (prev != null) {
                                FormatTokenPosition ip = fs.getInitialPosition(prev);
                                if (fs.isEndingWithPeriod(ip)) {
                                    if (fs.isInAreaA(ip)) {
                                        if (this.isUnderProcedureDivision(ip, fs)) {
                                            this.AdjustCursor(fw, pos, idf, 4 + fs.getFormattedIndentPosition());
                                        } else {
                                            this.AdjustCursor(fw, pos, idf, fs.getIndent(ip));
                                        }
                                    } else {
                                        FormatTokenPosition MostRecentPeriod = this.FindMostRecentStatementWithPeriod(ip, fs);
                                        if (MostRecentPeriod != null) {
                                            FormatTokenPosition NextPosition = fs.getNextNonEmptyLine(MostRecentPeriod);
                                            this.AdjustCursor(fw, pos, idf, fs.getIndent(fs.getInitialPosition(NextPosition)));
                                        } else {
                                            this.AdjustCursor(fw, pos, idf, 4 + fs.getFormattedIndentPosition());
                                        }
                                    }
                                } else if (fs.isIFStatement(ip) | fs.isELSEStatement(ip) | fs.isThenStatement(ip)) {
                                    this.AdjustCursor(fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                                } else if (fs.isENDIFStatement(ip)) {
                                    FormatTokenPosition CorrespondingIf = this.FindCorrespondingIFStatement(ip, fs);
                                    this.AdjustCursor(fw, pos, idf, fs.getIndent(CorrespondingIf));
                                } else {
                                    this.AdjustCursor(fw, pos, idf, fs.getIndent(ip));
                                }
                            }
                        }
                        break block57;
                    }
                    while (pos != null) {
                        if (!fs.isComment(pos)) {
                            this.formatLine(fw, pos, fs);
                        } else {
                            this.formatCommentLine(fw, pos, fs);
                        }
                        CobolCompilerType ct = (CobolCompilerType)CompilerType.find((Class)(class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType == null ? CobolFormatter.class$("com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerType") : class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType));
                        FormatTokenPosition pos2 = fs.findLineEnd(pos);
                        if (pos2 != null && pos2.getToken() != null && (pos = fs.getNextPosition(pos2, Position.Bias.Forward)) != pos2 && pos != null && pos.getToken() != null) {
                            FormatTokenPosition fnw = fs.findLineFirstNonWhitespace(pos);
                            if (fnw != null) {
                                pos = fnw;
                                continue;
                            }
                            pos = fs.findLineStart(pos);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("cobol-strip-whitespace-at-line-end");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new CobolFormatSupport(fw);
        }

        public void format(FormatWriter fw) {
            Document doc = fw.getDocument();
            CobolFormatSupport fs = (CobolFormatSupport)this.createFormatSupport(fw);
            FormatTokenPosition pos = fs.getFormatStartPosition();
            if (!fs.isIndentOnly()) {
                while (pos.getToken() != null) {
                    if ((pos = fs.removeLineEndWhitespace(pos)).getToken() == null) continue;
                    pos = fs.getNextPosition(pos);
                }
            }
        }
    }
}

