/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.beans.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileEditor3
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    private PropertyEnv env;
    static final String PROPERTY_SHOW_DIRECTORIES = "directories";
    static final String PROPERTY_SHOW_FILES = "files";
    static final String PROPERTY_FILTER = "filter";
    static final String PROPERTY_CURRENT_DIR = "currentDir";
    static final String PROPERTY_BASE_DIR = "baseDir";
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    static File lastCurrentDir;
    private JFileChooser chooser;
    private FeatureDescriptor fd;
    private boolean enableFC = true;
    private boolean inherited = true;
    JCheckBox jButton1 = null;
    JPanel jPanel1 = null;
    static /* synthetic */ Class class$com$hp$openvms$netbeans$beans$editors$FileEditor3;

    public Object getObject() {
        return this.env.getFeatureDescriptor().getValue("object");
    }

    public Method getMethod() {
        return (Method)this.env.getFeatureDescriptor().getValue("method");
    }

    public String getParam() {
        return (String)this.env.getFeatureDescriptor().getValue("param");
    }

    public String getContext() {
        return (String)this.env.getFeatureDescriptor().getValue("context");
    }

    public File getInherit() {
        Method m = this.getMethod();
        Object obj = this.getObject();
        String param = this.getParam();
        Object value = null;
        try {
            Object tmp = m.invoke(obj, param);
            value = tmp instanceof String ? (tmp.equals("") ? null : new File((String)tmp)) : (File)tmp;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveDisableComponent(JComponent comp, boolean enable) {
        JComponent jComponent = comp;
        synchronized (jComponent) {
            comp.setEnabled(enable);
            for (int index = 0; index < comp.getComponentCount(); ++index) {
                Component c = comp.getComponent(index);
                if (!(c instanceof JComponent)) continue;
                this.recursiveDisableComponent((JComponent)c, enable);
            }
        }
    }

    public void attachEnv(PropertyEnv env) {
        Object baseDir;
        Object filter;
        Object fil;
        this.env = env;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        Object dirs = env.getFeatureDescriptor().getValue(PROPERTY_SHOW_DIRECTORIES);
        if (dirs instanceof Boolean) {
            this.directories = (Boolean)dirs;
        }
        if ((fil = env.getFeatureDescriptor().getValue(PROPERTY_SHOW_FILES)) instanceof Boolean) {
            this.files = (Boolean)fil;
        }
        if ((filter = env.getFeatureDescriptor().getValue(PROPERTY_FILTER)) instanceof FilenameFilter) {
            this.fileFilter = new DelegatingFilenameFilter((FilenameFilter)filter);
        } else if (filter instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)filter;
        } else if (filter instanceof FileFilter) {
            this.fileFilter = new DelegatingFileFilter((FileFilter)filter);
        }
        Object curDir = env.getFeatureDescriptor().getValue(PROPERTY_CURRENT_DIR);
        if (curDir instanceof File) {
            this.currentDirectory = (File)curDir;
            if (!this.currentDirectory.isDirectory()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept currentDir=" + this.baseDirectory);
                this.currentDirectory = null;
            }
        }
        if ((baseDir = env.getFeatureDescriptor().getValue(PROPERTY_BASE_DIR)) instanceof File) {
            this.baseDirectory = (File)baseDir;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                ErrorManager.getDefault().log(16, "java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        this.mode = this.files ? (this.directories ? 2 : 0) : (this.directories ? 1 : 2);
    }

    public String getAsText() {
        String file = (String)this.getValue();
        if (file == null) {
            return "";
        }
        String path = file;
        if (path.equals("")) {
            path = ".";
        }
        String s = this.env.getFeatureDescriptor().getName();
        path = s + " " + "= " + path;
        return path;
    }

    public void setAsText(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("null");
        }
        if (str.equals("")) {
            this.setValue(null);
            return;
        }
        if (str.equals(".")) {
            str = "";
        }
        this.setValue(str + "list");
    }

    public Component getCustomEditor() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            File originalFile = new File("");
            if (originalFile != null && !originalFile.isAbsolute() && this.baseDirectory != null) {
                originalFile = new File(this.baseDirectory, originalFile.getPath());
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            } else if (originalFile != null && originalFile.getParentFile() != null) {
                this.chooser.setCurrentDirectory(originalFile.getParentFile());
                this.chooser.setSelectedFile(originalFile);
            } else if (lastCurrentDir != null) {
                this.chooser.setCurrentDirectory(lastCurrentDir);
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileEditor3.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileEditor3.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileEditor3.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener("SelectedFileChangedProperty", this);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new FlowLayout(2));
            this.jPanel1.setPreferredSize(new Dimension(10, 45));
            this.jButton1 = new JCheckBox("");
            this.jButton1.setToolTipText("");
            this.jButton1.setText(ResourceBundle.getBundle("com/hp/openvms/netbeans/utils/Bundle").getString("CTL_Default"));
            this.jButton1.setMaximumSize(new Dimension(180, 27));
            this.jButton1.setPreferredSize(new Dimension(180, 27));
            this.jButton1.setLocation((int)(this.jButton1.getLocation().getX() - 14.0), (int)this.jButton1.getLocation().getY());
            this.jButton1.setMargin(new Insets(2, 11, 2, 11));
            this.jButton1.setFocusPainted(false);
            if (this.getContext() == null) {
                if (this.getInherit() == null) {
                    this.jButton1.setSelected(true);
                    this.recursiveDisableComponent(this.chooser, false);
                    this.inherited = true;
                } else {
                    this.jButton1.setSelected(false);
                    this.recursiveDisableComponent(this.chooser, true);
                    this.inherited = false;
                }
            } else {
                this.jButton1.setVisible(false);
                this.inherited = false;
            }
            this.jPanel1.add(this.jButton1);
            this.chooser.add(this.jPanel1);
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FileEditor3.this.jButton1ActionPerformed(evt);
                }
            });
            String helpID = (String)this.env.getFeatureDescriptor().getValue("helpID");
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)helpID);
        }
        return this.chooser;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            JCheckBox jb = (JCheckBox)evt.getSource();
            if (jb.isSelected()) {
                this.setValue(null);
                File value = new File((String)this.getValue());
                if (value != null) {
                    if (value != null && !value.getPath().equals(".") && !value.getPath().equals("")) {
                        this.chooser.setSelectedFile(value);
                    } else if (value != null && (value.getPath().equals(".") || value.getPath().equals(""))) {
                        this.chooser.setSelectedFile(value);
                    }
                    this.setValue(null);
                }
                this.recursiveDisableComponent(this.chooser, false);
                this.jPanel1.setEnabled(true);
                this.jButton1.setEnabled(true);
                this.inherited = true;
            } else {
                this.recursiveDisableComponent(this.chooser, true);
                if (this.chooser.getSelectedFile() == null) {
                    if (this.files) {
                        if (this.getValue() == null || this.getValue().equals("")) {
                            this.setValue("<>");
                            this.setValue("");
                        } else {
                            File oldValue = new File((String)this.getValue());
                            this.setValue("<>");
                            this.setValue(oldValue.getPath());
                        }
                    } else {
                        this.setValue(this.chooser.getCurrentDirectory().getPath());
                    }
                } else {
                    String filePath = this.chooser.getSelectedFile().getAbsolutePath();
                    this.setAsText("<>");
                    this.setAsText(filePath);
                }
                this.inherited = false;
            }
        }
        catch (Exception nsme) {
            nsme.printStackTrace();
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        File value = (File)this.getValue();
        if (value == null) {
            return "null";
        }
        if (this.baseDirectory != null && !value.isAbsolute()) {
            return "new java.io.File(" + FileEditor3.stringify(this.baseDirectory.getPath()) + ", " + FileEditor3.stringify(value.getPath()) + ")";
        }
        return "new java.io.File(" + FileEditor3.stringify(value.getAbsolutePath()) + ")";
    }

    static String stringify(String in) {
        StringBuffer buf = new StringBuffer(in.length() * 2 + 2);
        buf.append('\"');
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\\' || c == '\"') {
                buf.append('\\');
            }
            buf.append(c);
        }
        buf.append('\"');
        return buf.toString();
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(class$com$hp$openvms$netbeans$beans$editors$FileEditor3 == null ? (class$com$hp$openvms$netbeans$beans$editors$FileEditor3 = FileEditor3.class$("com.hp.openvms.netbeans.beans.editors.FileEditor3")) : class$com$hp$openvms$netbeans$beans$editors$FileEditor3);
    }

    private static String getString(String key) {
        return NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$beans$editors$FileEditor3 == null ? (class$com$hp$openvms$netbeans$beans$editors$FileEditor3 = FileEditor3.class$("com.hp.openvms.netbeans.beans.editors.FileEditor3")) : class$com$hp$openvms$netbeans$beans$editors$FileEditor3)).getString(key);
    }

    static String getChildRelativePath(File baseDir, File file) {
        if (file.equals(baseDir)) {
            return "";
        }
        StringBuffer buf = new StringBuffer(file.getPath().length());
        buf.append(file.getName());
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.equals(baseDir)) {
                return buf.toString();
            }
            buf.insert(0, File.separatorChar);
            buf.insert(0, parent.getName());
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String rel;
        JFileChooser chooser = (JFileChooser)e.getSource();
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        if (!this.files && f.isFile()) {
            return;
        }
        if (!this.directories && f.isDirectory()) {
            return;
        }
        if (this.baseDirectory != null && (rel = FileEditor3.getChildRelativePath(this.baseDirectory, f)) != null) {
            f = new File(rel);
        }
        if (!this.inherited) {
            this.setValue(f.getAbsolutePath());
            lastCurrentDir = chooser.getCurrentDirectory();
        }
    }

    public static JFileChooser createHackedFileChooser() {
        ActionMap parent;
        ActionMap map;
        KeyStroke enter;
        Object value;
        final JFileChooser chooser = new JFileChooser();
        InputMap im = chooser.getInputMap(1);
        if (im != null && (value = im.get(enter = KeyStroke.getKeyStroke(10, 0))) == null) {
            im.put(enter, "approveSelection");
        }
        if ((map = chooser.getActionMap()) != null && (parent = map.getParent()) != null) {
            final Action original = parent.get("approveSelection");
            parent.put("approveSelection", new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    File file = chooser.getSelectedFile();
                    if (file != null && file.isDirectory()) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        chooser.setCurrentDirectory(file);
                    } else if (original != null) {
                        original.actionPerformed(evt);
                    }
                }
            });
        }
        return chooser;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class DelegatingFilenameFilter
    extends javax.swing.filechooser.FileFilter {
        private FilenameFilter filter;

        public DelegatingFilenameFilter(FilenameFilter f) {
            this.filter = f;
        }

        public boolean accept(File f) {
            return this.filter.accept(f.getParentFile(), f.getName());
        }

        public String getDescription() {
            return null;
        }
    }

    static class DelegatingFileFilter
    extends javax.swing.filechooser.FileFilter {
        private FileFilter filter;

        public DelegatingFileFilter(FileFilter f) {
            this.filter = f;
        }

        public boolean accept(File f) {
            return this.filter.accept(f);
        }

        public String getDescription() {
            return null;
        }
    }
}

