/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.services;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.client.RemoteLoginClient;
import org.netbeans.modules.distributed.rmi.protocol.Admin;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.rmi.protocol.SecurityContext;
import org.netbeans.modules.distributed.services.DistConnectionListener;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RemoteRuntimeType
implements Serializable {
    static final long serialVersionUID = -5272304999227754317L;
    private static final String REMOTESVR_PROB = "Problem accessing the Remote Server: {0}.\n\nThe error message was: {1}.\n\nPlease go to the Runtime Tab and reconnect the Remote Server";
    private static final String REMOTESVR_NOT_CONN = "Remote Server {0} is not connected.Please go to the Runtime Tab and make a connection";
    private String userName;
    private String password;
    private String hostName;
    private String jdkVersion;
    private String setupCommand;
    private int port;
    private int svrTimeOut;
    private boolean connectAtStartup;
    private boolean connectNow;
    private transient SecurityContext securityContext;
    private transient RemoteLoginClient rtClient;
    private transient RemoteRuntime rt;
    private transient ArrayList remoteProcesses;
    private String lastStatusMsg;
    private transient HashSet connectionListeners;
    private transient boolean remoteServerError;

    public RemoteRuntimeType() {
        this.remoteProcesses = new ArrayList(10);
        this.connectionListeners = new HashSet();
    }

    public RemoteRuntimeType(String userName, String password, String hostName, int port, String jdkVersion, String setupCommand, int svrTimeOut, boolean connectNow) {
        this.userName = userName;
        this.password = password;
        this.hostName = hostName;
        this.port = port;
        this.jdkVersion = jdkVersion;
        this.connectNow = connectNow;
        this.setupCommand = setupCommand;
        this.svrTimeOut = svrTimeOut;
        this.rtClient = new RemoteLoginClient();
        this.remoteProcesses = new ArrayList(10);
        this.connectionListeners = new HashSet();
    }

    public void setRemoteServerError(boolean flag) {
        this.remoteServerError = flag;
    }

    public boolean getRemoteServerError() {
        return this.remoteServerError;
    }

    public synchronized boolean addRemoteProcess(Process rp) {
        if (this.remoteProcesses == null) {
            this.remoteProcesses = new ArrayList(10);
        }
        return this.remoteProcesses.add(rp);
    }

    public synchronized boolean removeRemoteProcess(Process rp) {
        if (this.remoteProcesses == null) {
            return false;
        }
        return this.remoteProcesses.remove(rp);
    }

    public synchronized int remoteProcessCount() {
        if (this.remoteProcesses != null) {
            return this.remoteProcesses.size();
        }
        return 0;
    }

    public synchronized void stopRemoteProcesses() {
        if (this.remoteProcesses == null) {
            return;
        }
        int size = this.remoteProcesses.size();
        for (int i = 0; i < size; ++i) {
            Process prc = (Process)this.remoteProcesses.get(0);
            prc.destroy();
        }
    }

    public void addConnectionListener(DistConnectionListener listener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(DistConnectionListener listener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        this.connectionListeners.remove(listener);
    }

    void fireConnected() {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        Iterator itr = this.connectionListeners.iterator();
        while (itr.hasNext()) {
            DistConnectionListener listener = (DistConnectionListener)itr.next();
            listener.connected();
        }
    }

    void fireConnecting() {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        Iterator itr = this.connectionListeners.iterator();
        while (itr.hasNext()) {
            DistConnectionListener listener = (DistConnectionListener)itr.next();
            listener.connecting();
        }
    }

    void fireDisconnected() {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        Iterator itr = this.connectionListeners.iterator();
        while (itr.hasNext()) {
            DistConnectionListener listener = (DistConnectionListener)itr.next();
            listener.disconnected();
        }
    }

    private RemoteLoginClient getRemoteLoginClient() {
        if (this.rtClient == null) {
            this.rtClient = new RemoteLoginClient();
        }
        return this.rtClient;
    }

    public Admin getAdminInterface(String password) {
        return this.getRemoteLoginClient().getAdminInterface(password);
    }

    public boolean getConnectNow() {
        return this.connectNow;
    }

    public void setConnectNow(boolean connect) {
        this.connectNow = connect;
        DistributedSettings.getDefault().setTimeOut(DistributedSettings.getDefault().getTimeOut());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String displayName() {
        return this.hostName + ":" + this.userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getSetupCommand() {
        if (this.setupCommand == null) {
            return "";
        }
        return this.setupCommand;
    }

    public String getJDKVersion() {
        return this.getRemoteLoginClient().getJDKVersion();
    }

    public String getServerVersion() {
        return this.getRemoteLoginClient().getServerVersion();
    }

    public boolean isConnected() {
        return this.getRemoteLoginClient().isConnected();
    }

    public boolean isConnecting() {
        return this.getRemoteLoginClient().isConnecting();
    }

    public boolean isConnectAtStartup() {
        return this.connectAtStartup;
    }

    public void setConnectAtStartup(boolean b) {
        this.connectAtStartup = b;
        DistributedSettings.getDefault().setConnectAtStartup(b);
    }

    public synchronized void disconnect(boolean recover) {
        if (this.isConnected()) {
            this.getRemoteLoginClient().close();
        }
        if (!recover) {
            this.setConnectNow(false);
        }
    }

    private void errorMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
            }
        });
    }

    public boolean isFileSTRMLF(String file) {
        if (this.isConnected()) {
            RemoteFileService rsvc = this.getRemoteLoginClient().getRemoteFileService();
            if (rsvc == null) {
                this.errorMessage(this.getRemoteLoginClient().getErrorMessage());
                return false;
            }
            try {
                return rsvc.isFileSTRMLF(file);
            }
            catch (RemoteException e) {
                this.errorMessage(e.getMessage());
                return false;
            }
        }
        this.errorMessage(MessageFormat.format(REMOTESVR_NOT_CONN, this.getHostName() + ":" + this.getUserName()));
        return false;
    }

    public boolean fileExists(String file) {
        if (this.isConnected()) {
            RemoteFileService rsvc = this.getRemoteLoginClient().getRemoteFileService();
            if (rsvc == null) {
                this.errorMessage(this.getRemoteLoginClient().getErrorMessage());
                return false;
            }
            try {
                return rsvc.fileExists(file);
            }
            catch (RemoteException e) {
                this.errorMessage(e.getMessage());
                return false;
            }
        }
        this.errorMessage(MessageFormat.format(REMOTESVR_NOT_CONN, this.getHostName() + ":" + this.getUserName()));
        return false;
    }

    public ArrayList listRoots() {
        if (this.isConnected()) {
            RemoteFileService rsvc = this.getRemoteLoginClient().getRemoteFileService();
            if (rsvc == null) {
                this.errorMessage(MessageFormat.format(REMOTESVR_PROB, this.getHostName() + ":" + this.getUserName(), this.getRemoteLoginClient().getErrorMessage()));
                return null;
            }
            try {
                return rsvc.listRoots();
            }
            catch (RemoteException e) {
                this.errorMessage(e.getMessage());
                return null;
            }
        }
        this.errorMessage(MessageFormat.format(REMOTESVR_NOT_CONN, this.getHostName() + ":" + this.getUserName()));
        return null;
    }

    public byte[] getSecurityContext() {
        return this.getRemoteLoginClient().getTicket();
    }

    public String getID() {
        return this.getRemoteLoginClient().getID();
    }

    public int getPort() {
        return this.port;
    }

    public int getSvrTimeOut() {
        if (this.svrTimeOut <= 0) {
            return DistributedSettings.getDefault().getSvrTimeOut();
        }
        return this.svrTimeOut;
    }

    public void setSvrTimeOut(int svrTimeOut) {
        this.svrTimeOut = svrTimeOut;
    }

    public String getNetworkShareRoot(String shareName) {
        if (this.getRemoteLoginClient().findRemoteRuntime() == null) {
            return null;
        }
        String sname = this.getRemoteLoginClient().getNetworkShareRoot(shareName);
        if (sname == null) {
            this.errorMessage(this.getRemoteLoginClient().getErrorMessage());
        }
        return sname;
    }

    public boolean isConnectedServerSafe() {
        return this.getRemoteLoginClient().findRemoteRuntimeServerSafe() != null;
    }

    private RemoteRuntime createRemoteRuntime() {
        if (this.rt == null && this.getConnectNow()) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("VERSION", "1.0");
            hm.put("USER", this.getUserName().toLowerCase());
            hm.put("PASSWD", this.getPassword());
            hm.put("JDK_VER_TAG", this.getJDKVersion());
            if (this.getSetupCommand() != null && !this.getSetupCommand().trim().equals("")) {
                hm.put("SETUP", this.getSetupCommand().trim());
            }
            StatusDisplayer.getDefault().setStatusText("Connecting to the remote server:" + this.getHostName() + ":" + this.getUserName());
            this.fireConnecting();
            hm.put("SVR_WAITTIME", new Integer(this.getSvrTimeOut()));
            if (!this.getRemoteLoginClient().connect(hm, this.getHostName(), this.getPort())) {
                this.lastStatusMsg = this.getRemoteLoginClient().getErrorMessage();
                if (this.lastStatusMsg != null && this.lastStatusMsg.indexOf(0) > 0) {
                    this.lastStatusMsg = this.lastStatusMsg.substring(0, this.lastStatusMsg.indexOf(0));
                }
                StatusDisplayer.getDefault().setStatusText("Connection attempt failed:" + this.getHostName() + ":" + this.getUserName());
                if (this.getRemoteLoginClient().isServerTimedOut()) {
                    this.setConnectNow(false);
                }
                final String title = NbBundle.getMessage((Class)RemoteRuntimeType.class, (String)"MSG_RMIServerErrorMsgTitle");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)RemoteRuntimeType.this.getLastStatusMessage(), title, -1, 2));
                    }
                });
                this.fireDisconnected();
                return null;
            }
            this.lastStatusMsg = null;
            StatusDisplayer.getDefault().setStatusText("Connection succeeded:" + this.getHostName() + ":" + this.getUserName());
            this.rt = this.getRemoteLoginClient().findRemoteRuntimeServerSafe();
            this.setConnectNow(true);
            this.fireConnected();
            this.getRemoteLoginClient().keepServerAlive();
            return this.rt;
        }
        return this.rt;
    }

    public synchronized RemoteRuntime getRemoteRuntimeServerSafe() {
        this.rt = this.getRemoteLoginClient().findRemoteRuntimeServerSafe();
        return this.createRemoteRuntime();
    }

    public synchronized RemoteRuntime getRemoteRuntime() {
        this.rt = this.getRemoteLoginClient().findRemoteRuntime();
        return this.createRemoteRuntime();
    }

    public String getLastStatusMessage() {
        return this.lastStatusMsg;
    }

    protected void finalize() {
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setSetupCommand(String setupCommand) {
        this.setupCommand = setupCommand;
        DistributedSettings.getDefault().setSetupCommand(setupCommand);
    }

    public void setPassword(String password) {
        this.password = password;
        DistributedSettings.getDefault().setPasswd(password);
    }

    public void setUserName(String userName) {
        this.userName = userName;
        DistributedSettings.getDefault().setUserName(userName);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAsText() {
        return this.hostName + ":" + this.userName;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        boolean isEqual = false;
        RemoteRuntimeType obj = (RemoteRuntimeType)o;
        isEqual = this.userName.equalsIgnoreCase(obj.userName);
        boolean bl = isEqual = !isEqual ? false : this.hostName.equalsIgnoreCase(obj.hostName);
        isEqual = !isEqual ? false : this.port == obj.port;
        return isEqual;
    }

    public boolean isServerFailed() {
        return this.rtClient.isServerFailed();
    }

    public RemoteFileService getRemoteFileService() throws RemoteException {
        return this.getRemoteLoginClient().getRemoteFileService();
    }
}

