/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.remotefs.wizard.ErrorPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteJarRootVisualPanel;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.distributed.util.JarAndZipFilter;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;

public class RemoteJarRootPanel
implements WizardDescriptor.Panel {
    private Component component;
    private Component errorComponent;
    private RemoteRuntimeType rrt;
    private ArrayList listeners = new ArrayList();
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    private boolean firstTime = true;

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public String getRemoteDirectory(String localJarFile) {
        RemoteRuntimeType rrt = this.getRemoteRuntimeType();
        return FileUtility.getRemoteJarShare(rrt, localJarFile);
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteJarRootVisualPanel(this, this.fsv);
            ((RemoteJarRootVisualPanel)this.component).getFileChooser().setFileFilter(new JarAndZipFilter());
            ((RemoteJarRootVisualPanel)this.component).getFileChooser().setFileSelectionMode(0);
            ((RemoteJarRootVisualPanel)this.component).getFileChooser().setDialogTitle("Remote Archive File");
            this.errorComponent = new ErrorPanel();
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (!(this.getComponent() instanceof RemoteJarRootVisualPanel)) {
            return false;
        }
        if (!((RemoteJarRootVisualPanel)this.component).getLocalDirectory().equals("") && !((RemoteJarRootVisualPanel)this.component).getRemoteDirectory().equals("")) {
            Enumeration fse = Repository.getDefault().getFileSystems();
            while (fse.hasMoreElements()) {
                String lroot;
                FileSystem fs = (FileSystem)fse.nextElement();
                if (!(fs instanceof JarFileSystem) || !(lroot = ((JarFileSystem)fs).getJarFile().getAbsolutePath()).equalsIgnoreCase(((RemoteJarRootVisualPanel)this.component).getLocalDirectory())) continue;
                return false;
            }
            File file = new File(((RemoteJarRootVisualPanel)this.component).getLocalDirectory());
            if (file.exists()) {
                return true;
            }
        }
        return false;
    }

    public final void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeState() {
        ArrayList list;
        RemoteJarRootPanel remoteJarRootPanel = this;
        synchronized (remoteJarRootPanel) {
            list = (ArrayList)this.listeners.clone();
        }
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public void readSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        this.rrt = (RemoteRuntimeType)wiz.getProperty("remote_runtime");
        this.firstTime = true;
        this.fsv = FileSystemView.getFileSystemView();
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        if (!(this.component instanceof RemoteJarRootVisualPanel)) {
            return;
        }
        wiz.putProperty("local_directory", (Object)((RemoteJarRootVisualPanel)this.component).getLocalDirectory());
        wiz.putProperty("remote_directory", (Object)((RemoteJarRootVisualPanel)this.component).getRemoteDirectory());
    }
}

