/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.actions.RemoteBuildAction;
import org.netbeans.modules.distributed.actions.RemoteCompileAction;
import org.netbeans.modules.distributed.actions.RemoteDebugAction;
import org.netbeans.modules.distributed.actions.RemoteExecuteAction;
import org.netbeans.modules.distributed.actions.RemotePropertiesAction;
import org.netbeans.modules.distributed.actions.RemoteRunTargetsAction;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.core.LogInfo;
import org.netbeans.modules.distributed.remotefs.core.RemoteClient;
import org.netbeans.modules.distributed.remotefs.core.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.core.RemoteFile;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.core.Sync;
import org.netbeans.modules.distributed.remotefs.ftpclient.FTPClient;
import org.netbeans.modules.distributed.remotefs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.remotefs.ftpclient.FTPLogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPDialogs;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPSettings;
import org.netbeans.modules.distributed.remotefs.ftpfs.FileStatusInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.Password;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedProjectSettings;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.distributed.util.DisconnectCallBack;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.options.SystemOption;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class FTPFileSystem
extends RemoteFileSystem
implements FTPClient.Reconnect,
AbstractNetworkFileSystem,
FileSystem.Status {
    static final long serialVersionUID = -981665601872580022L;
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 8;
    private static final boolean DEBUG = true;
    private static final String FTPWORK = System.getProperty("netbeans.user") + File.separator + "ftpcache";
    private static RequestProcessor statusRequestProcessor;
    private static final Object STATUS_REQUEST_PROCESSOR_LOCK;
    private FTPSettings ftpsettings = (FTPSettings)SystemOption.findObject((Class)FTPSettings.class, (boolean)true);
    private Boolean useXtermCompile;
    private Boolean useXtermExecution;
    private int refCount;
    private RemoteRuntimeType remoteRuntimeType;

    public FTPFileSystem(RemoteRuntimeType remoteRuntime, int ftpPort, String cachedir, String startdir, boolean useSSHForwarding, boolean isPassiveMode) throws IOException {
        this.remoteRuntimeType = remoteRuntime;
        this.loginfo = new FTPLogInfo(remoteRuntime.getHostName(), ftpPort, remoteRuntime.getUserName(), remoteRuntime.getPassword());
        this.cachedir = new File(cachedir);
        this.startdir = startdir;
        this.SSHForwarding = useSSHForwarding;
        this.ftpPassiveMode = isPassiveMode;
        this.getFTPSettings().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                FTPFileSystem.this.ftpSettingsChanged(event);
            }
        });
        this.addFileStatusListener(new FileStatusListener(){

            public void annotationChanged(FileStatusEvent ev) {
            }
        });
        this.client = this.createClient(this.loginfo, this.cachedir, startdir);
        this.addedFS((FileSystem)this);
    }

    public SystemAction[] getActions() {
        SystemAction[] defaultActions = super.getActions();
        SystemAction[] allActions = new SystemAction[defaultActions.length + 6];
        System.arraycopy(defaultActions, 0, allActions, 0, defaultActions.length);
        SystemAction[] newActions = new SystemAction[]{SystemAction.get((Class)RemoteCompileAction.class), SystemAction.get((Class)RemoteBuildAction.class), SystemAction.get((Class)RemoteExecuteAction.class), SystemAction.get((Class)RemoteDebugAction.class), SystemAction.get((Class)RemotePropertiesAction.class), SystemAction.get((Class)RemoteRunTargetsAction.class)};
        System.arraycopy(newActions, 0, allActions, defaultActions.length, 6);
        return allActions;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        RemoteRuntimeType ret = DistributedSettings.getDefault().finRemoteRuntime(this.remoteRuntimeType);
        return ret;
    }

    public RemoteRuntimeType getRemoteRuntimeTypeRef() {
        return this.remoteRuntimeType;
    }

    public void setRemoteRuntimeType(RemoteRuntimeType rt) {
        this.remoteRuntimeType = rt;
    }

    public boolean getUseXtermCompile() {
        if (this.useXtermCompile == null) {
            return DistributedProjectSettings.getDefault().getUseXtermCompile();
        }
        return this.useXtermCompile;
    }

    public void setUseXtermCompile(boolean useX) {
        this.useXtermCompile = new Boolean(useX);
        this.firePropertyChange("useXtermCompile", null, this.useXtermCompile);
    }

    public boolean getUseXtermExecution() {
        if (this.useXtermExecution == null) {
            return DistributedProjectSettings.getDefault().getUseXtermExecution();
        }
        return this.useXtermExecution;
    }

    public void setUseXtermExecution(boolean useX) {
        this.useXtermExecution = new Boolean(useX);
        this.firePropertyChange("useXtermExecution", null, this.useXtermExecution);
    }

    public String getRemoteRoot() {
        return this.getRootFile();
    }

    public String getLocalRoot() {
        return this.getCache().getAbsolutePath();
    }

    private static String getSearchRoot(String remoteRootName, NetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        String searchRootName = remoteRootName;
        if (Utils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            searchRootName = remoteRootName.endsWith(":") ? remoteRootName : remoteRootName.substring(0, remoteRootName.length() - 1);
        }
        return searchRootName;
    }

    private static String getClientPath(String fileName, String remoteRootName, NetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        if (Utils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            if (Utilities.isWindows()) {
                return FileUtility.openVMSPathToWinPath(fileName, false, nfs.getLocalRoot(), remoteRootName);
            }
            if (Utilities.isUnix()) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
            if (Utilities.getOperatingSystem() == 8192) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
        }
        return fileName;
    }

    private void deleteClientFiles(File file, String name) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                this.deleteClientFiles(files[i], name + "/" + file.getAbsolutePath());
            }
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getAbsolutePath());
            file.delete();
        } else {
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getAbsolutePath());
            if (file.delete()) {
                this.setFileAttribute(name, "ftp_cache_lastmodified", null);
                this.setFileAttribute(name, "ftp_remote_lastmodified", null);
                this.setFileAttribute(name, "file_residence_mode", null);
            }
        }
    }

    private void deleteServerFiles(RemoteFileName file, String name) throws IOException {
        if (file.isDirectory()) {
            RemoteFileAttributes[] files = this.client.list(file);
            for (int i = 0; files != null && i < files.length; ++i) {
                this.deleteServerFiles(files[i].getName(), name + "/" + files[i].getName().getName());
            }
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getFullName());
            this.client.rmdir(file);
        } else {
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getFullName());
            this.client.delete(file);
            this.setFileAttribute(name, "ftp_cache_lastmodified", null);
            this.setFileAttribute(name, "ftp_remote_lastmodified", null);
            this.setFileAttribute(name, "file_residence_mode", null);
        }
    }

    public void delete(String name) throws IOException {
        FTPFileName ftpName;
        RemoteFileAttributes fileAt;
        DistributedModule.logger.info(name + " is being deleted");
        name = name.replace('/', '\\');
        if (name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
            new File(this.getLocalRoot(), name).delete();
            return;
        }
        this.isReadyToModify();
        File local = new File(this.getLocalRoot(), name);
        boolean isDir = local.isDirectory();
        this.deleteClientFiles(local, name);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("REMOTE_ROOT", this.getRemoteRoot());
        map.put("LCOAL_ROOT", this.getCache().getAbsolutePath());
        String server = FileUtility.winPathToOpenVMSPath(local.getAbsolutePath(), false, map);
        server = FileUtility.openVMSPathToUnixPath(server, false);
        if (server.endsWith(".")) {
            server = server.substring(0, server.length() - 1);
        }
        if ((fileAt = this.client.listFile("", ftpName = new FTPFileName("", server, isDir))) != null && fileAt.getDate().getTime() != 0L) {
            if (fileAt.isDirectory()) {
                this.deleteServerFiles(new FTPFileName("", server, true), name);
            } else {
                this.deleteServerFiles(new FTPFileName("", server, false), name);
            }
        }
    }

    public static void refreshParent(String fileName, String root, char sep, FileSystem fs) {
        String parent = fileName.substring(root.length() + 1);
        parent = parent.lastIndexOf(sep) > 0 ? parent.substring(0, parent.lastIndexOf(sep)).replace(sep, '/') : "";
        FileObject pfo = fs.findResource(parent);
        if (pfo != null) {
            pfo.refresh();
        }
    }

    public static File toFile(FileObject fo) {
        return (File)fo.getAttribute("java.io.File");
    }

    public static FileObject[] fromFile(String fileName) {
        Enumeration en = Repository.getDefault().getFileSystems();
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            if (!(fs instanceof NetworkFileSystem)) continue;
            try {
                File file2Fo;
                FileObject fo;
                String res;
                NetworkFileSystem nfs = (NetworkFileSystem)fs;
                File root = FTPFileSystem.toFile(fs.getRoot());
                if (root == null) continue;
                String rootName = root.getCanonicalPath();
                String remoteRootName = nfs.getRemoteRoot();
                String searchRootName = FTPFileSystem.getSearchRoot(remoteRootName, nfs);
                if (fileName.toLowerCase().indexOf(searchRootName.toLowerCase()) == 0 && (fileName.charAt(remoteRootName.length() - 1) == '.' || fileName.charAt(remoteRootName.length() - 1) == ']')) {
                    fileName = FTPFileSystem.getClientPath(fileName, remoteRootName, nfs);
                    res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                    FTPFileSystem.refreshParent(fileName, rootName, File.separatorChar, fs);
                    fo = fs.findResource(res);
                    File file = file2Fo = fo != null ? FTPFileSystem.toFile(fo) : null;
                    if (fo == null || file2Fo == null) continue;
                    list.add(fo);
                    continue;
                }
                if (!Utils.getServerOS(nfs.getRemoteRuntimeType()).equals(Utils.OS_VMS)) continue;
                remoteRootName = FileUtility.openVMSPathToUnixPath(remoteRootName, true);
                if (fileName.toLowerCase().indexOf(remoteRootName.toLowerCase()) != 0 || fileName.charAt(remoteRootName.length()) != '/') continue;
                res = fileName.substring(remoteRootName.length() + 1);
                FTPFileSystem.refreshParent(fileName, remoteRootName, '/', fs);
                fo = fs.findResource(res);
                File file = file2Fo = fo != null ? FTPFileSystem.toFile(fo) : null;
                if (fo == null || file2Fo == null) continue;
                list.add(fo);
            }
            catch (IOException iexc) {}
        }
        FileObject[] results = new FileObject[list.size()];
        list.toArray(results);
        return results;
    }

    public Date lastModified(String name) {
        return super.lastModified(name);
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void addNotify() {
        super.addNotify();
        this.incRefCount();
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
    }

    public void removeNotify() {
        super.removeNotify();
        this.decRefCount();
    }

    public void addedFS(FileSystem fs) throws IOException {
        if (fs == this) {
            try {
                if (!this.getSystemName().equals(this.computeSystemName())) {
                    this.setSystemName(this.computeSystemName());
                }
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            super.addedFS(fs);
        }
    }

    protected void ftpSettingsChanged(PropertyChangeEvent event) {
        if (event.getPropertyName() == null) {
            return;
        }
        if (event.getPropertyName().equals("passivemode") && this.client != null) {
            ((FTPClient)this.client).setPassiveMode((Boolean)event.getNewValue());
        }
        if (event.getPropertyName().equals("refreshtime")) {
            this.setRefreshTime((Integer)event.getNewValue());
        }
    }

    protected FTPSettings getFTPSettings() {
        if (this.ftpsettings == null) {
            this.ftpsettings = (FTPSettings)SystemOption.findObject((Class)FTPSettings.class, (boolean)true);
        }
        return this.ftpsettings;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.client = this.createClient(this.loginfo, this.cachedir, this.startdir);
        this.addedFS((FileSystem)this);
        TopManager.getDefault().getRepository().addRepositoryListener(new RepositoryListener(){

            public void fileSystemAdded(RepositoryEvent ev) {
                FTPFileSystem.this.addedFSProjectSwitch(ev.getFileSystem());
            }

            public void fileSystemRemoved(RepositoryEvent ev) {
                FTPFileSystem.this.removedFS(ev.getFileSystem());
            }

            public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
            }
        });
    }

    public void setFtpSocketTimeout(int timeout) throws PropertyVetoException {
    }

    public int getFtpSocketTimeout() {
        if (this.getRemoteRuntimeType() == null) {
            return DistributedSettings.getDefault().getSvrTimeOut() * 1000;
        }
        return this.getRemoteRuntimeType().getSvrTimeOut() * 1000;
    }

    public void setFtpPassiveMode(boolean flag) throws PropertyVetoException {
        if (flag != this.ftpPassiveMode) {
            this.ftpPassiveMode = flag;
            this.firePropertyChange("ftpPassiveMode", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
            this.propChanged();
        }
    }

    public boolean getFtpPassiveMode() {
        return this.ftpPassiveMode;
    }

    public void setSSHForwarding(boolean flag) throws PropertyVetoException {
        if (flag != this.SSHForwarding) {
            this.SSHForwarding = flag;
            this.firePropertyChange("SSHForwarding", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
            this.propChanged();
        }
    }

    public boolean getSSHForwarding() {
        return this.SSHForwarding;
    }

    private String computeSystemName() {
        String sysname = this.getCache().getAbsolutePath();
        return sysname.replaceAll("\\\\|\\.|:", "#");
    }

    private String getDefaultCache() {
        return FTPWORK + File.separator + ((FTPLogInfo)this.loginfo).getHost() + (((FTPLogInfo)this.loginfo).getPort() == 21 ? "" : "_" + String.valueOf(((FTPLogInfo)this.loginfo).getPort())) + "_" + ((FTPLogInfo)this.loginfo).getUser();
    }

    private boolean cacheAlreadyMounted(File r) throws IOException {
        if (r == null) {
            return true;
        }
        if (!r.exists()) {
            return true;
        }
        Enumeration fse = Repository.getDefault().getFileSystems();
        while (fse.hasMoreElements()) {
            String lroot;
            FileSystem fs = (FileSystem)fse.nextElement();
            if (!(fs instanceof LocalFileSystem && !(fs instanceof AbstractNetworkFileSystem) ? (lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(r.getAbsolutePath()) : fs instanceof AbstractNetworkFileSystem && (lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot()).equalsIgnoreCase(r.getAbsolutePath()))) continue;
            return true;
        }
        return false;
    }

    public void setCache(File r) throws PropertyVetoException, IOException {
        if (this.cacheAlreadyMounted(r)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The selected FTP local root directory does not exist or is already being used\nas the local root directory for another FTP file system.\nPlease choose a different FTP local root directory or\nunmount the filesystem that is using the selected directory", 2));
            throw new IOException("selected FTP local directory is not valid");
        }
        if (!r.canWrite() || !r.canRead()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Can't read or write to the selected FTP local root directory", 2));
            throw new IOException("selected FTP local directory is not valid");
        }
        this.cachedir = r;
        String oldDisplayName = this.getDisplayName();
        this.setSystemName(this.computeSystemName());
        this.firePropertyChange("displayName", null, this.getDisplayName());
        this.propChanged();
    }

    protected RemoteFile createRootFile(RemoteClient client, File cache) throws IOException {
        FTPFileName rfn = new FTPFileName("", FileUtility.openVMSPathToUnixPath(this.getStartdir(), true), true);
        RemoteFileAttributes rfa = new RemoteFileAttributes(rfn, true);
        return new RemoteFile(rfa, null, client, this, this, cache, true, this);
    }

    public File getCache() {
        return this.cachedir;
    }

    public String getServer() {
        return ((FTPLogInfo)this.loginfo).getHost();
    }

    public void setServer(String server) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setHost(server);
        this.ftpsettings.setHostName(server);
        this.propChanged();
    }

    public int getPort() {
        return ((FTPLogInfo)this.loginfo).getPort();
    }

    public void setPort(int port) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setPort(port);
        this.ftpsettings.setFTPPort(port);
        this.propChanged();
    }

    public String getUsername() {
        return ((FTPLogInfo)this.loginfo).getUser();
    }

    public void setUsername(String username) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setUser(username);
        this.ftpsettings.setUserName(username);
        this.propChanged();
    }

    public Password getPassword() {
        return new Password(((FTPLogInfo)this.loginfo).getPassword());
    }

    public void setPassword(Password password) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setPassword(password.toString());
        this.ftpsettings.setPassword(password.toString());
        this.propChanged();
    }

    public String getStartdir() {
        return this.startdir;
    }

    public void setStartdir(String startdir) throws PropertyVetoException, IOException {
        String newstartdir = startdir;
        if (startdir == null || startdir.equals("/") || startdir.equals("")) {
            newstartdir = "/";
        } else {
            if (!startdir.startsWith("/")) {
                newstartdir = startdir;
            }
            if (newstartdir.endsWith("/")) {
                newstartdir = newstartdir.substring(0, newstartdir.length() - 1);
            }
        }
        this.startdir = newstartdir;
    }

    private void propChanged() throws PropertyVetoException {
        this.connectOnBackground(true);
    }

    public RemoteClient createClient(LogInfo loginfo, File cache, String rwd) throws IOException {
        File logfile;
        if (!this.cachedir.exists()) {
            this.cachedir.mkdirs();
        }
        if (!(logfile = new File(System.getProperty("netbeans.user") + File.separatorChar + "distributed" + File.separatorChar + "ftp.log")).getParentFile().exists()) {
            logfile = new File(System.getProperty("netbeans.home") + File.separatorChar + "distributed" + File.separatorChar + "ftp_" + System.getProperty("user.name") + ".log");
        }
        FTPClient client = new FTPClient((FTPLogInfo)loginfo, rwd, new DisconnectCallBack(){

            public void disconnected() {
                FTPFileSystem.this.firePropertyChange("displayName", null, FTPFileSystem.this.getDisplayName());
            }
        });
        client.setLog(logfile);
        client.setPassiveMode(this.getFtpPassiveMode());
        client.setSSHForward(this.getSSHForwarding());
        client.setSocketTimeout(this.getFtpSocketTimeout());
        this.rootFile = this.createRootFile(client, cache);
        return client;
    }

    public FTPClient getClient() {
        return (FTPClient)this.client;
    }

    protected void isReadyToModify() throws IOException {
        if (this.client == null) {
            super.addedFS((FileSystem)this);
        } else if (this.rootFile == null) {
            throw new IOException("Connection to server " + this.getServer() + " isn't established");
        }
        if (!this.isConnected() && !this.isOfflineChanges()) {
            throw new IOException("Modification in offline mode are not allowed");
        }
    }

    protected void isReadyToRead() throws IOException {
        if (this.client == null || this.rootFile == null) {
            throw new IOException("Connection to server " + this.getServer() + " isn't established" + (this.client == null) + (this.rootFile == null));
        }
    }

    protected boolean isReady() {
        return this.client != null && this.rootFile != null;
    }

    protected int disconnectDialog(String server) {
        return FTPDialogs.disconnect(server);
    }

    protected boolean connectDialog(String server) {
        return FTPDialogs.connect(server);
    }

    protected void startdirNotFound(String startdir, String server, String rootDir) {
        FTPDialogs.startdirNotFound(startdir, server, rootDir);
    }

    protected void errorConnect(String error, String hostName) {
        FTPDialogs.ftpConnectionError(error, hostName);
    }

    public void notifyIncorrectPassword() {
        FTPDialogs.incorrectPassword(this.getServer());
    }

    public boolean notifyIncorrectCache(File newcache) {
        return FTPDialogs.incorrectCache(this.getCache().getPath(), newcache.getPath(), this.getServer());
    }

    public boolean notifyReconnect(String mess) {
        return true;
    }

    public int notifyWhichFile(String path, Date file1, long size1, Date file2, long size2) {
        return 1;
    }

    public int notifyBothFilesChanged(String path, Date file1, long size1, Date file2, long size2) {
        return 0;
    }

    public boolean isRefreshServer() {
        return this.getFTPSettings().isRefreshServer();
    }

    public boolean isScanCache() {
        return this.getFTPSettings().isScanCache();
    }

    public boolean isAlwaysRefresh() {
        return this.getFTPSettings().isRefreshAlways();
    }

    public void setAlwaysRefresh(boolean alwaysRefresh) {
        this.getFTPSettings().setRefreshAlways(alwaysRefresh);
    }

    public boolean isDownloadServerChangedFile() {
        return this.getFTPSettings().isDownloadServerChangedFile();
    }

    public boolean isOfflineChanges() {
        return this.getFTPSettings().isOfflineChanges();
    }

    public boolean notifyServerChanged(String path, Date file1, long size1, Date file2, long size2) {
        return true;
    }

    public boolean notifyCacheExtDelete(String path, boolean isDir) {
        return false;
    }

    public boolean notifyServerExtDelete(String path, boolean isDir) {
        return false;
    }

    public void fileChanged(String path) {
        FileObject fo = this.findResource(path);
        if (fo != null) {
            fo.refresh();
        }
    }

    public void notifyException(Exception e) {
        ErrorManager.getDefault().notify((Throwable)e);
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.getLocalRoot());
    }

    public FileObject findExistingResource(String name) {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        FileObject fo = null;
        while (enumeration.hasMoreElements()) {
            FileObject obj = (FileObject)enumeration.nextElement();
            if (!name.equalsIgnoreCase(obj.getPackageNameExt('/', '.'))) continue;
            fo = obj;
            break;
        }
        return fo;
    }

    public void statusChanged(String path) {
        FileObject chfo;
        FileObject fo = this.findExistingResource(path);
        if (fo == null) {
            return;
        }
        Enumeration enumeration = this.existingFileObjects(fo);
        HashSet hs = new HashSet();
        if (enumeration.hasMoreElements()) {
            hs.add(enumeration.nextElement());
        }
        while (enumeration.hasMoreElements() && fo.equals((chfo = (FileObject)enumeration.nextElement()).getParent())) {
            hs.add(chfo);
        }
        Set s = Collections.synchronizedSet(hs);
    }

    public String annotateName(String name, Set files) {
        String result;
        block26: {
            result = name;
            if (result == null) {
                return result;
            }
            if (this.getLocalRoot().equals(name)) {
                this.firePropertyChange("displayName", null, this.getDisplayName());
                return this.getDisplayName();
            }
            int len = files.size();
            if (len == 0 || name.indexOf(this.getLocalRoot()) >= 0) {
                return result;
            }
            ArrayList importantFiles = new ArrayList(files);
            len = importantFiles.size();
            if (len == 1) {
                String fullName;
                result = fullName = ((FileObject)importantFiles.get(0)).getNameExt();
                try {
                    if (this.rootFile == null) break block26;
                    RemoteFile rf = this.getRemoteFile(((FileObject)importantFiles.get(0)).getPackageNameExt('/', '.'));
                    if (rf != null) {
                        result = rf.getName().getName();
                    }
                    if (rf != null && !rf.getRemoteFS().getDisplayStatus()) {
                        return result;
                    }
                    if (!((FileObject)importantFiles.get(0)).isFolder() && rf != null) {
                        if (((FileObject)importantFiles.get(0)).getExt().toLowerCase().equals("xml")) {
                            rf.setMimeType("text");
                        } else if (this.getAsciiFileExts().isRegistered(((FileObject)importantFiles.get(0)).getExt().toLowerCase())) {
                            rf.setMimeType("text");
                        } else {
                            String mimeType = FileUtil.getMIMEType((FileObject)((FileObject)importantFiles.get(0)));
                            rf.setMimeType(mimeType);
                        }
                        result = result + " [" + rf.getStatusString() + "]";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
            } else {
                Sync.SyncState cs = null;
                Sync.SyncState ss = null;
                String statusString = "[";
                RemoteFile mainRf = null;
                Iterator it = importantFiles.iterator();
                while (it.hasNext()) {
                    FileObject fobj = (FileObject)it.next();
                    try {
                        if (this.rootFile == null) continue;
                        RemoteFile rf = this.getRemoteFile(fobj.getPackageNameExt('/', '.'));
                        if (mainRf == null) {
                            mainRf = rf;
                        }
                        if (rf != null && !rf.getRemoteFS().getDisplayStatus()) {
                            return result;
                        }
                        if (fobj.isFolder() || rf == null) continue;
                        String mimeType = null;
                        if (fobj.getExt().toLowerCase().equals("form")) {
                            mimeType = "text";
                        } else if (fobj.getExt().toLowerCase().equals("xml")) {
                            mimeType = "text";
                        } else if (this.getAsciiFileExts().isRegistered(fobj.getExt())) {
                            rf.setMimeType("text");
                        } else {
                            mimeType = FileUtil.getMIMEType((FileObject)fobj);
                        }
                        rf.setMimeType(mimeType);
                        cs = cs == null ? rf.getClientStatus() : rf.getClientStatus().getSevererStatus(cs);
                        Sync.SyncState syncState = ss = ss == null ? rf.getServerStatus() : rf.getServerStatus().getSevererStatus(ss);
                        if (!rf.getName().getName().endsWith(".java")) continue;
                        mainRf = rf;
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.out);
                    }
                }
                if (mainRf != null) {
                    name = mainRf.getName().getName();
                }
                result = name + " [" + (cs == null ? "" : cs.toString() + "*") + "|" + (ss == null ? "" : ss.toString() + "*") + "]";
            }
        }
        return result;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public void pubFireFileStatusChanged(Set fos) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fos, true, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestProcessor getStatusChangeRequestProcessor() {
        Object object = STATUS_REQUEST_PROCESSOR_LOCK;
        synchronized (object) {
            if (statusRequestProcessor == null) {
                statusRequestProcessor = new RequestProcessor("FTP FS Status Update Request Processor");
            }
        }
        return statusRequestProcessor;
    }

    public void statusChanged(final String path, final boolean recursively) {
        FTPFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fo = FTPFileSystem.this.findExistingResource(path);
                if (fo == null) {
                    return;
                }
                Enumeration enumeration = FTPFileSystem.this.existingFileObjects(fo);
                HashSet hs = new HashSet();
                if (enumeration.hasMoreElements()) {
                    hs.add(enumeration.nextElement());
                }
                while (enumeration.hasMoreElements()) {
                    FileObject chfo = (FileObject)enumeration.nextElement();
                    if (!recursively && !fo.equals(chfo.getParent())) break;
                    hs.add(chfo);
                }
                Set s = Collections.synchronizedSet(hs);
                FTPFileSystem.this.fireFileStatusChanged(new FileStatusEvent((FileSystem)FTPFileSystem.this, s, true, true));
            }
        });
    }

    public Image annotateIcon(Image icon, int iconType, Set files) {
        FileObject fullName;
        Object[] oo = files.toArray();
        int len = oo.length;
        Image img = null;
        if (len == 0) {
            return icon;
        }
        ArrayList importantFiles = new ArrayList(files);
        len = importantFiles.size();
        if (len == 1 && "".equals((fullName = (FileObject)importantFiles.get(0)).getName())) {
            img = FileStatusInfo.OUT_OF_DATE.getIcon();
            icon = Utilities.mergeImages((Image)icon, (Image)img, (int)16, (int)8);
        }
        if (((FileObject)importantFiles.get(0)).isFolder()) {
            return icon;
        }
        try {
            RemoteFile rf;
            if (this.rootFile != null && (rf = this.getRemoteFile(((FileObject)importantFiles.get(0)).getPackageNameExt('/', '.'))) != null) {
                if (rf.getFileResidenceMode() != 1) {
                    if (rf.getFileResidenceMode() != 0 && Sync.getAction(rf.getClientStatus(), rf.getServerStatus()) == Sync.SyncAction.conflict_dialog) {
                        img = FileStatusInfo.OUT_OF_DATE.getIcon();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        if (img != null) {
            icon = Utilities.mergeImages((Image)icon, (Image)img, (int)16, (int)8);
        }
        return icon;
    }

    public final String getDisplayName() {
        return (!this.isConnected() ? "<offline> " : "") + this.getServer() + " " + this.getCache();
    }

    public FileObject getFSRoot() {
        return this.getRoot();
    }

    static {
        STATUS_REQUEST_PROCESSOR_LOCK = new Object();
    }
}

