/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remotefs.core.RemoteFile;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.core.SyncTablePanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class SynchResidenceAction
extends NodeAction
implements Presenter.Popup {
    static final long serialVersionUID = -7910677883191530622L;
    private RemoteFileSystem fs = null;
    public static final String CLIENT_ONLY_NO_ACTION = "Client Only";
    public static final String SERVER_ONLY_NO_ACTION = "Server Only";
    public static final String CLIENT_SERVER_NO_ACTION = "Client and Server";
    public static final String CLIENT_ONLY = "Make Client Only";
    public static final String SERVER_ONLY = "Make Server Only";
    public static final String CLIENT_SERVER = "Make Client and Server";
    public static final String FILE_MODE_TAG = "File Residence";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu((SystemAction)this, new ActSubMenuModel(this), true);
    }

    protected boolean enable(Node[] nodes) {
        if (nodes == null) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            DataObject df = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SynchResidenceAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (df == null) continue;
            FileObject fo = df.getPrimaryFile();
            try {
                FileSystem fs = fo.getFileSystem();
                if (!(fs instanceof RemoteFileSystem)) {
                    return false;
                }
                if (((RemoteFileSystem)fs).isConnected()) continue;
                return false;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        return true;
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            Set fobjs = ((DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SynchResidenceAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)).files();
            Iterator itr = fobjs.iterator();
            while (itr.hasNext()) {
                try {
                    FileObject fobj = (FileObject)itr.next();
                    RemoteFileSystem fs = (RemoteFileSystem)fobj.getFileSystem();
                    RemoteFile rfile = fs.getRemoteFile(fobj.getPackageNameExt('/', '.'));
                    SyncTablePanel.showSyncFiles(rfile, false, false);
                }
                catch (FileStateInvalidException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                }
                catch (IOException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                }
            }
        }
    }

    protected void setFS(RemoteFileSystem fs) {
        this.fs = fs;
    }

    public String getName() {
        return FILE_MODE_TAG;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = null;
        private List nodeList = null;
        private DataObject dobj = null;
        private final NodeAction action;

        ActSubMenuModel(NodeAction action) {
            this.action = action;
            this.targets = new ArrayList();
            this.nodeList = new ArrayList();
        }

        public int getCount() {
            if (this.targets == null) {
                return 0;
            }
            return this.targets.size();
        }

        public String getLabel(int index) {
            return (String)this.targets.get(index);
        }

        public HelpCtx getHelpCtx(int index) {
            return new HelpCtx("org.apache.tools.ant.module.executing-target");
        }

        private void recursivelyChangeState(FileObject fobj, int index, HashSet folders) {
            if (fobj.isFolder()) {
                FileObject[] children = fobj.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    this.recursivelyChangeState(children[i], index, folders);
                }
            } else {
                try {
                    RemoteFileSystem fs = (RemoteFileSystem)fobj.getFileSystem();
                    RemoteFile rfile = fs.getRemoteFile(fobj.getPackageNameExt('/', '.'));
                    if (fs.getServerOnlyFileExts().isRegistered(rfile.getName().getName()) && index != 1) {
                        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)(rfile.getName().getName() + "'s residence mode is fixed to \"Server Only\".\n Update the \"ServerOnly File Extensions\" propety of the FTP filesystem to change it"), -1, 2));
                    }
                    if (index == 0) {
                        if (rfile.getFileResidenceMode() != 1) {
                            rfile.setFileResidenceMode(1, fobj);
                        }
                    } else if (index == 1) {
                        if (rfile.getFileResidenceMode() != 0) {
                            rfile.setFileResidenceMode(0, fobj);
                        }
                    } else if (index == 2 && rfile.getFileResidenceMode() != 2) {
                        rfile.setFileResidenceMode(2, fobj);
                    }
                    folders.add(fobj.getParent());
                }
                catch (FileStateInvalidException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                }
                catch (IOException e) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
                }
            }
        }

        public void performActionAt(int index) {
            RequestProcessor.postRequest((Runnable)new Runnable(this, index){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ ActSubMenuModel this$0;
                {
                    this.this$0 = this$0;
                    this.val$index = val$index;
                }

                public void run() {
                    StatusDisplayer.getDefault().setStatusText("Performing File Residence Action Recursively");
                    String target = (String)ActSubMenuModel.access$000(this.this$0).get(this.val$index);
                    HashSet<E> folders = new HashSet<E>();
                    for (int i = 0; i < ActSubMenuModel.access$100(this.this$0).size(); ++i) {
                        Set fobjs = ((DataObject)ActSubMenuModel.access$100(this.this$0).get(i)).files();
                        Iterator<E> itr = fobjs.iterator();
                        while (itr.hasNext()) {
                            ActSubMenuModel.access$200(this.this$0, (FileObject)itr.next(), this.val$index, folders);
                        }
                    }
                    Iterator<E> itr = folders.iterator();
                    while (itr.hasNext()) {
                        ((FileObject)itr.next()).refresh();
                    }
                    StatusDisplayer.getDefault().setStatusText("File Residence Action: Done");
                }
            });
        }

        void addNotify() {
            this.targets.add(SynchResidenceAction.CLIENT_ONLY);
            this.targets.add(SynchResidenceAction.SERVER_ONLY);
            this.targets.add(SynchResidenceAction.CLIENT_SERVER);
            Node[] nodes = this.action.getActivatedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                this.nodeList.add((DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SynchResidenceAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject));
            }
        }

        public synchronized void addChangeListener(ChangeListener l) {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
        }

        static /* synthetic */ List access$000(ActSubMenuModel x0) {
            return x0.targets;
        }

        static /* synthetic */ List access$100(ActSubMenuModel x0) {
            return x0.nodeList;
        }

        static /* synthetic */ void access$200(ActSubMenuModel x0, FileObject x1, int x2, HashSet x3) {
            x0.recursivelyChangeState(x1, x2, x3);
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(SystemAction action, ActSubMenuModel model, boolean popup) {
            super(action, (Actions.SubMenuModel)model, popup);
            this.model = model;
        }

        public void addNotify() {
            this.model.addNotify();
            super.addNotify();
        }
    }
}

