/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.java.JavaCompilerType;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.NbBundle;

public class FileSystemPE
extends PropertyEditorSupport {
    private FileSystem fs;
    private String[] tags = null;
    private FileSystem[] fss = null;
    private static String INVALID_MSG = NbBundle.getMessage((Class)FileSystemPE.class, (String)"LABEL_TargetInvalid");
    private static String DEFAULT_MSG = NbBundle.getMessage((Class)FileSystemPE.class, (String)"LABEL_TargetDefault");

    private final FileSystem[] findUsableFilesystems() {
        Enumeration e = FileSystemCapability.COMPILE.fileSystems();
        LinkedList<FileSystem> lst = null;
        while (e.hasMoreElements()) {
            FileSystem fs = (FileSystem)e.nextElement();
            if (!this.canUseFilesystem(fs)) continue;
            if (lst == null) {
                lst = new LinkedList<FileSystem>();
            }
            lst.add(fs);
        }
        return lst == null ? new FileSystem[]{} : lst.toArray(new FileSystem[lst.size()]);
    }

    protected boolean canUseFilesystem(FileSystem fs) {
        return !fs.isReadOnly() && !fs.isDefault() && !fs.isHidden() && fs.isValid() && fs.getCapability().capableOf(FileSystemCapability.COMPILE) && (fs instanceof NetworkFileSystem || fs instanceof FTPFileSystem);
    }

    private synchronized void updateTags() {
        this.fss = this.findUsableFilesystems();
        this.tags = new String[this.fss.length + 1];
        for (int i = 0; i < this.fss.length; ++i) {
            this.tags[i + 1] = this.fss[i].getDisplayName();
        }
        this.tags[0] = DEFAULT_MSG;
    }

    public void setValue(Object o) {
        this.fs = (FileSystem)o;
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.fs;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public synchronized String[] getTags() {
        this.updateTags();
        return this.tags;
    }

    public String getAsText() {
        if (this.fs == null) {
            return DEFAULT_MSG;
        }
        if (this.fs == JavaCompilerType.TARGET_INVALID || !this.fs.isValid()) {
            return INVALID_MSG;
        }
        return this.fs.getDisplayName();
    }

    public synchronized void setAsText(String name) throws IllegalArgumentException {
        this.updateTags();
        if (name.equals(DEFAULT_MSG)) {
            this.setValue(null);
            return;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            if (!name.equals(this.tags[i])) continue;
            this.setValue(this.fss[i - 1]);
            return;
        }
        throw (IllegalArgumentException)ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("No such fs:" + name), MessageFormat.format(NbBundle.getMessage((Class)FileSystemPE.class, (String)"MSG_InvalidTargetFS"), name));
    }

    public static class Local
    extends FileSystemPE {
        protected boolean canUseFileSystem(FileSystem fs) {
            File f = NbClassPath.toFile((FileObject)fs.getRoot());
            return f != null && f.exists() && f.isDirectory() && (fs instanceof NetworkFileSystem || fs instanceof FTPFileSystem);
        }
    }
}

