/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.text.Format;
import java.util.List;
import org.netbeans.modules.distributed.execute.OutputWriterOutputStream;
import org.netbeans.modules.distributed.execute.ReaderCharSequence;
import org.netbeans.modules.distributed.execute.RemoteExecute;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.actions.ExecuteAction;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class TargetExecutor
implements Runnable {
    private RemoteRuntimeType rrt;
    private RemoteProcessDescriptor rpd;
    private InputOutput io;
    private MapFormat format;
    private boolean ok = false;
    private boolean useXterm = false;
    private List targetNames;
    private boolean switchWorkspace = false;
    private ExternalCompiler.ErrorExpression errExp;
    private String cwd;
    private String name;
    private DataObject dobj;
    private int displayNumber;

    public TargetExecutor(RemoteRuntimeType rrt, RemoteProcessDescriptor rpd, ExternalCompiler.ErrorExpression errorExp, boolean useXterm, MapFormat map, String cwd, DataObject dobj, int displayNumber) {
        this.rrt = rrt;
        this.rpd = rpd;
        this.errExp = errorExp;
        this.format = map;
        this.useXterm = useXterm;
        this.cwd = cwd;
        this.dobj = dobj;
        this.displayNumber = displayNumber;
    }

    public void setSwitchWorkspace(boolean sw) {
        this.switchWorkspace = sw;
    }

    public ExecutorTask execute() throws IOException {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorTask execute(String name) throws IOException {
        this.name = name;
        TargetExecutor targetExecutor = this;
        synchronized (targetExecutor) {
            if (this.switchWorkspace) {
                Mutex.EVENT.readAccess(new Mutex.Action(){

                    public Object run() {
                        Workspace w = WindowManager.getDefault().findWorkspace(ExecuteAction.getWorkspace());
                        if (w != null) {
                            w.activate();
                        }
                        return null;
                    }
                });
            }
        }
        this.io = TopManager.getDefault().getIO(name, false);
        this.io.getOut().reset();
        this.io.select();
        this.io.setFocusTaken(true);
        this.io.setErrVisible(false);
        this.io.setErrSeparated(false);
        try {
            if (this.dobj.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem) {
                Thread.currentThread();
                Thread.sleep(3000L);
            } else {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        TopManager.getDefault().setStatusText("Starting (" + name + ")");
        ExecutorTask task = this.createExecutorTask(name, new PERunnable(name));
        return task;
    }

    ExecutorTask createExecutorTask(String name, PERunnable run) throws IOException {
        PERunnable pERunnable = run;
        synchronized (pERunnable) {
            ExecutorTask et = ExecutionEngine.getDefault().execute(name, (Runnable)run, this.io);
            run.setExecutorTask(et);
            try {
                run.wait();
                Throwable t = run.getException();
                if (t != null) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    IOException ex = new IOException(t.getMessage());
                    ErrorManager.getDefault().copyAnnotation((Throwable)ex, t);
                    throw ex;
                }
                return run.getExecutorTask();
            }
            catch (InterruptedException e) {
                IOException ex = new IOException(e.getMessage());
                TopManager.getDefault().setStatusText("Error (" + name + ") : " + e.getMessage());
                ErrorManager.getDefault().copyAnnotation((Throwable)ex, (Throwable)e);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        this.io.setFocusTaken(true);
        this.io.setErrVisible(false);
        this.io.setErrSeparated(false);
        try {
            this.ok = true;
        }
        catch (ThreadDeath td) {
            TopManager.getDefault().setStatusText(NbBundle.getMessage((Class)TargetExecutor.class, (String)"MSG_target_failed_status"));
            return;
        }
        catch (Exception e) {
            TopManager.getDefault().setStatusText(NbBundle.getMessage((Class)TargetExecutor.class, (String)"MSG_target_failed_status"));
        }
    }

    private static class WrapperRunnable
    implements Runnable {
        private ExecutorTask task;

        public WrapperRunnable(ExecutorTask task) {
            this.task = task;
        }

        public void run() {
            this.task.waitFinished();
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;

        public WrapperExecutorTask(ExecutorTask task) {
            super((Runnable)new WrapperRunnable(task));
            this.task = task;
        }

        public void stop() {
            this.task.stop();
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return TargetExecutor.this.io;
        }
    }

    private class CopyMaker
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        final String permName;
        private boolean done = false;
        private ExternalCompiler.ErrorExpression errExp;

        CopyMaker(Reader is, Writer os, boolean b, String className, ExternalCompiler.ErrorExpression errExp) {
            this.os = os;
            this.is = is;
            this.errExp = errExp;
            this.autoflush = b;
            this.permName = className;
        }

        public void run() {
            char c;
            BufferedReader parsedReader = new BufferedReader(this.is);
            StringBuffer sbuf = new StringBuffer();
            PrintStream err = new PrintStream(new OutputWriterOutputStream(TargetExecutor.this.io.getErr(), this.errExp));
            PrintStream out = new PrintStream(new OutputWriterOutputStream(TargetExecutor.this.io.getOut(), this.errExp));
            ReaderCharSequence s = new ReaderCharSequence(parsedReader, 4096, 10000, 1.3333334f);
            for (int i = 0; i < s.length() && (c = s.charAt(i)) != '\uffff'; ++i) {
                sbuf.append(c);
                if (c != '\n') continue;
                out.print(sbuf.toString());
                sbuf.delete(0, sbuf.length());
            }
            out.flush();
        }

        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader is, char[] buff, int start, int count) throws InterruptedException, IOException {
            return is.read();
        }
    }

    static class ExternalExecutorTask
    extends ExecutorTask
    implements RemoteExecute {
        Process proc;
        Thread[] copyMakers;
        ExecutorTask foreign;

        ExternalExecutorTask(Runnable run, ExecutorTask etask, Process proc, Thread[] copyMakers) {
            super(run);
            this.proc = proc;
            this.copyMakers = copyMakers;
            this.foreign = etask;
            TaskListener tl = new TaskListener(this){
                private final /* synthetic */ ExternalExecutorTask this$0;
                {
                    this.this$0 = this$0;
                }

                public void taskFinished(Task t) {
                    this.this$0.stop();
                }
            };
            etask.addTaskListener(tl);
            new Thread(this){
                private final /* synthetic */ ExternalExecutorTask this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.result();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                this.copyMakers[0].interrupt();
                this.copyMakers[1].interrupt();
                this.copyMakers[2].interrupt();
            }
            finally {
                this.proc.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int result() {
            try {
                int ret = this.proc.waitFor();
                Thread.sleep(2000L);
                int n = ret;
                return n;
            }
            catch (InterruptedException e) {
                int n = 1;
                return n;
            }
            finally {
                this.stop();
                this.notifyFinished();
            }
        }

        public InputOutput getInputOutput() {
            return this.foreign.getInputOutput();
        }

        public void run() {
        }
    }

    private class PERunnable
    implements Runnable,
    TaskListener {
        private DataObject obj;
        private ExecutorTask fromEngine;
        ExecutorTask fromMe;
        private Throwable t;
        private String name;

        PERunnable(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                String className = this.name;
                String clientIP = Utils.getIntendedHostAddress();
                if (TargetExecutor.this.useXterm) {
                    clientIP = clientIP + ":" + TargetExecutor.this.displayNumber;
                }
                Process process = TargetExecutor.this.rpd.exec((Format)TargetExecutor.this.format, TargetExecutor.this.rrt, TargetExecutor.this.useXterm, TargetExecutor.this.cwd, clientIP);
                Thread[] copyMakers = new Thread[3];
                copyMakers[0] = new CopyMaker(this.fromEngine.getInputOutput().getIn(), new OutputStreamWriter(process.getOutputStream()), true, className, TargetExecutor.this.errExp);
                copyMakers[0].start();
                copyMakers[1] = new CopyMaker(new InputStreamReader(process.getInputStream()), (Writer)this.fromEngine.getInputOutput().getOut(), false, className, TargetExecutor.this.errExp);
                copyMakers[1].start();
                copyMakers[2] = new CopyMaker(new InputStreamReader(process.getErrorStream()), (Writer)this.fromEngine.getInputOutput().getErr(), false, className, TargetExecutor.this.errExp);
                copyMakers[2].start();
                this.fromMe = new ExternalExecutorTask(this, this.fromEngine, process, copyMakers);
                TaskListener tl = new TaskListener(this){
                    private final /* synthetic */ PERunnable this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void taskFinished(Task t) {
                        TopManager.getDefault().setStatusText("Finished (" + PERunnable.access$700(this.this$1) + ")");
                        PERunnable.access$800(this.this$1).getInputOutput().getOut().print("Finished (" + PERunnable.access$700(this.this$1) + ")");
                    }
                };
                this.fromEngine.addTaskListener(tl);
            }
            catch (Exception e) {
                this.t = e;
                TopManager.getDefault().setStatusText("Error (" + this.name + ") : " + e.getMessage());
            }
            finally {
                this.notifyAll();
            }
        }

        public void setExecutorTask(ExecutorTask fromEngine) {
            this.fromEngine = fromEngine;
            fromEngine.addTaskListener((TaskListener)this);
        }

        public ExecutorTask getExecutorTask() {
            return this.fromMe;
        }

        public Throwable getException() {
            return this.t;
        }

        public void taskFinished(Task t) {
            if (this.fromMe != null) {
                this.fromMe.stop();
            }
        }

        static /* synthetic */ String access$700(PERunnable x0) {
            return x0.name;
        }

        static /* synthetic */ ExecutorTask access$800(PERunnable x0) {
            return x0.fromEngine;
        }
    }
}

