/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.execute.RemoteJavaCompiler;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.execute.TargetExecutor;
import org.netbeans.modules.distributed.propertyeditors.ErrorExpressionEditor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.distributed.util.FileUtility;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.ExecInfo;
import org.openide.execution.Executor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class RemoteExecutor
extends Executor {
    private static final long serialVersionUID = 4921782425419448313L;
    public static final String PROP_REMOTE_EXECUTOR = "remoteExecutor";
    public static final String TAG_FILE = "file";
    public static final String TAG_CURRENT_DIR = "current dir";
    public static final String TAG_ARGUMENTS = "arguments";
    public static final String TAG_ROOT_DIR = "root dir";
    public static final String TAG_FILENAME = "file name";
    public static final String TAG_EXT = "file extension";
    public static final String TAG_DEVICE = "device";
    public static final String TAG_DIRECTORY = "directory";
    public static final String TAG_JAVA_CLASSNAME = "java class";
    public static final String PROP_ERROR_EXPRESSION = "errorExpression";
    public static final String PROP_CHANGE_WORKING_DIR = "changeWorkingDir";
    protected ExternalCompiler.ErrorExpression errorExpression = ErrorExpressionEditor.errorExpression;
    protected RemoteProcessDescriptor remoteExecutor;
    protected boolean useXterm;
    protected boolean includeFileExtension;
    protected boolean useUnixFilePath;
    protected boolean changeWorkingDir;
    protected boolean useFileNameOnly;
    protected File workingDirectory = null;
    protected MapFormat format;

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    public void setErrorExpression(ExternalCompiler.ErrorExpression e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        ExternalCompiler.ErrorExpression old = this.errorExpression;
        this.errorExpression = e;
        this.firePropertyChange(PROP_ERROR_EXPRESSION, old, e);
    }

    public boolean getChangeWorkingDir() {
        return this.changeWorkingDir;
    }

    public void setChangeWorkingDir(boolean workingDir) {
        boolean old = this.changeWorkingDir;
        this.changeWorkingDir = workingDir;
        this.firePropertyChange(PROP_CHANGE_WORKING_DIR, new Boolean(old), new Boolean(workingDir));
    }

    public ExecutorTask execute(ExecInfo info) throws IOException {
        throw new IOException("unimplemented");
    }

    public RemoteProcessDescriptor getRemoteExecutor() {
        return this.getExternalExecutor();
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        if (this.remoteExecutor == null) {
            this.remoteExecutor = new RemoteProcessDescriptor("run ", " {arguments} {file}", NbBundle.getBundle((Class)RemoteExecutor.class).getString("MSG_RemoteExecutorHint"));
        }
        return this.remoteExecutor;
    }

    public void setRemoteExecutor(RemoteProcessDescriptor re) {
        this.remoteExecutor = re;
        this.firePropertyChange(PROP_REMOTE_EXECUTOR, null, re);
    }

    protected MapFormat createMapFormat(DataObject obj, AbstractNetworkFileSystem nfs) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        FileObject fobj = obj.getPrimaryFile();
        String arguments = (String)fobj.getAttribute("REMOTE_ARGUMENT");
        if (arguments != null && arguments.length() > 0) {
            m.put(TAG_ARGUMENTS, arguments);
        } else {
            m.put(TAG_ARGUMENTS, "");
        }
        m.put(TAG_JAVA_CLASSNAME, fobj.getPackageName('.'));
        File file = FileUtil.toFile((FileObject)fobj);
        String vmsPath = "";
        if (Utilities.isWindows()) {
            vmsPath = FileUtility._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 8192) {
            vmsPath = FileUtility.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
        }
        String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
        if (curDir == null || curDir.length() == 0) {
            File pfile = FileUtil.toFile((FileObject)fobj.getParent());
            if (Utilities.isWindows()) {
                curDir = FileUtility._winPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 8192) {
                curDir = FileUtility.unixPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
            }
        }
        m.put(TAG_CURRENT_DIR, curDir);
        String rootDir = nfs.getRemoteRoot();
        m.put(TAG_ROOT_DIR, rootDir);
        m.put(TAG_FILE, vmsPath);
        String fileName = curDir + fobj.getName();
        String devName = vmsPath.indexOf(":") > 0 ? vmsPath.substring(0, vmsPath.indexOf(":")) : vmsPath;
        m.put(TAG_FILENAME, fileName);
        m.put(TAG_EXT, fobj.getExt());
        m.put(TAG_DEVICE, devName);
        m.put(TAG_DIRECTORY, curDir);
        MapFormat mf = new MapFormat(m);
        mf.setLeftBrace("{");
        mf.setRightBrace("}");
        return mf;
    }

    public ExecutorTask execute(DataObject obj) throws IOException {
        String cmd;
        AbstractNetworkFileSystem nfs = null;
        RemoteRuntimeType rrt = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException exp) {
            // empty catch block
        }
        rrt = nfs.getRemoteRuntimeType();
        if (nfs == null || !(nfs instanceof AbstractNetworkFileSystem)) {
            IOException ioe = new IOException("The file " + obj.getNodeDelegate().getDisplayName() + " is not a remote file");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\n Please go to Runtime Tab and create remote server", 2));
            DistributedModule.err.annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        if (rrt == null) {
            IOException ioe = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\n Please go to Runtime Tab and create remote server", 2));
            DistributedModule.err.annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        if (rrt.getRemoteRuntime() == null) {
            IOException ioe = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Remote server is diconnected.\n Please go to Runtime Tab and make connection", 2));
            DistributedModule.err.annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        File file = FileUtil.toFile((FileObject)obj.getPrimaryFile().getParent());
        String cwd = null;
        if (this.getChangeWorkingDir()) {
            cwd = this.getWorkingDirectory(file, obj);
        }
        boolean useX = false;
        Boolean bobj = null;
        int displayNumber = 0;
        bobj = this instanceof RemoteJavaCompiler ? (Boolean)obj.getPrimaryFile().getAttribute("useXtermCompile") : (Boolean)obj.getPrimaryFile().getAttribute("useXtermExecution");
        useX = bobj != null ? bobj : (this instanceof RemoteJavaCompiler ? nfs.getUseXtermCompile() : nfs.getUseXtermExecution());
        if (useX) {
            Integer iobj = (Integer)obj.getPrimaryFile().getAttribute("xDisplayDeviceNumber");
            displayNumber = iobj != null ? iobj.intValue() : nfs.getXDisplayDeviceNumber();
        }
        if (useX && Utilities.isWindows() && (cmd = DistributedSettings.getDefault().getXServer()) != null && cmd.length() > 0) {
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Problem launching X Window sever on your desktop.", 2));
                DistributedModule.err.annotate((Throwable)e, 1, null, null, null, null);
                throw e;
            }
        }
        TargetExecutor texec = new TargetExecutor(rrt, this.getRemoteExecutor(), this.getErrorExpression(), useX, this.format, cwd, obj, displayNumber);
        return texec.execute(this.getName() + " (" + obj.getPrimaryFile().getNameExt() + ")");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.distributed.RemoteExecutor");
    }

    public String getWorkingDirectory(File file, DataObject obj) {
        String cwd = null;
        if (this.workingDirectory != null) {
            if (Utilities.isWindows()) {
                cwd = FileUtility.__winPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true);
                cwd = FileUtility.openVMSPathToUnixPath(cwd, true);
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 8192) {
                cwd = FileUtility.unixPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true);
            }
        } else if (Utilities.isWindows()) {
            cwd = FileUtility._winPathToOpenVMSPath(file.getAbsolutePath(), true, obj.getPrimaryFile().getParent());
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 8192) {
            cwd = FileUtility.unixPathToOpenVMSPath(file.getAbsolutePath(), true, obj.getPrimaryFile().getParent());
        }
        return cwd;
    }

    public static void disconnectRemoteProcesses() {
    }
}

