/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.actions;

import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.support.DebuggerSettings;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.actions.RemoteCompileAction;
import org.netbeans.modules.distributed.execute.RemoteExecutor;
import org.netbeans.modules.distributed.execute.RemoteJavaDebugger;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.settings.DistributedProjectSettings;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.ServiceType;
import org.openide.actions.ExecuteAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CompilerCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class RemoteDebugAction
extends NodeAction {
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$util$RemoteCookie;
    static /* synthetic */ Class class$org$netbeans$modules$distributed$actions$RemoteDebugAction;

    public String getName() {
        return "Remote Debug";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/distributed/resources/remdebug.gif";
    }

    protected Class[] cookieClasses() {
        return new Class[]{CompilerCookie.class};
    }

    private static void refreshFS() {
        Enumeration fss = FileSystemCapability.DEBUG.fileSystems();
        FileSystem defaultFS = Repository.getDefault().getDefaultFileSystem();
        while (fss.hasMoreElements()) {
            FileSystem fs = (FileSystem)fss.nextElement();
            if (fs.isReadOnly() || fs == defaultFS || !(fs instanceof AbstractNetworkFileSystem)) continue;
            fs.refresh(false);
        }
    }

    protected void performAction(Node[] activatedNodes) {
        int res;
        DistributedModule.logger.info("Invoking remote debug java command ");
        if (ExecuteAction.getRunCompilation() && (res = RemoteCompileAction.doAction(activatedNodes, true)) == 0) {
            return;
        }
        RemoteDebugAction.refreshFS();
        for (int i = 0; i < activatedNodes.length; ++i) {
            RemoteExecutor ret;
            DataObject dobj = (DataObject)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteDebugAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dobj.getCookie(class$org$netbeans$modules$distributed$util$RemoteCookie == null ? RemoteDebugAction.class$("org.netbeans.modules.distributed.util.RemoteCookie") : class$org$netbeans$modules$distributed$util$RemoteCookie) != null || !dobj.getPrimaryFile().getExt().equals("java")) continue;
            Object obj = dobj.getPrimaryFile().getAttribute("remoteDebuggerType");
            if (obj == null) {
                ret = (RemoteExecutor)DistributedProjectSettings.getDefault().getRemoteDebuggerType();
            } else {
                ServiceType.Handle handle = (ServiceType.Handle)obj;
                ret = (RemoteExecutor)handle.getServiceType();
            }
            if (ret == null) {
                DistributedModule.err.notify((Throwable)new Exception("Remote Debug Action Failed"));
                return;
            }
            int j = 0;
            try {
                for (j = 0; j < 10; ++j) {
                    ExecutorTask task = ret.execute(dobj);
                    int dbgPort = ((RemoteJavaDebugger)ret).getTCPPort();
                    class DbgThread
                    extends Thread {
                        private int result = 0;
                        private final /* synthetic */ ExecutorTask val$task;

                        DbgThread(ExecutorTask val$task) {
                            this.val$task = val$task;
                        }

                        public int getResult() {
                            return this.result;
                        }

                        public void run() {
                            this.result = this.val$task.result();
                        }
                    }
                    DbgThread thr = new DbgThread(task);
                    thr.start();
                    try {
                        Thread.sleep(7000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    int res2 = thr.getResult();
                    if (res2 != 1076) {
                        try {
                            AbstractNetworkFileSystem fs = (AbstractNetworkFileSystem)dobj.getPrimaryFile().getFileSystem();
                            if (fs.getRemoteRuntimeType() == null) {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\nPlease go to the Runtime Tab and create a remote server", 0));
                                break;
                            }
                            this.connect(fs.getRemoteRuntimeType().getHostName(), dbgPort);
                        }
                        catch (FileStateInvalidException e) {
                            DistributedModule.err.notify((Throwable)e);
                        }
                        break;
                    }
                    StatusDisplayer.getDefault().setStatusText("Remote Debugger could not make server connection. Trying again... (" + dobj.getName() + ")");
                }
            }
            catch (IOException ioe) {
                DistributedModule.err.notify((Throwable)ioe);
            }
            if (j != 10) continue;
            StatusDisplayer.getDefault().setStatusText("Remote Debug Failed - No available Port Found (" + dobj.getName() + ")");
        }
    }

    public String getDesktop() {
        String d = ((DebuggerSettings)DebuggerSettings.findObject((Class)DebuggerSettings.class, (boolean)true)).getDesktop();
        if (d == null) {
            return "Debugging";
        }
        return d;
    }

    public void connect(final String host, final int port) {
        String workspaceName;
        WindowManager wm = WindowManager.getDefault();
        Workspace w = wm.findWorkspace(workspaceName = this.getDesktop());
        if (w != null) {
            w.activate();
        }
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                boolean tryAgain = false;
                try {
                    RemoteDebuggerInfo rd = new RemoteDebuggerInfo(host, port);
                    CoreDebugger d = Register.getCoreDebugger();
                    d.startDebugger((DebuggerInfo)rd);
                }
                catch (DebuggerException ex) {
                    Throwable th = ex.getTargetException();
                    ErrorManager.getDefault().notify(1, th != null ? th : ex);
                    if (th instanceof UnknownHostException) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$distributed$actions$RemoteDebugAction == null ? (class$org$netbeans$modules$distributed$actions$RemoteDebugAction = RemoteDebugAction.class$("org.netbeans.modules.distributed.actions.RemoteDebugAction")) : class$org$netbeans$modules$distributed$actions$RemoteDebugAction)).getString("EXC_Cannot_attach_unknown_host"), 0));
                        tryAgain = true;
                    }
                    if (th instanceof IllegalConnectorArgumentsException) {
                        String argNames;
                        List<String> argList = ((IllegalConnectorArgumentsException)th).argumentNames();
                        int listSize = argList.size();
                        if (listSize == 1) {
                            argNames = argList.get(0);
                        } else {
                            StringBuffer buf = new StringBuffer(50);
                            buf.append((Object)argList.get(0));
                            for (int i = 1; i < listSize; ++i) {
                                buf.append(", ");
                                buf.append((Object)argList.get(i));
                            }
                            argNames = buf.toString();
                        }
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$distributed$actions$RemoteDebugAction == null ? (class$org$netbeans$modules$distributed$actions$RemoteDebugAction = RemoteDebugAction.class$("org.netbeans.modules.distributed.actions.RemoteDebugAction")) : class$org$netbeans$modules$distributed$actions$RemoteDebugAction)).getString("EXC_Illegal_attach_arguments"), new Integer(listSize), argNames), 0));
                        tryAgain = true;
                    }
                    if (th instanceof IOException) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$distributed$actions$RemoteDebugAction == null ? (class$org$netbeans$modules$distributed$actions$RemoteDebugAction = RemoteDebugAction.class$("org.netbeans.modules.distributed.actions.RemoteDebugAction")) : class$org$netbeans$modules$distributed$actions$RemoteDebugAction)).getString("EXC_Cannot_attach"), 0));
                        tryAgain = true;
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(th == null ? ex : th, (Object)(NbBundle.getBundle((Class)(class$org$netbeans$modules$distributed$actions$RemoteDebugAction == null ? (class$org$netbeans$modules$distributed$actions$RemoteDebugAction = RemoteDebugAction.class$("org.netbeans.modules.distributed.actions.RemoteDebugAction")) : class$org$netbeans$modules$distributed$actions$RemoteDebugAction)).getString("EXC_Debugger") + ": " + ex.getMessage())));
                }
            }
        });
    }

    protected boolean enable(Node[] node) {
        int nodeCnt = 0;
        if (node.length == 0) {
            return false;
        }
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteDebugAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dobj == null) {
                return false;
            }
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            try {
                if (!(dobj.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem) && !(dobj.getPrimaryFile().getFileSystem() instanceof FTPFileSystem)) {
                    return false;
                }
                if (dobj.getPrimaryFile().getFileSystem() instanceof RemoteFileSystem && !((RemoteFileSystem)dobj.getPrimaryFile().getFileSystem()).isConnected()) {
                    return false;
                }
            }
            catch (FileStateInvalidException e) {
                return false;
            }
            if (!dobj.getPrimaryFile().getExt().toLowerCase().equals("java")) continue;
            ++nodeCnt;
        }
        return nodeCnt == node.length;
    }

    protected boolean asynchronous() {
        return false;
    }
}

