/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.ExPropertyEditor;
import com.hp.openvms.netbeans.cppsupport.prop.IndexedEditorPanel;
import com.hp.openvms.netbeans.cppsupport.prop.PropertyEnv;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.IndexedNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

class IndexedPropertyEditor
implements ExPropertyEditor {
    private Object[] array;
    private PropertyEnv env;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Node.IndexedProperty indexedProperty = null;
    private IndexedEditorPanel currentEditorPanel;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$com$hp$openvms$netbeans$cppsupport$prop$IndexedPropertyEditor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public void attachEnv(PropertyEnv env) {
        this.env = env;
        FeatureDescriptor details = env.getFeatureDescriptor();
        if (!(details instanceof Node.IndexedProperty)) {
            throw new IllegalStateException("This is not an array: " + details);
        }
        this.indexedProperty = (Node.IndexedProperty)details;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.array = null;
            this.firePropertyChange();
            return;
        }
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException(this.env != null ? "Property which value is not an array " + this.env.getFeatureDescriptor().getName() : "Unknown property - not attached yet.");
        }
        if (value.getClass().getComponentType().isPrimitive()) {
            this.array = Utilities.toObjectArray((Object)value);
        } else {
            this.array = (Object[])Array.newInstance(value.getClass().getComponentType(), ((Object[])value).length);
            System.arraycopy(value, 0, this.array, 0, this.array.length);
        }
        this.firePropertyChange();
    }

    public Object getValue() {
        if (this.array == null) {
            return null;
        }
        if (this.indexedProperty.getElementType().isPrimitive()) {
            return Utilities.toPrimitiveArray((Object[])this.array);
        }
        return this.array;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString(int index) {
        if (this.array[index] == null) {
            return "null";
        }
        try {
            this.indexedProperty.getIndexedPropertyEditor().setValue(this.array[index]);
            return this.indexedProperty.getIndexedPropertyEditor().getJavaInitializationString();
        }
        catch (NullPointerException e) {
            return "null";
        }
    }

    public String getJavaInitializationString() {
        if (this.array == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer("new ");
        buf.append(this.indexedProperty.getElementType().getName());
        if (this.array.length == 0) {
            buf.append("[0]");
        } else {
            buf.append("[] {\n\t");
            for (int i = 0; i < this.array.length; ++i) {
                try {
                    this.indexedProperty.getIndexedPropertyEditor().setValue(this.array[i]);
                    buf.append(this.indexedProperty.getIndexedPropertyEditor().getJavaInitializationString());
                }
                catch (NullPointerException e) {
                    buf.append("null");
                }
                if (i != this.array.length - 1) {
                    buf.append(",\n\t");
                    continue;
                }
                buf.append("\n");
            }
            buf.append("}");
        }
        return buf.toString();
    }

    public String getAsText() {
        if (this.array == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer("[");
        PropertyEditor p = null;
        if (this.indexedProperty != null) {
            p = this.indexedProperty.getIndexedPropertyEditor();
        }
        for (int i = 0; i < this.array.length; ++i) {
            if (p != null) {
                p.setValue(this.array[i]);
                buf.append(p.getAsText());
            } else {
                buf.append("null");
            }
            if (i == this.array.length - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text.equals("null")) {
            this.setValue(null);
            return;
        }
        if (text.equals("[]")) {
            this.setValue(Array.newInstance(this.indexedProperty.getElementType(), 0));
            return;
        }
        int i1 = text.indexOf(91);
        i1 = i1 < 0 || i1 + 1 >= text.length() ? 0 : ++i1;
        int i2 = text.lastIndexOf(93);
        if (i2 < 0) {
            i2 = text.length();
        }
        if (i2 < i1 || i2 > text.length()) {
            return;
        }
        try {
            text = text.substring(i1, i2);
            StringTokenizer tok = new StringTokenizer(text, ",");
            LinkedList<Object> list = new LinkedList<Object>();
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                PropertyEditor p = this.indexedProperty.getIndexedPropertyEditor();
                p.setAsText(s.trim());
                list.add(p.getValue());
            }
            Object[] a = list.toArray((Object[])Array.newInstance(this.getConvertedType(), list.size()));
            this.setValue(a);
        }
        catch (Exception x) {
            IllegalArgumentException iae = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)iae, 256, IndexedPropertyEditor.getString("EXC_ErrorInIndexedSetter"), IndexedPropertyEditor.getString("EXC_ErrorInIndexedSetter"), (Throwable)x, new Date());
            throw iae;
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.array == null) {
            this.array = (Object[])Array.newInstance(this.getConvertedType(), 0);
            this.firePropertyChange();
        }
        DisplayIndexedNode dummy = new DisplayIndexedNode(0);
        Node.Property prop = dummy.getPropertySets()[0].getProperties()[0];
        Node.Property[] np = new Node.Property[]{prop};
        this.currentEditorPanel = new IndexedEditorPanel(this.createRootNode(), np);
        return this.currentEditorPanel;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    private Node createRootNode() {
        DisplayIndexedNode[] n = new DisplayIndexedNode[this.array.length];
        for (int i = 0; i < n.length; ++i) {
            n[i] = new DisplayIndexedNode(i);
        }
        MyIndexedRootNode idr = new MyIndexedRootNode((Node[])n);
        Index ind = (Index)idr.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = IndexedPropertyEditor.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        for (int i = 0; i < n.length; ++i) {
            ind.addChangeListener(WeakListener.change((ChangeListener)n[i], (Object)ind));
        }
        return idr;
    }

    private Class getConvertedType() {
        Class type = this.indexedProperty.getElementType();
        if (type.isPrimitive()) {
            type = Utilities.getObjectType((Class)type);
        }
        return type;
    }

    void firePropertyChange() {
        this.propertySupport.firePropertyChange("value", null, null);
    }

    private static String getString(String key) {
        return NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$cppsupport$prop$IndexedPropertyEditor == null ? (class$com$hp$openvms$netbeans$cppsupport$prop$IndexedPropertyEditor = IndexedPropertyEditor.class$("com.hp.openvms.netbeans.cppsupport.prop.IndexedPropertyEditor")) : class$com$hp$openvms$netbeans$cppsupport$prop$IndexedPropertyEditor)).getString(key);
    }

    private Object defaultValue() {
        Constable value = null;
        if (this.indexedProperty.getElementType().isPrimitive()) {
            if (this.getConvertedType().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = IndexedPropertyEditor.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                value = new Integer(0);
            }
            if (this.getConvertedType().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = IndexedPropertyEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                value = Boolean.FALSE;
            }
            if (this.getConvertedType().equals(class$java$lang$Byte == null ? (class$java$lang$Byte = IndexedPropertyEditor.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                value = new Byte(0);
            }
            if (this.getConvertedType().equals(class$java$lang$Character == null ? (class$java$lang$Character = IndexedPropertyEditor.class$("java.lang.Character")) : class$java$lang$Character)) {
                value = new Character('\u0000');
            }
            if (this.getConvertedType().equals(class$java$lang$Double == null ? (class$java$lang$Double = IndexedPropertyEditor.class$("java.lang.Double")) : class$java$lang$Double)) {
                value = new Double(0.0);
            }
            if (this.getConvertedType().equals(class$java$lang$Float == null ? (class$java$lang$Float = IndexedPropertyEditor.class$("java.lang.Float")) : class$java$lang$Float)) {
                value = new Float(0.0f);
            }
            if (this.getConvertedType().equals(class$java$lang$Long == null ? (class$java$lang$Long = IndexedPropertyEditor.class$("java.lang.Long")) : class$java$lang$Long)) {
                value = new Long(0L);
            }
            if (this.getConvertedType().equals(class$java$lang$Short == null ? (class$java$lang$Short = IndexedPropertyEditor.class$("java.lang.Short")) : class$java$lang$Short)) {
                value = new Short(0);
            }
        } else {
            try {
                value = (Constable)this.getConvertedType().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Object[] access$102(IndexedPropertyEditor x0, Object[] x1) {
        x0.array = x1;
        return x1;
    }

    static /* synthetic */ Object access$900(IndexedPropertyEditor x0) {
        return x0.defaultValue();
    }

    private class MyIndexedRootNode
    extends IndexedNode {
        public MyIndexedRootNode(Node[] ch) {
            this.getChildren().add(ch);
            this.setName("IndexedRoot");
            this.setDisplayName(NbBundle.getBundle((Class)(class$com$hp$openvms$netbeans$cppsupport$prop$IndexedPropertyEditor == null ? (class$com$hp$openvms$netbeans$cppsupport$prop$IndexedPropertyEditor = IndexedPropertyEditor.class$("com.hp.openvms.netbeans.cppsupport.prop.IndexedPropertyEditor")) : class$com$hp$openvms$netbeans$cppsupport$prop$IndexedPropertyEditor)).getString("CTL_Index"));
        }

        public NewType[] getNewTypes() {
            NewType nt = new NewType(this){
                private final /* synthetic */ MyIndexedRootNode this$1;
                {
                    this.this$1 = this$1;
                }

                public void create() {
                    if (IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)) != null) {
                        Object[] newArray = (Object[])Array.newInstance(IndexedPropertyEditor.access$000(MyIndexedRootNode.access$800(this.this$1)), IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)).length + 1);
                        System.arraycopy(IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)), 0, newArray, 0, IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)).length);
                        IndexedPropertyEditor.access$102(MyIndexedRootNode.access$800(this.this$1), newArray);
                        IndexedPropertyEditor.access$100((IndexedPropertyEditor)MyIndexedRootNode.access$800((MyIndexedRootNode)this.this$1))[IndexedPropertyEditor.access$100((IndexedPropertyEditor)MyIndexedRootNode.access$800((MyIndexedRootNode)this.this$1)).length - 1] = IndexedPropertyEditor.access$900(MyIndexedRootNode.access$800(this.this$1));
                    } else {
                        IndexedPropertyEditor.access$102(MyIndexedRootNode.access$800(this.this$1), (Object[])Array.newInstance(IndexedPropertyEditor.access$000(MyIndexedRootNode.access$800(this.this$1)), 1));
                        IndexedPropertyEditor.access$100((IndexedPropertyEditor)MyIndexedRootNode.access$800((MyIndexedRootNode)this.this$1))[0] = IndexedPropertyEditor.access$900(MyIndexedRootNode.access$800(this.this$1));
                    }
                    MyIndexedRootNode.access$800(this.this$1).firePropertyChange();
                    DisplayIndexedNode din = MyIndexedRootNode.access$800(this.this$1).new DisplayIndexedNode(IndexedPropertyEditor.access$100(MyIndexedRootNode.access$800(this.this$1)).length - 1);
                    this.this$1.getChildren().add(new Node[]{din});
                    Index i = (Index)this.this$1.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = IndexedPropertyEditor.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
                    i.addChangeListener(WeakListener.change((ChangeListener)din, (Object)i));
                }
            };
            return new NewType[]{nt};
        }

        static /* synthetic */ IndexedPropertyEditor access$800(MyIndexedRootNode x0) {
            return x0.IndexedPropertyEditor.this;
        }
    }

    class DisplayIndexedNode
    extends AbstractNode
    implements ChangeListener {
        private int index;

        public DisplayIndexedNode(int index) {
            super(Children.LEAF);
            this.index = index;
            this.setName(Integer.toString(index));
            this.setDisplayName(Integer.toString(index));
        }

        protected SystemAction[] createActions() {
            try {
                return new SystemAction[]{SystemAction.get(Class.forName("org.openide.actions.MoveUpAction")), SystemAction.get(Class.forName("org.openide.actions.MoveDownAction"))};
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set props = sheet.get("properties");
            if (props == null) {
                props = Sheet.createPropertiesSet();
                sheet.put(props);
            }
            props.put((Node.Property)new ValueProp());
            return sheet;
        }

        public void destroy() throws IOException {
            Object[] newArray = (Object[])Array.newInstance(IndexedPropertyEditor.this.getConvertedType(), IndexedPropertyEditor.this.array.length - 1);
            System.arraycopy(IndexedPropertyEditor.this.array, 0, newArray, 0, this.index);
            System.arraycopy(IndexedPropertyEditor.this.array, this.index + 1, newArray, this.index, IndexedPropertyEditor.this.array.length - this.index - 1);
            IndexedPropertyEditor.access$102(IndexedPropertyEditor.this, newArray);
            IndexedPropertyEditor.this.firePropertyChange();
            if (IndexedPropertyEditor.this.currentEditorPanel != null) {
                IndexedPropertyEditor.this.currentEditorPanel.getExplorerManager().setRootContext(IndexedPropertyEditor.this.createRootNode());
            }
        }

        public void stateChanged(ChangeEvent e) {
            int currentIndex;
            Node parent = this.getParentNode();
            Index i = (Index)parent.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = IndexedPropertyEditor.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
            if (i != null && (currentIndex = i.indexOf((Node)this)) != this.index) {
                if (currentIndex > this.index) {
                    Object tmp = IndexedPropertyEditor.this.array[this.index];
                    ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[this.index] = IndexedPropertyEditor.this.array[currentIndex];
                    ((IndexedPropertyEditor)IndexedPropertyEditor.this).array[currentIndex] = tmp;
                }
                this.index = currentIndex;
                this.firePropertyChange(null, null, null);
                this.setDisplayName(Integer.toString(this.index));
                IndexedPropertyEditor.this.firePropertyChange();
            }
        }

        private class ValueProp
        extends PropertySupport {
            public ValueProp() {
                super(IndexedPropertyEditor.this.indexedProperty.getName(), IndexedPropertyEditor.this.indexedProperty.getElementType(), IndexedPropertyEditor.this.indexedProperty.getDisplayName(), IndexedPropertyEditor.this.indexedProperty.getShortDescription(), IndexedPropertyEditor.this.indexedProperty.canRead(), IndexedPropertyEditor.this.indexedProperty.canWrite());
            }

            public Object getValue() {
                if (DisplayIndexedNode.this.index < IndexedPropertyEditor.this.array.length) {
                    return IndexedPropertyEditor.this.array[DisplayIndexedNode.this.index];
                }
                return null;
            }

            public void setValue(Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                Object oldVal = IndexedPropertyEditor.this.array[DisplayIndexedNode.this.index];
                ((IndexedPropertyEditor)((DisplayIndexedNode)DisplayIndexedNode.this).IndexedPropertyEditor.this).array[((DisplayIndexedNode)DisplayIndexedNode.this).index] = value;
                DisplayIndexedNode.this.firePropertyChange(this.getName(), oldVal, value);
                IndexedPropertyEditor.this.firePropertyChange();
            }

            public PropertyEditor getPropertyEditor() {
                return IndexedPropertyEditor.this.indexedProperty.getIndexedPropertyEditor();
            }
        }
    }
}

