/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.ccpp.cc;

import com.hp.openvms.netbeans.cppsupport.ccpp.CCppCompiler;
import com.hp.openvms.netbeans.cppsupport.ccpp.CCppCompilerGroup;
import com.hp.openvms.netbeans.cppsupport.ccpp.cc.CCompiler;
import com.hp.openvms.netbeans.cppsupport.ccpp.cc.CCompilerType;
import com.hp.openvms.netbeans.utils.DCLExecutor;
import java.io.File;
import java.io.IOException;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.compiler.Compiler;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

public class CCompilerGroup
extends CCppCompilerGroup {
    private CCompilerType compilerSvcType = null;

    public void add(Compiler c) throws IllegalArgumentException {
        super.add(c);
        this.compilerSvcType = ((CCompiler)c).getCompilerSvcType();
        this.isRemote = ((CCompiler)c).isRemote();
    }

    protected Process createProcess(NbProcessDescriptor desc, String[] files) throws IOException {
        ExternalCompiler[] ec = this.getAllCompilers();
        DataObject[] dobj = new DataObject[ec.length];
        String[] fnames = new String[ec.length];
        RemoteRuntimeType rrt = null;
        boolean useX = false;
        FileSystem fs = null;
        FileObject fo = null;
        for (int i = 0; i < ec.length; ++i) {
            fo = ((CCppCompiler)ec[i]).getFileObject0();
            dobj[i] = DataObject.find((FileObject)fo);
            fs = fo.getFileSystem();
            if (this.getIsRemote()) {
                AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
                rrt = nfs.getRemoteRuntimeType();
                Boolean bobj = (Boolean)fo.getAttribute("useXtermCompile");
                useX = bobj != null ? bobj.booleanValue() : nfs.getUseXtermCompile();
            }
            fnames[i] = ec[i].getFileName();
            continue;
        }
        CFormat cformat = new CFormat(dobj, fnames, this.getIsRemote());
        if (this.getIsRemote()) {
            IOException ioe;
            String clientIP = Utils.getIntendedHostAddress();
            int displayNumber = 0;
            if (useX) {
                AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
                Integer iobj = (Integer)fo.getAttribute("xDisplayDeviceNumber");
                displayNumber = iobj != null ? iobj.intValue() : nfs.getXDisplayDeviceNumber();
                clientIP = clientIP + ":" + displayNumber;
            }
            if (cformat.getUseDECterm() && Utilities.isWindows()) {
                String cmd = DistributedSettings.getDefault().getXServer();
                try {
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                if (fo != null && fo.getFileSystem() instanceof NetworkFileSystem) {
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e) {
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
            if (rrt == null) {
                ioe = new IOException("");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\nPlease go to Runtime Tab and create remote server", 2));
                DistributedModule.err.annotate((Throwable)ioe, 1, null, null, null, null);
                throw ioe;
            }
            if (rrt.getRemoteRuntime() == null) {
                ioe = new IOException("");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Remote server is diconnected.\nPlease go to Runtime Tab and make connection", 2));
                DistributedModule.err.annotate((Throwable)ioe, 1, null, null, null, null);
                throw ioe;
            }
            RemoteProcessDescriptor rpd = new RemoteProcessDescriptor("", "");
            return rpd.exec(cformat.getCmds(), rrt, null, null, useX, clientIP, rrt.getSecurityContext());
        }
        File tmpDCLFile = File.createTempFile("compilerparams", ".bat");
        tmpDCLFile.deleteOnExit();
        return DCLExecutor.execute((String)tmpDCLFile.getAbsolutePath(), (String[])cformat.getCmds(), (int)(cformat.getUseDECterm() ? 0 : 1));
    }

    public static class CFormat
    extends CCppCompilerGroup.CCppFormat {
        public static final String TAG_SRC_ANAL = "code analysis";

        public CFormat(DataObject[] files, String[] fnames, boolean isRemote) {
            super(isRemote);
            this.composeCmds(files, fnames);
        }
    }
}

