/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSRemoteUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.LocalFileSystem;

public class CMSUtils {
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.CMSUtils") | Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
    public static final String GENDB_FILE = "file_info.cms";
    public static final String FETCHDIR_NAME = "FETCH";
    public static final String TEMPDIR_NAME = "CMSINFO";
    public static final String TEMPDIR_NAME_REGEX = "^CMSINFO$|.nbintdb";
    private static final String VERSION_NUM = "Version .014";

    public static boolean copyPatchFile(String sourceFilename, String sourcePathname, String destinationPathname, boolean copyAlways) {
        boolean status;
        block21: {
            File outFile;
            File DCLDir;
            String fileExt = "";
            status = false;
            if (debug) {
                System.out.println("Entering copyFilefromJar...");
            }
            if (!(DCLDir = new File(destinationPathname)).exists()) {
                if (debug) {
                    System.out.println("The directory " + destinationPathname + " doesn't exist; creating it...");
                }
                DCLDir.mkdir();
            }
            if (!(outFile = new File(destinationPathname + File.separatorChar + sourceFilename)).exists() || copyAlways) {
                if (outFile.exists()) {
                    outFile.delete();
                    if (debug) {
                        System.out.println(outFile.toString() + " exists, overwriting...");
                    }
                } else if (debug) {
                    System.out.println(outFile.toString() + " does not exist, creating...");
                }
                int dotPos = sourceFilename.lastIndexOf(46);
                String fileBase = sourceFilename;
                if (dotPos != -1) {
                    fileBase = sourceFilename.substring(0, dotPos);
                    fileExt = sourceFilename.substring(dotPos + 1);
                }
                try {
                    LocalFileSystem sourceLF = new LocalFileSystem();
                    sourceLF.setRootDirectory(new File(sourcePathname));
                    FileObject sourceFileFO = sourceLF.find("", fileBase, fileExt);
                    if (sourceFileFO != null) {
                        if (debug) {
                            System.out.println(sourceFilename + " found in default filesystem: " + sourceFileFO.toString());
                        }
                        LocalFileSystem destinationLF = new LocalFileSystem();
                        File destinationF = new File(destinationPathname);
                        destinationLF.setRootDirectory(destinationF);
                        FileObject destinationFO = destinationLF.getRoot();
                        sourceFileFO.copy(destinationFO, fileBase, fileExt);
                        if (debug) {
                            System.out.println(outFile.toString() + " copied successfully");
                        }
                        status = true;
                        break block21;
                    }
                    if (debug) {
                        System.out.println("The source file (" + sourceFilename + ") was not found in the default filesystem!");
                    }
                    status = false;
                }
                catch (IOException e) {
                    if (debug) {
                        System.out.println("An error occurred while copying " + outFile.toString());
                        System.out.println("Error = " + e);
                    }
                    status = false;
                }
                catch (Exception e) {
                    if (debug) {
                        System.out.println("An error occurred while copying " + outFile.toString());
                        System.out.println("Error = " + e);
                    }
                    status = false;
                }
            } else {
                if (debug) {
                    System.out.println(outFile.toString() + " already exists");
                }
                status = true;
            }
        }
        if (debug) {
            System.out.println("...Leaving copyFilefromJar...");
        }
        return status;
    }

    public static synchronized Hashtable readFileGenerationDB(String filePath) {
        Hashtable fileGenerationTable;
        if (debug) {
            System.out.println("Entering readFileGenerationDB...");
        }
        try {
            if (debug) {
                System.out.println("Trying file: '" + filePath + File.separatorChar + GENDB_FILE + "'");
            }
            FileInputStream input_stream = new FileInputStream(filePath + File.separatorChar + GENDB_FILE);
            ObjectInputStream input_object = new ObjectInputStream(new BufferedInputStream(input_stream));
            if (debug) {
                System.out.println("Generation database successfully opened and read");
            }
            fileGenerationTable = (Hashtable)input_object.readObject();
            if (debug) {
                System.out.println("Total # of file generation entries: " + fileGenerationTable.size());
            }
            input_object.close();
            input_stream.close();
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("An error occurred - " + e);
            }
            return null;
        }
        if (debug) {
            System.out.println("...Leaving readFileGenerationDB");
        }
        return fileGenerationTable;
    }

    public static synchronized boolean writeFileGenerationDB(String filePath, Hashtable fileGenerationTable) {
        if (debug) {
            System.out.println("Entering writeFileGenerationDB...");
        }
        if (fileGenerationTable != null) {
            try {
                if (debug) {
                    System.out.println("Trying file: '" + filePath + File.separatorChar + GENDB_FILE + "'");
                }
                FileOutputStream output_stream = new FileOutputStream(filePath + File.separatorChar + GENDB_FILE);
                ObjectOutputStream output_object = new ObjectOutputStream(new BufferedOutputStream(output_stream));
                output_object.writeObject(fileGenerationTable);
                if (debug) {
                    System.out.println("Generation database successfully opened and written");
                }
                output_object.flush();
                output_object.close();
                output_stream.close();
            }
            catch (Exception e) {
                if (debug) {
                    System.out.println("An error occurred - " + e);
                }
                return false;
            }
        }
        if (debug) {
            System.out.println("...Leaving writeFileGenerationDB");
        }
        return true;
    }

    public static boolean CMSLibraryIsValid(String CMSLibraryPath, String CMSCommandProcessor2) {
        boolean valid = false;
        if (debug) {
            System.out.println("Entering CMSLibraryIsValid...");
            System.out.println("Library path: " + CMSLibraryPath + "; command processor: " + CMSCommandProcessor2);
        }
        return true;
    }

    public static boolean invokeCommand(VcsFileSystem fileSystem, String cmdName, Hashtable vars, CommandDataOutputListener listener) {
        block3: {
            VcsCommand cmd = fileSystem.getCommand(cmdName);
            if (cmd == null) {
                return false;
            }
            VcsCommandExecutor executor = CMSRemoteUtil.getCommandExecutor(cmd, vars, fileSystem);
            fileSystem.getCommandsPool().preprocessCommand(executor, vars, fileSystem);
            executor.addDataOutputListener(listener);
            CMSRemoteUtil.startExecutor(executor);
            try {
                CMSRemoteUtil.waitToFinish(executor);
            }
            catch (InterruptedException e) {
                if (!debug) break block3;
                System.out.println(e.getMessage());
            }
        }
        return true;
    }

    public static void invokeListCommand(VcsFileSystem fileSystem, String dir, DirReaderListener listener) {
        VcsAction.doList((VcsFileSystem)fileSystem, (String)dir);
    }
}

