/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteExecuteCommand;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteUserCommandSupport;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteVcsRuntimeCommand;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReader;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReaderRecursive;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.commands.CommandCustomizationSupport;
import org.netbeans.modules.vcscore.commands.CommandExecutionContext;
import org.netbeans.modules.vcscore.commands.CommandExecutorSupport;
import org.netbeans.modules.vcscore.commands.CommandOutputCollector;
import org.netbeans.modules.vcscore.commands.CommandOutputVisualizer;
import org.netbeans.modules.vcscore.commands.CommandProcessor;
import org.netbeans.modules.vcscore.commands.CommandTaskInfo;
import org.netbeans.modules.vcscore.commands.InteractiveCommandOutputVisualizer;
import org.netbeans.modules.vcscore.commands.ProvidedCommand;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.TextOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.commands.VcsDescribedTask;
import org.netbeans.modules.vcscore.runtime.RuntimeCommand;
import org.netbeans.modules.vcscore.runtime.RuntimeCommandTask;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.spi.vcs.VcsCommandsProvider;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.netbeans.spi.vcs.commands.CommandTaskSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class RemoteUserCommandTask
extends CommandTaskSupport
implements VcsDescribedTask,
RuntimeCommandTask,
ProvidedCommand {
    private RemoteUserCommandSupport cmdSupport;
    private VcsDescribedCommand cmd;
    private VcsCommandExecutor executor;
    private CommandOutputCollector outputCollector;
    private RemoteVcsRuntimeCommand runtimeCommand;
    private VcsCommandVisualizer visualizerGUI;
    private VcsCommandVisualizer visualizerText;
    private File spawnRefreshFile;
    private boolean spawnRefreshRecursively;
    private RemoteRuntimeType rrt;
    private static Set runningTasks = new HashSet();
    private static List pendingTasks = new LinkedList();
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$UserCommandTask;

    public RemoteUserCommandTask(RemoteUserCommandSupport cmdSupport, VcsDescribedCommand cmd, RemoteRuntimeType rrt) {
        super((CommandSupport)cmdSupport, (Command)cmd);
        this.cmdSupport = cmdSupport;
        this.cmd = cmd;
        this.executor = cmd.getExecutor();
        if (this.executor == null) {
            this.executor = this.createExecutor();
        }
        if (this.executor instanceof RemoteExecuteCommand) {
            ((RemoteExecuteCommand)this.executor).setTask((CommandTask)this);
        }
        this.outputCollector = new CommandOutputCollector((CommandTask)this, cmdSupport.getExecutionContext().getCommandsProvider());
    }

    private VcsCommandExecutor createExecutor() {
        CommandExecutionContext executionContext = this.cmdSupport.getExecutionContext();
        VcsFileSystem fileSystem = executionContext instanceof VcsFileSystem ? (VcsFileSystem)executionContext : null;
        Hashtable vars = executionContext.getVariablesAsHashtable();
        Map additionalVariables = this.cmd.getAdditionalVariables();
        if (additionalVariables != null) {
            vars.putAll(additionalVariables);
        }
        UserCommand uCmd = (UserCommand)this.cmd.getVcsCommand();
        Object vce = fileSystem != null && ("LIST".equals(this.cmd.getName()) || "LIST_OFFLINE".equals(this.cmd.getName())) ? this.createRefresh(fileSystem, vars, uCmd) : (fileSystem != null && ("LIST_SUB".equals(this.cmd.getName()) || "LIST_SUB_OFFLINE".equals(this.cmd.getName())) ? this.createRecursiveRefresh(fileSystem, vars, uCmd) : new RemoteExecuteCommand(executionContext, uCmd, vars, this.cmd.getPreferredExec(), this.rrt));
        return vce;
    }

    private String getRefreshPath(VcsFileSystem fileSystem, Hashtable vars) {
        String path = null;
        FileObject[] fos = this.cmd.getFiles();
        if (fos != null && fos.length > 0) {
            path = fos[0].getPackageName('/');
        } else {
            String root;
            File[] diskFiles = this.cmd.getDiskFiles();
            if (diskFiles != null && diskFiles.length > 0 && (path = diskFiles[0].getAbsolutePath()).indexOf(root = fileSystem.getFile("").getAbsolutePath()) == 0) {
                path = path.substring(root.length());
                while (path.startsWith(File.separator)) {
                    path = path.substring(1);
                }
            }
        }
        return path;
    }

    private File getRefreshDir(VcsFileSystem fileSystem, Hashtable vars) {
        File dir = null;
        FileObject[] fos = this.cmd.getFiles();
        boolean isDir = true;
        if (fos != null && fos.length > 0) {
            dir = FileUtil.toFile((FileObject)fos[0]);
            isDir = fos[0].isFolder();
        } else {
            File[] diskFiles = this.cmd.getDiskFiles();
            if (diskFiles != null && diskFiles.length > 0) {
                dir = diskFiles[0];
                isDir = dir.isDirectory();
            }
        }
        if (dir != null && !isDir) {
            dir = dir.getParentFile();
        }
        return dir;
    }

    private VcsCommandExecutor createRefresh(VcsFileSystem fileSystem, Hashtable vars, UserCommand uCmd) {
        DirReaderListener dirListener = this.cmdSupport.getAttachedDirReaderListener((Command)this.cmd);
        if (dirListener != null) {
            String file = (String)vars.get("FILE");
            String dir = (String)vars.get("DIR");
            dir = dir.length() > 0 ? dir + Variables.expand((Hashtable)vars, (String)"${PS}", (boolean)false) + file : file;
            vars.put("FILE", "");
            vars.put("DIR", dir);
            this.cmd.setAdditionalVariables((Map)vars);
            return new CommandLineVcsDirReader(dirListener, fileSystem, uCmd, vars);
        }
        this.spawnRefreshFile = new File(this.getRefreshDir(fileSystem, vars), "test");
        this.spawnRefreshRecursively = false;
        return null;
    }

    private VcsCommandExecutor createRecursiveRefresh(VcsFileSystem fileSystem, Hashtable vars, UserCommand uCmd) {
        DirReaderListener dirListener = this.cmdSupport.getAttachedDirReaderListener((Command)this.cmd);
        if (dirListener != null) {
            String file = (String)vars.get("FILE");
            String dir = (String)vars.get("DIR");
            dir = dir.length() > 0 ? dir + Variables.expand((Hashtable)vars, (String)"${PS}", (boolean)false) + file : file;
            vars.put("FILE", "");
            vars.put("DIR", dir);
            this.cmd.setAdditionalVariables((Map)vars);
            return new CommandLineVcsDirReaderRecursive(dirListener, fileSystem, uCmd, vars);
        }
        this.spawnRefreshFile = new File(this.getRefreshDir(fileSystem, vars), "test");
        this.spawnRefreshRecursively = true;
        return null;
    }

    boolean willSpawnRefresh() {
        return this.spawnRefreshFile != null;
    }

    void spawnRefresh(VcsFileSystem fileSystem) {
        FileSystemCache cache = CacheHandler.getInstance().getCache(fileSystem.getCacheIdStr());
        Object locker = new Object();
        cache.getCacheFile(this.spawnRefreshFile, this.spawnRefreshRecursively ? 12 : 11, locker);
        locker = null;
    }

    public String getDisplayName() {
        if (this.willSpawnRefresh()) {
            return null;
        }
        return super.getDisplayName();
    }

    public VcsCommandExecutor getExecutor() {
        return this.executor;
    }

    public int getPriority() {
        return VcsCommandIO.getIntegerPropertyAssumeZero((VcsCommand)this.cmd.getVcsCommand(), (String)"executionPriority");
    }

    public Map getVariables() {
        if (this.executor == null) {
            return Collections.EMPTY_MAP;
        }
        return this.executor.getVariables();
    }

    public VcsCommand getVcsCommand() {
        if (this.executor == null) {
            return this.cmd.getVcsCommand();
        }
        return this.executor.getCommand();
    }

    public synchronized RuntimeCommand getRuntimeCommand(CommandTaskInfo info) {
        if (this.willSpawnRefresh()) {
            return null;
        }
        if (this.runtimeCommand == null) {
            this.runtimeCommand = new RemoteVcsRuntimeCommand(info);
        }
        return this.runtimeCommand;
    }

    private void initVisualizer(final VcsCommandVisualizer outputVisualizer) {
        outputVisualizer.setVcsTask((VcsDescribedTask)this);
        outputVisualizer.setPossibleFileStatusInfoMap(this.cmdSupport.getExecutionContext().getPossibleFileStatusInfoMap());
        outputVisualizer.setOutputCollector(this.outputCollector);
        this.outputCollector.addTextOutputListener(new TextOutputListener(){

            public void outputLine(String line) {
                outputVisualizer.stdOutputLine(line);
            }
        });
        this.outputCollector.addTextErrorListener(new TextOutputListener(){

            public void outputLine(String line) {
                outputVisualizer.errOutputLine(line);
            }
        });
        this.outputCollector.addRegexOutputListener(new RegexOutputListener(){

            public void outputMatchedGroups(String[] data) {
                outputVisualizer.stdOutputData(data);
            }
        });
        this.outputCollector.addRegexErrorListener(new RegexOutputListener(){

            public void outputMatchedGroups(String[] data) {
                outputVisualizer.errOutputData(data);
            }
        });
    }

    public VcsCommandVisualizer getVisualizer(boolean gui) {
        VcsCommandVisualizer visualizer = null;
        if (gui) {
            visualizer = this.getVisualizerGUI(false, false);
        } else {
            visualizer = this.getVisualizerText(false);
            if (this.isFinished() && visualizer != null) {
                visualizer.setExitStatus(this.executor.getExitStatus());
            }
        }
        return visualizer;
    }

    synchronized VcsCommandVisualizer getVisualizerGUI(boolean showPlainOutput, boolean interactive) {
        VcsCommandVisualizer visualizer = this.getVisualizerGUI();
        if (visualizer == null && (showPlainOutput || interactive)) {
            visualizer = this.getVisualizerText(interactive);
        }
        if (this.isFinished() && visualizer != null) {
            visualizer.setExitStatus(this.executor.getExitStatus());
        }
        return visualizer;
    }

    private synchronized VcsCommandVisualizer getVisualizerGUI() {
        if (this.visualizerGUI == null) {
            this.visualizerGUI = this.executor.getVisualizer();
            if (this.visualizerGUI != null) {
                this.initVisualizer(this.visualizerGUI);
            }
        }
        return this.visualizerGUI;
    }

    private synchronized VcsCommandVisualizer getVisualizerText(boolean interactive) {
        if (this.visualizerText == null) {
            this.visualizerText = interactive ? new InteractiveCommandOutputVisualizer() : new CommandOutputVisualizer();
            this.initVisualizer(this.visualizerText);
        }
        return this.visualizerText;
    }

    public boolean hasGUIVisualizer() {
        return this.visualizerGUI != null || this.executor.getVisualizer() != null;
    }

    protected boolean canExecute() {
        if (this.willSpawnRefresh()) {
            return true;
        }
        return this.canRun(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute() {
        Set set;
        int status = 0;
        try {
            status = super.execute();
            Object var3_2 = null;
            set = runningTasks;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Set set2 = runningTasks;
            synchronized (set2) {
                runningTasks.remove((Object)this);
            }
            throw throwable;
        }
        synchronized (set) {
            runningTasks.remove((Object)this);
        }
        if (this.executor != null) {
            this.doPostprocessing();
        }
        return status;
    }

    private void doPostprocessing() {
        VcsCommand cmd = this.executor.getCommand();
        CommandExecutionContext executionContext = this.cmdSupport.getExecutionContext();
        String message = null;
        String name = cmd.getDisplayName();
        if (name == null && CommandProcessor.getInstance().getParentTask((CommandTask)this) == null) {
            name = cmd.getName();
        }
        if (name != null) {
            int i = name.indexOf(38);
            if (i >= 0) {
                name = name.substring(0, i) + name.substring(i + 1);
            }
            switch (this.executor.getExitStatus()) {
                case 0: {
                    message = RemoteUserCommandTask.g("MSG_Command_name_finished", name);
                    break;
                }
                case 1: {
                    if (VcsCommandIO.getBooleanPropertyAssumeDefault((VcsCommand)this.executor.getCommand(), (String)"ignoreFail")) {
                        message = RemoteUserCommandTask.g("MSG_Command_name_finished", name);
                        break;
                    }
                    message = RemoteUserCommandTask.g("MSG_Command_name_failed", name);
                    break;
                }
                case 2: {
                    message = RemoteUserCommandTask.g("MSG_Command_name_interrupted", name);
                }
            }
        }
        String notification = null;
        if (this.executor.getExitStatus() != 0 && !VcsCommandIO.getBooleanPropertyAssumeDefault((VcsCommand)cmd, (String)"ignoreFail")) {
            if (message != null) {
                this.printErrorOutput(executionContext);
            }
            if (executionContext.isCommandNotification()) {
                notification = (String)cmd.getProperty("notificationFailMsg");
            }
        } else {
            if (message != null && executionContext != null) {
                executionContext.debug(message);
            }
            if (executionContext.isCommandNotification()) {
                notification = (String)cmd.getProperty("notificationSuccessMsg");
            }
        }
        if (notification != null) {
            CommandCustomizationSupport.commandNotification((VcsCommandExecutor)this.executor, (String)notification, (CommandExecutionContext)executionContext);
        }
        CommandExecutorSupport.postprocessCommand((CommandExecutionContext)executionContext, (VcsCommandExecutor)this.executor);
    }

    private void printErrorOutput(CommandExecutionContext executionContext) {
        if (executionContext == null) {
            return;
        }
        String exec = this.getExecutor().getExec();
        Vector<String> vct = new Vector<String>();
        if (this.getFiles() != null) {
            String[] cmdNames = VcsManager.getDefault().findCommands(this.getFiles());
            for (int i = 0; i < cmdNames.length; ++i) {
                if (exec.indexOf(cmdNames[i]) == -1 || !this.hasVisualizer(cmdNames[i])) continue;
                vct.addElement(cmdNames[i]);
            }
        }
        if (vct.size() == 0 && this.visualizerGUI == null && this.visualizerText == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RemoteUserCommandTask.this.getVisualizer(false).open(null);
                    RemoteUserCommandTask.this.visualizerText.errOutputLine("\n" + RemoteUserCommandTask.g("EXEC_STRING") + "\n" + RemoteUserCommandTask.this.executor.getExec());
                    RemoteUserCommandTask.this.visualizerText.setExitStatus(RemoteUserCommandTask.this.executor.getExitStatus());
                }
            });
        }
    }

    private boolean hasVisualizer(String cmdName) {
        VcsDescribedCommand descCmd;
        boolean hasVisualizer = false;
        try {
            descCmd = (VcsDescribedCommand)VcsManager.getDefault().createCommand(cmdName, this.getFiles());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        VcsCommand cmd = descCmd.getVcsCommand();
        Object textVisualizer = cmd.getProperty("display");
        Object guiVisualizer = cmd.getProperty("visualizer");
        if (textVisualizer != null || guiVisualizer != null) {
            hasVisualizer = true;
        }
        return hasVisualizer;
    }

    public VcsCommandsProvider getProvider() {
        return this.cmdSupport.getExecutionContext().getCommandsProvider();
    }

    public void setProvider(VcsCommandsProvider provider) {
        throw new IllegalStateException("setProvider() method should not be called.");
    }

    private static boolean areFilesInSamePackage(Collection files1, Collection files2) {
        Iterator it1 = files1.iterator();
        while (it1.hasNext()) {
            String file1 = (String)it1.next();
            String dir1 = VcsUtilities.getDirNamePart((String)file1);
            Iterator it2 = files2.iterator();
            while (it2.hasNext()) {
                String file2 = (String)it2.next();
                String dir2 = VcsUtilities.getDirNamePart((String)file2);
                if (!dir1.equals(dir2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isParentFolder(Collection files1, Collection files2) {
        Iterator it1 = files1.iterator();
        while (it1.hasNext()) {
            String file1 = (String)it1.next();
            Iterator it2 = files2.iterator();
            while (it2.hasNext()) {
                String file2 = (String)it2.next();
                if (!file1.startsWith(file2)) continue;
                return true;
            }
        }
        return false;
    }

    private HashMap createConcurrencyMap(String concurrencyWith) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (concurrencyWith != null) {
            String[] items = VcsUtilities.getQuotedStrings((String)concurrencyWith);
            for (int i = 0; i < items.length; ++i) {
                int conc;
                int index = items[i].lastIndexOf(32);
                if (index < 0) continue;
                String cmdName = items[i].substring(0, index);
                String concStr = items[i].substring(index + 1);
                try {
                    conc = Integer.parseInt(concStr);
                }
                catch (NumberFormatException nfexc) {
                    continue;
                }
                map.put(cmdName, new Integer(conc));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canRun(RemoteUserCommandTask task) {
        if (!pendingTasks.contains((Object)task)) {
            pendingTasks.add(task);
        }
        VcsCommandExecutor vce = task.getExecutor();
        VcsCommand cmd = vce.getCommand();
        Collection files = vce.getFiles();
        int concurrency = VcsCommandIO.getIntegerPropertyAssumeZero((VcsCommand)cmd, (String)"concurrentExec");
        String concurrencyWith = (String)cmd.getProperty("concurrentExecWith");
        boolean haveToWait = false;
        if (concurrency != -1) {
            HashSet<RemoteUserCommandTask> tasksToTest;
            HashMap concurrencyMap = this.createConcurrencyMap(concurrencyWith);
            String name = cmd.getName();
            boolean serialOnFile = (concurrency & 1) != 0;
            boolean serialOnPackage = (concurrency & 2) != 0;
            boolean serialWithParent = (concurrency & 4) != 0;
            boolean serialOfCommand = (concurrency & 8) != 0;
            boolean serialOfAll = (concurrency & 0x10) != 0;
            Set set = runningTasks;
            synchronized (set) {
                tasksToTest = new HashSet<RemoteUserCommandTask>(runningTasks);
            }
            if ((concurrency & 0x20) != 0) {
                RemoteUserCommandTask pendingTask;
                Iterator pendingIt = pendingTasks.iterator();
                while (pendingIt.hasNext() && (pendingTask = (RemoteUserCommandTask)((Object)pendingIt.next())) != task) {
                    tasksToTest.add(pendingTask);
                }
            }
            Iterator iter = tasksToTest.iterator();
            while (iter.hasNext()) {
                RemoteUserCommandTask cwTest = (RemoteUserCommandTask)((Object)iter.next());
                VcsCommandExecutor ec = cwTest.getExecutor();
                Collection cmdFiles = ec.getFiles();
                VcsCommand uc = ec.getCommand();
                int cmdConcurrency = VcsCommandIO.getIntegerPropertyAssumeZero((VcsCommand)uc, (String)"concurrentExec");
                if (-1 == cmdConcurrency) continue;
                if (serialOfAll) {
                    haveToWait = true;
                    break;
                }
                String cmdName = uc.getName();
                haveToWait = RemoteUserCommandTask.matchSerial(name, cmdName, files, cmdFiles, serialOnFile, serialOnPackage, serialWithParent, serialOfCommand);
                if (!haveToWait) {
                    if ((cmdConcurrency & 0x10) != 0) {
                        haveToWait = true;
                        break;
                    }
                    haveToWait = RemoteUserCommandTask.matchSerial(cmdName, name, cmdFiles, files, (cmdConcurrency & 1) != 0, (cmdConcurrency & 2) != 0, (cmdConcurrency & 4) != 0, (cmdConcurrency & 8) != 0);
                }
                if (haveToWait) break;
                Integer concurrencyWithNum = (Integer)concurrencyMap.get(cmdName);
                if (concurrencyWithNum == null || !RemoteUserCommandTask.haveToWaitFor(files, cmdFiles, concurrencyWithNum)) continue;
                haveToWait = true;
                break;
            }
        }
        if (!haveToWait) {
            Set set = runningTasks;
            synchronized (set) {
                runningTasks.add(task);
            }
            pendingTasks.remove((Object)task);
        }
        return !haveToWait;
    }

    private static boolean matchSerial(String name, String name2, Collection files, Collection files2, boolean serialOnFile, boolean serialOnPackage, boolean serialWithParent, boolean serialOfCommand) {
        boolean matchOnFile = false;
        boolean matchOnPackage = false;
        boolean matchWithParent = false;
        boolean matchOfCommand = false;
        if (serialOnFile) {
            Iterator it = files.iterator();
            while (it.hasNext()) {
                String file = (String)it.next();
                if (!files2.contains(file)) continue;
                matchOnFile = true;
                break;
            }
        }
        if (serialOnPackage && RemoteUserCommandTask.areFilesInSamePackage(files, files2)) {
            matchOnPackage = true;
        }
        if (serialWithParent && RemoteUserCommandTask.isParentFolder(files, files2)) {
            matchWithParent = true;
        }
        if (serialOfCommand) {
            matchOfCommand = name.equals(name2);
        }
        return !(serialOfCommand && !matchOfCommand || !matchOnFile && !matchOnPackage && !matchWithParent && !matchOfCommand);
    }

    private static boolean haveToWaitFor(Collection files, Collection cmdFiles, int concurrency) {
        boolean serialWithParent;
        boolean serialOnFile = (concurrency & 1) != 0;
        boolean serialOnPackage = (concurrency & 2) != 0;
        boolean bl = serialWithParent = (concurrency & 4) != 0;
        if (serialOnFile) {
            Iterator it = files.iterator();
            while (it.hasNext()) {
                String file = (String)it.next();
                if (!cmdFiles.contains(file)) continue;
                return true;
            }
        }
        if (serialOnPackage && RemoteUserCommandTask.areFilesInSamePackage(files, cmdFiles)) {
            return true;
        }
        return serialWithParent && RemoteUserCommandTask.isParentFolder(files, cmdFiles);
    }

    private static String g(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$UserCommandTask == null ? (class$org$netbeans$modules$vcscore$cmdline$UserCommandTask = RemoteUserCommandTask.class$("org.netbeans.modules.vcscore.cmdline.UserCommandTask")) : class$org$netbeans$modules$vcscore$cmdline$UserCommandTask), (String)s);
    }

    private static String g(String s, Object obj) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$UserCommandTask == null ? (class$org$netbeans$modules$vcscore$cmdline$UserCommandTask = RemoteUserCommandTask.class$("org.netbeans.modules.vcscore.cmdline.UserCommandTask")) : class$org$netbeans$modules$vcscore$cmdline$UserCommandTask), (String)s, (Object)obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

