/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteDebug;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteExternalCommand;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.CommandLineVcsDirReader;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.netbeans.modules.vcscore.cmdline.exec.BadRegexException;
import org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand;
import org.netbeans.modules.vcscore.cmdline.exec.StructuredExec;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandExecutionContext;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.TextOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandVisualizer;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RemoteExecuteCommand
implements VcsCommandExecutor {
    private RemoteDebug E = new RemoteDebug("RemoteExecuteCommand", true);
    private RemoteDebug D;
    public static final String DEFAULT_REGEX = "^(.*$)";
    public static final String STATUS_USE_REG_EXP_PARSE_OUTPUT = "REG_EXP_PARSE_OUTPUT";
    private CommandExecutionContext executionContext;
    private VcsFileSystem fileSystem;
    private UserCommand cmd;
    private Hashtable vars;
    private String preferredExec;
    private String preferredExecExpanded;
    private StructuredExec preferredStructuredExec;
    private VcsDescribedCommand command;
    private CommandTask task;
    private RemoteExternalCommand externalCommand;
    private ArrayList textOutputListeners;
    private ArrayList textErrorListeners;
    private ArrayList regexOutputListeners;
    private ArrayList regexErrorListeners;
    private ArrayList dataOutputListeners;
    private ArrayList dataErrorListeners;
    private ArrayList fileReaderListeners;
    private ArrayList immediateOutputListeners;
    private ArrayList immediateErrorListeners;
    private boolean doFileRefresh;
    private boolean doPostExecutionRefresh;
    private boolean getFileRefreshFromErrOut;
    private ArrayList filesToRefresh;
    private ArrayList refreshInfoElements;
    private String refreshFilesBase;
    private String refreshFilesMustStartWith;
    private boolean substituteStatuses;
    private Pattern[] substituitionRegExps;
    private String[] substituitionStatuses;
    private Collection processingFilesCollection;
    protected int exitStatus;
    private RemoteRuntimeType rrt;
    private String lastCollectedFolder;
    private Set lastCollectedElements;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsFileSystem;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$CommandExecutionContext;

    public RemoteExecuteCommand(CommandExecutionContext executionContext, UserCommand cmd, Hashtable vars, RemoteRuntimeType rrt) {
        this(executionContext, cmd, vars, null, rrt);
    }

    public RemoteExecuteCommand(CommandExecutionContext executionContext, UserCommand cmd, Hashtable vars, String preferredExec, RemoteRuntimeType rrt) {
        boolean debug;
        RemoteDebug.debGeneralEnabled = debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
        this.D = this.E;
        this.executionContext = null;
        this.fileSystem = null;
        this.cmd = null;
        this.vars = null;
        this.preferredExec = null;
        this.preferredExecExpanded = null;
        this.preferredStructuredExec = null;
        this.command = null;
        this.task = null;
        this.externalCommand = null;
        this.textOutputListeners = new ArrayList();
        this.textErrorListeners = new ArrayList();
        this.regexOutputListeners = new ArrayList();
        this.regexErrorListeners = new ArrayList();
        this.dataOutputListeners = new ArrayList();
        this.dataErrorListeners = new ArrayList();
        this.fileReaderListeners = new ArrayList();
        this.immediateOutputListeners = new ArrayList();
        this.immediateErrorListeners = new ArrayList();
        this.getFileRefreshFromErrOut = false;
        this.refreshFilesBase = null;
        this.refreshFilesMustStartWith = null;
        this.substituteStatuses = false;
        this.processingFilesCollection = null;
        this.exitStatus = 0;
        this.rrt = null;
        this.lastCollectedFolder = null;
        this.lastCollectedElements = null;
        this.executionContext = executionContext;
        this.fileSystem = executionContext instanceof VcsFileSystem ? (VcsFileSystem)executionContext : null;
        this.cmd = cmd;
        this.vars = vars;
        this.rrt = rrt;
        if (preferredExec == null) {
            preferredExec = (String)cmd.getProperty("exec");
        }
        this.preferredExec = preferredExec;
        this.doFileRefresh = this.fileSystem != null && VcsCommandIO.getIntegerPropertyAssumeNegative((VcsCommand)cmd, (String)"data.fileName.index") >= 0;
        boolean bl = this.doPostExecutionRefresh = this.fileSystem != null && VcsCommandIO.getBooleanProperty((VcsCommand)cmd, (String)"refreshProcessedFiles");
        if (this.doFileRefresh) {
            this.refreshInfoElements = new ArrayList();
            String statusSubstitutions = (String)cmd.getProperty("refreshFileStatusSubstitutions");
            boolean bl2 = this.substituteStatuses = statusSubstitutions != null && statusSubstitutions.length() > 0;
            if (this.substituteStatuses) {
                this.parseStatusSubstitutions(statusSubstitutions);
            }
            this.getFileRefreshFromErrOut = VcsCommandIO.getBooleanProperty((VcsCommand)cmd, (String)"refreshInfoFromBothDataOuts");
        }
    }

    private void parseStatusSubstitutions(String statusSubstitutions) {
        String[] substitutions = VcsUtilities.getQuotedStrings((String)statusSubstitutions);
        int n = substitutions.length / 2;
        Pattern[] regExps = new Pattern[n];
        String[] statuses = new String[n];
        int nn = n;
        for (int i = 0; i < n; ++i) {
            try {
                regExps[i] = Pattern.compile(substitutions[2 * i]);
            }
            catch (PatternSyntaxException e) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand") : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)"MSG_BadRegExpInStatusSubstitution", (Object)substitutions[2 * i])));
                --nn;
                continue;
            }
            statuses[i] = substitutions[2 * i + 1];
        }
        if (n == nn) {
            this.substituitionRegExps = regExps;
            this.substituitionStatuses = statuses;
        } else {
            n = nn;
            this.substituitionRegExps = new Pattern[n];
            this.substituitionStatuses = new String[n];
            int j = 0;
            for (int i = 0; i < n; ++i) {
                if (regExps[j] == null) {
                    --i;
                } else {
                    this.substituitionRegExps[i] = regExps[j];
                    this.substituitionStatuses[i] = statuses[j];
                }
                ++j;
            }
        }
    }

    public VcsDescribedCommand getDescribedCommand() {
        return this.command;
    }

    public void setDescribedCommand(VcsDescribedCommand command) {
        this.command = command;
    }

    public CommandTask getTask() {
        return this.task;
    }

    public void setTask(CommandTask task) {
        this.task = task;
    }

    public final synchronized void addTextOutputListener(TextOutputListener l) {
        if (this.textOutputListeners != null) {
            this.textOutputListeners.add(l);
        }
    }

    public final synchronized void addTextErrorListener(TextOutputListener l) {
        if (this.textErrorListeners != null) {
            this.textErrorListeners.add(l);
        }
    }

    public final synchronized void addRegexOutputListener(RegexOutputListener l) {
        if (this.regexOutputListeners != null) {
            this.regexOutputListeners.add(l);
        }
    }

    public final synchronized void addRegexErrorListener(RegexOutputListener l) {
        if (this.regexErrorListeners != null) {
            this.regexErrorListeners.add(l);
        }
    }

    public void addOutputListener(CommandOutputListener l) {
        if (this.textOutputListeners != null) {
            this.textOutputListeners.add(l);
        }
    }

    public void addErrorOutputListener(CommandOutputListener l) {
        if (this.textErrorListeners != null) {
            this.textErrorListeners.add(l);
        }
    }

    public void addDataOutputListener(CommandDataOutputListener l) {
        if (this.dataOutputListeners != null) {
            this.dataOutputListeners.add(l);
        }
    }

    public void addDataErrorOutputListener(CommandDataOutputListener l) {
        if (this.dataErrorListeners != null) {
            this.dataErrorListeners.add(l);
        }
    }

    public void addImmediateTextOutputListener(TextOutputListener l) {
        if (this.immediateOutputListeners != null) {
            this.immediateOutputListeners.add(l);
        }
    }

    public void addImmediateTextErrorListener(TextOutputListener l) {
        if (this.immediateErrorListeners != null) {
            this.immediateErrorListeners.add(l);
        }
    }

    public void sendInput(String input) {
        if (this.externalCommand != null) {
            this.externalCommand.sendInput(input);
        }
    }

    public final VcsCommand getCommand() {
        return this.cmd;
    }

    public final Hashtable getVariables() {
        return this.vars;
    }

    public final int getExitStatus() {
        return this.exitStatus;
    }

    private VcsCommandVisualizer createVisualizer() {
        String visualizerClassName = (String)this.cmd.getProperty("visualizer");
        if (visualizerClassName != null) {
            Class<?> visualizerClass = null;
            try {
                visualizerClass = Class.forName(visualizerClassName, true, VcsUtilities.getSFSClassLoader());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (visualizerClass == null) {
                try {
                    visualizerClass = Class.forName(visualizerClassName, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = RemoteExecuteCommand.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (visualizerClass == null) {
                try {
                    this.printErrorOutput("CLASS EXEC: " + RemoteExecuteCommand.g("ERR_ClassNotFound", visualizerClassName));
                }
                catch (MissingResourceException mrexc) {
                    this.printErrorOutput("CLASS EXEC: Class " + visualizerClassName + " not found");
                }
            } else {
                VcsCommandVisualizer visualizer = null;
                try {
                    visualizer = (VcsCommandVisualizer)visualizerClass.newInstance();
                }
                catch (InstantiationException e) {
                    this.printErrorOutput("CLASS EXEC: " + RemoteExecuteCommand.g("ERR_CanNotInstantiate", visualizerClass));
                }
                catch (IllegalAccessException e) {
                    this.printErrorOutput("CLASS EXEC: " + RemoteExecuteCommand.g("ERR_IllegalAccessOnClass", visualizerClass));
                }
                return visualizer;
            }
        }
        return null;
    }

    public VcsCommandVisualizer getVisualizer() {
        return this.createVisualizer();
    }

    private void commandFinished(String exec, boolean success) {
        this.textOutputListeners.clear();
        this.textErrorListeners.clear();
        this.regexOutputListeners.clear();
        this.regexErrorListeners.clear();
        this.dataOutputListeners.clear();
        this.dataErrorListeners.clear();
        this.immediateOutputListeners.clear();
        this.immediateErrorListeners.clear();
        if (this.doFileRefresh) {
            this.flushRefreshInfo();
            this.cleanupSendRefreshInfo();
        }
        this.textOutputListeners = null;
        this.textErrorListeners = null;
        this.regexOutputListeners = null;
        this.regexErrorListeners = null;
        this.dataOutputListeners = null;
        this.dataErrorListeners = null;
        this.immediateOutputListeners = null;
        this.immediateErrorListeners = null;
        if (success || VcsCommandIO.getIntegerPropertyAssumeNegative((VcsCommand)this.cmd, (String)"refreshOnFail") == 1) {
            this.refreshRemainingFiles();
            boolean whatChanged = false;
            Object changedInfo = null;
        }
        this.fileReaderListeners.clear();
        this.fileReaderListeners = null;
    }

    public String preprocessCommand(VcsCommand vc, Hashtable vars, String exec, StructuredExec sexec) {
        this.preferredExec = exec;
        this.preferredStructuredExec = sexec;
        this.executionContext.getVarValueAdjustment().adjustVarValues(vars);
        boolean createTempFile = false;
        if (sexec != null) {
            StructuredExec.Argument[] args = sexec.getArguments();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].getArgument().indexOf("TEMPORARY_FILE") < 0) continue;
                createTempFile = true;
                break;
            }
        } else {
            boolean bl = createTempFile = exec != null && exec.indexOf("TEMPORARY_FILE") >= 0;
        }
        if (createTempFile) {
            try {
                File tempFile = File.createTempFile("VCS", "tmp");
                tempFile.deleteOnExit();
                vars.put("TEMPORARY_FILE", tempFile.getAbsolutePath());
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        this.vars = vars;
        if (exec != null) {
            this.preferredExecExpanded = Variables.expand((Hashtable)vars, (String)exec, (boolean)false);
        }
        return exec;
    }

    public String getExec() {
        return this.preferredExecExpanded;
    }

    protected final VcsFileSystem getFileSystem() {
        return this.fileSystem;
    }

    private StringBuffer[] addRegexListeners(RemoteExternalCommand ec, Pattern[] globalRegexs) {
        StringBuffer errorOutput;
        StringBuffer dataOutput;
        String errorRegex;
        String dataRegex = (String)this.cmd.getProperty("data.regex");
        if (dataRegex == null) {
            dataRegex = DEFAULT_REGEX;
        }
        if ((errorRegex = (String)this.cmd.getProperty("error.regex")) == null) {
            errorRegex = DEFAULT_REGEX;
        }
        String dataRegexGlobal = (String)this.cmd.getProperty("data.regex.global");
        String errorRegexGlobal = (String)this.cmd.getProperty("error.regex.global");
        Pattern dataRegexGlobalRE = null;
        Pattern errorRegexGlobalRE = null;
        if (dataRegexGlobal != null) {
            try {
                dataRegexGlobalRE = Pattern.compile(dataRegexGlobal);
            }
            catch (PatternSyntaxException exc) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)exc, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"MSG_BadRegexMessageInfo", (Object)dataRegexGlobal)));
            }
            if (dataRegexGlobalRE != null) {
                globalRegexs[0] = dataRegexGlobalRE;
                dataOutput = new StringBuffer();
            } else {
                dataOutput = null;
            }
        } else {
            dataOutput = null;
        }
        if (errorRegexGlobal != null) {
            try {
                errorRegexGlobalRE = Pattern.compile(errorRegexGlobal);
            }
            catch (PatternSyntaxException exc) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)exc, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"MSG_BadRegexMessageInfo", (Object)errorRegexGlobal)));
            }
            if (errorRegexGlobalRE != null) {
                globalRegexs[1] = errorRegexGlobalRE;
                errorOutput = new StringBuffer();
            } else {
                errorOutput = null;
            }
        } else {
            errorOutput = null;
        }
        try {
            if (dataRegexGlobalRE == null) {
                ec.addRegexOutputListener(new RegexOutputListener(){

                    public void outputMatchedGroups(String[] data) {
                        RemoteExecuteCommand.this.printDataOutput(data);
                    }
                }, dataRegex);
            } else {
                ec.addRegexOutputListener(new RegexOutputListener(){

                    public void outputMatchedGroups(String[] data) {
                        if (data != null) {
                            for (int i = 0; i < data.length; ++i) {
                                dataOutput.append(data[i]);
                            }
                            dataOutput.append(" ");
                        }
                    }
                }, dataRegex);
            }
        }
        catch (BadRegexException e) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"MSG_BadRegexMessageInfo", (Object)dataRegex)));
        }
        try {
            if (errorRegexGlobalRE == null) {
                ec.addRegexErrorListener(new RegexOutputListener(){

                    public void outputMatchedGroups(String[] data) {
                        RemoteExecuteCommand.this.printDataErrorOutput(data);
                    }
                }, errorRegex);
            } else {
                ec.addRegexErrorListener(new RegexOutputListener(){

                    public void outputMatchedGroups(String[] data) {
                        if (data != null) {
                            for (int i = 0; i < data.length; ++i) {
                                errorOutput.append(data[i]);
                            }
                            errorOutput.append(" ");
                        }
                    }
                }, errorRegex);
            }
        }
        catch (BadRegexException e) {
            ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.exec.ExternalCommand")) : class$org$netbeans$modules$vcscore$cmdline$exec$ExternalCommand), (String)"MSG_BadRegexMessageInfo", (Object)errorRegex)));
        }
        if (dataOutput != null || errorOutput != null) {
            return new StringBuffer[]{dataOutput, errorOutput};
        }
        return null;
    }

    private void printGlobalDataOutput(String globalDataOutput, Pattern globalDataRegex) {
        if (globalDataOutput.endsWith(" ")) {
            globalDataOutput = globalDataOutput.substring(0, globalDataOutput.length() - 1);
        }
        String[] parsed = RemoteExternalCommand.matchToStringArray(globalDataRegex, globalDataOutput);
        this.printDataOutput(parsed);
    }

    private void printGlobalErrorDataOutput(String globalDataOutput, Pattern globalDataRegex) {
        if (globalDataOutput.endsWith(" ")) {
            globalDataOutput = globalDataOutput.substring(0, globalDataOutput.length() - 1);
        }
        String[] parsed = RemoteExternalCommand.matchToStringArray(globalDataRegex, globalDataOutput);
        this.printDataErrorOutput(parsed);
    }

    protected void runCommand(String[] execs) {
        this.E.deb("runCommand: execs");
        for (int i = 0; i < execs.length; ++i) {
            this.E.deb(execs[i]);
        }
        this.preferredExec = this.preferredExecExpanded = VcsUtilities.array2stringNl((String[])execs);
        StringBuffer[] globalDataOutputWhole = null;
        Pattern[] globalRegexs = new Pattern[2];
        for (int i = 0; i < execs.length; ++i) {
            String exec = execs[i];
            RemoteExternalCommand ec = new RemoteExternalCommand(exec, this.rrt);
            this.setupExternalCommand(ec);
            StringBuffer[] globalDataOutput = this.addRegexListeners(ec, globalRegexs);
            this.E.deb("ec=" + ec);
            int status = 0;
            for (int j = 0; j < 10 && (status = ec.exec()) == 98954; ++j) {
                try {
                    System.out.println("The file is locked. Trying again...");
                    Thread.currentThread();
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (status != this.exitStatus && (this.exitStatus == 0 || this.exitStatus == 1 && status == 2)) {
                this.exitStatus = status;
            }
            if (globalDataOutput == null) continue;
            if (globalDataOutputWhole == null) {
                globalDataOutputWhole = globalDataOutput;
                continue;
            }
            if (globalDataOutputWhole[0] != null) {
                globalDataOutputWhole[0].append(globalDataOutput[0]);
            }
            if (globalDataOutputWhole[1] == null) continue;
            globalDataOutputWhole[1].append(globalDataOutput[1]);
        }
        if (globalDataOutputWhole != null) {
            if (globalDataOutputWhole[0] != null) {
                this.printGlobalDataOutput(globalDataOutputWhole[0].toString(), globalRegexs[0]);
            }
            if (globalDataOutputWhole[1] != null) {
                this.printGlobalErrorDataOutput(globalDataOutputWhole[1].toString(), globalRegexs[1]);
            }
        }
        this.E.deb("Command exited with exit status = " + this.exitStatus);
        switch (this.exitStatus) {
            case 0: {
                this.commandFinished(this.preferredExecExpanded, true);
                break;
            }
            case 1: 
            case 2: {
                this.commandFinished(this.preferredExecExpanded, false);
                if (this.fileSystem == null) break;
                this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
            }
        }
        this.D.deb("run(" + this.cmd.getName() + ") finished");
    }

    protected void runCommand(StructuredExec exec) {
        int status;
        this.preferredExec = this.preferredExecExpanded = VcsUtilities.array2stringNl((String[])RemoteExternalCommand.parseParameters(exec));
        Object globalDataOutputWhole = null;
        Pattern[] globalRegexs = new Pattern[2];
        RemoteExternalCommand ec = new RemoteExternalCommand(exec, this.rrt);
        this.setupExternalCommand(ec);
        StringBuffer[] globalDataOutput = this.addRegexListeners(ec, globalRegexs);
        this.E.deb("ec arg=" + ec);
        this.exitStatus = status = ec.exec();
        if (globalDataOutput != null) {
            if (globalDataOutput[0] != null) {
                this.printGlobalDataOutput(globalDataOutput[0].toString(), globalRegexs[0]);
            }
            if (globalDataOutput[1] != null) {
                this.printGlobalErrorDataOutput(globalDataOutput[1].toString(), globalRegexs[1]);
            }
        }
        switch (this.exitStatus) {
            case 0: {
                this.commandFinished(this.preferredExecExpanded, true);
                break;
            }
            case 1: 
            case 2: {
                this.commandFinished(this.preferredExecExpanded, false);
                if (this.fileSystem == null) break;
                this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
            }
        }
        this.D.deb("run(" + this.cmd.getName() + ") finished");
    }

    private void setupExternalCommand(RemoteExternalCommand ec) {
        this.externalCommand = ec;
        ec.setInput((String)this.cmd.getProperty("input"), VcsCommandIO.getBooleanProperty((VcsCommand)this.cmd, (String)"inputRepeat"));
        ec.setEnv(this.executionContext.getEnvironmentVars());
        Iterator it = this.textOutputListeners.iterator();
        while (it.hasNext()) {
            ec.addTextOutputListener((TextOutputListener)it.next());
        }
        it = this.textErrorListeners.iterator();
        while (it.hasNext()) {
            ec.addTextErrorListener((TextOutputListener)it.next());
        }
        it = this.immediateOutputListeners.iterator();
        while (it.hasNext()) {
            ec.addImmediateTextOutputListener((TextOutputListener)it.next());
        }
        it = this.immediateErrorListeners.iterator();
        while (it.hasNext()) {
            ec.addImmediateTextErrorListener((TextOutputListener)it.next());
        }
    }

    protected void printOutput(String line) {
        Iterator it = this.textOutputListeners.iterator();
        while (it.hasNext()) {
            ((TextOutputListener)it.next()).outputLine(line);
        }
    }

    protected void printErrorOutput(String line) {
        Iterator it = this.textErrorListeners.iterator();
        while (it.hasNext()) {
            ((TextOutputListener)it.next()).outputLine(line);
        }
    }

    protected void printDataOutput(String[] data) {
        Iterator it = this.regexOutputListeners.iterator();
        while (it.hasNext()) {
            ((RegexOutputListener)it.next()).outputMatchedGroups(data);
        }
        it = this.dataOutputListeners.iterator();
        while (it.hasNext()) {
            ((CommandDataOutputListener)it.next()).outputData(data);
        }
        if (this.doFileRefresh) {
            this.collectRefreshInfo(data);
        }
    }

    protected void printDataErrorOutput(String[] data) {
        Iterator it = this.regexErrorListeners.iterator();
        while (it.hasNext()) {
            ((RegexOutputListener)it.next()).outputMatchedGroups(data);
        }
        it = this.dataErrorListeners.iterator();
        while (it.hasNext()) {
            ((CommandDataOutputListener)it.next()).outputData(data);
        }
        if (this.getFileRefreshFromErrOut) {
            this.collectRefreshInfo(data);
        }
    }

    protected void runClass(String exec, String className, String[] args) {
        this.E.deb("runClass: " + className);
        boolean success = true;
        Class<?> execClass = null;
        this.preferredExec = this.preferredExecExpanded = exec;
        try {
            execClass = Class.forName(className, true, VcsUtilities.getSFSClassLoader());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (execClass == null) {
            try {
                this.printErrorOutput("CLASS EXEC: " + RemoteExecuteCommand.g("ERR_ClassNotFound", className));
            }
            catch (MissingResourceException mrexc) {
                this.printErrorOutput("CLASS EXEC: Class " + className + " not found");
            }
            success = false;
        }
        VcsAdditionalCommand execCommand = null;
        if (success) {
            this.D.deb(execClass + " loaded");
            try {
                execCommand = (VcsAdditionalCommand)execClass.newInstance();
            }
            catch (InstantiationException e) {
                this.printErrorOutput("CLASS EXEC: " + RemoteExecuteCommand.g("ERR_CanNotInstantiate", execClass));
                success = false;
            }
            catch (IllegalAccessException e) {
                this.printErrorOutput("CLASS EXEC: " + RemoteExecuteCommand.g("ERR_IllegalAccessOnClass", execClass));
                success = false;
            }
        }
        if (success) {
            this.E.deb("VcsAdditionalCommand created.");
            RemoteExecuteCommand.setAdditionalParams(execCommand, this.fileSystem, this.executionContext);
            String dataRegex = (String)this.cmd.getProperty("data.regex");
            String errorRegex = (String)this.cmd.getProperty("error.regex");
            String input = (String)this.cmd.getProperty("input");
            if (dataRegex != null) {
                this.vars.put("DATAREGEX", dataRegex);
            }
            if (errorRegex != null) {
                this.vars.put("ERRORREGEX", errorRegex);
            }
            if (input != null) {
                this.vars.put("INPUT", input);
            }
            try {
                success = execCommand.exec(this.vars, args, new CommandOutputListener(){

                    public void outputLine(String line) {
                        RemoteExecuteCommand.this.printOutput(line);
                    }
                }, new CommandOutputListener(){

                    public void outputLine(String line) {
                        RemoteExecuteCommand.this.printErrorOutput(line);
                    }
                }, new CommandDataOutputListener(){

                    public void outputData(String[] data) {
                        RemoteExecuteCommand.this.printDataOutput(data);
                    }
                }, dataRegex, new CommandDataOutputListener(){

                    public void outputData(String[] data) {
                        RemoteExecuteCommand.this.printDataErrorOutput(data);
                    }
                }, errorRegex);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable thr) {
                success = false;
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate(thr, NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)"ERR_EXC_IN_CLASS", (Object)className)));
            }
        }
        Thread.currentThread();
        if (Thread.interrupted()) {
            this.exitStatus = 2;
            this.commandFinished(exec, false);
            if (this.fileSystem != null) {
                this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
            }
        } else if (success) {
            this.exitStatus = 0;
            this.commandFinished(exec, true);
        } else {
            this.exitStatus = 1;
            this.commandFinished(exec, false);
            if (this.fileSystem != null) {
                this.fileSystem.removeNumDoAutoRefresh((String)this.vars.get("DIR"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String tempFilePath2;
        block28: {
            StructuredExec sexec;
            String exec = null;
            String[] execs = null;
            int maxCmdLength = 0;
            String maxCmdLengthStr = (String)this.vars.get("MAX_CMD_LENGTH");
            if (maxCmdLengthStr != null) {
                try {
                    maxCmdLength = Integer.parseInt(maxCmdLengthStr);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            if ((sexec = this.preferredStructuredExec) == null) {
                sexec = (StructuredExec)this.cmd.getProperty("execStructured");
            }
            if (sexec != null) {
                sexec = sexec.getExpanded(this.vars, false);
            } else {
                exec = this.preferredExec != null ? this.preferredExec : (String)this.cmd.getProperty("exec");
                if (exec == null) {
                    return;
                }
                String execOrig = exec;
                exec = Variables.expand((Hashtable)this.vars, (String)exec, (boolean)false);
                if ((exec = exec.trim()).trim().length() == 0) {
                    this.preferredExec = "";
                    return;
                }
                execs = maxCmdLength > 0 && exec.length() > maxCmdLength ? this.splitExec(execOrig, maxCmdLength) : new String[]{exec};
            }
            if (this.doPostExecutionRefresh) {
                this.filesToRefresh = new ArrayList(this.getFiles());
            } else if (this.doFileRefresh) {
                this.filesToRefresh = new ArrayList();
            }
            this.createRefreshFilesBase();
            boolean checkForModification = VcsCommandIO.getBooleanProperty((VcsCommand)this.cmd, (String)"checkForModifications") && this.fileSystem != null;
            Collection processingFiles = null;
            if (checkForModification) {
                processingFiles = this.getFiles();
                this.fileSystem.disableRefresh();
                Iterator it = processingFiles.iterator();
                while (it.hasNext()) {
                    this.fileSystem.lockFilesToBeModified((String)it.next(), true);
                }
            }
            try {
                String[] args;
                if (checkForModification) {
                    ArrayList<FileObject> fileObjects = new ArrayList<FileObject>(processingFiles.size());
                    Iterator it = processingFiles.iterator();
                    while (it.hasNext()) {
                        FileObject fo = this.fileSystem.findResource((String)it.next());
                        if (fo == null) continue;
                        fileObjects.add(fo);
                    }
                    VcsAction.assureFilesSaved(fileObjects);
                }
                if (sexec != null) {
                    String exe = sexec.getExecutable();
                    if (exe.toLowerCase().endsWith(".class")) {
                        String[] eargs = ExternalCommand.parseParameters((StructuredExec)sexec);
                        args = new String[eargs.length - 1];
                        System.arraycopy(eargs, 1, args, 0, args.length);
                        this.runClass(VcsUtilities.array2stringNl((String[])eargs), exe.substring(0, exe.length() - ".class".length()), args);
                    } else {
                        this.runCommand(sexec);
                    }
                } else {
                    String[] allArgs = VcsUtilities.getQuotedArguments((String)exec);
                    String first = allArgs[0];
                    if (first != null && first.toLowerCase().endsWith(".class")) {
                        args = new String[allArgs.length - 1];
                        System.arraycopy(allArgs, 1, args, 0, args.length);
                        this.runClass(exec, first.substring(0, first.length() - ".class".length()), args);
                    } else {
                        this.runCommand(execs);
                    }
                }
                Object var12_13 = null;
                if (!checkForModification) break block28;
            }
            catch (Throwable throwable) {
                String tempFilePath2;
                Object var12_14 = null;
                if (checkForModification) {
                    this.fileSystem.enableRefresh();
                    Iterator it = processingFiles.iterator();
                    while (it.hasNext()) {
                        this.fileSystem.unlockFilesToBeModified((String)it.next(), true);
                    }
                }
                if ((tempFilePath2 = (String)this.vars.get("TEMPORARY_FILE")) != null) {
                    new File(tempFilePath2).delete();
                }
                throw throwable;
            }
            this.fileSystem.enableRefresh();
            Iterator it = processingFiles.iterator();
            while (it.hasNext()) {
                this.fileSystem.unlockFilesToBeModified((String)it.next(), true);
            }
        }
        if ((tempFilePath2 = (String)this.vars.get("TEMPORARY_FILE")) != null) {
            new File(tempFilePath2).delete();
        }
    }

    private String[] splitExec(String exec, int maxCmdLength) {
        int i;
        String[] varNames = new String[]{"FILES", "QFILES", "PATHS", "QPATHS", "MPATHS", "QMPATHS"};
        int nVARS = varNames.length;
        int[][] fileIndexes = new int[nVARS][];
        int nFiles = 0;
        for (int i2 = 0; i2 < nVARS; ++i2) {
            String indexesEncoded = (String)this.vars.get(varNames[i2] + "_FILE_POS_INDEXES");
            if (indexesEncoded == null) continue;
            try {
                fileIndexes[i2] = (int[])VcsUtilities.decodeValue((String)indexesEncoded);
                nFiles = fileIndexes[i2].length;
                continue;
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        if (nFiles <= 1) {
            return new String[]{Variables.expand((Hashtable)this.vars, (String)exec, (boolean)false)};
        }
        String[] varValues = new String[nVARS];
        for (int i3 = 0; i3 < nVARS; ++i3) {
            varValues[i3] = (String)this.vars.get(varNames[i3]);
        }
        Hashtable tempVars = new Hashtable(this.vars);
        ArrayList<String> execs = new ArrayList<String>();
        int startFileIndex = 0;
        do {
            i = startFileIndex;
            int j = nFiles;
            String execTemp = null;
            int lastK = -1;
            while (i < j) {
                int k = (i + j + 1) / 2;
                if (k == startFileIndex) {
                    ++k;
                }
                if (k == lastK) {
                    if (i == k) break;
                    if (i == startFileIndex) {
                        i = k;
                    } else {
                        k = i;
                        j = i;
                    }
                }
                if ((execTemp = this.getTempExec(startFileIndex, k, fileIndexes, exec, nVARS, varNames, varValues, tempVars)).length() < maxCmdLength) {
                    i = k;
                } else {
                    j = k;
                }
                lastK = k;
            }
            execs.add(execTemp);
        } while ((startFileIndex = i) < nFiles);
        return execs.toArray(new String[0]);
    }

    private String getTempExec(int j, int k, int[][] fileIndexes, String exec, int nVARS, String[] varNames, String[] varValues, Hashtable vars) {
        for (int i = 0; i < nVARS; ++i) {
            String varTempValue = j < k ? (k < fileIndexes[i].length ? varValues[i].substring(fileIndexes[i][j], fileIndexes[i][k] - 1) : varValues[i].substring(fileIndexes[i][j])) : "";
            vars.put(varNames[i], varTempValue);
        }
        String execTemp = Variables.expand((Hashtable)vars, (String)exec, (boolean)false);
        execTemp = execTemp.trim();
        return execTemp;
    }

    protected static void setAdditionalParams(Object execCommand, VcsFileSystem fileSystem) {
        RemoteExecuteCommand.setAdditionalParams(execCommand, fileSystem, (CommandExecutionContext)fileSystem);
    }

    protected static void setAdditionalParams(Object execCommand, VcsFileSystem fileSystem, CommandExecutionContext executionContext) {
        Object[] args;
        Class[] paramClasses;
        Class<?> clazz = execCommand.getClass();
        if (fileSystem != null) {
            paramClasses = new Class[]{class$org$netbeans$modules$vcscore$VcsFileSystem == null ? (class$org$netbeans$modules$vcscore$VcsFileSystem = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.VcsFileSystem")) : class$org$netbeans$modules$vcscore$VcsFileSystem};
            Method setFileSystemMethod = null;
            try {
                setFileSystemMethod = clazz.getDeclaredMethod("setFileSystem", paramClasses);
            }
            catch (Exception exc) {
                setFileSystemMethod = null;
            }
            if (setFileSystemMethod != null) {
                args = new Object[]{fileSystem};
                try {
                    setFileSystemMethod.invoke(execCommand, args);
                }
                catch (Exception iae) {
                    // empty catch block
                }
            }
        }
        paramClasses = new Class[]{class$org$netbeans$modules$vcscore$commands$CommandExecutionContext == null ? (class$org$netbeans$modules$vcscore$commands$CommandExecutionContext = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.commands.CommandExecutionContext")) : class$org$netbeans$modules$vcscore$commands$CommandExecutionContext};
        Method setExecutionContextMethod = null;
        try {
            setExecutionContextMethod = clazz.getDeclaredMethod("setExecutionContext", paramClasses);
        }
        catch (Exception exc) {
            setExecutionContextMethod = null;
        }
        if (setExecutionContextMethod != null) {
            args = new Object[]{executionContext};
            try {
                setExecutionContextMethod.invoke(execCommand, args);
            }
            catch (Exception iae) {
                // empty catch block
            }
        }
    }

    public Collection getFiles() {
        if (this.processingFilesCollection == null) {
            this.processingFilesCollection = RemoteExecuteCommand.createProcessingFiles(this.executionContext, this.vars);
        }
        return this.processingFilesCollection;
    }

    public static Collection createProcessingFiles(CommandExecutionContext executionContext, Hashtable vars) {
        VariableValueAdjustment valueAdjustment = executionContext.getVarValueAdjustment();
        String separator = (String)vars.get("PS");
        char separatorChar = separator != null && separator.length() == 1 ? separator.charAt(0) : File.separatorChar;
        String paths = (String)vars.get("PATHS");
        String commonParent = (String)vars.get("COMMON_PARENT");
        if (commonParent != null) {
            commonParent = valueAdjustment.revertAdjustedVarValue(commonParent);
        }
        if ((paths = valueAdjustment.revertAdjustedVarValue(paths)) != null && paths.length() > 0) {
            int index;
            ArrayList<String> files = new ArrayList<String>();
            int len = paths.length();
            int begin = 0;
            do {
                if ((index = paths.indexOf("" + separatorChar + separatorChar, begin)) < 0) {
                    index = len;
                }
                String file = paths.substring(begin, index);
                if (commonParent != null) {
                    file = commonParent + "/" + file;
                }
                files.add(file.replace(separatorChar, '/'));
            } while ((begin = index + 2) < len);
            return Collections.unmodifiableList(files);
        }
        String path = (String)vars.get("DIR");
        String file = (String)vars.get("FILE");
        file = valueAdjustment.revertAdjustedVarValue(file);
        if ((path = valueAdjustment.revertAdjustedVarValue(path)) != null) {
            if (commonParent != null) {
                path = commonParent + "/" + path;
            }
            String fullPath = (path.length() > 0 ? path.replace(separatorChar, '/') : "") + (file == null ? "" : "/" + file);
            return Collections.singleton(fullPath);
        }
        return Collections.EMPTY_SET;
    }

    private void createRefreshFilesBase() {
        this.refreshFilesBase = (String)this.cmd.getProperty("refreshFileRelativePath");
        if (this.refreshFilesBase == null) {
            this.refreshFilesBase = (String)this.vars.get("COMMON_PARENT");
            this.refreshFilesMustStartWith = null;
        } else {
            this.refreshFilesBase = Variables.expand((Hashtable)this.vars, (String)this.refreshFilesBase, (boolean)false);
            String relMountPoint = this.fileSystem.getRelativeMountPoint();
            if (this.refreshFilesBase.length() <= relMountPoint.length()) {
                if (!relMountPoint.startsWith(this.refreshFilesBase)) {
                    this.doFileRefresh = false;
                    return;
                }
                this.refreshFilesMustStartWith = relMountPoint.substring(this.refreshFilesBase.length());
                while (this.refreshFilesMustStartWith.startsWith("/")) {
                    this.refreshFilesMustStartWith = this.refreshFilesMustStartWith.substring(1);
                }
                if (this.refreshFilesMustStartWith.length() == 0) {
                    this.refreshFilesMustStartWith = null;
                }
                this.refreshFilesBase = null;
            } else {
                if (!this.refreshFilesBase.startsWith(relMountPoint)) {
                    this.doFileRefresh = false;
                    return;
                }
                this.refreshFilesBase = this.refreshFilesBase.substring(relMountPoint.length());
                while (this.refreshFilesBase.startsWith("/")) {
                    this.refreshFilesBase = this.refreshFilesBase.substring(1);
                }
                if (this.refreshFilesBase.length() == 0) {
                    this.refreshFilesBase = null;
                }
                this.refreshFilesMustStartWith = null;
            }
        }
    }

    private void collectRefreshInfo(String[] elements) {
        if ((elements = CommandLineVcsDirReader.translateElements((String[])elements, (UserCommand)this.cmd)).length == 1) {
            this.flushRemoveFile(elements[0]);
            return;
        }
        this.refreshInfoElements.add(elements);
    }

    private void flushRemoveFile(String fileName) {
        String filePath;
        String fileDir = "";
        fileName.replace(File.separatorChar, '/');
        if (this.refreshFilesMustStartWith != null) {
            if (!fileName.startsWith(this.refreshFilesMustStartWith)) {
                return;
            }
            fileName = fileName.substring(this.refreshFilesMustStartWith.length() + 1);
        }
        if (this.refreshFilesBase != null) {
            filePath = this.refreshFilesBase + "/" + fileName;
            fileDir = VcsUtilities.getDirNamePart((String)filePath);
            fileName = VcsUtilities.getFileNamePart((String)filePath);
        } else {
            int sepIndex = fileName.indexOf(47);
            if (sepIndex < 0 || sepIndex == fileName.length() - 1) {
                fileDir = this.findFileDir(fileName);
                if (fileName.startsWith(fileDir + "/")) {
                    fileName = fileName.substring(fileDir.length() + 1);
                }
                filePath = fileDir.length() == 0 ? fileName : fileDir + "/" + fileName;
            } else {
                fileDir = this.findFileDir(fileName);
                filePath = fileDir.length() == 0 ? fileName : fileDir + "/" + fileName;
                fileDir = VcsUtilities.getDirNamePart((String)filePath);
                fileName = VcsUtilities.getFileNamePart((String)filePath);
            }
        }
        this.sendRefreshInfo(fileDir, new String[]{fileName});
        this.filesToRefresh.remove(filePath);
    }

    private void flushRefreshInfo() {
        Object name = null;
        String[] elements = this.mergeInfoElements();
        while (elements != null) {
            if (elements[0] != null && elements[0].trim().length() > 0) {
                String filePath;
                elements[0].replace(File.separatorChar, '/');
                String fileName = elements[0];
                String fileDir = "";
                if (this.refreshFilesMustStartWith != null) {
                    if (!fileName.startsWith(this.refreshFilesMustStartWith)) {
                        return;
                    }
                    if (this.refreshFilesMustStartWith.length() < fileName.length()) {
                        fileName = fileName.substring(this.refreshFilesMustStartWith.length() + 1);
                    } else {
                        fileName = "";
                        return;
                    }
                }
                if (this.refreshFilesBase != null) {
                    filePath = this.refreshFilesBase + "/" + fileName;
                    fileDir = VcsUtilities.getDirNamePart((String)filePath);
                    elements[0] = fileName = VcsUtilities.getFileNamePart((String)filePath);
                } else {
                    int sepIndex = fileName.indexOf(47);
                    if (sepIndex < 0 || sepIndex == fileName.length() - 1) {
                        fileDir = this.findFileDir(fileName);
                        if (fileName.startsWith(fileDir + "/")) {
                            fileName = fileName.substring(fileDir.length() + 1);
                        }
                        filePath = fileDir.length() == 0 ? fileName : fileDir + "/" + fileName;
                    } else {
                        fileDir = this.findFileDir(fileName);
                        filePath = fileDir.length() == 0 ? fileName : fileDir + "/" + fileName;
                        fileDir = VcsUtilities.getDirNamePart((String)filePath);
                        fileName = VcsUtilities.getFileNamePart((String)filePath);
                    }
                    elements[0] = fileName;
                }
                if (this.substituteStatuses && (elements = this.performStatusSubstitution(elements)) == null) {
                    if (!this.doPostExecutionRefresh) {
                        this.filesToRefresh.add(filePath);
                    }
                } else {
                    fileName = elements[0];
                    if (!fileName.endsWith("/") && this.fileSystem.folder(fileDir + "/" + fileName)) {
                        elements[0] = fileName = fileName + "/";
                    }
                    this.sendRefreshInfo(fileDir, elements);
                    this.filesToRefresh.remove(filePath);
                }
            }
            elements = this.mergeInfoElements();
        }
    }

    private String[] mergeInfoElements() {
        String[] elements = null;
        while (this.refreshInfoElements.size() > 0) {
            String[] elements1 = (String[])this.refreshInfoElements.get(0);
            if (elements == null) {
                elements = elements1;
                this.refreshInfoElements.remove(0);
                continue;
            }
            if (elements1[0] != null && elements1[0].trim().length() != 0) break;
            elements = this.mergeElements(elements, elements1);
            this.refreshInfoElements.remove(0);
        }
        return elements;
    }

    private String[] mergeElements(String[] e1, String[] e2) {
        for (int i = 0; i < e1.length && i < e2.length; ++i) {
            if (i == 0 || e1[i] != null && (e1[i].trim().length() != 0 || e2[i] == null || e2[i].trim().length() <= 0)) continue;
            e1[i] = e2[i];
        }
        return e1;
    }

    private String[] performStatusSubstitution(String[] elements) {
        String status = elements[1];
        if (status == null) {
            return elements;
        }
        for (int i = 0; i < this.substituitionRegExps.length; ++i) {
            Matcher matcher = this.substituitionRegExps[i].matcher(status);
            if (!matcher.matches()) continue;
            status = STATUS_USE_REG_EXP_PARSE_OUTPUT.equals(this.substituitionStatuses[i]) ? matcher.group() : this.substituitionStatuses[i];
            elements[1] = status;
            return elements;
        }
        return null;
    }

    private String findFileDir(String name) {
        String dir = "";
        Collection files = this.doPostExecutionRefresh ? this.filesToRefresh : this.getFiles();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String filePath = (String)it.next();
            if (!filePath.endsWith(name)) continue;
            if (filePath.length() <= name.length()) break;
            dir = filePath.substring(0, filePath.length() - name.length() - 1);
            break;
        }
        return dir;
    }

    private void refreshRemainingFiles() {
        if (!"LIST_FILE".equals(this.cmd.getName())) {
            if (this.filesToRefresh != null && this.filesToRefresh.size() > 0) {
                this.doRefreshFiles(this.fileSystem, this.filesToRefresh);
            } else if (VcsCommandIO.getBooleanProperty((VcsCommand)this.cmd, (String)"refreshProcessedFiles")) {
                this.doRefreshFiles(this.fileSystem, this.getFiles());
            }
        }
    }

    private void doRefreshFiles(VcsFileSystem fileSystem, Collection filesPaths) {
        CommandSupport cmdSupp = fileSystem.getCommandSupport("LIST_FILE");
        if (cmdSupp != null) {
            Command cmd = cmdSupp.createCommand();
            ArrayList<FileObject> foFiles = new ArrayList<FileObject>();
            ArrayList<File> diskFiles = new ArrayList<File>();
            Iterator it = filesPaths.iterator();
            while (it.hasNext()) {
                String file = (String)it.next();
                FileObject fo = fileSystem.findFileObject(file);
                if (fo != null) {
                    foFiles.add(fo);
                    continue;
                }
                diskFiles.add(fileSystem.getFile(file));
            }
            if (foFiles.size() > 0) {
                cmd.setFiles(foFiles.toArray(new FileObject[foFiles.size()]));
            }
            if (cmd instanceof VcsDescribedCommand) {
                if (diskFiles.size() > 0) {
                    ((VcsDescribedCommand)cmd).setDiskFiles(diskFiles.toArray(new File[diskFiles.size()]));
                }
                it = this.fileReaderListeners.iterator();
                while (it.hasNext()) {
                    ((VcsDescribedCommand)cmd).addFileReaderListener((FileReaderListener)it.next());
                }
            }
            VcsManager.getDefault().showCustomizer(cmd);
            cmd.execute();
        }
    }

    private void sendRefreshInfo(String folder, String[] elements) {
        if (!folder.equals(this.lastCollectedFolder)) {
            if (this.lastCollectedFolder != null) {
                Iterator it = new ArrayList(this.fileReaderListeners).iterator();
                while (it.hasNext()) {
                    ((FileReaderListener)it.next()).readFileFinished(this.lastCollectedFolder, (Collection)this.lastCollectedElements);
                }
                this.lastCollectedElements.clear();
            }
            this.lastCollectedFolder = folder;
        }
        if (this.lastCollectedElements == null) {
            this.lastCollectedElements = new HashSet();
        }
        this.lastCollectedElements.add(elements);
    }

    private void cleanupSendRefreshInfo() {
        if (this.lastCollectedFolder != null) {
            Iterator it = new ArrayList(this.fileReaderListeners).iterator();
            while (it.hasNext()) {
                ((FileReaderListener)it.next()).readFileFinished(this.lastCollectedFolder, (Collection)this.lastCollectedElements);
            }
        }
        this.lastCollectedFolder = null;
        this.lastCollectedElements = null;
    }

    public void addFileReaderListener(FileReaderListener l) {
        if (this.fileReaderListeners != null) {
            this.fileReaderListeners.add(l);
        }
    }

    private static final String g(String s) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)s);
    }

    private static final String g(String s, Object obj) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)s, (Object)obj);
    }

    private static final String g(String s, Object obj1, Object obj2) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)s, (Object)obj1, (Object)obj2);
    }

    private static final String g(String s, Object obj1, Object obj2, Object obj3) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand == null ? (class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand = RemoteExecuteCommand.class$("org.netbeans.modules.vcscore.cmdline.ExecuteCommand")) : class$org$netbeans$modules$vcscore$cmdline$ExecuteCommand), (String)s, (Object)obj1, (Object)obj2, (Object)obj3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

