/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.vcscore.versioning.RevisionItem;

public class NumDotRevisionItem
extends RevisionItem {
    private NumDotRevisionItem next = null;
    private static final long serialVersionUID = 7946273312693547993L;

    public NumDotRevisionItem(String revision) {
        super(revision);
    }

    public boolean isBranch() {
        return false;
    }

    public static int numDots(String str) {
        int num = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '.') continue;
            ++num;
        }
        return num;
    }

    private boolean evenDots() {
        return NumDotRevisionItem.numDots(this.getRevision()) % 2 == 0;
    }

    protected int cmpRev(String revision) {
        StringTokenizer tokens1 = new StringTokenizer(this.getRevision(), ".");
        StringTokenizer tokens2 = new StringTokenizer(revision, ".");
        while (tokens1.hasMoreTokens() && tokens2.hasMoreTokens()) {
            String rev1 = tokens1.nextToken();
            String rev2 = tokens2.nextToken();
            int irev1 = 0;
            int irev2 = 0;
            try {
                irev1 = Integer.parseInt(rev1);
                irev2 = Integer.parseInt(rev2);
            }
            catch (NumberFormatException e) {
                return -1000;
            }
            if (irev1 == irev2) continue;
            return irev1 - irev2;
        }
        if (tokens1.hasMoreTokens()) {
            return 1;
        }
        if (tokens2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public RevisionItem addRevision(String revision) {
        boolean inserted = false;
        RevisionItem addedRevision = null;
        if (this.next == null) {
            if (NumDotRevisionItem.numDots(revision) == NumDotRevisionItem.numDots(this.getRevision())) {
                this.next = new NumDotRevisionItem(revision);
                addedRevision = this.next;
                inserted = true;
            } else if (this.evenDots() && revision.indexOf(this.getRevision()) == 0) {
                this.next = new NumDotRevisionItem(revision);
                addedRevision = this.next;
                inserted = true;
            }
        } else if (NumDotRevisionItem.numDots(revision) == NumDotRevisionItem.numDots(this.next.getRevision()) && this.next.cmpRev(revision) > 0) {
            NumDotRevisionItem nextOne = this.next;
            this.next = new NumDotRevisionItem(revision);
            addedRevision = this.next;
            this.next.setNextItem(nextOne);
            inserted = true;
        } else {
            addedRevision = this.next.addRevision(revision);
        }
        if (!inserted && this.branches != null) {
            Enumeration enumeration = this.branches.elements();
            while (enumeration.hasMoreElements()) {
                RevisionItem branch = (RevisionItem)enumeration.nextElement();
                if (revision.indexOf(branch.getRevision()) != 0) continue;
                addedRevision = branch.addRevision(revision);
            }
        }
        return addedRevision;
    }

    public RevisionItem addBranch(String branch) {
        RevisionItem addedRevision = null;
        if (branch.indexOf(this.getRevision()) == 0 && NumDotRevisionItem.numDots(this.getRevision()) + 1 == NumDotRevisionItem.numDots(branch)) {
            if (this.branches == null) {
                this.branches = new Vector();
            }
            addedRevision = new NumDotRevisionItem(branch);
            this.branches.add(addedRevision);
        } else {
            if (this.next != null) {
                addedRevision = this.next.addBranch(branch);
            }
            if (this.branches != null) {
                Enumeration enumeration = this.branches.elements();
                while (enumeration.hasMoreElements()) {
                    addedRevision = ((RevisionItem)enumeration.nextElement()).addBranch(branch);
                }
            }
        }
        return addedRevision;
    }

    protected RevisionItem getNextItem() {
        return this.next;
    }

    private void setNextItem(NumDotRevisionItem next) {
        this.next = next;
    }
}

