/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSRemoteUtil;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.DefaultDiff;
import org.netbeans.modules.diff.builtin.DiffPresenter;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class CMSDiff
implements VcsAdditionalCommand,
CommandDataOutputListener {
    private static final String TEXT_MIMETYPE = "text/plain";
    private VcsFileSystem fileSystem = null;
    private List differences = new ArrayList();
    private File tmpDir = null;
    private File tmpDir2 = null;
    private String tmpDirName = "";
    Hashtable vars = null;
    private String rootDir = null;
    private String file = null;
    private String dir = null;
    private transient CommandOutputListener stdoutNRListener = null;
    private transient CommandOutputListener stderrNRListener = null;
    private transient CommandDataOutputListener stdoutListener = null;
    protected transient CommandDataOutputListener stderrListener = null;
    protected String diffOutRev1 = null;
    protected String diffOutRev2 = null;
    protected int outputType = -1;
    private String checkoutCmd = null;
    private String diffCmd = null;
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.CMSDiff") | Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
    private static final String CMS_REVISION_STR = "%CMS-S-FETCHED, generation ";
    private StringBuffer firstText = new StringBuffer();
    private StringBuffer secondText = new StringBuffer();
    private String fsTmpDir;
    static /* synthetic */ Class class$org$netbeans$modules$vcs$profiles$commands$AbstractDiffCommand;
    static /* synthetic */ Class class$org$netbeans$spi$diff$DiffVisualizer;
    static /* synthetic */ Class class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff;

    public void setFileSystem(VcsFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    private boolean checkOut(Hashtable vars, String file, String revision, String tmpDir) {
        VcsCommand cmd = this.fileSystem.getCommand(this.checkoutCmd);
        String varRevision = "";
        if (revision != null) {
            varRevision = "" + revision;
        }
        vars.put("REVISION", varRevision);
        vars.put("TEMPDIR", tmpDir);
        Hashtable newVars = new Hashtable(vars);
        VcsCommandExecutor vce = this.fileSystem.getVcsFactory().getCommandExecutor(cmd, newVars);
        this.fileSystem.getCommandsPool().preprocessCommand(vce, newVars, this.fileSystem);
        this.fileSystem.getCommandsPool().startExecutor(vce);
        try {
            this.fileSystem.getCommandsPool().waitToFinish(vce);
        }
        catch (InterruptedException iexc) {
            this.fileSystem.getCommandsPool().kill(vce);
            return false;
        }
        return vce.getExitStatus() == 0;
    }

    private boolean performDiff(String revision1, String revision2) throws InterruptedException {
        VcsCommand cmd = this.fileSystem.getCommand(this.diffCmd);
        if (revision1 != null) {
            this.vars.put("REVISION1", revision1);
        } else {
            this.vars.put("REVISION1", "");
        }
        if (revision2 != null) {
            this.vars.put("REVISION2", revision2);
        } else {
            this.vars.put("REVISION2", "");
        }
        Hashtable newVars = new Hashtable(this.vars);
        VcsCommandExecutor vce = this.fileSystem.getVcsFactory().getCommandExecutor(cmd, newVars);
        vce.addDataOutputListener((CommandDataOutputListener)this);
        this.fileSystem.getCommandsPool().preprocessCommand(vce, newVars, this.fileSystem);
        this.fileSystem.getCommandsPool().startExecutor(vce);
        try {
            this.fileSystem.getCommandsPool().waitToFinish(vce);
        }
        catch (InterruptedException iexc) {
            this.fileSystem.getCommandsPool().kill(vce);
            throw iexc;
        }
        this.diffFinished();
        return vce.getExitStatus() == 0;
    }

    public boolean exec(Hashtable vars, String[] args, CommandOutputListener stdoutNRListener, CommandOutputListener stderrNRListener, CommandDataOutputListener stdoutListener, String dataRegex, CommandDataOutputListener stderrListener, String errorRegex) {
        boolean diffStatus;
        boolean status = true;
        this.stdoutNRListener = stdoutNRListener;
        this.stderrNRListener = stderrNRListener;
        this.stdoutListener = stdoutListener;
        this.stderrListener = stderrListener;
        this.vars = vars;
        int arglen = args.length;
        if (arglen < 3) {
            String message = "Too few arguments to Diff command !";
            String[] elements = new String[]{message};
            if (stderrListener != null) {
                stderrListener.outputData(elements);
            }
            if (stderrNRListener != null) {
                stderrNRListener.outputLine(message);
            }
            return false;
        }
        try {
            this.outputType = Integer.parseInt(args[arglen - 3]);
        }
        catch (NumberFormatException e) {
            String message = "Bad output type specification:" + args[arglen - 3];
            String[] elements = new String[]{message};
            if (stderrListener != null) {
                stderrListener.outputData(elements);
            }
            if (stderrNRListener != null) {
                stderrNRListener.outputLine(message);
            }
            return false;
        }
        this.checkoutCmd = args[arglen - 2];
        this.diffCmd = args[arglen - 1];
        String mime = (String)vars.get("MIMETYPE");
        if (mime == null || mime.indexOf("unknown") >= 0) {
            vars.put("MIMETYPE", TEXT_MIMETYPE);
            mime = TEXT_MIMETYPE;
        }
        String mimeType = mime;
        this.rootDir = (String)vars.get("ROOTDIR");
        this.fsTmpDir = this.fileSystem.getRootDirectory().getAbsolutePath() + File.separatorChar + "CMSINFO";
        String module = (String)vars.get("MODULE");
        if (module == null) {
            module = "";
        }
        if (module.length() > 0) {
            module = module + File.separator;
        }
        this.dir = module + (String)vars.get("DIR");
        this.file = (String)vars.get("FILE");
        VariableValueAdjustment adjust = this.fileSystem.getVarValueAdjustment();
        if (adjust != null) {
            this.file = adjust.revertAdjustedVarValue(this.file);
        }
        this.tmpDir = new File(this.fsTmpDir);
        this.tmpDirName = this.tmpDir.getAbsolutePath();
        String path = this.rootDir + File.separator + this.dir + File.separator + this.file;
        String revision1 = null;
        String revision2 = null;
        if (args.length > 3) {
            revision1 = args[0];
        }
        FileObject tempFOFolder = null;
        try {
            tempFOFolder = CMSRemoteUtil.refreshLocalDir(this.fsTmpDir, true);
            CMSRemoteUtil.cleanUpAll(tempFOFolder);
            diffStatus = this.performDiff(revision1, revision2);
        }
        catch (InterruptedException iexc) {
            return false;
        }
        if (this.differences.size() == 0) {
            String file1 = this.fsTmpDir + File.separatorChar + this.file;
            try {
                FileObject fobj1;
                if (tempFOFolder != null) {
                    tempFOFolder.refresh(false);
                }
                if ((fobj1 = CMSRemoteUtil.getTempFile(file1, false)) != null) {
                    fobj1.delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (diffStatus) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$vcs$profiles$commands$AbstractDiffCommand == null ? (class$org$netbeans$modules$vcs$profiles$commands$AbstractDiffCommand = CMSDiff.class$("org.netbeans.modules.vcs.profiles.commands.AbstractDiffCommand")) : class$org$netbeans$modules$vcs$profiles$commands$AbstractDiffCommand), (String)"NoDifferenceInFile", (Object)this.file)));
                return true;
            }
            return false;
        }
        if (this.diffOutRev1 != null) {
            revision1 = this.diffOutRev1;
        }
        if (this.diffOutRev2 != null) {
            revision2 = this.diffOutRev2;
        }
        if (!(status = this.checkOut(vars, this.dir + File.separator + this.file, revision1, this.tmpDirName))) {
            this.closing();
            return status;
        }
        String file1Title = revision1 == null ? this.getTitleHeadRevision() : this.getTitleRevision(revision1);
        String file2Title = revision2 == null ? this.getTitleWorkingRevision() : this.getTitleRevision(revision2);
        String file1 = this.fsTmpDir + File.separatorChar + this.file;
        String file2 = this.rootDir + File.separator + this.dir + (this.dir != null ? File.separator : "") + this.file;
        FileObject fobj1 = CMSRemoteUtil.getTempFile(file1, true);
        if (debug) {
            System.out.println("1st diff file:" + file1 + " 2nd diff file:" + file2 + " " + this.differences.size());
        }
        DiffInfo diffInfo = new DiffInfo(this.differences.toArray(new Difference[this.differences.size()]), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcs$profiles$commands$AbstractDiffCommand == null ? (class$org$netbeans$modules$vcs$profiles$commands$AbstractDiffCommand = CMSDiff.class$("org.netbeans.modules.vcs.profiles.commands.AbstractDiffCommand")) : class$org$netbeans$modules$vcs$profiles$commands$AbstractDiffCommand), (String)"Diff.titleComponent", (Object)this.file), "", file1Title, file2Title, mimeType, false, true, new File(file1), new File(file2));
        DiffPresenter presenter = new DiffPresenter((DiffPresenter.Info)diffInfo);
        MyDiffTopComponent diffComponent = new MyDiffTopComponent((Component)presenter, new File(file1), new File(file2), fobj1);
        diffInfo.setPresentingComponent((TopComponent)diffComponent);
        presenter.setVisualizer((DiffVisualizer)Lookup.getDefault().lookup(class$org$netbeans$spi$diff$DiffVisualizer == null ? (class$org$netbeans$spi$diff$DiffVisualizer = CMSDiff.class$("org.netbeans.spi.diff.DiffVisualizer")) : class$org$netbeans$spi$diff$DiffVisualizer));
        diffComponent.open();
        return status;
    }

    public void closing() {
    }

    protected boolean checkEmpty(String str, String element) {
        if (str == null || str.length() == 0) {
            if (this.stderrListener != null) {
                String[] elements = new String[]{"Bad format of diff result: " + element};
                this.stderrListener.outputData(elements);
            }
            return true;
        }
        return false;
    }

    protected final void addDifference(Difference diff) {
        this.differences.add(diff);
    }

    protected final void setTextOnLastDifference(String text1, String text2) {
        if (this.differences.size() > 0) {
            if (text1.length() == 0) {
                text1 = null;
            }
            if (text2.length() == 0) {
                text2 = null;
            }
            Difference d = (Difference)this.differences.remove(this.differences.size() - 1);
            this.differences.add(new Difference(d.getType(), d.getFirstStart(), d.getFirstEnd(), d.getSecondStart(), d.getSecondEnd(), text1, text2));
        }
    }

    public CMSDiff() {
        if (debug) {
            System.out.println("CMSDiff object created");
        }
    }

    protected void finalize() throws IOException {
        if (debug) {
            System.out.println("CMSDiff object destroyed");
        }
    }

    public void outputData(String[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (!debug) continue;
            System.out.println("CMSDiff:" + elements[i]);
        }
        switch (this.outputType) {
            case 0: {
                char c;
                if (elements[0] == null || ((c = elements[0].toString().charAt(0)) < '0' || c > '9') && c != '%') break;
                if (debug) {
                    System.out.println("Diff match line: " + elements[0]);
                }
                if (elements[0].indexOf(CMS_REVISION_STR) == 0) {
                    String rev = elements[0].substring(CMS_REVISION_STR.length(), elements[0].indexOf(32, CMS_REVISION_STR.length()));
                    if (this.diffOutRev1 != null) break;
                    this.diffOutRev1 = rev;
                    if (!debug) break;
                    System.out.println("DIFFing againt CMS element generation: " + rev);
                    break;
                }
                this.matchUnixLike(elements);
            }
        }
    }

    public void matchUnixLike(String[] elements) {
        if (elements[0].startsWith("< ")) {
            this.firstText.append(elements[0].substring(2) + "\n");
            return;
        }
        if (elements[0].startsWith("> ")) {
            this.secondText.append(elements[0].substring(2) + "\n");
            return;
        }
        if (elements[0].startsWith("--")) {
            return;
        }
        this.setTextOnLastDifference(this.firstText.toString(), this.secondText.toString());
        this.firstText.delete(0, this.firstText.length());
        this.secondText.delete(0, this.secondText.length());
        int index = 0;
        int commaIndex = 0;
        int n1 = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        index = elements[0].indexOf(97);
        if (index >= 0) {
            try {
                n1 = Integer.parseInt(elements[0].substring(0, index));
                commaIndex = elements[0].indexOf(44, ++index);
                if (commaIndex < 0) {
                    String nStr = elements[0].substring(index, elements[0].length());
                    if (this.checkEmpty(nStr, elements[0])) {
                        return;
                    }
                    n4 = n3 = Integer.parseInt(nStr);
                } else {
                    String nStr = elements[0].substring(index, commaIndex);
                    if (this.checkEmpty(nStr, elements[0])) {
                        return;
                    }
                    n3 = Integer.parseInt(nStr);
                    nStr = elements[0].substring(commaIndex + 1, elements[0].length());
                    n4 = nStr == null || nStr.length() == 0 ? n3 : Integer.parseInt(nStr);
                }
            }
            catch (NumberFormatException e) {
                if (this.stderrListener != null) {
                    String[] debugOut = new String[]{"NumberFormatException " + e.getMessage()};
                    this.stderrListener.outputData(debugOut);
                }
                if (debug) {
                    System.out.println("NumberFormatException occurred: " + e.getMessage());
                }
                return;
            }
            this.addDifference(new Difference(1, n1, 0, n3, n4));
        } else {
            index = elements[0].indexOf(100);
            if (index >= 0) {
                commaIndex = elements[0].lastIndexOf(44, index);
                try {
                    String nStr;
                    if (commaIndex < 0) {
                        n2 = n1 = Integer.parseInt(elements[0].substring(0, index));
                    } else {
                        nStr = elements[0].substring(0, commaIndex);
                        if (this.checkEmpty(nStr, elements[0])) {
                            return;
                        }
                        n1 = Integer.parseInt(nStr);
                        nStr = elements[0].substring(commaIndex + 1, index);
                        if (this.checkEmpty(nStr, elements[0])) {
                            return;
                        }
                        n2 = Integer.parseInt(nStr);
                    }
                    nStr = elements[0].substring(index + 1, elements[0].length());
                    if (this.checkEmpty(nStr, elements[0])) {
                        return;
                    }
                    n3 = Integer.parseInt(nStr);
                }
                catch (NumberFormatException e) {
                    if (this.stderrListener != null) {
                        String[] debugOut = new String[]{"NumberFormatException " + e.getMessage()};
                        this.stderrListener.outputData(debugOut);
                    }
                    if (debug) {
                        System.out.println("NumberFormatException occurred: " + e.getMessage());
                    }
                    return;
                }
                this.addDifference(new Difference(0, n1, n2, n3, 0));
            } else {
                index = elements[0].indexOf(99);
                if (index >= 0) {
                    commaIndex = elements[0].lastIndexOf(44, index);
                    try {
                        String nStr;
                        if (commaIndex < 0) {
                            n2 = n1 = Integer.parseInt(elements[0].substring(0, index));
                        } else {
                            nStr = elements[0].substring(0, commaIndex);
                            if (this.checkEmpty(nStr, elements[0])) {
                                return;
                            }
                            n1 = Integer.parseInt(nStr);
                            nStr = elements[0].substring(commaIndex + 1, index);
                            if (this.checkEmpty(nStr, elements[0])) {
                                return;
                            }
                            n2 = Integer.parseInt(nStr);
                        }
                        commaIndex = elements[0].indexOf(44, ++index);
                        if (commaIndex < 0) {
                            nStr = elements[0].substring(index, elements[0].length());
                            if (this.checkEmpty(nStr, elements[0])) {
                                return;
                            }
                            n4 = n3 = Integer.parseInt(nStr);
                        } else {
                            nStr = elements[0].substring(index, commaIndex);
                            if (this.checkEmpty(nStr, elements[0])) {
                                return;
                            }
                            n3 = Integer.parseInt(nStr);
                            nStr = elements[0].substring(commaIndex + 1, elements[0].length());
                            n4 = nStr == null || nStr.length() == 0 ? n3 : Integer.parseInt(nStr);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (this.stderrListener != null) {
                            String[] debugOut = new String[]{"NumberFormatException " + e.getMessage()};
                            this.stderrListener.outputData(debugOut);
                        }
                        if (debug) {
                            System.out.println("NumberFormatException occurred:" + e.getMessage());
                        }
                        return;
                    }
                    this.addDifference(new Difference(2, n1, n2, n3, n4));
                }
            }
        }
    }

    protected void diffFinished() {
        switch (this.outputType) {
            default: 
        }
        if (this.firstText.length() > 0 || this.secondText.length() > 0) {
            this.setTextOnLastDifference(this.firstText.toString(), this.secondText.toString());
        }
    }

    protected String getTitleHeadRevision() {
        return NbBundle.getMessage((Class)(class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff == null ? (class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff = CMSDiff.class$("com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSDiff")) : class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff), (String)"Diff.titleHeadRevision");
    }

    protected String getTitleRevision(String revNumber) {
        return NbBundle.getMessage((Class)(class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff == null ? (class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff = CMSDiff.class$("com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSDiff")) : class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff), (String)"Diff.titleRevision", (Object)revNumber);
    }

    protected String getTitleWorkingRevision() {
        return NbBundle.getMessage((Class)(class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff == null ? (class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff = CMSDiff.class$("com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSDiff")) : class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$CMSDiff), (String)"Diff.titleWorkingFile");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DiffInfo
    extends DiffPresenter.Info {
        private Difference[] diffs;
        private File file1;
        private File file2;

        public DiffInfo(Difference[] diffs, String name1, String name2, String title1, String title2, String mimeType, boolean chooseProviders, boolean chooseVisualizers, File file1, File file2) {
            super(name1, name2, title1, title2, mimeType, chooseProviders, chooseVisualizers);
            this.file1 = file1;
            this.file2 = file2;
            this.diffs = diffs;
        }

        public Reader createFirstReader() {
            try {
                return new FileReader(this.file1);
            }
            catch (FileNotFoundException fnfex) {
                return null;
            }
        }

        public Reader createSecondReader() {
            try {
                return new FileReader(this.file2);
            }
            catch (FileNotFoundException fnfex) {
                return null;
            }
        }

        public Difference[] getDifferences() {
            return this.diffs;
        }
    }

    private static class MyDiffTopComponent
    extends DefaultDiff.DiffTopComponent {
        File f1;
        File f2;
        FileObject fobj1;

        public MyDiffTopComponent(Component c, File f1, File f2, FileObject fobj1) {
            super(c);
            this.f1 = f1;
            this.f2 = f2;
            this.fobj1 = fobj1;
        }

        protected void componentClosed() {
            if (this.f1 != null) {
                this.f1.delete();
                if (this.fobj1 != null) {
                    try {
                        this.fobj1.delete();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

