/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.edtkeypad;

import com.compaq.openvms.netbeans.edtkeypad.EDTInitializer;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallbackSystemAction;

public class EDTCustomActions {
    public static final String IGNORE_NEXT = "flagIgnoreNext";
    protected static boolean bSelectionInProgress = false;
    protected static char[] lineBuffer = null;
    protected static char[] wordBuffer = null;
    protected static char[] charBuffer = null;
    static /* synthetic */ Class class$org$openide$actions$NextTabAction;
    static /* synthetic */ Class class$org$openide$actions$PreviousTabAction;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public EDTCustomActions() {
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: EDT CustomActions ctor");
        }
    }

    private static String getStatusBarDirection(JTextComponent jTextComponent) {
        StatusBar statusBar;
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: getStatusBarDirection");
        }
        if ((statusBar = Utilities.getEditorUI((JTextComponent)jTextComponent).getStatusBar()) == null) {
            return "";
        }
        if (EDTInitializer.debugSB) {
            System.out.println("sb ok 3; get sb dir = " + statusBar.getText("direction"));
        }
        return statusBar.getText("direction");
    }

    private static void setStatusBarDirection(JTextComponent jTextComponent, String string) {
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: setStatusBarDirection");
        }
        if (jTextComponent == null) {
            return;
        }
        StatusBar statusBar = Utilities.getEditorUI((JTextComponent)jTextComponent).getStatusBar();
        if (statusBar == null) {
            return;
        }
        if (statusBar.getCellCount() == 0) {
            return;
        }
        if (statusBar.getCellByName("direction") == null) {
            if (EDTInitializer.debugSB) {
                System.out.println("sb ok 4; set sb dir = unexpected adding direction cell");
            }
            statusBar.addCell(4, "direction", new String[]{"Forward", "Reverse"}).setHorizontalAlignment(4);
        }
        statusBar.setText("direction", string);
        if (EDTInitializer.debugSB) {
            System.out.println("set sb dir = " + statusBar.getText("direction"));
        }
    }

    private static void ResetSelection(JTextComponent jTextComponent) {
        if (EDTInitializer.debugVerbose) {
            System.out.println("deselecting");
        }
        bSelectionInProgress = false;
        if (jTextComponent == null) {
            return;
        }
        Caret caret = jTextComponent.getCaret();
        try {
            if (caret.isSelectionVisible()) {
                caret.setSelectionVisible(false);
            }
        }
        catch (Exception exception) {
            jTextComponent.getToolkit().beep();
        }
    }

    private static int findPrevFF(char[] cArray, int n, int n2) {
        int n3 = n2 - n - 1;
        while (n2 > 0) {
            char c;
            if ((c = cArray[n3--]) == '\f') {
                if (EDTInitializer.debugVerbose) {
                    System.out.println("findFF: found it. returning idx (offby1) = " + n3);
                }
                return n3 + 1;
            }
            --n2;
        }
        if (EDTInitializer.debugVerbose) {
            System.out.println("findFF: not found. idx=" + n3);
        }
        return -1;
    }

    private static int findNextFF(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n2 > 0) {
            char c;
            if ((c = cArray[n3++]) == '\f') {
                if (EDTInitializer.debugVerbose) {
                    System.out.println("findFF: found it. returning idx (offby1) = " + n3);
                }
                return n3 - 1;
            }
            --n2;
        }
        if (EDTInitializer.debugVerbose) {
            System.out.println("findFF: not found. idx=" + n3);
        }
        return -1;
    }

    private static int getNextPageMark(JTextComponent jTextComponent, int n) throws BadLocationException {
        int n2;
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: getNextPageMark - dotpos = " + n);
        }
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n3 = (Integer)baseDocument.getProperty((Object)"read-buffer-size");
        char[] cArray = new char[n3];
        int n4 = n2 = baseDocument.getLength();
        int n5 = n;
        int n6 = 0;
        int n7 = Math.min(n3, n2 - n5);
        if (EDTInitializer.debugCaret) {
            System.out.println("gnpm: getlen = " + n7);
        }
        cArray = baseDocument.getChars(n, n7);
        if (EDTInitializer.debugCaret) {
            System.out.println("gnpm: b4 loop: textlength = " + cArray.length + " dotpos = " + n);
            if (n7 > 0) {
                System.out.println("gnpm  firstchar = " + cArray[0]);
            }
        }
        while (cArray.length > 0) {
            if (EDTInitializer.debugCaret) {
                System.out.println("gnpm: begin loop: len = " + cArray.length);
            }
            if ((n6 = EDTCustomActions.findNextFF(cArray, 0, cArray.length)) != -1) {
                n4 = n5 + n6 + 1;
                if (!EDTInitializer.debugCaret) break;
                System.out.println("gnpm: leaving loop. found it. retval = " + n4);
                break;
            }
            n6 = 0;
            n7 = Math.min(n3, n2 - (n5 += n3));
            if (n7 < 0) break;
            if (EDTInitializer.debugCaret) {
                System.out.println("getlen = " + n7 + " docLen = " + n2 + " newOffset = " + n5);
            }
            cArray = baseDocument.getChars(n5, n7);
            if (!EDTInitializer.debugCaret) continue;
            System.out.println("gnpm: bottom loop: textlength = " + cArray.length + " newOffset = " + n5 + " firstchar = " + cArray[0]);
        }
        if (EDTInitializer.debugCaret) {
            System.out.println("gnpm: after loop: foundIdx = " + n6 + " newOffset = " + n5 + " retval =  " + n4);
        }
        return n4;
    }

    private static int getPreviousPageMark(JTextComponent jTextComponent, int n) throws BadLocationException {
        if (EDTInitializer.debugTrace) {
            System.out.println("edt trace: getPreviousPageMark - dotpos = " + n);
        }
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n2 = (Integer)baseDocument.getProperty((Object)"read-buffer-size");
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        int n6 = Math.min(n2, n4);
        n4 -= n6;
        if (EDTInitializer.debugCaret) {
            System.out.println("gppm: b4 loop: getlen = " + n6 + " newOffset = " + n4);
        }
        cArray = baseDocument.getChars(n4, n6);
        while (cArray.length > 0) {
            if (EDTInitializer.debugCaret) {
                String string = new String(cArray);
                System.out.println("gppm: looptop: Scanning string\n" + string.substring(0, Math.min(5, n6)) + " [...] " + " len = " + cArray.length);
            }
            if ((n5 = EDTCustomActions.findPrevFF(cArray, 0, cArray.length)) != -1) {
                n3 = n4 + n5;
                if (!EDTInitializer.debugCaret) break;
                System.out.println("gppm: leaving loop. found it. retval = " + n3 + "newoffset = " + n4 + " foundIdx = " + n5);
                break;
            }
            n5 = 0;
            n6 = Math.min(n2, n4);
            if (n6 < 0) break;
            cArray = baseDocument.getChars(n4 -= n6, n6);
            if (!EDTInitializer.debugCaret) continue;
            System.out.println("gppm: loopbottom: getlen = " + n6 + " newOffset = " + n4);
        }
        if (EDTInitializer.debugCaret) {
            System.out.println("gppm: after loop: foundIdx = " + n5 + " newOffset = " + n4 + " retval =  " + n3);
        }
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class GoldEnterActionJ14
    extends BaseAction {
        public GoldEnterActionJ14() {
            super("edt-gold-enter-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldEnterActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = null;
            if (n == 4) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-subst");
            }
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    public static class GoldDeleteActionJ14
    extends BaseAction {
        public GoldDeleteActionJ14() {
            super("edt-gold-delete-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldDeleteActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = null;
            if (n == 4) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-reset");
            } else if (!EDTInitializer.doNavPCKeys) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-reset");
            }
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    public static class GoldInsertActionJ14
    extends BaseAction {
        public GoldInsertActionJ14() {
            super("edt-gold-insert-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldinsertActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = null;
            if (n == 4) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-openline");
            } else if (!EDTInitializer.doNavPCKeys) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("find");
            }
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    public static class GoldEndActionJ14
    extends BaseAction {
        public GoldEndActionJ14() {
            super("edt-gold-end-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldendActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = null;
            if (n == 4) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-change-case");
            } else if (!EDTInitializer.doNavPCKeys) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-begin");
            }
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    public static class GoldHomeActionJ14
    extends BaseAction {
        public GoldHomeActionJ14() {
            super("edt-gold-home-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldhomeActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = null;
            if (n == 4) {
                return;
            }
            if (!EDTInitializer.doNavPCKeys) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("paste-from-clipboard");
            }
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    public static class GoldPageDownActionJ14
    extends BaseAction {
        public GoldPageDownActionJ14() {
            super("edt-gold-pgdown-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldpageDownActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = null;
            if (n == 4) {
                return;
            }
            if (!EDTInitializer.doNavPCKeys) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-end");
            }
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    public static class GoldPageUpActionJ14
    extends BaseAction {
        public GoldPageUpActionJ14() {
            super("edt-gold-pgup-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldpageUpActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = null;
            if (n == 4) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-cut-replace");
            } else if (!EDTInitializer.doNavPCKeys) {
                action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-copy");
            }
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }
    }

    public static class GoldDownArrowActionJ14
    extends BaseAction {
        public GoldDownArrowActionJ14() {
            super("edt-gold-down-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldDownArrowActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-del-eol") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-next-window");
            action.actionPerformed(actionEvent);
        }
    }

    public static class GoldUpArrowActionJ14
    extends BaseAction {
        public GoldUpArrowActionJ14() {
            super("edt-gold-up-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldUpArrowActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            if (n == 4) {
                return;
            }
            Action action = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-prev-window");
            action.actionPerformed(actionEvent);
        }
    }

    public static class GoldLeftArrowActionJ14
    extends BaseAction {
        public GoldLeftArrowActionJ14() {
            super("edt-gold-left-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldLeftArrowActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-end") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("shift-line-left");
            action.actionPerformed(actionEvent);
        }
    }

    public static class GoldRightArrowActionJ14
    extends BaseAction {
        public GoldRightArrowActionJ14() {
            super("edt-gold-right-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: GoldRightArrowActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("paste-from-clipboard") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("shift-line-right");
            action.actionPerformed(actionEvent);
        }
    }

    public static class DeleteActionJ14
    extends BaseAction {
        public DeleteActionJ14() {
            super("edt-delete-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: deleteActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-select") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("delete-next") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-select-toggle"));
            action.actionPerformed(actionEvent);
        }
    }

    public static class InsertActionJ14
    extends BaseAction {
        public InsertActionJ14() {
            super("edt-insert-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: insertActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-line") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("paste-from-clipboard") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-find-action"));
            action.actionPerformed(actionEvent);
        }
    }

    public static class EndActionJ14
    extends BaseAction {
        public EndActionJ14() {
            super("edt-end-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: endActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-word") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-endline") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-prev"));
            action.actionPerformed(actionEvent);
        }
    }

    public static class HomeActionJ14
    extends BaseAction {
        public HomeActionJ14() {
            super("edt-home-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: homeActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-page") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-begline") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("paste-from-clipboard"));
            action.actionPerformed(actionEvent);
        }
    }

    public static class PageDownActionJ14
    extends BaseAction {
        public PageDownActionJ14() {
            super("edt-pgdown-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: pageDownActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-char") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-next");
            action.actionPerformed(actionEvent);
        }
    }

    public static class PageUpActionJ14
    extends BaseAction {
        public PageUpActionJ14() {
            super("edt-pgup-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: pageUpActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-cut-append") : (EDTInitializer.doNavPCKeys ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-prev") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-cut"));
            action.actionPerformed(actionEvent);
        }
    }

    public static class DownArrowActionJ14
    extends BaseAction {
        public DownArrowActionJ14() {
            super("edt-down-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DownArrowActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-eol") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-down");
            action.actionPerformed(actionEvent);
        }
    }

    public static class UpArrowActionJ14
    extends BaseAction {
        public UpArrowActionJ14() {
            super("edt-up-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UpArrowActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-section") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-up");
            action.actionPerformed(actionEvent);
        }
    }

    public static class LeftArrowActionJ14
    extends BaseAction {
        public LeftArrowActionJ14() {
            super("edt-left-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: LeftArrowActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-advance") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-left");
            action.actionPerformed(actionEvent);
        }
    }

    public static class RightArrowActionJ14
    extends BaseAction {
        public RightArrowActionJ14() {
            super("edt-right-j14");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: RightArrowActionJ14");
            }
            KeyEvent keyEvent = (KeyEvent)jTextComponent.getClientProperty(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = EDTCustomActions.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            int n = keyEvent.getKeyLocation();
            if (EDTInitializer.debugVerbose) {
                System.out.println("keyLoc = " + (n == 4 ? " numpad" : " standard"));
            }
            Action action = n == 4 ? Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-cut") : Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-right");
            action.actionPerformed(actionEvent);
        }
    }

    public static class KeyCommaTypedAction
    extends BaseAction {
        public KeyCommaTypedAction() {
            super("edt-key-comma-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyCommaTypedAction");
            }
            Boolean bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (EDTInitializer.debugVerbose) {
                System.out.println("ignore flag = " + bl);
            }
            if (bl != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class KeyDecTypedAction
    extends BaseAction {
        public KeyDecTypedAction() {
            super("edt-key-dec-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyDecTypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class KeyPlusTypedAction
    extends BaseAction {
        public KeyPlusTypedAction() {
            super("edt-key-plus-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyPlusTypedAction");
            }
            Boolean bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (EDTInitializer.debugVerbose) {
                System.out.println("ignore flag = " + bl);
            }
            if (bl != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class KeySubtTypedAction
    extends BaseAction {
        public KeySubtTypedAction() {
            super("edt-key-subt-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeySubtTypedAction");
            }
            Boolean bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (EDTInitializer.debugVerbose) {
                System.out.println("ignore flag = " + bl);
            }
            if (bl != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class KeyMultTypedAction
    extends BaseAction {
        public KeyMultTypedAction() {
            super("edt-key-mult-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyMultTypedAction");
            }
            Boolean bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT);
            if (EDTInitializer.debugVerbose && bl == null) {
                System.out.println("flag is null");
            }
            if (bl != null && bl.booleanValue()) {
                if (EDTInitializer.debugVerbose) {
                    System.out.println("flag = " + bl);
                }
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class KeyDivTypedAction
    extends BaseAction {
        public KeyDivTypedAction() {
            super("edt-key-div-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: KeyDivTypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                if (EDTInitializer.debugVerbose) {
                    System.out.println("IGNORE_NEXT was true. returning.");
                }
                return;
            }
            if (EDTInitializer.debugVerbose) {
                System.out.println("IGNORE NEXT was not true: ");
                if (bl == null) {
                    System.out.println("b was null");
                }
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            if (EDTInitializer.debugTrace) {
                System.out.println(baseKit.getClass().getName());
            }
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num9TypedAction
    extends BaseAction {
        public Num9TypedAction() {
            super("edt-num9-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num9TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num8TypedAction
    extends BaseAction {
        public Num8TypedAction() {
            super("edt-num8-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num8TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num7TypedAction
    extends BaseAction {
        public Num7TypedAction() {
            super("edt-num7-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num7TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num6TypedAction
    extends BaseAction {
        public Num6TypedAction() {
            super("edt-num6-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num6TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num5TypedAction
    extends BaseAction {
        public Num5TypedAction() {
            super("edt-num5-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num5TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num4TypedAction
    extends BaseAction {
        public Num4TypedAction() {
            super("edt-num4-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num4TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num3TypedAction
    extends BaseAction {
        public Num3TypedAction() {
            super("edt-num3-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num3TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num2TypedAction
    extends BaseAction {
        public Num2TypedAction() {
            super("edt-num2-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num2TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num1TypedAction
    extends BaseAction {
        public Num1TypedAction() {
            super("edt-num1-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num1TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class Num0TypedAction
    extends BaseAction {
        public Num0TypedAction() {
            super("edt-num0-typed");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Boolean bl;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: Num0TypedAction");
            }
            if ((bl = (Boolean)this.getValue(EDTCustomActions.IGNORE_NEXT)) == null && EDTInitializer.debugVerbose) {
                System.out.println("flag not found");
            }
            if (bl != null && bl.booleanValue()) {
                this.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.FALSE);
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            Action action = baseKit.getActionByName("default-typed");
            action.actionPerformed(actionEvent);
        }
    }

    public static class CutActionNL
    extends BaseAction {
        public CutActionNL() {
            super("edt-cut-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: CutActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("cut-to-clipboard");
                object.actionPerformed(actionEvent);
                EDTCustomActions.ResetSelection(jTextComponent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('6'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class StartRangeActionNL
    extends BaseAction {
        public StartRangeActionNL() {
            super("edt-select-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: StartRangeActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-select");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('.'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class CutAppendActionNL
    extends BaseAction {
        public CutAppendActionNL() {
            super("edt-cut-append-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: CutAppendActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-cut-append");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('9'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class SectionActionNL
    extends BaseAction {
        public SectionActionNL() {
            super("edt-section-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: SectionActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-section");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('8'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class PageActionNL
    extends BaseAction {
        public PageActionNL() {
            super("edt-page-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: PageActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-page");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('7'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class ForwardDirectionActionNL
    extends BaseAction {
        public ForwardDirectionActionNL() {
            super("edt-advance-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: ForwardDirectionActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-advance");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('4'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class ReverseDirectionActionNL
    extends BaseAction {
        public ReverseDirectionActionNL() {
            super("edt-reverse-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: ReverseDirectionActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-reverse");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('5'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class CharActionNL
    extends BaseAction {
        public CharActionNL() {
            super("edt-char-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: CharActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-char");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('3'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class EolActionNL
    extends BaseAction {
        public EolActionNL() {
            super("edt-eol-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: EolActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-eol");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('2'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class WordActionNL
    extends BaseAction {
        public WordActionNL() {
            super("edt-word-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: WordActionNL");
            }
            try {
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-word");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('1'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class LineActionNL
    extends BaseAction {
        public LineActionNL() {
            super("edt-line-nl");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            try {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: LineActionNL");
                }
                object = Utilities.getKit((JTextComponent)jTextComponent).getActionByName("edt-line");
                object.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('0'));
            } else if (EDTInitializer.debugVerbose) {
                System.out.println("edt: km was null");
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            } else if (EDTInitializer.debugVerbose) {
                System.out.println("edt: action was null, flag not set");
            }
        }
    }

    public static class CopyAction
    extends BaseAction {
        public CopyAction() {
            super("edt-copy");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: CopyAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = baseKit.getActionByName("copy-to-clipboard");
                action.actionPerformed(actionEvent);
                EDTCustomActions.ResetSelection(jTextComponent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class CutAction
    extends BaseAction {
        public CutAction() {
            super("edt-cut");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: cutAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = baseKit.getActionByName("cut-to-clipboard");
                action.actionPerformed(actionEvent);
                EDTCustomActions.ResetSelection(jTextComponent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PreviousWindowAction
    extends BaseAction {
        public PreviousWindowAction() {
            super("edt-prev-window");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: PreviousWindowAction");
            }
            try {
                CallbackSystemAction callbackSystemAction = (CallbackSystemAction)CallbackSystemAction.findObject((Class)(class$org$openide$actions$PreviousTabAction == null ? (class$org$openide$actions$PreviousTabAction = EDTCustomActions.class$("org.openide.actions.PreviousTabAction")) : class$org$openide$actions$PreviousTabAction));
                callbackSystemAction.performAction();
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class NextWindowAction
    extends BaseAction {
        public NextWindowAction() {
            super("edt-next-window");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: NextWindowAction");
            }
            try {
                CallbackSystemAction callbackSystemAction = (CallbackSystemAction)CallbackSystemAction.findObject((Class)(class$org$openide$actions$NextTabAction == null ? (class$org$openide$actions$NextTabAction = EDTCustomActions.class$("org.openide.actions.NextTabAction")) : class$org$openide$actions$NextTabAction));
                callbackSystemAction.performAction();
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class DownPageAction
    extends BaseAction {
        public DownPageAction() {
            super("edt-next");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DownPageAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-page-down") : baseKit.getActionByName("page-down");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class UpPageAction
    extends BaseAction {
        public UpPageAction() {
            super("edt-prev");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UpPageAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-page-up") : baseKit.getActionByName("page-up");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class LeftCharAction
    extends BaseAction {
        public LeftCharAction() {
            super("edt-left");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: LeftCharAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-backward") : baseKit.getActionByName("caret-backward");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class RightCharAction
    extends BaseAction {
        public RightCharAction() {
            super("edt-right");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: RightCharAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-forward") : baseKit.getActionByName("caret-forward");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class DownLineAction
    extends BaseAction {
        public DownLineAction() {
            super("edt-down");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DownLineAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-down") : baseKit.getActionByName("caret-down");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class UpLineAction
    extends BaseAction {
        public UpLineAction() {
            super("edt-up");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UpLineAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-up") : baseKit.getActionByName("caret-up");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class HelpAction
    extends BaseAction {
        public HelpAction() {
            super("edt-help");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: HelpAction");
            }
            try {
                object = new HelpCtx("com-compaq-openvms-netbeans-edtkeypad-help_htm");
                if (EDTInitializer.debugVerbose) {
                    System.out.println("help = " + object);
                }
                TopManager.getDefault().showHelp((HelpCtx)object);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
            object = jTextComponent.getKeymap();
            Action action = null;
            if (object != null) {
                action = object.getAction(KeyStroke.getKeyStroke('/'));
            }
            if (action != null) {
                action.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
                if (EDTInitializer.debugVerbose) {
                    System.out.println("set IGNORE_NEXT to true. action = " + action.toString());
                }
            }
        }
    }

    public static class ResetAction
    extends BaseAction {
        public ResetAction() {
            super("edt-reset");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: resetAction");
            }
            EDTCustomActions.setStatusBarDirection(jTextComponent, "Forward");
            EDTCustomActions.ResetSelection(jTextComponent);
        }
    }

    public static class StartRangeWithToggleAction
    extends BaseAction {
        public StartRangeWithToggleAction() {
            super("edt-select-toggle");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: StartRangeWithToggleAction");
            }
            if (EDTInitializer.debugVerbose) {
                System.out.println("evt = " + actionEvent.toString());
            }
            if (bSelectionInProgress) {
                EDTCustomActions.ResetSelection(jTextComponent);
            }
            bSelectionInProgress = true;
        }
    }

    public static class StartRangeAction
    extends BaseAction {
        public StartRangeAction() {
            super("edt-select");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: StartRangeAction");
            }
            if (EDTInitializer.debugVerbose) {
                System.out.println("evt cmd = " + actionEvent.getActionCommand().toString());
            }
            bSelectionInProgress = true;
        }
    }

    public static class DelCharAction
    extends BaseAction {
        public DelCharAction() {
            super("edt-del-char");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            Keymap keymap;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DelCharAction");
            }
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    block14: {
                        keymap = Utilities.getDocument((JTextComponent)jTextComponent);
                        object = jTextComponent.getCaret();
                        int n = object.getDot();
                        if (EDTInitializer.debugCaret) {
                            System.out.println("edt: dotpos to delete = " + n);
                        }
                        try {
                            charBuffer = keymap.getChars(n, 1);
                            if (EDTInitializer.debugVerbose) {
                                System.out.println("edt: char to delete is: " + charBuffer[0]);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                badLocationException.printStackTrace();
                            }
                            if (!EDTInitializer.debugVerbose) break block14;
                            System.out.println("edt: BadLocationException");
                        }
                    }
                    BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                    Action action = baseKit.getActionByName("delete-next");
                    action.actionPerformed(actionEvent);
                }
                catch (Exception exception) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        exception.printStackTrace();
                    }
                    if (EDTInitializer.debugVerbose) {
                        System.out.println("edt: exception");
                    }
                    jTextComponent.getToolkit().beep();
                }
            }
            keymap = jTextComponent.getKeymap();
            object = null;
            if (keymap != null) {
                object = EDTInitializer.isDecKeyboard ? keymap.getAction(KeyStroke.getKeyStroke(',')) : keymap.getAction(KeyStroke.getKeyStroke('+'));
            }
            if (object != null) {
                object.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class DelWordAction
    extends BaseAction {
        public DelWordAction() {
            super("edt-del-word");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            Keymap keymap;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DelWordAction");
            }
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    keymap = Utilities.getDocument((JTextComponent)jTextComponent);
                    object = jTextComponent.getCaret();
                    int n = object.getDot();
                    int n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)keymap, (int)n);
                    if (n2 == n && (n2 = Utilities.getWordEnd((JTextComponent)jTextComponent, (int)n) + 1) == 0) {
                        n2 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n);
                    }
                    if (EDTInitializer.debugCaret) {
                        System.out.println("edt: " + EDTCustomActions.getStatusBarDirection(jTextComponent) + ": dot=" + n + " eowPos=" + n2);
                    }
                    wordBuffer = keymap.getChars(n, n2 - n);
                    keymap.remove(n, n2 - n);
                    if (EDTInitializer.debugCaret) {
                        String string = new String(wordBuffer);
                        System.out.println("edt: deleted word is: " + string);
                    }
                }
                catch (GuardedException guardedException) {
                    jTextComponent.getToolkit().beep();
                }
                catch (BadLocationException badLocationException) {}
            } else if (EDTInitializer.debugVerbose) {
                System.out.println("edt: no deleted word");
            }
            keymap = jTextComponent.getKeymap();
            object = null;
            if (keymap != null) {
                object = EDTInitializer.isVms ? keymap.getAction(KeyStroke.getKeyStroke('-')) : keymap.getAction(KeyStroke.getKeyStroke('+'));
            }
            if (object == null) {
                if (EDTInitializer.debugVerbose) {
                    System.out.println("edt: did not getAction");
                }
                return;
            }
            object.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            if (EDTInitializer.debugVerbose) {
                System.out.println("edt: kta= " + object.toString());
            }
        }
    }

    public static class CutAppendAction
    extends BaseAction {
        public CutAppendAction() {
            super("edt-cut-append");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: CutAppendAction");
            }
            try {
                EDTCustomActions.ResetSelection(jTextComponent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class TopAction
    extends BaseAction {
        public TopAction() {
            super("edt-begin");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: TopAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-begin") : baseKit.getActionByName("caret-begin");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class BottomAction
    extends BaseAction {
        public BottomAction() {
            super("edt-end");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: BottomAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-end") : baseKit.getActionByName("caret-end");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class SectionAction
    extends BaseAction {
        public SectionAction() {
            super("edt-section");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: SectionAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = EDTCustomActions.getStatusBarDirection(jTextComponent) == "Reverse" ? (bSelectionInProgress ? baseKit.getActionByName("selection-page-up") : baseKit.getActionByName("page-up")) : (bSelectionInProgress ? baseKit.getActionByName("selection-page-down") : baseKit.getActionByName("page-down"));
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PageAction
    extends BaseAction {
        public PageAction() {
            super("edt-page");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: PageAction");
            }
            if (jTextComponent != null) {
                try {
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    n = EDTCustomActions.getStatusBarDirection(jTextComponent) == "Reverse" ? EDTCustomActions.getPreviousPageMark(jTextComponent, n) : EDTCustomActions.getNextPageMark(jTextComponent, n);
                    if (bSelectionInProgress) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class WordAction
    extends BaseAction {
        public WordAction() {
            super("edt-word");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: WordAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = EDTCustomActions.getStatusBarDirection(jTextComponent) == "Reverse" ? (bSelectionInProgress ? baseKit.getActionByName("selection-previous-word") : baseKit.getActionByName("caret-previous-word")) : (bSelectionInProgress ? baseKit.getActionByName("selection-next-word") : baseKit.getActionByName("caret-next-word"));
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class OpenLineAction
    extends BaseAction {
        public OpenLineAction() {
            super("edt-openline");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: OpenLineAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = baseKit.getActionByName("insert-break");
                action.actionPerformed(actionEvent);
                action = baseKit.getActionByName("caret-up");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class ToggleCaseAction
    extends BaseAction {
        public ToggleCaseAction() {
            super("edt-change-case");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: ToggleCaseAction");
            }
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    if (caret.isSelectionVisible()) {
                        int n = jTextComponent.getSelectionStart();
                        int n2 = jTextComponent.getSelectionEnd();
                        Utilities.changeCase((BaseDocument)baseDocument, (int)n, (int)(n2 - n), (int)2);
                        caret.setSelectionVisible(false);
                        caret.setDot(n2);
                    } else {
                        int n = caret.getDot();
                        Utilities.changeCase((BaseDocument)baseDocument, (int)n, (int)1, (int)2);
                        if (EDTCustomActions.getStatusBarDirection(jTextComponent) == "Reverse") {
                            caret.setDot(n - 1);
                        } else {
                            caret.setDot(n + 1);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class LineAction
    extends BaseAction {
        public LineAction() {
            super("edt-line");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: LineAction");
            }
            try {
                Action action;
                String string;
                String string2;
                Object object;
                Object object2;
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                if (jTextComponent != null) {
                    object2 = Utilities.getDocument((JTextComponent)jTextComponent);
                    object = jTextComponent.getCaret();
                    n = object.getDot();
                    n2 = Utilities.getRowStart((JTextComponent)jTextComponent, (int)n);
                    n3 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n);
                    if (EDTInitializer.debugCaret) {
                        System.out.println("edt: " + EDTCustomActions.getStatusBarDirection(jTextComponent) + ": dot=" + n + " bol=" + n2 + " eolPos=" + n3);
                    }
                }
                if (bSelectionInProgress) {
                    object2 = "selection-up";
                    object = "selection-down";
                    string2 = "selection-line-first-column";
                    string = "selection-forward";
                } else {
                    object2 = "caret-up";
                    object = "caret-down";
                    string2 = "caret-line-first-column";
                    string = "caret-forward";
                }
                if (EDTCustomActions.getStatusBarDirection(jTextComponent) == "Reverse") {
                    action = n == n2 ? baseKit.getActionByName((String)object2) : baseKit.getActionByName(string2);
                } else if (n == n3) {
                    action = baseKit.getActionByName(string);
                } else {
                    if (n != n2) {
                        action = baseKit.getActionByName(string2);
                        action.actionPerformed(actionEvent);
                    }
                    action = baseKit.getActionByName((String)object);
                }
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class CutReplaceAction
    extends BaseAction {
        public CutReplaceAction() {
            super("edt-cut-replace");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: CutReplaceAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = baseKit.getActionByName("replace");
                action.actionPerformed(actionEvent);
                EDTCustomActions.ResetSelection(null);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class SubstBuffAction
    extends BaseAction {
        public SubstBuffAction() {
            super("edt-subst");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: SubstBuffAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = baseKit.getActionByName("replace");
                action.actionPerformed(actionEvent);
                EDTCustomActions.ResetSelection(null);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class UndoDelCharAction
    extends BaseAction {
        public UndoDelCharAction() {
            super("edt-undo-del-char");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block6: {
                if (EDTInitializer.debugTrace) {
                    System.out.println("edt trace: UndoDelCharAction");
                }
                try {
                    if (jTextComponent == null) break block6;
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                    if (baseDocument == null) break block6;
                    try {
                        String string = new String(charBuffer);
                        int n = caret.getDot();
                        baseDocument.insertString(n, string, null);
                        caret.setDot(n);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("edt: inserted buffer = " + string + "at location  " + caret.getDot());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
                catch (Exception exception) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class UndoDelWordAction
    extends BaseAction {
        public UndoDelWordAction() {
            super("edt-undo-del-word");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UndoDelWordAction");
            }
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                if (baseDocument != null) {
                    try {
                        if (wordBuffer != null) {
                            String string = new String(wordBuffer);
                            int n = caret.getDot();
                            baseDocument.insertString(n, string, null);
                            caret.setDot(n);
                            if (EDTInitializer.debugCaret) {
                                System.out.println("edt: inserted buffer = " + string + "at location  " + caret.getDot());
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class UndoDelLineAction
    extends BaseAction {
        public UndoDelLineAction() {
            super("edt-undo-del-line");
            if (EDTInitializer.debugVerbose) {
                System.out.println("edt: an action ctor - undo del line");
            }
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: UndoDelLineAction");
            }
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                if (baseDocument != null) {
                    if (EDTInitializer.debugVerbose) {
                        System.out.println("edt: inserting linebuffer");
                    }
                    try {
                        if (lineBuffer != null) {
                            String string = new String(lineBuffer);
                            int n = caret.getDot();
                            baseDocument.insertString(n, string, null);
                            caret.setDot(n);
                            if (EDTInitializer.debugCaret) {
                                System.out.println("edt: inserted buffer = " + string + "at location  " + caret.getDot());
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class DelLineAction
    extends BaseAction {
        public DelLineAction() {
            super("edt-del-line");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Object object;
            Keymap keymap;
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DelLineAction");
            }
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    keymap = Utilities.getDocument((JTextComponent)jTextComponent);
                    object = jTextComponent.getCaret();
                    int n = object.getDot();
                    int n2 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n) + 1;
                    n2 = Math.min(n2, keymap.getLength());
                    if (EDTInitializer.debugCaret) {
                        System.out.println("edt: " + EDTCustomActions.getStatusBarDirection(jTextComponent) + ": dot=" + n + " eolPos=" + n2);
                    }
                    lineBuffer = keymap.getChars(n, n2 - n);
                    keymap.remove(n, n2 - n);
                    if (EDTInitializer.debugCaret) {
                        String string = new String(lineBuffer);
                        System.out.println("edt: deleted line is: " + string);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            } else if (EDTInitializer.debugVerbose) {
                System.out.println("edt: no deleted line");
            }
            keymap = jTextComponent.getKeymap();
            object = null;
            if (keymap != null) {
                object = keymap.getAction(KeyStroke.getKeyStroke('-'));
            }
            if (object != null) {
                object.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
            }
        }
    }

    public static class FindAction
    extends BaseAction {
        public FindAction() {
            super("edt-find-action");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: FindAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = baseKit.getActionByName("find");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class FindNextAction
    extends BaseAction {
        public FindNextAction() {
            super("edt-find-next");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: FindNextAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = EDTCustomActions.getStatusBarDirection(jTextComponent) == "Reverse" ? baseKit.getActionByName("find-previous") : baseKit.getActionByName("find-next");
                action.actionPerformed(actionEvent);
                Keymap keymap = jTextComponent.getKeymap();
                Action action2 = null;
                if (keymap != null) {
                    action2 = keymap.getAction(KeyStroke.getKeyStroke('*'));
                }
                if (action2 != null) {
                    action2.putValue(EDTCustomActions.IGNORE_NEXT, Boolean.TRUE);
                }
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class CharAction
    extends BaseAction {
        public CharAction() {
            super("edt-char");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: CharAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = EDTCustomActions.getStatusBarDirection(jTextComponent) == "Reverse" ? (bSelectionInProgress ? baseKit.getActionByName("selection-backward") : baseKit.getActionByName("caret-backward")) : (bSelectionInProgress ? baseKit.getActionByName("selection-forward") : baseKit.getActionByName("caret-forward"));
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class DeleteToEolAction
    extends BaseAction {
        public DeleteToEolAction() {
            super("edt-del-eol");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: DeleteToEolAction");
            }
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    String string;
                    String string2 = null;
                    BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n);
                    if (EDTInitializer.debugCaret) {
                        System.out.println("DelToEol: dotPos=" + n + " eolPos=" + n2);
                    }
                    if (n == n2) {
                        string2 = baseDocument.getText(n, 1);
                        baseDocument.remove(n, 1);
                        n2 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("DelToEol2: dotPos=" + n + " eolPos=" + n2);
                        }
                    }
                    lineBuffer = baseDocument.getChars(n, n2 - n);
                    if (string2 != null) {
                        string = string2 + new String(lineBuffer);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("strLine = " + string);
                        }
                        lineBuffer = string.toCharArray();
                    }
                    baseDocument.remove(n, n2 - n);
                    if (EDTInitializer.debugCaret) {
                        string = new String(lineBuffer);
                        System.out.println("edt: deleted line is: " + string);
                    }
                }
                catch (GuardedException guardedException) {
                    jTextComponent.getToolkit().beep();
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class EndLnAction
    extends BaseAction {
        public EndLnAction() {
            super("edt-endline");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: EndLnAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-end-line") : baseKit.getActionByName("caret-end-line");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class BegLnAction
    extends BaseAction {
        public BegLnAction() {
            super("edt-begline");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: BegLnAction");
            }
            try {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                Action action = bSelectionInProgress ? baseKit.getActionByName("selection-begin-line") : baseKit.getActionByName("caret-begin-line");
                action.actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class EolAction
    extends BaseAction {
        public EolAction() {
            super("edt-eol");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: EolAction");
            }
            try {
                String string;
                Object object;
                Object object2;
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                if (jTextComponent != null) {
                    object2 = Utilities.getDocument((JTextComponent)jTextComponent);
                    object = jTextComponent.getCaret();
                    n = object.getDot();
                    n2 = Utilities.getRowStart((JTextComponent)jTextComponent, (int)n);
                    n3 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n);
                    if (EDTInitializer.debugCaret) {
                        System.out.println(EDTCustomActions.getStatusBarDirection(jTextComponent) + ": dot=" + n + " bol=" + n2 + " eolPos=" + n3);
                    }
                }
                if (bSelectionInProgress) {
                    object2 = "selection-down";
                    object = "selection-line-first-column";
                    string = "selection-end-line";
                } else {
                    object2 = "caret-down";
                    object = "caret-line-first-column";
                    string = "caret-end-line";
                }
                if (EDTCustomActions.getStatusBarDirection(jTextComponent) == "Reverse") {
                    Action action;
                    if (n2 == 0) {
                        return;
                    }
                    if (n != n2) {
                        action = baseKit.getActionByName((String)object);
                        action.actionPerformed(actionEvent);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("performed = " + action.toString());
                        }
                    }
                    action = baseKit.getActionByName("edt-left");
                    action.actionPerformed(actionEvent);
                    if (EDTInitializer.debugCaret) {
                        System.out.println("performed = " + action.toString());
                    }
                } else {
                    Action action;
                    if (n == n3) {
                        action = baseKit.getActionByName((String)object2);
                        action.actionPerformed(actionEvent);
                        if (EDTInitializer.debugCaret) {
                            System.out.println("performed = " + action.toString());
                        }
                    }
                    action = baseKit.getActionByName(string);
                    action.actionPerformed(actionEvent);
                    if (EDTInitializer.debugCaret) {
                        System.out.println("performed = " + action.toString());
                    }
                }
            }
            catch (Exception exception) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class ReverseDirectionAction
    extends BaseAction {
        public ReverseDirectionAction() {
            super("edt-reverse");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: ReverseDirectionAction");
            }
            EDTCustomActions.setStatusBarDirection(jTextComponent, "Reverse");
        }
    }

    public static class ForwardDirectionAction
    extends BaseAction {
        public ForwardDirectionAction() {
            super("edt-advance");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (EDTInitializer.debugTrace) {
                System.out.println("edt trace: ForwardDirectionAction");
            }
            EDTCustomActions.setStatusBarDirection(jTextComponent, "Forward");
        }
    }
}

