/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.util.MyMemoryHandler;
import org.netbeans.modules.distributed.util.MySimpleFormatter;
import org.netbeans.modules.distributed.util.MyStreamHandler;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.InputOutput;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Utils {
    public static final String REMOTE_AWARE = "REMOTE_AWARE";
    public static String OS_VMS = "OpenVMS";
    public static String JAVA_HOME_141_OVMS = "/SYS$COMMON/java$141/jre";
    public static String JDK_HOME_141_OVMS = "/SYS$COMMON/java$141";
    public static final String PUTALL_OUTPUT_PANE = " - Put All Files To the Server";
    public static final String GETALL_OUTPUT_PANE = " - Get All Files From the Server";
    public static final String SYNC_OUTPUT_PANE = " - Synchronize";
    public static final String REFRESH_OUTPUT_PANE = " - Refresh";
    public static final String REFRESH = "refresh";
    public static final String SYNC = "sync";
    public static final String GET_ALL = "getall";
    public static final String PUT_ALL = "putall";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public static void closeActiveEditorFile() {
        Set set = WindowManager.getDefault().getModes();
        HashSet<TopComponent> tcs = new HashSet<TopComponent>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Mode mode = (Mode)it.next();
            if (!mode.getDisplayName().equals("editor")) continue;
            tcs.add(mode.getSelectedTopComponent());
            break;
        }
        if (tcs.size() > 0) {
            it = tcs.iterator();
            while (it.hasNext()) {
                TopComponent tc = (TopComponent)it.next();
                if (tc == null) continue;
                tc.close();
            }
        }
    }

    public static boolean closeEditorFileObj(FileObject name) {
        Set set = WindowManager.getDefault().getModes();
        HashSet<TopComponent> tcs = new HashSet<TopComponent>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Mode mode = (Mode)it.next();
            if (!mode.getDisplayName().equals("editor")) continue;
            TopComponent[] cs = mode.getTopComponents();
            for (int i = 0; cs != null && i < cs.length; ++i) {
                tcs.add(cs[i]);
            }
        }
        if (tcs.size() > 0) {
            it = tcs.iterator();
            while (it.hasNext()) {
                TopComponent tc = (TopComponent)it.next();
                for (int i = 0; tc.getActivatedNodes() != null && i < tc.getActivatedNodes().length; ++i) {
                    Node node = tc.getActivatedNodes()[i];
                    DataObject dobj = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? Utils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    if (!dobj.getPrimaryFile().equals(name)) continue;
                    tc.close();
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean closeEditorFile(String name) {
        Set set = WindowManager.getDefault().getModes();
        HashSet<TopComponent> tcs = new HashSet<TopComponent>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Mode mode = (Mode)it.next();
            if (!mode.getDisplayName().equals("editor")) continue;
            TopComponent[] cs = mode.getTopComponents();
            for (int i = 0; cs != null && i < cs.length; ++i) {
                tcs.add(cs[i]);
            }
        }
        if (tcs.size() > 0) {
            it = tcs.iterator();
            while (it.hasNext()) {
                TopComponent tc = (TopComponent)it.next();
                for (int i = 0; tc.getActivatedNodes() != null && i < tc.getActivatedNodes().length; ++i) {
                    Node node = tc.getActivatedNodes()[i];
                    DataObject dobj = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? Utils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    if (!dobj.getPrimaryFile().getPackageNameExt('/', '.').equals(name)) continue;
                    tc.close();
                }
            }
        }
        return false;
    }

    public static boolean isEditorFile(String name) {
        Set set = WindowManager.getDefault().getModes();
        HashSet<TopComponent> tcs = new HashSet<TopComponent>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Mode mode = (Mode)it.next();
            if (!mode.getDisplayName().equals("editor")) continue;
            TopComponent[] cs = mode.getTopComponents();
            for (int i = 0; cs != null && i < cs.length; ++i) {
                tcs.add(cs[i]);
            }
        }
        if (tcs.size() > 0) {
            it = tcs.iterator();
            while (it.hasNext()) {
                TopComponent tc = (TopComponent)it.next();
                for (int i = 0; tc.getActivatedNodes() != null && i < tc.getActivatedNodes().length; ++i) {
                    Node node = tc.getActivatedNodes()[i];
                    DataObject dobj = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? Utils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    if (name.endsWith(".form")) {
                        name = name.substring(0, name.lastIndexOf(46)) + ".java";
                    }
                    if (!dobj.getPrimaryFile().getPackageNameExt('/', '.').equals(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getServerOS(RemoteRuntimeType rrt) {
        String os = "";
        if (rrt == null || rrt.getRemoteRuntime() == null) {
            return os;
        }
        try {
            os = rrt.getRemoteRuntime().getOperatingSystem();
        }
        catch (RemoteException re) {
            re.printStackTrace(System.err);
        }
        return os;
    }

    public static String getJavaHome() {
        return JAVA_HOME_141_OVMS;
    }

    public static String getJDKHome() {
        return JDK_HOME_141_OVMS;
    }

    public static int[] getIntIPAddress(InetAddress inetAddr) {
        String strAddr = inetAddr.toString();
        int[] ret = new int[4];
        int i = 0;
        if (strAddr.indexOf(47) >= 0) {
            strAddr = strAddr.substring(strAddr.indexOf(47) + 1);
        }
        StringTokenizer stok = new StringTokenizer(strAddr, ".");
        while (stok.hasMoreTokens()) {
            try {
                ret[i++] = Integer.parseInt(stok.nextToken());
            }
            catch (Exception e) {
                return null;
            }
        }
        return ret;
    }

    public static InetAddress findPublicInetAddress() throws SocketException, UnknownHostException {
        InetAddress faddr = InetAddress.getLocalHost();
        Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
        while (intfs.hasMoreElements()) {
            NetworkInterface intf = intfs.nextElement();
            Enumeration<InetAddress> addrs = intf.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                int[] addrbytes = Utils.getIntIPAddress(addr);
                if (addrbytes == null) {
                    return null;
                }
                if (addr.isLoopbackAddress() || addrbytes[0] == 10 || addrbytes[0] == 172 && addrbytes[1] < 32 && addrbytes[1] > 15 || addrbytes[0] == 192 && addrbytes[1] == 168) continue;
                faddr = addr;
            }
        }
        return faddr;
    }

    public static String getIntendedHostAddress() {
        String ipaddr = null;
        ipaddr = System.getProperty("java.rmi.server.hostname") != null ? System.getProperty("java.rmi.server.hostname") : Utils.getUsableInetAddress();
        return ipaddr;
    }

    public static String getUsableInetAddress() {
        try {
            InetAddress faddr = Utils.findPublicInetAddress();
            String strAddr = faddr.toString();
            if (strAddr.indexOf(47) >= 0) {
                strAddr = strAddr.substring(strAddr.indexOf(47) + 1);
            }
            return strAddr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getStatusLoggerID(String fsName, String action) {
        String fname = fsName + File.separatorChar + action;
        return fname;
    }

    public static String getStatusLoggerOutputPaneName(String fsName, String actionName) {
        if (actionName.equals(SYNC)) {
            return fsName + SYNC_OUTPUT_PANE;
        }
        if (actionName.equals(PUT_ALL)) {
            return fsName + PUTALL_OUTPUT_PANE;
        }
        if (actionName.equals(GET_ALL)) {
            return fsName + GETALL_OUTPUT_PANE;
        }
        if (actionName.equals(REFRESH)) {
            return fsName + REFRESH_OUTPUT_PANE;
        }
        return null;
    }

    public static synchronized Logger getStatusLogger(String fsName, String actionName) {
        String fname = Utils.getStatusLoggerID(fsName, actionName);
        return Logger.getLogger(fname);
    }

    public static synchronized Logger createStatusLogger(String fsName, String actionName) throws IOException {
        String fname = Utils.getStatusLoggerID(fsName, actionName);
        Logger logger = Logger.getLogger(fname);
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            logger.removeHandler(handlers[i]);
        }
        InputOutput io = null;
        String opaneName = Utils.getStatusLoggerOutputPaneName(fsName, actionName);
        if (opaneName != null) {
            io = TopManager.getDefault().getIO(opaneName, false);
        }
        if (io != null) {
            io.getOut().reset();
            io.closeInputOutput();
        }
        logger.addHandler(new MyMemoryHandler(new MyStreamHandler(System.out, new MySimpleFormatter()), 10000, Level.SEVERE));
        logger.setUseParentHandlers(false);
        return logger;
    }
}

