/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.core;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.distributed.remotefs.core.LogInfo;
import org.netbeans.modules.distributed.remotefs.core.RemoteClient;
import org.netbeans.modules.distributed.remotefs.core.RemoteFile;

public final class RemoteManager {
    private static Vector managers = new Vector();
    private Vector owners = new Vector();
    private File cacheroot = null;
    private RemoteFile root = null;
    private RemoteClient client;

    protected RemoteManager(RemoteOwner owner, LogInfo loginfo, File cache) throws IOException {
        this.owners.addElement(owner);
        this.cacheroot = cache;
        if (!this.cacheroot.exists()) {
            this.cacheroot.mkdirs();
        }
        this.client = owner.createClient(loginfo, cache);
    }

    public static RemoteManager getRemoteManager(RemoteOwner owner, File cache, LogInfo loginfo) throws IOException {
        boolean managerexist = false;
        RemoteManager manager = null;
        Enumeration enumeration = managers.elements();
        while (enumeration.hasMoreElements()) {
            manager = (RemoteManager)enumeration.nextElement();
            int compareresult = manager.getClient().compare(loginfo);
            if (compareresult == 0) {
                managerexist = true;
                if (cache.equals(manager.cacheroot) || owner.notifyIncorrectCache(manager.cacheroot)) break;
                return null;
            }
            if (compareresult <= 0) continue;
            owner.notifyIncorrectPassword();
            return null;
        }
        if (!managerexist) {
            manager = new RemoteManager(owner, loginfo, cache);
            managers.addElement(manager);
        } else {
            manager.owners.addElement(owner);
        }
        return manager;
    }

    public RemoteClient getClient() {
        return this.client;
    }

    public final void remove(RemoteOwner owner) {
        this.owners.removeElement(owner);
        if (this.owners.isEmpty()) {
            if (this.getClient().isConnected()) {
                this.getClient().disconnect();
            }
            managers.removeElement(this);
        }
    }

    public final boolean moreOwners() {
        return this.owners.size() > 1;
    }

    public RemoteFile getRoot() throws IOException {
        if (this.root == null) {
            this.root = ((RemoteOwner)this.owners.firstElement()).createRootFile(this.getClient(), this.cacheroot);
        }
        return this.root;
    }

    public RemoteFile getRoot(String startdir) throws IOException {
        RemoteFile f = this.getRoot().find(startdir);
        return f;
    }

    public static interface RemoteOwner {
        public RemoteClient createClient(LogInfo var1, File var2) throws IOException;

        public RemoteFile createRootFile(RemoteClient var1, File var2) throws IOException;

        public void notifyIncorrectPassword();

        public boolean notifyIncorrectCache(File var1);
    }
}

