/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.propertyeditors;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

public class RemoteFileSystemView
extends FileSystemView {
    public File createNewFolder(File containingDir) throws IOException {
        return FileSystemView.getFileSystemView().createNewFolder(containingDir);
    }

    public boolean isDrive(File f) {
        if (f.getAbsolutePath().length() == 3) {
            Enumeration enumeration = Repository.getDefault().fileSystems();
            while (enumeration.hasMoreElements()) {
                FileSystem fs = (FileSystem)enumeration.nextElement();
                if (!(fs instanceof NetworkFileSystem) || fs.getRoot().getName().toLowerCase().indexOf(f.getAbsolutePath().toLowerCase()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public File[] getRoots() {
        return FileSystemView.getFileSystemView().getRoots();
    }

    public boolean isHiddenFile(File f) {
        return true;
    }

    public boolean isRoot(File f) {
        return FileSystemView.getFileSystemView().isRoot(f);
    }

    public static void main(String[] args) {
        RemoteFileSystemView rfs = new RemoteFileSystemView();
        File[] files = rfs.getRoots();
        for (int i = 0; i < files.length; ++i) {
            System.out.println("root:" + files[i]);
        }
    }

    public static class RemoteFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "Filters out local drives";
        }
    }
}

