/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.distributed.rmi.protocol.RemoteData;
import org.netbeans.modules.distributed.rmi.protocol.RemoteErrorStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteInputStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteOutputStream;
import org.netbeans.modules.distributed.rmi.protocol.RemoteProcess;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RemoteProcessDescriptor
implements Serializable {
    private static final long serialVersionUID = -4535211234565221486L;
    private static ErrorManager execLog;
    private String processName;
    private String arguments;
    private String info;
    private RemoteRuntimeType rrt;

    public RemoteProcessDescriptor(String processName, String arguments) {
        this(processName, arguments, null);
    }

    public RemoteProcessDescriptor(String processName, String arguments, String info) {
        this.processName = processName;
        this.arguments = arguments;
        this.info = info;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getInfo() {
        return this.info;
    }

    public Process exec(Format format, String[] envp, String cwd) throws IOException {
        return this.exec(format, envp, false, cwd, false, Utils.getIntendedHostAddress());
    }

    public Process exec(Format format, String[] envp, boolean appendEnv, String cwd, boolean useXterm, String clientIP) throws IOException {
        String stringArgs = format == null ? this.arguments : format.format(this.arguments);
        String[] argsTmp = RemoteProcessDescriptor.parseArguments(stringArgs);
        String[] call = null;
        envp = RemoteProcessDescriptor.substituteEnv(format, envp);
        int size = 0;
        for (int i = 0; i < argsTmp.length; ++i) {
            if (argsTmp[i] == null || argsTmp[i].equals("")) continue;
            ++size;
        }
        String[] args = new String[size];
        for (int i = 0; i < size; ++i) {
            if (argsTmp[i] == null || argsTmp[i].equals("")) continue;
            args[i] = argsTmp[i];
        }
        call = new String[args.length + 1];
        call[0] = format == null ? this.processName : format.format(this.processName);
        System.arraycopy(args, 0, call, 1, args.length);
        RemoteProcessDescriptor.logArgs(call);
        if (envp != null && appendEnv) {
            int i;
            HashMap<String, Object> e = new HashMap<String, Object>(100);
            Iterator<Map.Entry<Object, Object>> it = System.getProperties().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String prop = (String)entry.getKey();
                if (!prop.startsWith("Env-")) continue;
                String evar = prop.substring(4);
                e.put(evar, entry.getValue());
            }
            for (i = 0; i < envp.length; ++i) {
                String nameval = envp[i];
                int idx = nameval.indexOf(61);
                if (idx == -1) {
                    throw new IOException("No equal sign in name=value: " + nameval);
                }
                e.put(nameval.substring(0, idx), nameval.substring(idx + 1));
            }
            envp = new String[e.size()];
            i = 0;
            it = e.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                envp[i++] = (String)entry.getKey() + '=' + (String)entry.getValue();
            }
        }
        int os = Utilities.getOperatingSystem();
        Thread currentThread = null;
        int currentPriority = 0;
        try {
            RemoteProcess rp;
            if (os == 4) {
                currentThread = Thread.currentThread();
                currentPriority = currentThread.getPriority();
                currentThread.setPriority(5);
            }
            byte[] ctx = new byte[4 + this.rrt.getSecurityContext().length];
            System.arraycopy(this.rrt.getSecurityContext(), 0, ctx, 4, this.rrt.getSecurityContext().length);
            if (this.isJavaCmd(call[0])) {
                System.arraycopy("JAVA".getBytes(), 0, ctx, 0, 4);
                rp = cwd != null ? this.rrt.getRemoteRuntime().exec(call, null, cwd, useXterm, clientIP, ctx) : this.rrt.getRemoteRuntime().exec(call, useXterm, clientIP, ctx);
            } else {
                System.arraycopy("DCLC".getBytes(), 0, ctx, 0, 4);
                String remoteCommand = call[0] + " " + stringArgs;
                rp = cwd != null ? this.rrt.getRemoteRuntime().exec(new String[]{remoteCommand}, null, cwd, useXterm, clientIP, ctx) : this.rrt.getRemoteRuntime().exec(remoteCommand, useXterm, clientIP, ctx);
            }
            RemoteProcessWrapper rpw = new RemoteProcessWrapper(rp);
            this.rrt.addRemoteProcess(rpw);
            RemoteProcessWrapper remoteProcessWrapper = rpw;
            return remoteProcessWrapper;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            throw new IOException(e.toString());
        }
        finally {
            if (os == 4) {
                currentThread.setPriority(currentPriority);
            }
        }
    }

    private static void logArgs(String[] args) {
        try {
            ResourceBundle rb = NbBundle.getBundle((String)"org.openide.execution.Bundle");
            String exc = rb.getString("CTL_Exec");
            String fmt = rb.getString("FMT_ExecParams");
            MessageFormat msgformat = new MessageFormat(fmt);
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            printer.println(exc);
            for (int i = 0; i < args.length; ++i) {
                printer.println(msgformat.format(new Object[]{new Integer(i), args[i]}));
            }
            printer.close();
            RemoteProcessDescriptor.getExecLog().log(1, writer.toString());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public Process exec(String[] cmdarray, RemoteRuntimeType rrt, String[] envp, String dir, boolean useXterm, String clientIP, byte[] ticket) throws IOException {
        this.rrt = rrt;
        byte[] ctx = new byte[4 + rrt.getSecurityContext().length];
        System.arraycopy(rrt.getSecurityContext(), 0, ctx, 4, rrt.getSecurityContext().length);
        System.arraycopy("DCLC".getBytes(), 0, ctx, 0, 4);
        RemoteProcess rp = rrt.getRemoteRuntime().exec(cmdarray, envp, dir, useXterm, clientIP, ctx);
        RemoteProcessWrapper rpw = new RemoteProcessWrapper(rp);
        rrt.addRemoteProcess(rpw);
        return rpw;
    }

    public Process exec(Format format, RemoteRuntimeType rrt, boolean useXterm, String cwd, String clientIP) throws IOException {
        this.rrt = rrt;
        return this.exec(format, null, false, cwd, useXterm, clientIP);
    }

    public Process exec() throws IOException {
        return this.exec(null, null, false, null, Utils.getIntendedHostAddress());
    }

    public int hashCode() {
        return this.processName.hashCode() + this.arguments.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteProcessDescriptor)) {
            return false;
        }
        RemoteProcessDescriptor him = (RemoteProcessDescriptor)o;
        return this.processName.equals(him.processName) && this.arguments.equals(him.arguments);
    }

    private static String[] parseArguments(String sargs) {
        return Utilities.parseParameters((String)sargs);
    }

    private static ErrorManager getExecLog() {
        if (execLog == null) {
            execLog = ErrorManager.getDefault().getInstance("IDE-Exec");
        }
        return execLog;
    }

    private boolean isJavaCmd(String processName) {
        return processName.endsWith("/java") || processName.endsWith("/javac");
    }

    private static String[] substituteEnv(Format format, String[] envp) {
        if (envp == null || envp.length == 0 || format == null) {
            return envp;
        }
        String[] ret = new String[envp.length];
        StringBuffer adder = new StringBuffer();
        for (int i = 0; i < envp.length; ++i) {
            int idx;
            ret[i] = envp[i];
            if (ret[i] == null || (idx = ret[i].indexOf(61)) < 0) continue;
            String val = ret[i].substring(idx + 1);
            String key = ret[i].substring(0, idx);
            adder.append(key).append('=').append(format.format(val));
            ret[i] = adder.toString();
            adder.setLength(0);
        }
        return ret;
    }

    public class RemoteProcessWrapper
    extends Process {
        RemoteProcess rp;

        public RemoteProcessWrapper(RemoteProcess rp) {
            this.rp = rp;
        }

        public void destroy() {
            try {
                this.rp.destroy();
                RemoteProcessDescriptor.this.rrt.removeRemoteProcess(this);
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().log(e.getMessage());
            }
            catch (Exception e) {
                ErrorManager.getDefault().log(e.getMessage());
            }
        }

        public int exitValue() {
            try {
                int ret = this.rp.exitValue();
                System.err.println("distnb:remoteprocess:vms ret code:" + ret);
                if (ret % 2 == 0) {
                    return 1;
                }
                return 0;
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return -1;
            }
        }

        public InputStream getErrorStream() {
            try {
                return new RemoteErrorStreamWrapper(this.rp.getErrorStream());
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }

        public InputStream getInputStream() {
            try {
                return new RemoteInputStreamWrapper(this.rp.getInputStream());
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }

        public OutputStream getOutputStream() {
            try {
                return new RemoteOutputStreamWrapper(this.rp.getOutputStream());
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }

        public int waitFor() {
            try {
                int ret = this.rp.waitFor();
                System.err.println("distnb:remoteprocess:vms ret code:" + ret);
                if (ret == 1076) {
                    return ret;
                }
                if (ret == 98954) {
                    return ret;
                }
                if (ret % 2 == 0) {
                    return 1;
                }
                return 0;
            }
            catch (RemoteException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return -1;
            }
        }
    }

    public static class RemoteOutputStreamWrapper
    extends OutputStream {
        RemoteOutputStream re;

        public RemoteOutputStreamWrapper(RemoteOutputStream re) {
            this.re = re;
        }

        public void close() throws IOException {
            try {
                this.re.close();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void flush() throws IOException {
            try {
                this.re.flush();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void write(int param) throws IOException {
            try {
                this.re.write(param);
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.re.write(b, off, len);
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void write(byte[] b) throws IOException {
            try {
                this.re.write(b);
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }
    }

    public static class RemoteErrorStreamWrapper
    extends InputStream {
        RemoteErrorStream re;

        public RemoteErrorStreamWrapper(RemoteErrorStream re) {
            this.re = re;
        }

        public int available() throws IOException {
            try {
                return this.re.available();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                this.re.close();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void mark(int readlimit) {
            try {
                this.re.mark(readlimit);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean markSupported() {
            try {
                return this.re.markSupported();
            }
            catch (RemoteException rex) {
                return false;
            }
        }

        public int read() throws IOException {
            try {
                return this.re.read();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                return this.read(b, 0, b.length);
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                RemoteData rData = this.re.read(b, off, len);
                System.arraycopy(rData.getData(), off, b, off, len);
                return rData.getReturn();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void reset() throws IOException {
            try {
                this.re.reset();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public long skip(long n) throws IOException {
            try {
                return this.re.skip(n);
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }
    }

    public static class RemoteInputStreamWrapper
    extends InputStream {
        RemoteInputStream re;

        public RemoteInputStreamWrapper(RemoteInputStream re) {
            this.re = re;
        }

        public int available() throws IOException {
            try {
                return this.re.available();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                this.re.close();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void mark(int readlimit) {
            try {
                this.re.mark(readlimit);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean markSupported() {
            try {
                return this.re.markSupported();
            }
            catch (RemoteException rex) {
                return false;
            }
        }

        public int read() throws IOException {
            try {
                return this.re.read();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                return this.read(b, 0, b.length);
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                RemoteData rData = this.re.read(b, off, len);
                System.arraycopy(rData.getData(), off, b, off, len);
                return rData.getReturn();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public void reset() throws IOException {
            try {
                this.re.reset();
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }

        public long skip(long n) throws IOException {
            try {
                return this.re.skip(n);
            }
            catch (RemoteException rex) {
                throw new IOException(rex.getMessage());
            }
        }
    }
}

