/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.distributed.execute.RemoteExecutor;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.property.RemoteNbClassPath;
import org.netbeans.modules.distributed.propertyeditors.ErrorExpressionEditor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.util.FileUtility;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class RemoteAntExecutor
extends RemoteExecutor {
    private String target = "";
    private static final long serialVersionUID = 4921782425409448322L;
    public static final String PROP_CLASSPATH = "classPath";
    private static final RemoteNbClassPath EMPTY_CLASSPATH = new RemoteNbClassPath("");
    private RemoteNbClassPath classPath;

    public RemoteAntExecutor() {
        this.setRemoteExecutor(this.getExternalExecutor());
        this.setErrorExpression(ErrorExpressionEditor.antErrorExpression);
        String antPath = "{ant.lib}{/}ant.jar";
        String jdkToolsPath = "{jdk.home}{/}lib{/}tools.jar";
        String vmsPath = "{ant.lib}{/}vmstask.jar";
        this.setClassPath(new RemoteNbClassPath(new String[]{antPath, jdkToolsPath, vmsPath}));
    }

    public RemoteNbClassPath getClassPath() {
        RemoteNbClassPath p = this.classPath;
        if (p != null) {
            return p;
        }
        return EMPTY_CLASSPATH;
    }

    public synchronized void setClassPath(RemoteNbClassPath path) {
        RemoteNbClassPath old = this.classPath;
        this.classPath = path;
        this.firePropertyChange(PROP_CLASSPATH, old, this.classPath);
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        if (this.remoteExecutor == null) {
            NbProcessDescriptor nbp = this.createDescriptor();
            this.remoteExecutor = new RemoteProcessDescriptor(nbp.getProcessName(), nbp.getArguments(), NbBundle.getBundle((Class)RemoteExecutor.class).getString("MSG_RemoteAntExecutorHint"));
        }
        return this.remoteExecutor;
    }

    protected NbProcessDescriptor createDescriptor() {
        return new NbProcessDescriptor("pipe ant == \"@ide$ant_home:ide_ant.com\" ; ant", "{basedir} \"-emacs\" {file} {target}", NbBundle.getBundle((Class)ProcessExecutor.class).getString("MSG_ExecutorHint"));
    }

    protected void createDefaultMapFormat(DataObject obj, String target) throws IOException {
        AbstractNetworkFileSystem nfs = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
            Map map = super.createMapFormat(obj, nfs).getMap();
            String fileName = (String)map.get("file");
            fileName = FileUtility.openVMSPathToUnixPath(fileName, false);
            String baseDir = (String)obj.getPrimaryFile().getAttribute("REMOTE_ANT_BASE_DIR");
            if (baseDir == null || baseDir.equals("")) {
                baseDir = null;
            } else if (baseDir.indexOf("^") < 0) {
                baseDir = FileUtility.openVMSPathToUnixPath(baseDir, true);
            }
            this.format = new JFormat(this.getClassPath(), fileName, target, baseDir, obj);
        }
        catch (FileStateInvalidException exp) {
        }
        catch (IOException e) {
            throw e;
        }
    }

    public ExecutorTask execute(DataObject obj, String target) throws IOException {
        this.createDefaultMapFormat(obj, target);
        this.setChangeWorkingDir(true);
        return super.execute(obj);
    }

    public void setWorkingDirectory(File buildDir) throws IOException {
        boolean found = false;
        if (buildDir != null) {
            FileObject[] fobjs = FileUtil.fromFile((File)buildDir);
            for (int j = 0; j < fobjs.length; ++j) {
                try {
                    if (!(fobjs[j].getFileSystem() instanceof NetworkFileSystem) && !(fobjs[j].getFileSystem() instanceof FTPFileSystem)) continue;
                    found = true;
                    break;
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
            }
        }
        if (found || buildDir == null) {
            File old = this.workingDirectory;
            this.workingDirectory = buildDir;
            this.firePropertyChange("workingDirectory", old, this.workingDirectory);
        } else {
            String msg = "You can only add Remote File System";
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        }
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ExecutorTask execute(ExecInfo info) throws IOException {
        throw new IOException("unimplemented");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.distributed.RemoteExecutor");
    }

    public static class JFormat
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        public static final String ANT_HOME = "ant.home";
        public static final String ANT_LIB = "ant.lib";
        public static final String ANT_SCRIPT = "file";
        public static final String ANT_TARGET = "target";
        public static final String ANT_BASE_DIR = "basedir";
        static final long serialVersionUID = -1524637220865300001L;

        public JFormat(RemoteNbClassPath classPath, String fileName, String target, String baseDir, DataObject dobj) {
            super(new HashMap());
            Map map = this.getMap();
            map.put(TAG_SEPARATOR, TAG_SEPARATOR);
            map.put(TAG_PATHSEPARATOR, TAG_PATHSEPARATOR);
            String pClassPath = this.format(classPath.getRemoteClassPath());
            map.put(TAG_CLASSPATH, pClassPath);
            if (target != null) {
                map.put(ANT_TARGET, "\"" + target + "\"");
            } else {
                map.put(ANT_TARGET, "");
            }
            if (fileName != null) {
                map.put(ANT_SCRIPT, "\"-buildfile\" \"" + fileName + "\"");
            } else {
                map.put(ANT_SCRIPT, "");
            }
            if (baseDir != null) {
                map.put(ANT_BASE_DIR, "\"-Dbasedir=" + baseDir + "\"");
            } else {
                map.put(ANT_BASE_DIR, "");
            }
        }
    }
}

