/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import org.openide.ServiceType;
import org.openide.actions.AbstractCompileAction;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerType;
import org.openide.cookies.CompilerCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CompilerSupport
implements CompilerCookie {
    private static final String EA_COMPILER_MANAGER = "NetBeansAttrDataObjectCompilerManager";
    public static final String PROP_COMPILER_TYPE = "compiler";
    private MultiDataObject.Entry entry;
    private Class cookie;
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;

    protected CompilerSupport(MultiDataObject.Entry entry, Class clazz) {
        this.entry = entry;
        this.cookie = clazz;
    }

    public boolean isDepthSupported(Compiler.Depth depth) {
        return Compiler.DEPTH_ONE == depth;
    }

    public void addToJob(CompilerJob compilerJob, Compiler.Depth depth) {
        CompilerType compilerType = CompilerSupport.getCompilerType(this.entry);
        if (compilerType == null) {
            compilerType = this.defaultCompilerType();
        }
        if (compilerType == null) {
            throw new IllegalStateException(this.getClass().getName() + ".defaultCompilerType returned null");
        }
        compilerType.prepareJob(compilerJob, this.cookie, (DataObject)this.entry.getDataObject());
    }

    protected CompilerType defaultCompilerType() {
        return CompilerType.getDefault();
    }

    public static void setCompilerType(MultiDataObject.Entry entry, CompilerType compilerType) throws IOException {
        entry.getFile().setAttribute(EA_COMPILER_MANAGER, (Object)(compilerType == null ? null : new ServiceType.Handle((ServiceType)compilerType)));
    }

    public static CompilerType getCompilerType(MultiDataObject.Entry entry) {
        Object object = entry.getFile().getAttribute(EA_COMPILER_MANAGER);
        if (object == null || !(object instanceof ServiceType.Handle)) {
            return null;
        }
        ServiceType serviceType = ((ServiceType.Handle)object).getServiceType();
        if (serviceType instanceof CompilerType) {
            return (CompilerType)serviceType;
        }
        Lookup lookup = Environment.find((DataObject)entry.getDataObject());
        return (CompilerType)((Object)lookup.lookup(CompilerType.class));
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createCompilerProperty());
    }

    public static void prepareJob(CompilerJob compilerJob, Enumeration enumeration, Class clazz, Compiler.Depth depth) {
        AbstractCompileAction.prepareJobFor(compilerJob, enumeration, clazz, depth);
    }

    private PropertySupport createCompilerProperty() {
        return new PropertySupport.ReadWrite(PROP_COMPILER_TYPE, CompilerType.class, NbBundle.getMessage((Class)Compiler.class, (String)"PROP_compilerType"), NbBundle.getMessage((Class)Compiler.class, (String)"HINT_compilerType")){

            public Object getValue() {
                CompilerType compilerType = CompilerSupport.getCompilerType(CompilerSupport.this.entry);
                if (compilerType == null) {
                    return CompilerSupport.this.defaultCompilerType();
                }
                return compilerType;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    CompilerSupport.setCompilerType(CompilerSupport.this.entry, (CompilerType)((Object)object));
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean bl = (Boolean)CompilerSupport.this.entry.getFile().getAttribute(CompilerSupport.READONLY_ATTRIBUTES);
                return bl == null ? false : bl == false;
            }
        };
    }

    public static class Clean
    extends CompilerSupport
    implements CompilerCookie.Clean {
        public Clean(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = CompilerSupport.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean);
        }
    }

    public static class Build
    extends CompilerSupport
    implements CompilerCookie.Build {
        public Build(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = CompilerSupport.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build);
        }
    }

    public static class Compile
    extends CompilerSupport
    implements CompilerCookie.Compile {
        public Compile(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = CompilerSupport.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        }
    }
}

