/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.netbeans.modules.distributed.common.cookies.RemoteExecCookie;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.openide.LifecycleManager;
import org.openide.actions.ExecuteAction;
import org.openide.cookies.CompilerCookie;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import patchsources.OpenProjectList_Dist;

public class RemoteExecuteAction
extends NodeAction {
    public String getName() {
        return "Remote Execute";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Class[] cookieClasses() {
        return new Class[]{CompilerCookie.class};
    }

    protected String iconResource() {
        return "org/netbeans/modules/distributed/resources/remexecute.gif";
    }

    private static void refreshFS() {
        for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
            if (fs.isReadOnly() || !(fs instanceof AbstractNetworkFileSystem)) continue;
            fs.refresh(false);
        }
    }

    protected void performAction(Node[] activatedNodes) {
        final Node[] anodes = activatedNodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteExecuteAction.refreshFS();
                RemoteExecuteAction.this.execute3GL(anodes);
                RemoteExecuteAction.refreshFS();
            }
        });
    }

    public void actionPerformed(ActionEvent evt) {
        Object s = evt == null ? null : evt.getSource();
        Node[] nodes = null;
        if (s instanceof Node) {
            Node node = (Node)s;
            nodes = new Node[]{node};
        } else {
            nodes = s instanceof Node[] ? (Node[])s : super.getActivatedNodes();
        }
        final Node[] anodes = nodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteExecuteAction.refreshFS();
                RemoteExecuteAction.this.execute3GL(anodes);
            }
        });
    }

    private void execute3GL(Node[] nodes) {
        if (DistributedSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        HashSet<RemoteExecCookie> execute = new HashSet<RemoteExecCookie>();
        for (int i = 0; i < nodes.length; ++i) {
            RemoteExecCookie exec = (RemoteExecCookie)nodes[i].getCookie(RemoteExecCookie.class);
            if (exec == null) continue;
            execute.add(exec);
        }
        if (execute.size() > 0) {
            ExecuteAction.execute(execute.iterator());
        }
    }

    protected boolean enable(Node[] node) {
        int nodeCnt = 0;
        if (node.length == 0) {
            return false;
        }
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(DataObject.class);
            if (dobj == null) {
                return false;
            }
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            try {
                if (!(dobj.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem) && !(dobj.getPrimaryFile().getFileSystem() instanceof FTPFileSystem)) {
                    return false;
                }
            }
            catch (FileStateInvalidException e) {
                return false;
            }
            if (dobj.getCookie(RemoteExecCookie.class) == null) continue;
            ++nodeCnt;
        }
        return nodeCnt == node.length;
    }

    protected boolean asynchronous() {
        return false;
    }
}

