/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.DisconnectCallBack;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPDialogs;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPSettings;
import org.netbeans.modules.distributed.remotefs.ftpfs.FileStatusInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.LogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteCompileAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteExecuteAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.Sync;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPLogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.logs.FTPBrowserChildren;
import org.netbeans.modules.distributed.remotefs.ftpfs.logs.FTPBrowserNode;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.modules.InstalledFileLocator;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import patchsources.OpenProjectList_Dist;

public class FTPFileSystem
extends RemoteFileSystem
implements FTPClient.Reconnect,
AbstractNetworkFileSystem,
FileSystem.HtmlStatus,
LookupListener,
FileStatusListener {
    static final long serialVersionUID = -981665601872580022L;
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 1;
    private static final boolean DEBUG = true;
    private static final String FTPWORK = System.getProperty("netbeans.user") + File.separator + "ftpcache";
    private static RequestProcessor statusRequestProcessor;
    private static final Object STATUS_REQUEST_PROCESSOR_LOCK;
    private FTPSettings ftpsettings = (FTPSettings)SystemOption.findObject(FTPSettings.class, (boolean)true);
    private Boolean useXtermCompile;
    private Boolean useXtermExecution;
    private int refCount;
    private RemoteRuntimeType remoteRuntimeType;
    private boolean justSerialized = false;
    private transient String hostName;
    private transient String userName;
    private transient Lookup.Result annotationProviders;
    private transient Collection previousProviders;
    private static final Pattern lt;
    private static final Pattern gt;

    public FTPFileSystem(String hostName, String userName, int ftpPort, String cachedir, String startdir, boolean useSSHForwarding, boolean isPassiveMode) throws IOException {
        this.loginfo = new FTPLogInfo(hostName, ftpPort, userName, null);
        FTPClient.removeFromFailedAttempts(hostName, userName);
        this.cachedir = new File(cachedir);
        this.startdir = startdir;
        this.SSHForwarding = useSSHForwarding;
        this.ftpPassiveMode = isPassiveMode;
        this.hostName = hostName;
        this.userName = userName;
        this.getFTPSettings().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                FTPFileSystem.this.ftpSettingsChanged(event);
            }
        });
        this.addedFS((FileSystem)this);
    }

    public void resultChanged(LookupEvent ev) {
        HashSet add;
        HashSet now = this.annotationProviders.allInstances();
        if (this.previousProviders != null) {
            add = new HashSet(now);
            add.removeAll(this.previousProviders);
            HashSet toRemove = new HashSet(this.previousProviders);
            toRemove.removeAll(now);
            for (AnnotationProvider ap : toRemove) {
                if (ap.getInterceptionListener() instanceof FileChangeListener) {
                    this.removeFileChangeListener((FileChangeListener)ap.getInterceptionListener());
                }
                ap.removeFileStatusListener((FileStatusListener)this);
            }
        } else {
            add = now;
        }
        for (AnnotationProvider ap : add) {
            if (ap.getInterceptionListener() instanceof FileChangeListener) {
                this.addFileChangeListener((FileChangeListener)ap.getInterceptionListener());
            }
            try {
                ap.addFileStatusListener((FileStatusListener)this);
            }
            catch (TooManyListenersException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        this.previousProviders = now;
    }

    public static void refreshFTPLogs() {
        try {
            FileSystem defaultFileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = defaultFileSystem.findResource("UI/Runtime");
            DataFolder df = (DataFolder)DataObject.find((FileObject)fo);
            Lookup l = new FolderLookup((DataObject.Container)df).getLookup();
            FTPBrowserNode node = (FTPBrowserNode)((Object)l.lookup(FTPBrowserNode.class));
            ((FTPBrowserChildren)node.getChildren()).refreshKeys2();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SystemAction[] getActions(Set foSet) {
        Action[] retVal = null;
        if (this.annotationProviders == null) {
            String user_system = this.loginfo.displayName().substring(6);
            String[] info = user_system.split("@");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("No Matching server with Host : " + info[1] + " and User : " + info[0] + " Found.\nPlease go to Services Tab and add remote server"), 1));
            System.exit(1);
        }
        Iterator it = this.annotationProviders.allInstances().iterator();
        while (retVal == null && it.hasNext()) {
            AnnotationProvider ap = (AnnotationProvider)it.next();
            retVal = ap.actions(foSet);
        }
        if (retVal == null) {
            retVal = new Action[]{};
        }
        SystemAction[] ret = new SystemAction[retVal.length];
        for (int i = 0; i < retVal.length; ++i) {
            ret[i] = (SystemAction)retVal[i];
        }
        SystemAction[] defaultActions = super.getActions();
        SystemAction[] allActions = new SystemAction[defaultActions.length + ret.length + 2];
        System.arraycopy(defaultActions, 0, allActions, 0, defaultActions.length);
        SystemAction[] newActions = new SystemAction[]{SystemAction.get(RemoteCompileAction.class), SystemAction.get(RemoteExecuteAction.class)};
        System.arraycopy(newActions, 0, allActions, defaultActions.length, 2);
        System.arraycopy(ret, 0, allActions, defaultActions.length + 2, ret.length);
        return allActions;
    }

    public SystemAction[] getActions() {
        SystemAction[] defaultActions = super.getActions();
        SystemAction[] allActions = new SystemAction[defaultActions.length + 2];
        System.arraycopy(defaultActions, 0, allActions, 0, defaultActions.length);
        SystemAction[] newActions = new SystemAction[]{SystemAction.get(RemoteCompileAction.class), SystemAction.get(RemoteExecuteAction.class)};
        System.arraycopy(newActions, 0, allActions, defaultActions.length, 2);
        return allActions;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        RemoteRuntimeType ret = DistributedSettings.getDefault().findRemoteRuntime(this.hostName, this.userName);
        return ret;
    }

    public boolean getUseXtermCompile() {
        if (this.useXtermCompile == null) {
            return DistributedSettings.getDefault().getUseXtermCompile();
        }
        return this.useXtermCompile;
    }

    public void setUseXtermCompile(boolean useX) {
        this.useXtermCompile = new Boolean(useX);
        this.firePropertyChange("useXtermCompile", null, this.useXtermCompile);
    }

    public boolean getUseXtermExecution() {
        if (this.useXtermExecution == null) {
            return DistributedSettings.getDefault().getUseXtermExecution();
        }
        return this.useXtermExecution;
    }

    public void setUseXtermExecution(boolean useX) {
        this.useXtermExecution = new Boolean(useX);
        this.firePropertyChange("useXtermExecution", null, this.useXtermExecution);
    }

    public String getRemoteRoot() {
        return this.getRootFile();
    }

    public String getLocalRoot() {
        return this.getCache().getAbsolutePath();
    }

    private void deleteClientFiles(File file, String name) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                this.deleteClientFiles(files[i], name + "/" + file.getAbsolutePath());
            }
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getAbsolutePath());
            file.delete();
        } else {
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getAbsolutePath());
            if (file.delete()) {
                this.setFileAttribute(name, "ftp_cache_lastmodified", null);
                this.setFileAttribute(name, "ftp_remote_lastmodified", null);
                this.setFileAttribute(name, "file_residence_mode", null);
            }
        }
    }

    private void deleteServerFiles(RemoteFileName file, String name) throws IOException {
        if (file.isDirectory()) {
            RemoteFileAttributes[] files = this.client.list(file);
            for (int i = 0; files != null && i < files.length; ++i) {
                this.deleteServerFiles(files[i].getName(), name + "/" + files[i].getName().getName());
            }
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getFullName());
            this.client.rmdir(file);
        } else {
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getFullName());
            this.client.delete(file);
            this.setFileAttribute(name, "ftp_cache_lastmodified", null);
            this.setFileAttribute(name, "ftp_remote_lastmodified", null);
            this.setFileAttribute(name, "file_residence_mode", null);
        }
    }

    public void delete(String name) throws IOException {
        FTPFileName ftpName;
        RemoteFileAttributes fileAt;
        if ((name = name.replace('/', '\\')).endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
            new File(this.getLocalRoot(), name).delete();
            return;
        }
        this.isReadyToModify();
        File local = new File(this.getLocalRoot(), name);
        boolean isDir = local.isDirectory();
        this.deleteClientFiles(local, name);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("REMOTE_ROOT", this.getRemoteRoot());
        map.put("LCOAL_ROOT", this.getCache().getAbsolutePath());
        String server = FileUtility.winPathToOpenVMSPath(local.getAbsolutePath(), false, map);
        server = FileUtility.openVMSPathToUnixPath(server, false);
        if (server.endsWith(".")) {
            server = server.substring(0, server.length() - 1);
        }
        if ((fileAt = this.client.listFile("", ftpName = new FTPFileName("", server, isDir))) != null && fileAt.getDate().getTime() != 0L) {
            if (fileAt.isDirectory()) {
                this.deleteServerFiles(new FTPFileName("", server, true), name);
            } else {
                this.deleteServerFiles(new FTPFileName("", server, false), name);
            }
        }
    }

    public static void refreshParent(String fileName, String root, char sep, FileSystem fs) {
        String parent = fileName.substring(root.length() + 1);
        parent = parent.lastIndexOf(sep) > 0 ? parent.substring(0, parent.lastIndexOf(sep)).replace(sep, '/') : "";
        FileObject pfo = fs.findResource(parent);
        if (pfo != null) {
            pfo.refresh();
        }
    }

    public static File toFile(FileObject fo) {
        return (File)fo.getAttribute("java.io.File");
    }

    public Date lastModified(String name) {
        return super.lastModified(name);
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void addNotify() {
        super.addNotify();
        this.incRefCount();
        try {
            super.addedFS((FileSystem)this);
            FTPFileSystem.refreshFTPLogs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
    }

    public void removeNotify() {
        super.removeNotify();
        this.decRefCount();
        super.removedFS((FileSystem)this);
        FTPFileSystem.refreshFTPLogs();
    }

    public void addedFS(FileSystem fs) throws IOException {
        if (fs == this) {
            try {
                if (!this.getSystemName().equals(this.computeSystemName())) {
                    this.setSystemName(this.computeSystemName());
                }
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            super.addedFS(fs);
            this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }
    }

    protected void ftpSettingsChanged(PropertyChangeEvent event) {
        if (event.getPropertyName() == null) {
            return;
        }
        if (event.getPropertyName().equals("passivemode") && this.client != null) {
            ((FTPClient)this.client).setPassiveMode((Boolean)event.getNewValue());
        }
        if (event.getPropertyName().equals("refreshtime")) {
            this.setRefreshTime((Integer)event.getNewValue());
        }
    }

    protected FTPSettings getFTPSettings() {
        if (this.ftpsettings == null) {
            this.ftpsettings = (FTPSettings)SystemOption.findObject(FTPSettings.class, (boolean)true);
        }
        return this.ftpsettings;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.hostName = ((FTPLogInfo)this.loginfo).getHost();
        this.userName = ((FTPLogInfo)this.loginfo).getUser();
        ((FTPLogInfo)this.loginfo).clearStringPassword();
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeType();
        if (remoteRuntimeType == null) {
            return;
        }
        if (this.password == null) {
            this.password = this.getOrPromptforPassword();
        }
        ((FTPLogInfo)this.loginfo).setPassword(this.password);
        this.client = this.createClient(this.loginfo, this.cachedir, this.startdir);
        this.justSerialized = true;
        this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
        this.annotationProviders.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void setFtpSocketTimeout(int timeout) throws PropertyVetoException {
    }

    public int getFtpSocketTimeout() {
        if (this.getRemoteRuntimeType() == null) {
            return DistributedSettings.getDefault().getSvrTimeOut() * 1000;
        }
        return this.getRemoteRuntimeType().getSvrTimeOut() * 1000;
    }

    public void setFtpPassiveMode(boolean flag) throws PropertyVetoException {
        if (flag != this.ftpPassiveMode) {
            this.ftpPassiveMode = flag;
            this.firePropertyChange("ftpPassiveMode", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
            this.propChanged();
        }
    }

    public boolean getFtpPassiveMode() {
        return this.ftpPassiveMode;
    }

    public void setSSHForwarding(boolean flag) throws PropertyVetoException {
        if (flag != this.SSHForwarding) {
            this.SSHForwarding = flag;
            this.firePropertyChange("SSHForwarding", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
            this.propChanged();
        }
    }

    public boolean getSSHForwarding() {
        return this.SSHForwarding;
    }

    private String computeSystemName() {
        String sysname = this.getCache().getAbsolutePath();
        return sysname.replaceAll("\\\\|\\.|:", "#");
    }

    private String getDefaultCache() {
        return FTPWORK + File.separator + ((FTPLogInfo)this.loginfo).getHost() + (((FTPLogInfo)this.loginfo).getPort() == 21 ? "" : "_" + String.valueOf(((FTPLogInfo)this.loginfo).getPort())) + "_" + ((FTPLogInfo)this.loginfo).getUser();
    }

    private boolean cacheAlreadyMounted(File r) throws IOException {
        if (r == null) {
            return true;
        }
        if (!r.exists()) {
            return true;
        }
        for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
            String lroot;
            if (!(fs instanceof LocalFileSystem && !(fs instanceof AbstractNetworkFileSystem) ? (lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(r.getAbsolutePath()) : fs instanceof AbstractNetworkFileSystem && (lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot()).equalsIgnoreCase(r.getAbsolutePath()))) continue;
            return true;
        }
        return false;
    }

    public void setCache(File r) throws PropertyVetoException, IOException {
        if (this.cacheAlreadyMounted(r)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The selected FTP local root directory does not exist or is already being used\nas the local root directory for another FTP file system.\nPlease choose a different FTP local root directory or\nunmount the filesystem that is using the selected directory", 2));
            throw new IOException("selected FTP local directory is not valid");
        }
        if (!r.canWrite() || !r.canRead()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Can't read or write to the selected FTP local root directory", 2));
            throw new IOException("selected FTP local directory is not valid");
        }
        this.cachedir = r;
        String oldDisplayName = this.getDisplayName();
        this.setSystemName(this.computeSystemName());
        this.firePropertyChange("displayName", null, this.getDisplayName());
        this.propChanged();
    }

    protected RemoteFile createRootFile(RemoteClient client, File cache) throws IOException {
        FTPFileName rfn = new FTPFileName("", FileUtility.openVMSPathToUnixPath(this.getStartdir(), true), true);
        RemoteFileAttributes rfa = new RemoteFileAttributes(rfn, true);
        return new RemoteFile(rfa, null, client, this, this, cache, true, this);
    }

    public File getCache() {
        return this.cachedir;
    }

    public String getServer() {
        return ((FTPLogInfo)this.loginfo).getHost();
    }

    public void setServer(String server) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setHost(server);
        this.ftpsettings.setHostName(server);
        this.propChanged();
    }

    public int getPort() {
        return ((FTPLogInfo)this.loginfo).getPort();
    }

    public void setPort(int port) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setPort(port);
        this.ftpsettings.setFTPPort(port);
        this.propChanged();
    }

    public String getUsername() {
        return ((FTPLogInfo)this.loginfo).getUser();
    }

    public void setUsername(String username) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setUser(username);
        this.ftpsettings.setUserName(username);
        this.propChanged();
    }

    public String getStartdir() {
        return this.startdir;
    }

    public void setStartdir(String startdir) throws PropertyVetoException, IOException {
        String newstartdir = startdir;
        if (startdir == null || startdir.equals("/") || startdir.equals("")) {
            newstartdir = "/";
        } else {
            if (!startdir.startsWith("/")) {
                newstartdir = startdir;
            }
            if (newstartdir.endsWith("/")) {
                newstartdir = newstartdir.substring(0, newstartdir.length() - 1);
            }
        }
        this.startdir = newstartdir;
    }

    private void propChanged() throws PropertyVetoException {
        this.connectOnBackground();
    }

    public RemoteClient createClient(LogInfo loginfo, File cache, String rwd) throws IOException {
        File logfile;
        if (!this.cachedir.exists()) {
            this.cachedir.mkdirs();
        }
        if ((logfile = InstalledFileLocator.getDefault().locate("distributed", null, false)) != null) {
            logfile = new File(logfile, "ftp_" + System.getProperty("user.name") + ".log");
            logfile.createNewFile();
        }
        FTPClient client = new FTPClient((FTPLogInfo)loginfo, rwd, new DisconnectCallBack(){

            public void disconnected() {
                FTPFileSystem.this.firePropertyChange("displayName", null, FTPFileSystem.this.getDisplayName());
            }
        });
        client.setLog(logfile);
        client.setPassiveMode(this.getFtpPassiveMode());
        client.setSSHForward(this.getSSHForwarding());
        client.setSocketTimeout(this.getFtpSocketTimeout());
        this.rootFile = this.createRootFile(client, cache);
        return client;
    }

    public FTPClient getClient() {
        return (FTPClient)this.client;
    }

    protected void isReadyToModify() throws IOException {
        if (this.client == null) {
            super.addedFS((FileSystem)this);
        } else if (this.rootFile == null) {
            throw new IOException("Connection to server " + this.getServer() + " isn't established");
        }
        if (!this.isConnected() && !this.isOfflineChanges()) {
            throw new IOException("Modification in offline mode are not allowed");
        }
    }

    protected void isReadyToRead() throws IOException {
        if (this.client == null || this.rootFile == null) {
            throw new IOException("Connection to server " + this.getServer() + " isn't established" + (this.client == null) + (this.rootFile == null));
        }
    }

    public String[] children(String name) {
        if (this.justSerialized) {
            try {
                super.addedFS((FileSystem)this);
                this.justSerialized = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.children(name);
    }

    protected boolean isReady() {
        return this.client != null && this.rootFile != null;
    }

    protected int disconnectDialog(String server) {
        return FTPDialogs.disconnect(server);
    }

    protected boolean connectDialog(String server) {
        return FTPDialogs.connect(server);
    }

    protected void startdirNotFound(String startdir, String server, String rootDir) {
        FTPDialogs.startdirNotFound(startdir, server, rootDir);
    }

    protected void errorConnect(String error, String hostName) {
        FTPDialogs.ftpConnectionError(error, hostName);
    }

    public void notifyIncorrectPassword() {
        FTPDialogs.incorrectPassword(this.getServer());
    }

    public boolean notifyIncorrectCache(File newcache) {
        return FTPDialogs.incorrectCache(this.getCache().getPath(), newcache.getPath(), this.getServer());
    }

    public boolean notifyReconnect(String mess) {
        return true;
    }

    public int notifyWhichFile(String path, Date file1, long size1, Date file2, long size2) {
        return 1;
    }

    public int notifyBothFilesChanged(String path, Date file1, long size1, Date file2, long size2) {
        return 0;
    }

    public boolean isRefreshServer() {
        return this.getFTPSettings().isRefreshServer();
    }

    public boolean isScanCache() {
        return this.getFTPSettings().isScanCache();
    }

    public boolean isAlwaysRefresh() {
        return this.getFTPSettings().isRefreshAlways();
    }

    public void setAlwaysRefresh(boolean alwaysRefresh) {
        this.getFTPSettings().setRefreshAlways(alwaysRefresh);
    }

    public boolean isDownloadServerChangedFile() {
        return this.getFTPSettings().isDownloadServerChangedFile();
    }

    public boolean isOfflineChanges() {
        return this.getFTPSettings().isOfflineChanges();
    }

    public boolean notifyServerChanged(String path, Date file1, long size1, Date file2, long size2) {
        return true;
    }

    public boolean notifyCacheExtDelete(String path, boolean isDir) {
        return false;
    }

    public boolean notifyServerExtDelete(String path, boolean isDir) {
        return false;
    }

    public void fileChanged(String path) {
        FileObject fo = this.findResource(path);
        if (fo != null) {
            fo.refresh();
        }
    }

    public void notifyException(Exception e) {
        ErrorManager.getDefault().notify((Throwable)e);
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.getLocalRoot());
    }

    public FileObject findExistingResource(String name) {
        Enumeration en = this.existingFileObjects(this.getRoot());
        FileObject fo = null;
        while (en.hasMoreElements()) {
            FileObject obj = (FileObject)en.nextElement();
            if (!name.equalsIgnoreCase(obj.getPath())) continue;
            fo = obj;
            break;
        }
        return fo;
    }

    public void statusChanged(String path) {
        FileObject chfo;
        FileObject fo = this.findExistingResource(path);
        if (fo == null) {
            return;
        }
        Enumeration en = this.existingFileObjects(fo);
        HashSet hs = new HashSet();
        if (en.hasMoreElements()) {
            hs.add(en.nextElement());
        }
        while (en.hasMoreElements() && fo.equals((chfo = (FileObject)en.nextElement()).getParent())) {
            hs.add(chfo);
        }
        Set s = Collections.synchronizedSet(hs);
    }

    public void annotationChanged(FileStatusEvent ev) {
        this.fireFileStatusChanged(ev);
    }

    public String annotateName(String name, Set files) {
        String result;
        block29: {
            result = name;
            for (Object o : files) {
                if (!((FileObject)o).getName().equalsIgnoreCase("nbproject")) continue;
                return name;
            }
            if (result == null) {
                return result;
            }
            if (this.getLocalRoot().equals(name) || name.equals("")) {
                String prefix = "";
                if (!this.isConnected()) {
                    prefix = "<offline> ";
                }
                this.firePropertyChange("displayName", null, prefix + this.getDisplayName());
                return prefix + this.getDisplayName();
            }
            int len = files.size();
            if (len == 0 || name.indexOf(this.getLocalRoot()) >= 0) {
                return result;
            }
            ArrayList importantFiles = new ArrayList(files);
            len = importantFiles.size();
            if (len == 1) {
                String fullName;
                result = fullName = ((FileObject)importantFiles.get(0)).getNameExt();
                try {
                    if (this.rootFile == null) break block29;
                    RemoteFile rf = this.getRemoteFile(((FileObject)importantFiles.get(0)).getPath());
                    if (rf != null) {
                        result = rf.getName().getName();
                    }
                    if (rf != null && !rf.getRemoteFS().getDisplayStatus()) {
                        return result;
                    }
                    if (!((FileObject)importantFiles.get(0)).isFolder()) {
                        if (rf != null) {
                            if (((FileObject)importantFiles.get(0)).getExt().toLowerCase().equals("xml")) {
                                rf.setMimeType("text");
                            } else if (this.getAsciiFileExts().isRegistered(((FileObject)importantFiles.get(0)).getExt().toLowerCase())) {
                                rf.setMimeType("text");
                            } else {
                                String mimeType = FileUtil.getMIMEType((FileObject)((FileObject)importantFiles.get(0)));
                                rf.setMimeType(mimeType);
                            }
                            result = result + " [" + rf.getStatusString() + "]";
                        }
                        break block29;
                    }
                    result = name;
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            } else {
                Sync.SyncState cs = null;
                Sync.SyncState ss = null;
                String statusString = "[";
                RemoteFile mainRf = null;
                for (FileObject fobj : importantFiles) {
                    try {
                        if (this.rootFile == null) continue;
                        RemoteFile rf = this.getRemoteFile(fobj.getPath());
                        if (mainRf == null) {
                            mainRf = rf;
                        }
                        if (rf != null && !rf.getRemoteFS().getDisplayStatus()) {
                            return result;
                        }
                        if (fobj.isFolder() || rf == null) continue;
                        String mimeType = null;
                        if (fobj.getExt().toLowerCase().equals("form")) {
                            mimeType = "text";
                        } else if (fobj.getExt().toLowerCase().equals("xml")) {
                            mimeType = "text";
                        } else if (this.getAsciiFileExts().isRegistered(fobj.getExt())) {
                            rf.setMimeType("text");
                        } else {
                            mimeType = FileUtil.getMIMEType((FileObject)fobj);
                        }
                        rf.setMimeType(mimeType);
                        cs = cs == null ? rf.getClientStatus() : rf.getClientStatus().getSevererStatus(cs);
                        Sync.SyncState syncState = ss = ss == null ? rf.getServerStatus() : rf.getServerStatus().getSevererStatus(ss);
                        if (!rf.getName().getName().endsWith(".java")) continue;
                        mainRf = rf;
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
                if (mainRf != null) {
                    name = mainRf.getName().getName();
                }
                result = name + " [" + (cs == null ? "" : cs.toString() + "*") + "|" + (ss == null ? "" : ss.toString() + "*") + "]";
            }
        }
        return result;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public void pubFireFileStatusChanged(Set fos) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fos, true, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestProcessor getStatusChangeRequestProcessor() {
        Object object = STATUS_REQUEST_PROCESSOR_LOCK;
        synchronized (object) {
            if (statusRequestProcessor == null) {
                statusRequestProcessor = new RequestProcessor("FTP FS Status Update Request Processor");
            }
        }
        return statusRequestProcessor;
    }

    public void statusChanged(final String path, final boolean recursively) {
        FTPFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fo = FTPFileSystem.this.findExistingResource(path);
                if (fo == null) {
                    return;
                }
                Enumeration en = FTPFileSystem.this.existingFileObjects(fo);
                HashSet hs = new HashSet();
                if (en.hasMoreElements()) {
                    hs.add(en.nextElement());
                }
                while (en.hasMoreElements()) {
                    FileObject chfo = (FileObject)en.nextElement();
                    if (!recursively && !fo.equals(chfo.getParent())) break;
                    hs.add(chfo);
                }
                Set s = Collections.synchronizedSet(hs);
                FTPFileSystem.this.fireFileStatusChanged(new FileStatusEvent((FileSystem)FTPFileSystem.this, s, true, true));
            }
        });
    }

    private static String htmlEncode(String name) {
        String retval = name;
        if (retval.indexOf(60) != -1) {
            retval = lt.matcher(retval).replaceAll("&lt;");
        }
        if (retval.indexOf(62) != -1) {
            retval = gt.matcher(retval).replaceAll("&gt;");
        }
        return retval;
    }

    public String annotateNameHtml(String name, Set files) {
        name = FTPFileSystem.htmlEncode(name);
        name = this.annotateName(name, files);
        String retVal = null;
        if (this.annotationProviders != null) {
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                retVal = ap.annotateNameHtml(name, files);
            }
        }
        if (retVal == null) {
            return name;
        }
        return retVal;
    }

    public Image annotateIcon(Image icon, int iconType, Set files) {
        Object[] oo = files.toArray();
        int len = oo.length;
        Image img = null;
        if (len == 0) {
            return icon;
        }
        ArrayList importantFiles = new ArrayList(files);
        len = importantFiles.size();
        FileObject fullName = (FileObject)importantFiles.get(0);
        Image tmpIcon = null;
        if (this.annotationProviders != null) {
            Iterator it = this.annotationProviders.allInstances().iterator();
            while (tmpIcon == null && it.hasNext()) {
                AnnotationProvider ap = (AnnotationProvider)it.next();
                tmpIcon = ap.annotateIcon(icon, iconType, files);
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        try {
            if ("".equals(fullName.getName()) && fullName.isFolder()) {
                img = this.isConnected() ? FileStatusInfo.REMOTE_PRJ.getIcon() : FileStatusInfo.REMOTE_PRJ_GREY.getIcon();
                icon = Utilities.mergeImages((Image)icon, (Image)img, (int)16, (int)1);
                return icon;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (((FileObject)importantFiles.get(0)).isFolder()) {
            return icon;
        }
        try {
            RemoteFile rf;
            if (this.rootFile != null && (rf = this.getRemoteFile(((FileObject)importantFiles.get(0)).getPath())) != null) {
                if (rf.getFileResidenceMode() != 1) {
                    if (rf.getFileResidenceMode() != 0 && Sync.getAction(rf.getClientStatus(), rf.getServerStatus()) == Sync.SyncAction.conflict_dialog) {
                        img = FileStatusInfo.OUT_OF_DATE.getIcon();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        if (img != null) {
            icon = Utilities.mergeImages((Image)icon, (Image)img, (int)16, (int)1);
        }
        return icon;
    }

    public final String getDisplayName() {
        return this.getServer() + " " + this.getCache();
    }

    public FileObject getFSRoot() {
        return this.getRoot();
    }

    public void copyReadableProps(FTPFileSystem sf) {
        try {
            this.setReadOnly(sf.isReadOnly());
            this.setSSHForwarding(sf.getSSHForwarding());
            this.setAsciiFileExts(sf.getAsciiFileExts());
            this.setAutoSync(sf.getAutoSync());
            this.setBackupExtensions(sf.getBackupExtensions());
            this.setDisplayStatus(sf.getDisplayStatus());
            this.setFtpPassiveMode(sf.getFtpPassiveMode());
            this.setHidden(sf.isHidden());
            this.setIgnoreHiddenFiles(sf.getIgnoreHiddenFiles());
            this.setIgnoredFiles(sf.getIgnoredFiles());
            this.setIgnoredFolders(sf.getIgnoredFolders());
            this.setServerOnlyFileExts(sf.getServerOnlyFileExts());
            this.setXDisplayDeviceNumber(sf.getXDisplayDeviceNumber());
            this.setUseXtermCompile(sf.getUseXtermCompile());
            this.setUseXtermExecution(sf.getUseXtermExecution());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    static {
        STATUS_REQUEST_PROCESSOR_LOCK = new Object();
        lt = Pattern.compile("<");
        gt = Pattern.compile(">");
    }
}

