/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.distributed.common.cookies.RemoteCookie;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.SimpleMessageDialog;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.NewProjectIterator;
import org.netbeans.modules.distributed.remoteexecute.ant.RemoteAntExecution;
import org.netbeans.modules.distributed.remoteexecute.ant.RemoteAntExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.property.RemoteRootProperty;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFSChooserPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectPanelMultiple;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectVisualPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRuntimePanel;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CookieAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import patchsources.OpenProjectList_Dist;

public final class ConvertToRemoteProject
extends CookieAction {
    public static final String LIBRARY_PREFIX = "${libs.";
    public static final String LIBRARY_SUFFIX = ".classpath}";
    public static final String OPENVMS_BUILDIMPL = "ovmsbuild-impl.xml";
    private boolean doConvert;
    private WizardDescriptor.Panel[] panels;
    private static final String PREFIX_EXTENT_CODEBASE = "codebase:";

    private WizardDescriptor.Panel[] getMultiplePanels(ArrayList fsList, String srcLevel) {
        ArrayList<Object> pList = new ArrayList<Object>();
        pList.add(new RemoteRuntimePanel(srcLevel));
        pList.add(new RemoteFSChooserPanel());
        for (int j = 0; j < fsList.size(); ++j) {
            pList.add(new RemoteFTPSelectPanelMultiple((String)fsList.get(j), false, NbBundle.getMessage(RemoteFTPSelectVisualPanel.class, (String)"TITLE_RemoteFTPSelectVisualPanel") + (String)fsList.get(j), j, false));
        }
        this.panels = pList.toArray(new WizardDescriptor.Panel[0]);
        String[] steps = new String[this.panels.length];
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
        return this.panels;
    }

    private ArrayList mountFS(WizardDescriptor wiz, Project project, boolean isSMB) throws Exception {
        ArrayList<Object> fsToMount = new ArrayList<Object>();
        ArrayList flist = (ArrayList)wiz.getProperty("remotefs_list");
        for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
            String lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot();
            Iterator itr = flist.iterator();
            while (itr.hasNext()) {
                HashMap map = (HashMap)itr.next();
                if (!lroot.equalsIgnoreCase((String)map.get("local_directory"))) continue;
                itr.remove();
                fsToMount.add(fs);
            }
        }
        for (HashMap map : flist) {
            AbstractNetworkFileSystem fs;
            if (isSMB) {
                fs = new NetworkFileSystem((RemoteRuntimeType)wiz.getProperty("remote_runtime"));
                RemoteRootProperty rrp = new RemoteRootProperty((NetworkFileSystem)fs, (String)map.get("remote_directory"), (String)map.get("local_directory"), false);
                fs.setRemoteRoot(rrp);
            } else {
                int port = 21;
                try {
                    port = (Integer)map.get("FTP_PORT");
                }
                catch (NumberFormatException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    throw e;
                }
                try {
                    fs = new FTPFileSystem(((RemoteRuntimeType)wiz.getProperty("remote_runtime")).getHostName(), ((RemoteRuntimeType)wiz.getProperty("remote_runtime")).getUserName(), port, (String)map.get("local_directory"), (String)map.get("remote_directory"), ((Boolean)map.get("SSH_FORWARD")).equals(Boolean.TRUE), ((Boolean)map.get("IS_PASSIVE")).equals(Boolean.TRUE));
                    ((FTPFileSystem)fs).setReadOnly(((Boolean)map.get("READ_ONLY")).equals(Boolean.TRUE));
                    ((FTPFileSystem)fs).setAutoSync(((Boolean)map.get("AUTO_SYNC")).equals(Boolean.TRUE));
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    throw e;
                }
            }
            this.setupRemoteFS((FileSystem)fs, project);
            fsToMount.add(fs);
        }
        return fsToMount;
    }

    private String getSourceLevel(FileObject root) {
        String result = SourceLevelQuery.getSourceLevel((FileObject)root);
        return result == null ? "" : result;
    }

    public String getRootURI(FileObject root) {
        try {
            return root.getURL().toString() + this.getSourceLevel(root);
        }
        catch (FileStateInvalidException e) {
            throw (RuntimeException)ErrorManager.getDefault().annotate((Throwable)new RuntimeException(), (Throwable)e);
        }
    }

    private static String getCBExtentName(String uri) {
        return PREFIX_EXTENT_CODEBASE + uri;
    }

    private void CloseAllActiveEditorWindows() {
        Mode mode = WindowManager.getDefault().findMode("editor");
        TopComponent[] tcs = mode.getTopComponents();
        for (int i = 0; i < tcs.length; ++i) {
            if (tcs[i] == null) continue;
            tcs[i].close();
        }
    }

    public static Object serialValue(String val) throws ClassNotFoundException, IOException {
        if (val == null || val.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[val.length() / 2];
        int count = 0;
        try {
            for (int i = 0; i < val.length(); ++i) {
                if (Character.isWhitespace(val.charAt(i))) continue;
                int tempI = Integer.parseInt(val.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
                ++i;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            IOException e2 = new IOException("Cannot read value of <serialvalue> attribute from file XXXX");
            ErrorManager.getDefault().annotate((Throwable)e2, (Throwable)e);
            throw e2;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
        try {
            class SpecialObjectInputStream
            extends ObjectInputStream {
                public SpecialObjectInputStream(InputStream is) throws IOException {
                    super(is);
                    try {
                        this.enableResolveObject(true);
                    }
                    catch (SecurityException ex) {
                        throw new IOException(ex.toString());
                    }
                }

                protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
                    ClassLoader cl = this.getNBClassLoader();
                    try {
                        return Class.forName(v.getName(), false, cl);
                    }
                    catch (ClassNotFoundException cnfe) {
                        String msg = "Offending classloader: " + cl;
                        ErrorManager.getDefault().annotate((Throwable)cnfe, 1, msg, null, null, null);
                        throw cnfe;
                    }
                }

                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    String newN;
                    ObjectStreamClass ose = super.readClassDescriptor();
                    String name = ose.getName();
                    if (name == (newN = Utilities.translate((String)name))) {
                        return ose;
                    }
                    ClassLoader cl = this.getNBClassLoader();
                    try {
                        Class<?> origCl = Class.forName(name, false, cl);
                        return ObjectStreamClass.lookup(origCl);
                    }
                    catch (ClassNotFoundException ex) {
                        Class<?> clazz = Class.forName(newN, false, cl);
                        ObjectStreamClass newOse = ObjectStreamClass.lookup(clazz);
                        if (newOse == null) {
                            throw new NotSerializableException(newN);
                        }
                        return newOse;
                    }
                }

                private ClassLoader getNBClassLoader() {
                    ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    return c != null ? c : ClassLoader.getSystemClassLoader();
                }
            }
            SpecialObjectInputStream ois = new SpecialObjectInputStream(bis);
            return ois.readObject();
        }
        catch (Exception e) {
            IOException e2 = new IOException("Cannot read value of <serialvalue> attribute from file XXXXX");
            ErrorManager.getDefault().annotate((Throwable)e2, (Throwable)e);
            throw e2;
        }
    }

    private WizardDescriptor bringupWizard(ArrayList list, String srcLevel) {
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new NewProjectIterator(list));
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle("Remote Project Conversion Wizard");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        dialog.setVisible(false);
        dialog.dispose();
        return wizardDescriptor;
    }

    private void setupRemoteFS(FileSystem fs, Project project) throws IOException {
        OpenProjectList_Dist.getFsSet().add(fs);
        Utils.writeFStoProjectXML_new(fs, project);
        final Project projectFinal = project;
        final FileSystem fsFinal = fs;
        fs.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    Utils.writeFStoProjectXML_new(fsFinal, projectFinal);
                }
                catch (Exception e) {
                    System.out.println("got it 2 :writeFStoProjectXML_new ");
                }
            }
        });
        OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
    }

    private void createOpenvmsProps(ArrayList flist, String projectDirectory, Project projectFO) throws IOException {
        PropertyProvider prop = PropertyUtils.propertiesFilePropertyProvider((File)new File(projectDirectory + File.separatorChar + "nbproject" + File.separatorChar + "private" + File.separatorChar + "private.properties"));
        FileSystem pfs = null;
        if (prop != null) {
            HashMap pMap = new HashMap();
            block0: for (int i = 0; i < flist.size(); ++i) {
                AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)flist.get(i);
                if (nfs.getLocalRoot().equalsIgnoreCase(projectDirectory)) {
                    pfs = (FileSystem)nfs;
                }
                Map props = prop.getProperties();
                for (Map.Entry entry : props.entrySet()) {
                    if (!((String)entry.getValue()).equalsIgnoreCase(nfs.getLocalRoot())) continue;
                    pMap.put(entry.getKey(), nfs.getRemoteRoot());
                    continue block0;
                }
            }
            if (pMap.size() > 0) {
                File vmsPropFile = new File(projectDirectory + File.separatorChar + "nbproject" + File.separatorChar + "private" + File.separatorChar + "openvms_private.properties");
                vmsPropFile.delete();
                vmsPropFile.createNewFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(vmsPropFile));
                for (Map.Entry entry : pMap.entrySet()) {
                    bw.write(entry.getKey() + "=" + FileUtility.openVMSPathToUnixPath((String)entry.getValue(), true));
                    bw.newLine();
                    bw.flush();
                }
                bw.close();
                if (pfs != null && pfs instanceof RemoteFileSystem) {
                    ((RemoteFileSystem)pfs).uploadAll("nbproject/private/openvms_private.properties", true, true);
                }
            }
        }
    }

    private Element createCondition(Document doc, String property, String value, Element testCondition) {
        Element e = doc.createElement("condition");
        e.setAttribute("property", property);
        e.setAttribute("value", value);
        e.appendChild(testCondition);
        return e;
    }

    private String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filePath)));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private void CreateOVMSBuildImplXML(Document ovmsBuildXML) {
        Element projRoot = ovmsBuildXML.createElement("project");
        projRoot.setAttribute("name", "ovms-buildimpl");
        projRoot.setAttribute("default", "-pre-init");
        projRoot.setAttribute("basedir", ".");
        ovmsBuildXML.appendChild(projRoot);
        Comment c1 = ovmsBuildXML.createComment("DISTRIBUTED_START V1.1\n *** This XML file is machine-generated ***\n *** Do Not Edit                        ***\n");
        projRoot.appendChild(c1);
        Element condElem2 = ovmsBuildXML.createElement("os");
        condElem2.setAttribute("family", "openvms");
        Element condElem1 = this.createCondition(ovmsBuildXML, "javac.classpath", "/ide$jars/swing-layout-1-0.jar", condElem2);
        projRoot.appendChild(condElem1);
        Element condElem4 = ovmsBuildXML.createElement("os");
        condElem4.setAttribute("family", "openvms");
        Element condElem3 = this.createCondition(ovmsBuildXML, "libs.jstl11.classpath.libfile.1", "/ide$jars/standard.jar", condElem4);
        projRoot.appendChild(condElem3);
        Element condElem6 = ovmsBuildXML.createElement("os");
        condElem6.setAttribute("family", "openvms");
        Element condElem5 = this.createCondition(ovmsBuildXML, "libs.jstl11.classpath.libfile.2", "/ide$jars/jstl.jar", condElem6);
        projRoot.appendChild(condElem5);
        Element condElem8 = ovmsBuildXML.createElement("os");
        condElem8.setAttribute("family", "openvms");
        Element condElem7 = this.createCondition(ovmsBuildXML, "is.vms", "true", condElem8);
        projRoot.appendChild(condElem7);
        Element condElem12 = ovmsBuildXML.createElement("condition");
        condElem12.setAttribute("property", "jpda_switch");
        condElem12.setAttribute("else", "agentlib:jdwp=transport=dt_socket");
        condElem12.setAttribute("value", "Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket");
        Element condElem13 = ovmsBuildXML.createElement("contains");
        condElem13.setAttribute("string", "${java.version}");
        condElem13.setAttribute("substring", "1.4");
        condElem12.appendChild(condElem13);
        projRoot.appendChild(condElem12);
        Element debugTarget = ovmsBuildXML.createElement("target");
        debugTarget.setAttribute("name", "remotedebug");
        debugTarget.setAttribute("depends", "init,compile,-remote-debug-start-debuggee");
        debugTarget.setAttribute("description", "Debug project in OpenVMS");
        debugTarget.setAttribute("if", "is.vms");
        projRoot.appendChild(debugTarget);
        Element debugeeTarget = ovmsBuildXML.createElement("target");
        debugeeTarget.setAttribute("name", "-remote-debug-start-debuggee");
        debugeeTarget.setAttribute("depends", "init,compile,-init-macrodef-debug-vms");
        debugeeTarget.setAttribute("if", "is.vms");
        Element debugeePropFile = ovmsBuildXML.createElement("propertyfile");
        debugeePropFile.setAttribute("file", "/ide$scratch/debugport.properties");
        debugeePropFile.setAttribute("comment", "");
        Element debugeePropEntry = ovmsBuildXML.createElement("entry");
        debugeePropEntry.setAttribute("key", "vms.ide.debugPort");
        debugeePropEntry.setAttribute("default", "9000");
        debugeePropEntry.setAttribute("type", "int");
        debugeePropEntry.setAttribute("operation", "+");
        debugeePropEntry.setAttribute("value", "1");
        debugeePropEntry.setAttribute("pattern", "0000");
        debugeePropFile.appendChild(debugeePropEntry);
        Element debugeeProp = ovmsBuildXML.createElement("property");
        debugeeProp.setAttribute("file", "/ide$scratch/debugport.properties");
        Element debugeePropEcho = ovmsBuildXML.createElement("echo");
        debugeePropEcho.setAttribute("message", "Debugging on port ${vms.ide.debugPort}");
        Element debugeePropEcho2 = ovmsBuildXML.createElement("echo");
        debugeePropEcho2.setAttribute("message", "Use the port number mentioned above for attaching to the NetBeans debugger");
        debugeeTarget.appendChild(debugeePropFile);
        debugeeTarget.appendChild(debugeeProp);
        debugeeTarget.appendChild(debugeePropEcho);
        debugeeTarget.appendChild(debugeePropEcho2);
        Element debugeeNested1 = ovmsBuildXML.createElement("remote-debug");
        Element debugeeNested2 = ovmsBuildXML.createElement("customize");
        Element debugeeNested3 = ovmsBuildXML.createElement("arg");
        debugeeNested3.setAttribute("line", "${application.args}");
        debugeeNested2.appendChild(debugeeNested3);
        debugeeNested1.appendChild(debugeeNested2);
        debugeeTarget.appendChild(debugeeNested1);
        projRoot.appendChild(debugeeTarget);
        Element debugMacro = ovmsBuildXML.createElement("target");
        debugMacro.setAttribute("name", "-init-macrodef-debug-vms");
        debugMacro.setAttribute("if", "is.vms");
        Element debugMacroDef = ovmsBuildXML.createElement("macrodef");
        debugMacroDef.setAttribute("name", "remote-debug");
        Element debugMacroDefAttr1 = ovmsBuildXML.createElement("attribute");
        debugMacroDefAttr1.setAttribute("name", "classname");
        debugMacroDefAttr1.setAttribute("default", "${main.class}");
        Element debugMacroDefAttr2 = ovmsBuildXML.createElement("attribute");
        debugMacroDefAttr2.setAttribute("name", "classpath");
        debugMacroDefAttr2.setAttribute("default", "${debug.classpath}");
        Element debugMacroDefElem = ovmsBuildXML.createElement("element");
        debugMacroDefElem.setAttribute("name", "customize");
        debugMacroDefElem.setAttribute("optional", "true");
        Element debugMacroDefSeq = ovmsBuildXML.createElement("sequential");
        Element debugMacroDefJava = ovmsBuildXML.createElement("java");
        debugMacroDefJava.setAttribute("fork", "true");
        debugMacroDefJava.setAttribute("classname", "@{classname}");
        debugMacroDefJava.setAttribute("dir", "${work.dir}");
        Element debugMacroDefJavaArg = ovmsBuildXML.createElement("jvmarg");
        debugMacroDefJavaArg.setAttribute("line", "-Djava.compiler=none -${jpda_switch},server=y,address=${vms.ide.debugPort} ${run.jvmargs}");
        Element debugMacroDefJavaClassPath = ovmsBuildXML.createElement("classpath");
        debugMacroDefJavaClassPath.setAttribute("path", "@{classpath}");
        debugMacroDefJava.appendChild(debugMacroDefJavaArg);
        debugMacroDefJava.appendChild(debugMacroDefJavaClassPath);
        debugMacroDefSeq.appendChild(debugMacroDefJava);
        debugMacroDef.appendChild(debugMacroDefAttr1);
        debugMacroDef.appendChild(debugMacroDefAttr2);
        debugMacroDef.appendChild(debugMacroDefElem);
        debugMacroDef.appendChild(debugMacroDefSeq);
        debugMacro.appendChild(debugMacroDef);
        projRoot.appendChild(debugMacro);
        Element preInit = ovmsBuildXML.createElement("target");
        preInit.setAttribute("name", "-pre-init");
        preInit.setAttribute("if", "is.vms");
        Element preInitProp = ovmsBuildXML.createElement("property");
        preInitProp.setAttribute("name", "user.properties.file");
        preInitProp.setAttribute("value", "/ide$misc/openvms_build55.properties");
        preInit.appendChild(preInitProp);
        Element preInitProp2 = ovmsBuildXML.createElement("property");
        preInitProp2.setAttribute("file", "nbproject/private/openvms_private.properties");
        preInit.appendChild(preInitProp2);
        projRoot.appendChild(preInit);
        Comment c2 = ovmsBuildXML.createComment("DISTRIBUTED_END V1.1\n");
        projRoot.appendChild(c2);
    }

    private void makeXMLChange(AntProjectCookie apc, FileObject buildXml, String projectDirectory) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document ovmsBuildXML = parser.newDocument();
        String s = this.readFileAsString("resources/ovmsbuild-impl.xml");
        try {
            String delim = Utilities.isWindows() ? "\\" : "/";
            FileOutputStream fout = new FileOutputStream(new File(projectDirectory + delim + OPENVMS_BUILDIMPL));
            if (fout != null) {
                fout.write(s.getBytes());
                fout.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        FileLock flock = buildXml.lock();
        NodeList nlist = apc.getDocument().getDocumentElement().getChildNodes();
        org.w3c.dom.Node descrNode = null;
        for (int i = 0; i < nlist.getLength(); ++i) {
            if (!nlist.item(i).getNodeName().equals("description")) continue;
            descrNode = nlist.item(i);
            break;
        }
        if (descrNode != null) {
            org.w3c.dom.Node importNode = this.findXMLNode(apc);
            if (importNode != null) {
                flock.releaseLock();
            } else {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    File file = new File(buildXml.getPath());
                    Document document = documentBuilder.parse(file);
                    org.w3c.dom.Node n = null;
                    org.w3c.dom.Node desc = null;
                    NodeList nl = document.getChildNodes();
                    Object ProjectNode = null;
                    Object descnode = null;
                    for (int i = 0; i < nl.getLength(); ++i) {
                        n = nl.item(i);
                        n.getNodeName();
                        if (!n.getNodeName().equalsIgnoreCase("project")) continue;
                        desc = n.getFirstChild();
                        break;
                    }
                    Element em = document.createElement("import");
                    em.setAttribute("file", OPENVMS_BUILDIMPL);
                    n.insertBefore(em, desc);
                    this.saveDocument(document, file);
                }
                catch (Exception ex) {
                    System.out.println("again !!!!!!");
                }
                flock.releaseLock();
            }
        }
    }

    private Element createOVMSImportNode(Document buildDoc) {
        Element ovmsImport = buildDoc.createElement("import");
        ovmsImport.setAttribute("file", OPENVMS_BUILDIMPL);
        return ovmsImport;
    }

    private String getProjectSrcLevel(Project project) {
        SourceLevelQueryImplementation sq = (SourceLevelQueryImplementation)project.getLookup().lookup(SourceLevelQueryImplementation.class);
        String srcLevel = sq.getSourceLevel(null);
        return srcLevel;
    }

    private boolean checkSourceLevel(RemoteRuntimeType rrt, Project project) {
        SourceLevelQueryImplementation sq = (SourceLevelQueryImplementation)project.getLookup().lookup(SourceLevelQueryImplementation.class);
        String srcLevel = sq.getSourceLevel(null);
        String svrSrcLevel = rrt.getJDKVersion();
        if (svrSrcLevel.indexOf(46) != svrSrcLevel.lastIndexOf(46)) {
            int secondDot = svrSrcLevel.indexOf(46);
            secondDot = svrSrcLevel.indexOf(46, secondDot + 1);
            svrSrcLevel = svrSrcLevel.substring(0, secondDot);
        }
        if (Float.parseFloat(srcLevel) > Float.parseFloat(svrSrcLevel)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The Java source level for this project is higher than the version of Java used on the remote server chosen.\nPlease change the source level property for this project before converting it to a remote project.", 1));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performAction(Node[] activatedNodes) {
        FileObject buildXml;
        Node[] anodes = activatedNodes;
        Lookup lookup = anodes[0].getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        Sources s = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = s.getSourceGroups("generic");
        FileObject projectDirectory1 = project.getProjectDirectory();
        SourceGroup projectDirGroup = null;
        for (int i = 0; i < groups.length; ++i) {
            FileObject groupRoot = groups[i].getRootFolder();
            if (!projectDirectory1.equals(groupRoot) && !FileUtil.isParentOf((FileObject)groupRoot, (FileObject)projectDirectory1)) continue;
            if (projectDirGroup != null) {
                projectDirGroup = null;
                break;
            }
            projectDirGroup = groups[i];
        }
        AntArtifactProvider antProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        AntArtifact[] antArts = antProvider.getBuildArtifacts();
        File buildfile = null;
        boolean isFreeForm = false;
        if (antArts == null || antArts.length == 0) {
            buildXml = Utils.getFreeFormBuildFile(project);
            isFreeForm = true;
        } else {
            buildXml = antArts[0].getScriptFile();
        }
        FileObject pdir = project.getProjectDirectory();
        String projectDirectory = FileUtil.toFile((FileObject)pdir).getAbsolutePath();
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        SimpleMessageDialog waitDialog = new SimpleMessageDialog(mainWindow, false);
        if (this.doConvert) {
            DataObject d = null;
            AntProjectCookie apc = null;
            try {
                int i;
                boolean isSMB;
                boolean cancelled;
                ArrayList<String> fsList = new ArrayList<String>();
                fsList.add(projectDirectory);
                Sources srcs = (Sources)project.getLookup().lookup(Sources.class);
                SourceGroup[] sgroups = srcs.getSourceGroups("java");
                for (int i2 = 0; srcs != null && i2 < sgroups.length; ++i2) {
                    String path;
                    FileObject fobj = sgroups[i2].getRootFolder();
                    if (Utilities.isWindows()) {
                        if (fobj.getPath().replace('/', '\\').startsWith(projectDirectory)) continue;
                        fsList.add(fobj.getPath());
                        continue;
                    }
                    if (!Utilities.isUnix()) continue;
                    String string = path = !fobj.getPath().startsWith("/") ? "/" + fobj.getPath() : fobj.getPath();
                    if (path.startsWith(projectDirectory)) continue;
                    fsList.add(path);
                }
                WizardDescriptor wizardDescriptor = this.bringupWizard(fsList, !isFreeForm ? this.getProjectSrcLevel(project) : null);
                boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
                if (wizardDescriptor.getProperty("error") != null) {
                    cancelled = true;
                }
                boolean bl2 = isSMB = wizardDescriptor.getProperty("SELECTED_FS") != null && !wizardDescriptor.getProperty("SELECTED_FS").equals("FTP");
                if (cancelled) return;
                SimpleMessageDialog.showMessage(false, "Work In Progress", "Project conversion is in progress.  Please wait...");
                if (!isFreeForm) {
                    if (!this.checkSourceLevel((RemoteRuntimeType)wizardDescriptor.getProperty("remote_runtime"), project)) {
                        waitDialog.closeDialog();
                        return;
                    }
                    d = DataObject.find((FileObject)buildXml);
                    apc = (AntProjectCookie)d.getCookie(AntProjectCookie.class);
                    this.makeXMLChange(apc, buildXml, projectDirectory);
                }
                long g = System.currentTimeMillis();
                ArrayList flist = this.mountFS(wizardDescriptor, project, isSMB);
                long t = System.currentTimeMillis() - g;
                if (!isFreeForm) {
                    this.createOpenvmsProps(flist, projectDirectory, project);
                }
                this.CloseAllActiveEditorWindows();
                OpenProjects.getDefault().close(new Project[]{project});
                ProjectManager.getDefault().deleteProject(project, pdir);
                ProjectManager.getDefault().clearNonProjectCache();
                pdir = URLMapper.findFileObject((URL)project.getProjectDirectory().getURL());
                Project np = ProjectManager.getDefault().findProject(pdir);
                OpenProjects.getDefault().open(new Project[]{np}, true);
                for (i = 0; srcs != null && i < sgroups.length; ++i) {
                    FileOwnerQuery.markExternalOwner((FileObject)sgroups[i].getRootFolder(), null, (int)0);
                }
                for (i = 0; i < flist.size(); ++i) {
                    FileOwnerQuery.markExternalOwner((FileObject)((FileSystem)flist.get(i)).getRoot(), (Project)np, (int)0);
                }
                if (!(pdir.getFileSystem() instanceof FTPFileSystem)) return;
                FTPFileSystem.refreshFTPLogs();
                return;
            }
            catch (ClassCastException cc) {
                return;
            }
            catch (Exception e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting a project. " + e.getMessage() + "\n" + "Please open it again to complete the conversion to the Remote Project"), 1));
                System.err.println(e.getMessage());
                e.printStackTrace(System.out);
                waitDialog.closeDialog();
                return;
            }
            finally {
                waitDialog.closeDialog();
            }
        }
        try {
            SimpleMessageDialog.showMessage(false, "Work In Progress", "Project conversion is in progress.  Please wait...");
            FileLock flock = buildXml.lock();
            DataObject d = DataObject.find((FileObject)buildXml);
            buildfile = FileUtility.toFile(buildXml);
            this.removeNode(buildfile);
            flock.releaseLock();
            FileObject fobj = pdir.getFileObject(OPENVMS_BUILDIMPL);
            if (fobj != null) {
                fobj.delete();
            }
            OpenProjects.getDefault().close(new Project[]{project});
            this.CloseAllActiveEditorWindows();
            Utils.removeFSFromProjectXML(project);
            Sources srcs = (Sources)project.getLookup().lookup(Sources.class);
            SourceGroup[] sgroups = srcs.getSourceGroups("java");
            TreeSet<String> extSrcs = new TreeSet<String>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((String)o1).compareToIgnoreCase((String)o2);
                }

                public boolean equals(Object obj) {
                    return super.equals(obj);
                }
            });
            for (int i = 0; srcs != null && i < sgroups.length; ++i) {
                if (sgroups[i].getDisplayName().startsWith("..")) {
                    extSrcs.add(FileUtil.toFile((FileObject)sgroups[i].getRootFolder()).getAbsolutePath());
                    continue;
                }
                extSrcs.add(sgroups[i].getDisplayName());
            }
            Iterator fsEnum = OpenProjectList_Dist.getFsSet().iterator();
            while (fsEnum.hasNext()) {
                FileSystem fs = (FileSystem)fsEnum.next();
                if (projectDirectory.equalsIgnoreCase(((AbstractNetworkFileSystem)fs).getLocalRoot())) {
                    fsEnum.remove();
                    FileOwnerQuery.markExternalOwner((FileObject)fs.getRoot(), null, (int)0);
                    continue;
                }
                if (!extSrcs.remove(((AbstractNetworkFileSystem)fs).getLocalRoot())) continue;
                fsEnum.remove();
                FileOwnerQuery.markExternalOwner((FileObject)fs.getRoot(), null, (int)0);
            }
            pdir = URLMapper.findFileObject((URL)project.getProjectDirectory().getURL());
            ProjectManager.getDefault().deleteProject(project, pdir);
            ProjectManager.getDefault().clearNonProjectCache();
            Project np = ProjectManager.getDefault().findProject(pdir);
            OpenProjects.getDefault().open(new Project[]{np}, true);
            return;
        }
        catch (ClassCastException cc) {
            System.out.println("This is it" + cc.getMessage());
            return;
        }
        catch (Exception e) {
            waitDialog.closeDialog();
            e.printStackTrace(System.out);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting a project. " + e.getMessage() + "\n" + "Please open it again to complete the conversion to the NetBeans Project"), 1));
            return;
        }
        finally {
            waitDialog.closeDialog();
        }
    }

    private org.w3c.dom.Node findXMLNode(AntProjectCookie apc) {
        Element ourDoc = apc.getDocument().getDocumentElement();
        NodeList nlist = ourDoc.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Element e;
            String importName;
            if (!nlist.item(i).getNodeName().equals("import") || !(importName = (e = (Element)nlist.item(i)).getAttribute("file")).equals(OPENVMS_BUILDIMPL)) continue;
            return nlist.item(i);
        }
        return null;
    }

    private void findAndRemoveXMLNode(AntProjectCookie apc) {
        org.w3c.dom.Node importNode = this.findXMLNode(apc);
        if (importNode != null) {
            Element ourDoc = apc.getDocument().getDocumentElement();
            org.w3c.dom.Node removed = ourDoc.removeChild(importNode);
        }
    }

    public void removeNode(File buildXml) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(buildXml);
        org.w3c.dom.Node project_node = null;
        NodeList root_nodelist = document.getChildNodes();
        int find_import_node = 0;
        Element em = document.createElement("import");
        em.setAttribute("file", "ovms-build.xml");
        block0: for (int find_project_node = 0; find_project_node < root_nodelist.getLength(); ++find_project_node) {
            project_node = root_nodelist.item(find_project_node);
            project_node.getNodeName();
            if (!project_node.getNodeName().equalsIgnoreCase("project")) continue;
            NodeList nl_project = project_node.getChildNodes();
            for (find_import_node = 0; find_import_node < nl_project.getLength(); ++find_import_node) {
                org.w3c.dom.Node import_node = nl_project.item(find_import_node);
                if (!import_node.getNodeName().equalsIgnoreCase("import")) continue;
                String s = import_node.getAttributes().getNamedItem("file").toString();
                import_node.getParentNode().removeChild(import_node);
                continue block0;
            }
        }
        this.saveDocument(document, buildXml);
    }

    private void saveDocument(Document document, File file) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    public static RemoteAntExecutor getRemoteAntExecutorType() {
        RemoteAntExecutor ex = (RemoteAntExecutor)Lookup.getDefault().lookup(RemoteAntExecutor.class);
        return ex;
    }

    public static void doAntAction(Node[] activatedNodes) {
        int i;
        if (DistributedSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        for (i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i].getCookie(AntProjectCookie.class) == null) continue;
            DataObject dobj = (DataObject)activatedNodes[i].getCookie(DataObject.class);
            RemoteAntExecutor ret = ConvertToRemoteProject.getRemoteAntExecutorType();
            if (ret == null) {
                ErrorManager.getDefault().notify((Throwable)new Exception("Remote Ant Execute Action Failed"));
                return;
            }
            try {
                String target = ConvertToRemoteProject.getTarget(activatedNodes[i]);
                ret.execute(dobj, target, new HashMap()).result();
                continue;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        for (i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i].getCookie(AntProjectCookie.class) == null) continue;
            final AntProjectCookie pcookie = (AntProjectCookie)activatedNodes[i].getCookie(AntProjectCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    FileObject script = pcookie.getFileObject();
                    if (script != null) {
                        try {
                            FileSystem fs = script.getFileSystem();
                            fs.refresh(false);
                        }
                        catch (FileStateInvalidException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                }
            }, 1000);
        }
    }

    protected int mode() {
        return 7;
    }

    public String getName() {
        if (this.doConvert) {
            return NbBundle.getMessage(RemoteAntExecution.class, (String)"CTL_ConvertToRemoteProject");
        }
        return NbBundle.getMessage(RemoteAntExecution.class, (String)"CTL_UnConvertFromRemoteProject");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static boolean isEnable(Node[] node) {
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(DataObject.class);
            if (dobj == null) {
                return false;
            }
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            if (dobj.getCookie(RemoteCookie.class) != null) {
                return false;
            }
            if (node[i].getCookie(AntProjectCookie.class) != null) continue;
            return false;
        }
        return true;
    }

    protected boolean enable(Node[] node) {
        if (node.length == 0) {
            return false;
        }
        Lookup lookup = node[0].getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        if (project == null) {
            return false;
        }
        AntArtifactProvider antProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
        if (antProvider == null) {
            return false;
        }
        AntArtifact[] antArts = antProvider.getBuildArtifacts();
        FileObject buildXml = antArts == null || antArts.length == 0 ? Utils.getFreeFormBuildFile(project) : antArts[0].getScriptFile();
        if (buildXml == null) {
            return false;
        }
        FileObject pdir = project.getProjectDirectory();
        String projectDirectory = FileUtil.toFile((FileObject)pdir).getAbsolutePath();
        this.doConvert = true;
        for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
            if (!(fs instanceof AbstractNetworkFileSystem) || !projectDirectory.equalsIgnoreCase(((AbstractNetworkFileSystem)fs).getLocalRoot())) continue;
            this.doConvert = false;
            break;
        }
        return true;
    }

    private static String getTarget(Node node) {
        AntProjectCookie project = (AntProjectCookie)node.getCookie(AntProjectCookie.class);
        if (project == null) {
            return null;
        }
        if (project.getParseException() != null) {
            return null;
        }
        Element pel = project.getProjectElement();
        String deftarget = pel.getAttribute("default");
        return deftarget;
    }
}

