/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.editor.pascal;

import com.hp.openvms.netbeans.pascalsupport.editor.lang.PascalLanguage;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.IndentInfo;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.PascalFormatSupport;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.PascalTokenContext;
import com.hp.openvms.netbeans.pascalsupport.editor.pascal.StringLexerInput;
import com.hp.openvms.netbeans.pascalsupport.pascal.PascalCompilerType;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.openide.compiler.CompilerType;

public class PascalFormatter
extends ExtFormatter {
    public int openParenOn = 0;

    public PascalFormatter(Class kitClass) {
        super(kitClass);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof PlainSyntax;
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        int[] ret = null;
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        int dotPos = target.getCaret().getDot();
        if (doc != null) {
            if ("n".equals(typedText) | "N".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if (fnw >= 0 && fnw + 5 == dotPos && "begin".equals(doc.getText(fnw, 5)) | "BEGIN".equals(doc.getText(fnw, 5))) {
                        ret = new int[]{fnw, fnw + 5};
                    }
                    if ("then".equals(doc.getText(fnw, 4)) | "THEN".equals(doc.getText(fnw, 4))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {}
            } else if (".".equals(typedText) | "d".equals(typedText) | "D".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if ("end.".equals(doc.getText(fnw, 4)) | "END.".equals(doc.getText(fnw, 4)) | "end".equals(doc.getText(fnw, 3)) | "END".equals(doc.getText(fnw, 3))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {}
            } else if ("e".equals(typedText) | "E".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if ("else".equals(doc.getText(fnw, 4)) | "ELSE".equals(doc.getText(fnw, 4))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {}
            } else if ("l".equals(typedText) | "L".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if ("until".equals(doc.getText(fnw, 5)) | "UNTIL".equals(doc.getText(fnw, 5))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
        this.addFormatLayer((FormatLayer)new PascalLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter fw) {
        return new PascalFormatSupport(fw);
    }

    public class PascalLayer
    extends AbstractFormatLayer {
        public int initialIndentation;

        public PascalLayer() {
            super("pascal-layer");
            this.initialIndentation = 0;
            PascalFormatter.this.openParenOn = 0;
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new PascalFormatSupport(fw);
        }

        public TokenContextPath getTokenContextPath() {
            return PascalTokenContext.contextPath;
        }

        public TokenID getWhitespaceTokenID() {
            return PascalTokenContext.WHITESPACE;
        }

        public TokenContextPath getWhitespaceTokenContextPath() {
            return this.getTokenContextPath();
        }

        public void insertWhiteSpace(FormatWriter fw, FormatTokenPosition pos, int indent) {
            if (pos.getToken() != null) {
                for (int i = 0; i < indent; ++i) {
                    fw.insertString(pos.getToken(), 0, " ");
                }
            } else {
                for (int i = 0; i < indent; ++i) {
                    fw.insertToken(null, null, null, " ");
                }
            }
        }

        public boolean isWhiteSpace(FormatTokenPosition pos) {
            PascalLanguage language = PascalLanguage.get();
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            return tok.getId().getIntId() == 1;
        }

        public TokenItem findLineStartToken(TokenItem token, PascalFormatSupport fs) {
            if (token != null) {
                FormatTokenPosition pos = fs.getPosition(token, 0);
                pos = fs.findLineStart(pos);
                token = pos.getToken();
                while (token.getTokenID() == PascalTokenContext.WHITESPACE) {
                    token = token.getNext();
                }
            }
            return token;
        }

        public void removeFirstTabFromLine(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs) {
            FormatTokenPosition tmpPos = pos;
            FormatTokenPosition savPos = pos;
            if (tmpPos != null) {
                while (tmpPos != null && tmpPos.getToken() != null && tmpPos.getToken().getImage() != null && tmpPos.getToken().getImage().charAt(0) != '\n') {
                    savPos = tmpPos;
                    if ((tmpPos = fs.getPreviousPosition(tmpPos)) != null) continue;
                }
                if ((tmpPos = savPos) != null && tmpPos.getToken() != null && tmpPos.getToken().getImage() != null && tmpPos.getToken().getImage().charAt(0) != '\n') {
                    savPos = tmpPos;
                    String tabString = savPos.getToken().getImage();
                    while (tabString.indexOf(9) != -1) {
                        int tabPos = tabString.indexOf(9);
                        tabString = tabString.substring(0, tabPos) + tabString.substring(tabString.indexOf(9) + 1, tabString.length());
                        fw.remove(tmpPos.getToken(), tabPos, 1);
                        for (int i = 0; i < fs.getSpacesPerTab(); ++i) {
                            tabString = tabString.substring(0, tabPos) + " " + tabString.substring(tabPos, tabString.length());
                            fw.insertString(savPos.getToken(), tabPos, " ");
                        }
                    }
                }
            }
        }

        public void removeWhiteSpace(FormatWriter fw, FormatTokenPosition pos, int indent) {
            PascalLanguage language = PascalLanguage.get();
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            if (tok != null && tok.getId().getIntId() == 1) {
                for (int i = 0; i < indent; ++i) {
                    fw.remove(pos.getToken(), 0, 1);
                }
            }
        }

        public int getVisualPos(FormatTokenPosition pos, String strVal) {
            int tmpPos = pos.getToken().getImage().toLowerCase().indexOf(strVal);
            if (tmpPos < 0) {
                tmpPos = 0;
            }
            return tmpPos;
        }

        public void AdjustCursor(FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, int indent) {
            if (indent != idf.getIndent() && indent > idf.getIndent()) {
                this.insertWhiteSpace(fw, pos, indent - idf.getIndent());
            }
        }

        public void IndentLine(PascalFormatSupport fs, FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, int indent) {
            FormatTokenPosition firstNWS = fs.findLineFirstNonWhitespace(pos);
            int tempIndent = idf.getIndent();
            if (firstNWS != null) {
                boolean remove = true;
                if (indent != tempIndent) {
                    if (indent > tempIndent) {
                        int temp = indent - tempIndent;
                        this.insertWhiteSpace(fw, firstNWS, temp);
                    } else {
                        int temp = tempIndent - indent;
                        if (remove) {
                            this.removeWhiteSpace(fw, pos, temp);
                        }
                    }
                }
            }
        }

        public FormatTokenPosition FindCorrespondingIFStatement(FormatTokenPosition pos, PascalFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) {
                    pos = current;
                    break;
                }
                if (!fs.isIfInSameLineAsElse(temp)) {
                    if (fs.isIfOnlyStatement(temp) || fs.isIfThenStatement(temp)) {
                        if (i > 0) {
                            --i;
                        } else if (i == 0) {
                            FormatTokenPosition ip;
                            pos = ip = fs.getInitialPosition(temp);
                            break;
                        }
                    } else if (fs.isElseIfStatement(temp)) {
                        if (i > 0) {
                            --i;
                        } else if (i == 0) {
                            FormatTokenPosition ip;
                            pos = ip = fs.getInitialPosition(temp);
                            break;
                        }
                    } else if (fs.isELSEOnlyStatement(temp)) {
                        ++i;
                    }
                }
                pos = temp;
            }
            return pos;
        }

        public boolean IsIfStatementClosed(FormatTokenPosition pos, PascalFormatSupport fs) {
            boolean status;
            block1: {
                FormatTokenPosition temp;
                FormatTokenPosition current = fs.getInitialPosition(pos);
                status = false;
                boolean i = false;
                do {
                    if ((temp = fs.getNextNonEmptyLine(pos)) == null) break block1;
                } while (!fs.isBegin(temp));
                return this.IsBeginBalanced(temp, fs);
            }
            status = false;
            return status;
        }

        public boolean IsBeginBalanced(FormatTokenPosition pos, PascalFormatSupport fs) {
            FormatTokenPosition nxt = fs.getNextNonEmptyLine(pos);
            int i = 0;
            while (nxt != null) {
                if (nxt == null) {
                    return false;
                }
                if (!fs.isBeginInSameLineAsEnd(nxt)) {
                    if (fs.isBegin(nxt)) {
                        --i;
                    } else if (fs.isEnd(nxt) && ++i == 1) {
                        return true;
                    }
                }
                nxt = fs.getNextNonEmptyLine(nxt);
            }
            return false;
        }

        public FormatTokenPosition FindCorrespondingRepeat(FormatTokenPosition pos, PascalFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (!fs.isRepeatInSameLineAsUntil(temp)) {
                    if (fs.isUntil(temp)) {
                        --i;
                    } else if (fs.isRepeat(temp) && ++i == 1) {
                        FormatTokenPosition ip;
                        pos = ip = fs.getInitialPosition(temp);
                        return pos;
                    }
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingBegin(FormatTokenPosition pos, PascalFormatSupport fs) {
            if (fs.isBeginInSameLineAsEnd(pos)) {
                return fs.getInitialPosition(pos);
            }
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (!fs.isBeginInSameLineAsEnd(temp)) {
                    if (fs.isCase(temp)) {
                        int a = fs.getCaserec();
                        if (a == 0) {
                            if (++i == 1) {
                                FormatTokenPosition ip;
                                pos = ip = fs.getInitialPosition(temp);
                                return pos;
                            }
                        } else {
                            a = fs.getCaserec();
                            fs.setCaserec(a - 1);
                        }
                    } else if (fs.isRecord(temp)) {
                        if (++i == 1) {
                            FormatTokenPosition ip;
                            pos = ip = fs.getInitialPosition(temp);
                            return pos;
                        }
                    } else if (fs.isEnd(temp)) {
                        --i;
                    } else if (fs.isBegin(temp) && ++i == 1) {
                        FormatTokenPosition ip;
                        pos = ip = fs.getInitialPosition(temp);
                        return pos;
                    }
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingOpenParen(FormatTokenPosition pos, PascalFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isLineClosedOnly(temp)) {
                    --i;
                } else if (fs.isLineOpenOnly(temp) && ++i == 1) {
                    FormatTokenPosition ip = fs.getInitialPosition(temp);
                    return ip;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public void formatOpenLine(PascalFormatSupport fs, FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, FormatTokenPosition ip) {
            FormatTokenPosition tmpPos = ip;
            int mOpenPos = 0;
            if (tmpPos != null) {
                mOpenPos = fs.getLineOpenPos(tmpPos);
            }
            if (mOpenPos <= 1) {
                this.IndentLine(fs, fw, pos, idf, fs.getIndent(tmpPos) + fs.getShiftWidth());
            } else {
                this.IndentLine(fs, fw, pos, idf, mOpenPos);
            }
        }

        public void formatCommentLine(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs) {
            if (pos != null) {
                int commentPos = fs.getCommentPosition();
                String tmpCommentChar = fs.getCommentChar(pos);
                if (tmpCommentChar == null) {
                    return;
                }
                int actualPos = pos.getToken().getImage().indexOf(tmpCommentChar) + 1;
                if (commentPos != actualPos && commentPos > actualPos) {
                    FormatTokenPosition tmpPos = fs.getPosition(pos.getToken(), actualPos - 1);
                    this.insertWhiteSpace(fw, tmpPos, commentPos - actualPos);
                }
            }
        }

        public void formatBegin(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
            if (prev != null) {
                if (fs.isBegin(prev) && !fs.isBeginInSameLineAsEnd(prev)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(prev)) + fs.getShiftWidth());
                    return;
                }
                if (fs.isIfThenOnlyStatement(prev)) {
                    this.IndentLine(fs, fw, pos, idf, this.getVisualPos(prev, "if"));
                    return;
                }
                if (fs.isWhile(prev) || fs.isIfOnlyStatement(prev) || fs.isELSEOnlyStatement(prev) || fs.isForOnly(prev) || fs.isWith(prev) || fs.isRepeat(prev)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(prev)));
                    return;
                }
            }
            if (fs.isWhile(pos) || fs.isForOnly(pos) || fs.isWith(pos) || fs.isIfOnlyStatement(pos)) {
                FormatTokenPosition fp = fs.getPreviousUnbalancedLine(pos);
                this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(fp)));
                return;
            }
            int i = 0;
            int p = 0;
            while (prev != null) {
                FormatTokenPosition prv;
                FormatTokenPosition ip = fs.getInitialPosition(prev);
                if (fs.isBeginInSameLineAsEnd(ip)) {
                    prv = fs.getPreviousNonEmptyLine(ip);
                    while (fs.isComment(prv)) {
                        prv = fs.getPreviousNonEmptyLine(ip);
                    }
                    if ((fs.isConst(prv) || fs.isLabel(prv) || fs.isType(prv) || fs.isVar(prv) || fs.isFunction(prv) || fs.isProcedure(prv) || fs.isProgram(prv)) && i != 0) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        return;
                    }
                } else if (fs.isBegin(ip)) {
                    prv = fs.getPreviousNonEmptyLine(ip);
                    ++i;
                    while (fs.isComment(prv)) {
                        prv = fs.getPreviousNonEmptyLine(ip);
                    }
                    if ((fs.isConst(prv) || fs.isLabel(prv) || fs.isType(prv) || fs.isVar(prv)) && i != 0) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        return;
                    }
                    if (i == 0) {
                        ++p;
                    } else if (i > 0 && p == 0) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        return;
                    }
                } else if (fs.isEnd(ip)) {
                    --i;
                } else if (fs.isFunction(ip) || fs.isProcedure(ip) || fs.isProgram(ip) || fs.isConst(ip) || fs.isLabel(ip) || fs.isType(ip) || fs.isVar(ip)) {
                    if (p == 0) {
                        if (fs.isLineClosedOnly(ip)) {
                            FormatTokenPosition corrOpenLinePos = this.FindCorrespondingOpenParen(ip, fs);
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(corrOpenLinePos)));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        }
                        return;
                    }
                    --p;
                } else if ((fs.isCase(ip) || fs.isRecord(ip)) && i == 0) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    return;
                }
                prev = fs.getPreviousNonEmptyLine(prev);
            }
        }

        public void formatFunction(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
            if (prev != null) {
                FormatTokenPosition ip = fs.getInitialPosition(prev);
                if (fs.isFunction(ip) || fs.isProcedure(ip)) {
                    if (fs.isEndingWithSemicolon(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                    } else {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    }
                } else if (fs.isLineOpenOnly(ip)) {
                    String tmpImg = pos.getToken().getImage().trim();
                    int i = tmpImg.toLowerCase().indexOf("func");
                    if (i < 0) {
                        tmpImg.toLowerCase().indexOf("proc");
                    }
                    if (i > 0) {
                        this.formatOpenLine(fs, fw, pos, idf, ip);
                    } else {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    }
                } else if (PascalFormatter.this.openParenOn > 0 || fs.isLineClosedOnly(ip)) {
                    FormatTokenPosition corrOpenLinePos = this.FindCorrespondingOpenParen(pos, fs);
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(corrOpenLinePos)));
                } else if (fs.isProgram(ip)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                } else {
                    int idt = fs.getIndent(ip);
                    int actualIdt = idt - fs.getShiftWidth();
                    if (actualIdt <= 0) {
                        this.IndentLine(fs, fw, pos, idf, 0);
                    } else {
                        this.IndentLine(fs, fw, pos, idf, actualIdt);
                    }
                }
            }
        }

        public void formatRepeat(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
            if (prev != null) {
                FormatTokenPosition ip = fs.getInitialPosition(prev);
                if (fs.isRepeat(ip)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                } else if (fs.isCase(ip) || fs.isWhile(ip) || fs.isBegin(ip) || fs.isRecord(ip) || fs.isELSEOnlyStatement(ip) || fs.isForOnly(ip) || fs.isIfOnlyStatement(ip) || fs.isLineOpenOnly(ip) || fs.isRepeat(ip) || fs.isWhile(ip)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                } else {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                }
            }
        }

        public void formatCase(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
            if (prev != null) {
                FormatTokenPosition ip = fs.getInitialPosition(prev);
                this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
            }
        }

        public void formatEnd(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition corrBegin = this.FindCorrespondingBegin(pos, fs);
            this.IndentLine(fs, fw, pos, idf, fs.getIndent(corrBegin));
        }

        public void formatClosedParen(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition corrOpen = this.FindCorrespondingOpenParen(pos, fs);
            int tmpIndent = fs.getLineOpenPos(corrOpen);
            this.IndentLine(fs, fw, pos, idf, tmpIndent);
        }

        public void formatClosedParen(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf, int tmpIndent) {
            this.IndentLine(fs, fw, pos, idf, tmpIndent);
        }

        public void formatUntil(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition CorrRep = this.FindCorrespondingRepeat(pos, fs);
            this.IndentLine(fs, fw, pos, idf, fs.getIndent(CorrRep));
        }

        public void formatGeneral(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs, IndentInfo idf) {
            if ((fs.isELSEStatement(pos) || fs.isELSEOnlyStatement(pos)) && !fs.isIFStatement(pos)) {
                if (!fs.isIfInSameLineAsElse(pos)) {
                    FormatTokenPosition MostRecentIf = this.FindCorrespondingIFStatement(pos, fs);
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf));
                } else {
                    FormatTokenPosition preIf = fs.getPreviousNonEmptyLine(pos);
                    if (fs.isBegin(preIf) || fs.isForOnly(preIf) || fs.isWhile(preIf) || fs.isRepeat(preIf) || fs.isWith(preIf) || fs.isIfOnlyStatement(preIf) || fs.isELSEOnlyStatement(preIf)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(preIf) + fs.getShiftWidth());
                    } else {
                        FormatTokenPosition fbp = fs.getPreviousUnbalancedLine(pos);
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(fbp)));
                    }
                }
            } else if (fs.isThenStatement(pos)) {
                FormatTokenPosition MostRecentIf = this.FindCorrespondingIFStatement(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf));
            } else if (fs.isLineClosedOnly(pos)) {
                FormatTokenPosition corrOpen = this.FindCorrespondingOpenParen(pos, fs);
                if (fs.isFunction(corrOpen) || fs.isProcedure(corrOpen) || fs.isProgram(corrOpen)) {
                    FormatTokenPosition prePos = fs.getPreviousNonEmptyLine(pos);
                    if (prePos.equals(corrOpen)) {
                        this.formatClosedParen(fw, pos, fs, idf, fs.getIndent(fs.getInitialPosition(prePos)) + fs.getShiftWidth());
                    } else {
                        this.formatClosedParen(fw, pos, fs, idf, fs.getIndent(fs.getInitialPosition(prePos)));
                    }
                } else {
                    this.formatClosedParen(fw, pos, fs, idf, fs.getLineOpenPos(corrOpen));
                    int cntCloseParen = fs.getCountClosedParen(pos);
                    PascalFormatter.this.openParenOn = PascalFormatter.this.openParenOn >= cntCloseParen ? (PascalFormatter.this.openParenOn -= cntCloseParen) : 0;
                }
            } else if (fs.isUntil(pos) && !fs.isRepeatInSameLineAsUntil(pos)) {
                this.formatUntil(fw, pos, fs, idf);
            } else if (fs.isProgram(pos)) {
                this.IndentLine(fs, fw, pos, idf, 0);
            } else if (fs.isProcedure(pos)) {
                this.formatFunction(fw, pos, fs, idf);
            } else if (fs.isFunction(pos)) {
                this.formatFunction(fw, pos, fs, idf);
            } else if (fs.isConst(pos) || fs.isLabel(pos) || fs.isType(pos) || fs.isVar(pos)) {
                FormatTokenPosition p1 = fs.getPreviousNonEmptyLine(pos);
                if (p1 != null) {
                    FormatTokenPosition p2 = fs.getPreviousNonEmptyLine(p1);
                    if (PascalFormatter.this.openParenOn > 0) {
                        this.formatClosedParen(fw, pos, fs, idf);
                    } else if (fs.isLineOpenOnly(pos)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(p1)) + fs.getShiftWidth());
                        ++PascalFormatter.this.openParenOn;
                    } else if (fs.isLineClosedOnly(p1)) {
                        FormatTokenPosition corrOpenLinePos = this.FindCorrespondingOpenParen(p1, fs);
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(corrOpenLinePos)));
                    } else if (fs.isFunction(p1) || fs.isProcedure(p1)) {
                        if (fs.isLineOpenOnly(p1)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(p1)) + fs.getShiftWidth());
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(p1)));
                        }
                    } else if (fs.isFunction(p2) || fs.isProcedure(p2)) {
                        if (fs.isLineOpenOnly(p2)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(p2)) + fs.getShiftWidth());
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(p2)));
                        }
                    } else {
                        FormatTokenPosition tmp = fs.getPreviousNonEmptyLine(pos);
                        while (tmp != null) {
                            if (fs.isVar(tmp) || fs.isConst(tmp) || fs.isLabel(tmp) || fs.isType(tmp)) {
                                this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(tmp)));
                                return;
                            }
                            if (fs.isFunction(tmp) || fs.isProcedure(tmp) || fs.isProgram(tmp)) {
                                if (fs.isLineOpenOnly(tmp)) {
                                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(tmp)) + fs.getShiftWidth());
                                } else {
                                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(tmp)));
                                }
                            }
                            tmp = fs.getPreviousNonEmptyLine(tmp);
                        }
                    }
                }
            } else if (fs.isCase(pos)) {
                int a;
                FormatTokenPosition nw = fs.getPreviousNonEmptyLine(pos);
                FormatTokenPosition nn = fs.getInitialPosition(nw);
                FormatTokenPosition nw1 = fs.getPreviousNonEmptyLine(nw);
                FormatTokenPosition nn1 = fs.getInitialPosition(nw1);
                if (fs.isLineOpenOnly(pos)) {
                    ++PascalFormatter.this.openParenOn;
                }
                if ((a = fs.getCaserec()) > 0) {
                    fs.setCaserec(a + 1);
                    if (fs.isLineOpenOnly(nw) || fs.isRecord(nw)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(nn) + fs.getShiftWidth());
                    } else {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(nn));
                    }
                } else if (fs.isRecord(nw)) {
                    fs.setCaserec(a + 1);
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(nn) + fs.getShiftWidth());
                } else if (fs.isRecord(nw1)) {
                    fs.setCaserec(a + 1);
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(nn1) + fs.getShiftWidth());
                } else if (fs.isCase(nw) || fs.isWhile(nw) || fs.isBegin(nw) || fs.isELSEOnlyStatement(nw) || fs.isForOnly(nw) || fs.isIfOnlyStatement(nw) || fs.isLineOpenOnly(nw) || fs.isRepeat(nw) || fs.isWhile(nw)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(nn) + fs.getShiftWidth());
                } else {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(nn));
                }
            } else if (fs.isBeginInSameLineAsEnd(pos)) {
                FormatTokenPosition preBeg = fs.getPreviousNonEmptyLine(pos);
                if (fs.isForOnly(preBeg) || fs.isWhile(preBeg) || fs.isRepeat(preBeg) || fs.isWith(preBeg) || fs.isIfOnlyStatement(preBeg) || fs.isELSEOnlyStatement(preBeg) || fs.isIfInSameLineAsElse(preBeg) || fs.isFunction(preBeg) || fs.isProcedure(preBeg) || fs.isProgram(preBeg)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(preBeg)));
                } else {
                    FormatTokenPosition pp = fs.getPreviousUnbalancedLine(pos);
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(pp)));
                }
            } else if (fs.isBegin(pos) && !fs.isELSEOnlyStatement(pos)) {
                this.formatBegin(fw, pos, fs, idf);
            } else if (fs.isEnd(pos)) {
                this.formatEnd(fw, pos, fs, idf);
            } else if (fs.isEndingWithComma(pos)) {
                if (PascalFormatter.this.openParenOn > 0) {
                    if (fs.isLineOpenOnly(pos)) {
                        ++PascalFormatter.this.openParenOn;
                    }
                    this.formatClosedParen(fw, pos, fs, idf);
                } else {
                    FormatTokenPosition preLine;
                    if (fs.isLineOpenOnly(pos)) {
                        ++PascalFormatter.this.openParenOn;
                    }
                    if ((preLine = fs.getPreviousNonEmptyLine(pos)) != null) {
                        if (fs.isVar(preLine) || fs.isConst(preLine) || fs.isLabel(preLine) || fs.isType(preLine) || fs.isFunction(preLine) || fs.isProcedure(preLine) || fs.isProgram(preLine)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(preLine)) + fs.getShiftWidth());
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(preLine)));
                        }
                    } else {
                        this.IndentLine(fs, fw, pos, idf, fs.getShiftWidth());
                    }
                }
            } else if (fs.isLineOpenOnly(pos)) {
                ++PascalFormatter.this.openParenOn;
                FormatTokenPosition preLine = fs.getPreviousNonEmptyLine(pos);
                if (preLine != null) {
                    if (fs.isVar(preLine) || fs.isConst(preLine) || fs.isLabel(preLine) || fs.isType(preLine) || fs.isFunction(preLine) || fs.isProcedure(preLine) || fs.isProgram(preLine)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(preLine)) + fs.getShiftWidth());
                    } else {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(preLine)));
                    }
                } else {
                    this.IndentLine(fs, fw, pos, idf, 0);
                }
            } else {
                FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
                if (prev != null) {
                    FormatTokenPosition ip = fs.getInitialPosition(prev);
                    if (PascalFormatter.this.openParenOn > 0) {
                        FormatTokenPosition tmpPos = this.FindCorrespondingOpenParen(pos, fs);
                        this.formatOpenLine(fs, fw, pos, idf, tmpPos);
                    } else if (fs.isIfOnlyStatement(ip) | fs.isELSEOnlyStatement(ip)) {
                        if (fs.isEndingWithSemicolon(ip)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        }
                    } else if (fs.isThenStatement(ip)) {
                        FormatTokenPosition MostRecentIf = this.FindCorrespondingIFStatement(ip, fs);
                        if (fs.isEndingWithSemicolon(ip)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf) + fs.getShiftWidth());
                        }
                    } else if (fs.isIfThenOnlyStatement(ip) || fs.isIfInSameLineAsElse(ip)) {
                        if (fs.isEndingWithSemicolon(ip)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, this.getVisualPos(ip, "if") + fs.getShiftWidth());
                        }
                    } else if (fs.isBegin(ip) && !fs.isBeginInSameLineAsEnd(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    } else if (fs.isEnd(ip) && !fs.isBeginInSameLineAsEnd(ip) && fs.isEndingWithSemicolon(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                    } else if (fs.isVar(ip) || fs.isType(ip) || fs.isLabel(ip) || fs.isConst(ip)) {
                        if (fs.isEndingWithSemicolon(ip)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        }
                    } else if ((fs.isFunction(ip) || fs.isProcedure(ip)) && !fs.isEndingWithSemicolon(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    } else if (fs.isWhile(ip) || fs.isRecord(ip) || fs.isWith(ip) || fs.isForOnly(ip) || fs.isFileOnly(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    } else if (fs.isRepeat(ip)) {
                        if (!fs.isRepeatInSameLineAsUntil(ip)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        }
                    } else if (fs.isCase(ip)) {
                        if (PascalFormatter.this.openParenOn > 0) {
                            FormatTokenPosition tmpPos = this.FindCorrespondingOpenParen(pos, fs);
                            this.formatOpenLine(fs, fw, pos, idf, tmpPos);
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        }
                    } else if (fs.isLineOpenOnly(ip)) {
                        this.formatOpenLine(fs, fw, pos, idf, ip);
                    } else {
                        FormatTokenPosition ppp = fs.getPreviousNonEmptyLine(ip);
                        while (fs.isComment(ppp)) {
                            ppp = fs.getPreviousNonEmptyLine(ppp);
                        }
                        if (fs.isBegin(ppp) && !fs.isBeginInSameLineAsEnd(ppp)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(ppp)) + fs.getShiftWidth());
                        } else {
                            FormatTokenPosition tmp = fs.getPreviousUnbalancedLine(pos);
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(tmp)));
                        }
                    }
                } else {
                    this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                }
            }
        }

        public void formatLine(FormatWriter fw, FormatTokenPosition pos, PascalFormatSupport fs) {
            this.removeFirstTabFromLine(fw, pos, fs);
            if (fs.findLineFirstNonWhitespace(pos) != null) {
                IndentInfo idf = new IndentInfo();
                fs.getIndentationInfo(pos, idf);
                this.formatGeneral(fw, pos, fs, idf);
            }
        }

        public void format(FormatWriter fw) {
            block21: {
                try {
                    Document doc = fw.getDocument();
                    String s = Utilities.getLastActiveComponent().getSelectedText();
                    PascalFormatSupport fs = (PascalFormatSupport)this.createFormatSupport(fw);
                    FormatTokenPosition pos = fs.getFormatStartPosition();
                    boolean t = false;
                    PascalFormatter.this.openParenOn = 0;
                    fs.setIsComment(false);
                    if (fs.isIndentOnly()) {
                        IndentInfo idf = new IndentInfo();
                        fs.getIndentationInfo(pos, idf);
                        if (fs.findLineFirstNonWhitespace(pos) != null) {
                            this.formatGeneral(fw, pos, fs, idf);
                        } else {
                            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
                            if (prev != null) {
                                FormatTokenPosition ip = fs.getInitialPosition(prev);
                                if (fs.isEndingWithSemicolon(ip)) {
                                    this.AdjustCursor(fw, pos, idf, fs.getIndent(ip));
                                } else if (fs.isIfOnlyStatement(ip) || fs.isELSEOnlyStatement(ip) || fs.isBegin(ip) || fs.isConst(ip) || fs.isLabel(ip) || fs.isType(ip) || fs.isVar(ip)) {
                                    if (fs.isLineClosedOnly(ip)) {
                                        FormatTokenPosition corrOpenLinePos = this.FindCorrespondingOpenParen(ip, fs);
                                        this.AdjustCursor(fw, pos, idf, fs.getIndent(fs.getInitialPosition(corrOpenLinePos)));
                                    } else {
                                        this.AdjustCursor(fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                                    }
                                } else if (fs.isWhile(ip) || fs.isRepeat(ip) || fs.isForOnly(ip) || fs.isRecord(ip) || fs.isWith(ip) || fs.isThenStatement(ip)) {
                                    this.AdjustCursor(fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                                } else {
                                    FormatTokenPosition ppr = fs.getPreviousNonEmptyLine(prev);
                                    if (fs.isIfOnlyStatement(ppr) || fs.isELSEOnlyStatement(ppr) || fs.isWhile(ppr) || fs.isForOnly(ppr) || fs.isWith(ppr)) {
                                        this.AdjustCursor(fw, pos, idf, fs.getIndent(fs.getInitialPosition(ppr)));
                                    } else {
                                        this.AdjustCursor(fw, pos, idf, fs.getIndent(ip));
                                    }
                                }
                            }
                        }
                        break block21;
                    }
                    while (pos != null) {
                        if (!fs.isComment(pos)) {
                            this.formatLine(fw, pos, fs);
                        } else {
                            this.formatCommentLine(fw, pos, fs);
                        }
                        PascalCompilerType ct = (PascalCompilerType)CompilerType.find(PascalCompilerType.class);
                        FormatTokenPosition pos2 = fs.findLineEnd(pos);
                        if (pos2 != null && pos2.getToken() != null && (pos = fs.getNextPosition(pos2, Position.Bias.Forward)) != pos2 && pos != null && pos.getToken() != null) {
                            FormatTokenPosition fnw = fs.findLineFirstNonWhitespace(pos);
                            if (fnw != null) {
                                pos = fnw;
                                continue;
                            }
                            pos = fs.findLineStart(pos);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("pascal-strip-whitespace-at-line-end");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new PascalFormatSupport(fw);
        }

        public void format(FormatWriter fw) {
            Document doc = fw.getDocument();
            PascalFormatSupport fs = (PascalFormatSupport)this.createFormatSupport(fw);
            FormatTokenPosition pos = fs.getFormatStartPosition();
            if (!fs.isIndentOnly()) {
                while (pos.getToken() != null) {
                    if ((pos = fs.removeLineEndWhitespace(pos)).getToken() == null) continue;
                    pos = fs.getNextPosition(pos);
                }
            }
        }
    }
}

