/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.basicsupport.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.openide.actions.CustomizeAction;
import org.openide.awt.Actions;
import org.openide.awt.JInlineMenu;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class RemotePropertiesAction
extends NodeAction {
    static final long serialVersionUID = 5485687384586248747L;
    static ThreadLocal activated = new ThreadLocal();

    public static void doAction(Node[] activatedNodes) {
        PropertySheet ps = new PropertySheet();
        ps.setNodes(activatedNodes);
        JDialog d = new JDialog();
        if (activatedNodes.length > 1) {
            d.setTitle("Remote Properties of Multiple Objects");
        } else {
            d.setTitle("Remote Properties of " + activatedNodes[0].getName());
        }
        d.setModal(true);
        d.getContentPane().setLayout(new BorderLayout());
        d.getContentPane().add((Component)ps, "Center");
        d.pack();
        d.show();
        d.dispose();
    }

    protected void performAction(Node[] activatedNodes) {
        RemotePropertiesAction.doAction(activatedNodes);
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            DataObject dobj = (DataObject)activatedNodes[i].getCookie(DataObject.class);
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            try {
                if (dobj.getPrimaryFile().getFileSystem() instanceof AbstractNetworkFileSystem) continue;
                return false;
            }
            catch (FileStateInvalidException e) {
                // empty catch block
            }
        }
        return true;
    }

    public JMenuItem getPopupPresenter() {
        Actions.MenuItem prop = new Actions.MenuItem((SystemAction)this, false);
        CustomizeAction customizeAction = (CustomizeAction)SystemAction.get(CustomizeAction.class);
        if (customizeAction.isEnabled()) {
            JInlineMenu mi = new JInlineMenu();
            mi.setMenuItems(new JMenuItem[]{new Actions.MenuItem((SystemAction)customizeAction, false), prop});
            return mi;
        }
        return prop;
    }

    public String getName() {
        return "Remote Properties";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/openide/resources/actions/properties.gif";
    }

    static class ShowPropertiesInvoker
    implements Runnable {
        ShowPropertiesInvoker() {
        }

        public void run() {
            Node[] activatedNodes = (Node[])activated.get();
            activated.set(null);
            if (activatedNodes == null) {
                throw new IllegalStateException();
            }
            if (activatedNodes.length == 1) {
                DataObject dobj = (DataObject)activatedNodes[0].getCookie(DataObject.class);
                NodeOperation.getDefault().showProperties(activatedNodes[0]);
            } else {
                NodeOperation.getDefault().showProperties(activatedNodes);
            }
        }
    }
}

