/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.basicsupport.basic;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerType;
import com.hp.openvms.netbeans.baseclasses.compiler.BogusCompiler;
import com.hp.openvms.netbeans.basicsupport.basic.BasicCompiler;
import com.hp.openvms.netbeans.basicsupport.basic.datasys.BasicDataObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.distributed.common.util.Utils;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class BasicCompilerType
extends AlphaVMSCompilerType {
    private Boolean updated;
    private static ResourceBundle bundle;
    static final long serialVersionUID = 3952144683021797629L;

    public BasicCompilerType(FileObject fobj) {
        super(fobj);
        this.project = FileOwnerQuery.getOwner((FileObject)fobj);
        FileObject pdir = this.project.getProjectDirectory();
        String projectDirectory = FileUtil.toFile((FileObject)pdir).getAbsolutePath();
        this.settingsMap = Utils.getCompilerSettingsFrom3GLXML(projectDirectory, "basic");
    }

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(BasicCompilerType.class);
        }
        return bundle.getString(name);
    }

    public void prepareJob(CompilerJob job, Class type, DataObject obj) {
        if (obj instanceof BasicDataObject) {
            super.prepareJob(job, type, obj);
        } else {
            String message = MessageFormat.format(BasicCompilerType.getString("MSG_InvalidCompiler"), this.getName(), obj.getPrimaryFile().toString());
            Throwable t = ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Invalid compiler"), 256, null, message, null, null);
            BogusCompiler compiler = new BogusCompiler(obj.getPrimaryFile(), t);
            job.add(compiler);
        }
    }

    protected Compiler createCompiler(Class type, FileObject fo) {
        return new BasicCompiler(type, fo, this.getExternalCompiler(), this.getErrorExpression(), this);
    }

    public void flushSettings() throws IOException {
        Utils.writeCompilerSettingto3GLXML(this.project, "basic", this.settingsMap);
    }
}

