/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.baseclasses.compiler;

import java.util.Collection;
import java.util.LinkedList;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.ErrorEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class BogusCompiler
extends Compiler {
    Throwable error;
    FileObject fo;

    public BogusCompiler(FileObject fo, Throwable err) {
        this.error = err;
        this.fo = fo;
    }

    public Class compilerGroupClass() {
        return Group.class;
    }

    protected boolean isUpToDate() {
        return false;
    }

    public static final class Group
    extends CompilerGroup {
        private static final ErrorManager errMan = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
        Collection compilers = new LinkedList();

        public void add(Compiler c) throws IllegalArgumentException {
            if (!(c instanceof BogusCompiler)) {
                throw new IllegalArgumentException("Incorrect compiler type: " + c);
            }
            this.compilers.add(c);
        }

        public boolean start() {
            for (BogusCompiler comp : this.compilers) {
                Throwable t = comp.error;
                FileObject f = comp.fo;
                ErrorManager.Annotation[] anns = errMan.findAnnotations(t);
                boolean shown = false;
                for (int i = 0; i < anns.length; ++i) {
                    String lm = anns[i].getLocalizedMessage();
                    if (lm == null) continue;
                    this.fireErrorEvent(new ErrorEvent(this, f, 0, 0, lm, null));
                    shown = true;
                }
                if (shown) continue;
                this.fireErrorEvent(new ErrorEvent(this, f, 0, 0, t.toString(), null));
            }
            return false;
        }
    }
}

