/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AuxiliaryConfigImpl
implements AuxiliaryConfiguration {
    private static final Logger LOG = Logger.getLogger(AuxiliaryConfigImpl.class.getName());
    static final String AUX_CONFIG_ATTR_BASE = AuxiliaryConfiguration.class.getName();
    static final String AUX_CONFIG_FILENAME = ".netbeans.xml";
    private final Project project;

    public AuxiliaryConfigImpl(Project proj) {
        this.project = proj;
    }

    public Element getConfigurationFragment(final String elementName, final String namespace, final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Element run() {
                Element fragment;
                AuxiliaryConfiguration delegate = (AuxiliaryConfiguration)AuxiliaryConfigImpl.this.project.getLookup().lookup(AuxiliaryConfiguration.class);
                if (delegate != null && (fragment = delegate.getConfigurationFragment(elementName, namespace, shared)) != null) {
                    if (elementName.equals(fragment.getLocalName()) && namespace.equals(fragment.getNamespaceURI())) {
                        return fragment;
                    }
                    LOG.log(Level.INFO, delegate.getClass().getName() + " produced wrong local name or namespace for " + namespace + "#" + elementName + " in " + AuxiliaryConfigImpl.this.project);
                }
                FileObject dir = AuxiliaryConfigImpl.this.project.getProjectDirectory();
                if (shared) {
                    FileObject config = dir.getFileObject(AuxiliaryConfigImpl.AUX_CONFIG_FILENAME);
                    if (config == null) return null;
                    try {
                        Element element;
                        InputStream is = config.getInputStream();
                        try {
                            InputSource input = new InputSource(is);
                            input.setSystemId(config.getURL().toString());
                            Element root = XMLUtil.parse((InputSource)input, (boolean)false, (boolean)true, null, null).getDocumentElement();
                            element = AuxiliaryConfigImpl.findElement(root, elementName, namespace);
                            Object var9_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_15 = null;
                            is.close();
                            throw throwable;
                        }
                        is.close();
                        return element;
                    }
                    catch (Exception x) {
                        LOG.log(Level.INFO, "Cannot parse" + config, x);
                        return null;
                    }
                }
                String attrName = AUX_CONFIG_ATTR_BASE + "." + namespace + "#" + elementName;
                Object attr = dir.getAttribute(attrName);
                if (!(attr instanceof String)) return null;
                try {
                    Element fragment2 = XMLUtil.parse((InputSource)new InputSource(new StringReader((String)attr)), (boolean)false, (boolean)true, null, null).getDocumentElement();
                    if (elementName.equals(fragment2.getLocalName()) && namespace.equals(fragment2.getNamespaceURI())) {
                        return fragment2;
                    }
                    LOG.log(Level.INFO, "Value " + attr + " of " + attrName + " on " + dir + " has the wrong local name or namespace");
                    return null;
                }
                catch (SAXException x) {
                    LOG.log(Level.INFO, "Cannot parse value " + attr + " of " + attrName + " on " + dir + ": " + x.getMessage());
                    return null;
                }
                catch (IOException x) {
                    assert (false) : x;
                    return null;
                }
            }
        });
    }

    public void putConfigurationFragment(final Element fragment, final boolean shared) throws IllegalArgumentException {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                block14: {
                    String elementName = fragment.getLocalName();
                    String namespace = fragment.getNamespaceURI();
                    if (namespace == null) {
                        throw new IllegalArgumentException();
                    }
                    AuxiliaryConfiguration delegate = (AuxiliaryConfiguration)AuxiliaryConfigImpl.this.project.getLookup().lookup(AuxiliaryConfiguration.class);
                    if (delegate != null) {
                        delegate.putConfigurationFragment(fragment, shared);
                        AuxiliaryConfigImpl.this.removeFallbackImpl(elementName, namespace, shared);
                        return null;
                    }
                    FileObject dir = AuxiliaryConfigImpl.this.project.getProjectDirectory();
                    try {
                        if (shared) {
                            Element root;
                            Element oldFragment;
                            Document doc;
                            FileObject config;
                            block13: {
                                config = dir.getFileObject(AuxiliaryConfigImpl.AUX_CONFIG_FILENAME);
                                if (config != null) {
                                    InputStream is = config.getInputStream();
                                    try {
                                        InputSource input = new InputSource(is);
                                        input.setSystemId(config.getURL().toString());
                                        doc = XMLUtil.parse((InputSource)input, (boolean)false, (boolean)true, null, null);
                                        Object var10_11 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var10_12 = null;
                                        is.close();
                                        throw throwable;
                                    }
                                    is.close();
                                    {
                                        break block13;
                                    }
                                }
                                config = dir.createData(AuxiliaryConfigImpl.AUX_CONFIG_FILENAME);
                                doc = XMLUtil.createDocument((String)"auxiliary-configuration", (String)"http://www.netbeans.org/ns/auxiliary-configuration/1", null, null);
                            }
                            if ((oldFragment = AuxiliaryConfigImpl.findElement(root = doc.getDocumentElement(), elementName, namespace)) != null) {
                                root.removeChild(oldFragment);
                            }
                            Node ref = null;
                            NodeList list = root.getChildNodes();
                            for (int i = 0; i < list.getLength(); ++i) {
                                Node node = list.item(i);
                                if (node.getNodeType() != 1) continue;
                                int comparison = node.getNodeName().compareTo(elementName);
                                if (comparison == 0) {
                                    comparison = node.getNamespaceURI().compareTo(namespace);
                                }
                                if (comparison <= 0) continue;
                                ref = node;
                                break;
                            }
                            root.insertBefore(root.getOwnerDocument().importNode(fragment, true), ref);
                            OutputStream os = config.getOutputStream();
                            try {
                                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                                Object var15_19 = null;
                            }
                            catch (Throwable throwable) {
                                Object var15_20 = null;
                                os.close();
                                throw throwable;
                            }
                            os.close();
                            {
                                break block14;
                            }
                        }
                        String attrName = AUX_CONFIG_ATTR_BASE + "." + namespace + "#" + elementName;
                        dir.setAttribute(attrName, (Object)AuxiliaryConfigImpl.elementToString(fragment));
                    }
                    catch (Exception x) {
                        LOG.log(Level.WARNING, "Cannot save configuration to " + dir, x);
                    }
                }
                return null;
            }
        });
    }

    static String elementToString(Element e) throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DOMImplementationLS ls = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
        assert (ls != null) : "No DOM 3 LS supported in " + doc.getClass().getName();
        doc.appendChild(doc.importNode(e, true));
        LSSerializer serializer = ls.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer.writeToString(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFallbackImpl(String elementName, String namespace, boolean shared) {
        block11: {
            FileObject dir = this.project.getProjectDirectory();
            try {
                if (shared) {
                    FileObject config = dir.getFileObject(AUX_CONFIG_FILENAME);
                    if (config == null) break block11;
                    try {
                        block12: {
                            Document doc;
                            InputStream is = config.getInputStream();
                            try {
                                InputSource input = new InputSource(is);
                                input.setSystemId(config.getURL().toString());
                                doc = XMLUtil.parse((InputSource)input, (boolean)false, (boolean)true, null, null);
                                Object var10_12 = null;
                            }
                            catch (Throwable throwable) {
                                Object var10_13 = null;
                                is.close();
                                throw throwable;
                            }
                            is.close();
                            Element root = doc.getDocumentElement();
                            Element toRemove = AuxiliaryConfigImpl.findElement(root, elementName, namespace);
                            if (toRemove == null) break block11;
                            root.removeChild(toRemove);
                            if (root.getElementsByTagName("*").getLength() > 0) {
                                OutputStream os = config.getOutputStream();
                                try {
                                    XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                                    Object var12_16 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var12_17 = null;
                                    os.close();
                                    throw throwable;
                                }
                                os.close();
                                {
                                    break block12;
                                }
                            }
                            config.delete();
                        }
                        return true;
                    }
                    catch (SAXException x) {
                        LOG.log(Level.INFO, "Cannot parse" + config, x);
                    }
                    break block11;
                }
                String attrName = AUX_CONFIG_ATTR_BASE + "." + namespace + "#" + elementName;
                if (dir.getAttribute(attrName) != null) {
                    dir.setAttribute(attrName, null);
                    return true;
                }
            }
            catch (IOException x) {
                LOG.warning("Cannot remove configuration from " + dir);
            }
        }
        return false;
    }

    public boolean removeConfigurationFragment(final String elementName, final String namespace, final boolean shared) throws IllegalArgumentException {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                AuxiliaryConfiguration delegate = (AuxiliaryConfiguration)AuxiliaryConfigImpl.this.project.getLookup().lookup(AuxiliaryConfiguration.class);
                boolean result = false;
                if (delegate != null) {
                    result |= delegate.removeConfigurationFragment(elementName, namespace, shared);
                }
                return result |= AuxiliaryConfigImpl.this.removeFallbackImpl(elementName, namespace, shared);
            }
        });
    }

    private static Element findElement(Element parent, String name, String namespace) {
        Element result = null;
        NodeList l = parent.getChildNodes();
        int len = l.getLength();
        for (int i = 0; i < len; ++i) {
            Element el;
            if (l.item(i).getNodeType() != 1 || !name.equals((el = (Element)l.item(i)).getLocalName()) || !namespace.equals(el.getNamespaceURI())) continue;
            if (result == null) {
                result = el;
                continue;
            }
            return null;
        }
        return result;
    }
}

