/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.SimpleFileOwnerQueryImplementation;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Union2;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectManager {
    private static final Logger LOG = Logger.getLogger(ProjectManager.class.getName());
    private static final Logger TIMERS = Logger.getLogger("TIMER.projects");
    private static final Lookup.Result<ProjectFactory> factories = Lookup.getDefault().lookupResult(ProjectFactory.class);
    private static final ProjectManager DEFAULT = new ProjectManager();
    private static final Mutex MUTEX = new Mutex();
    private final Map<FileObject, Union2<Reference<Project>, LoadStatus>> dir2Proj = new WeakHashMap<FileObject, Union2<Reference<Project>, LoadStatus>>();
    private final Set<Project> modifiedProjects = new HashSet<Project>();
    private final Set<Project> removedProjects = new WeakSet();
    private final Map<Project, ProjectFactory> proj2Factory = new WeakHashMap<Project, ProjectFactory>();
    private final FileChangeListener projectDeletionListener = new ProjectDeletionListener();
    private ThreadLocal<Set<FileObject>> loadingThread = new ThreadLocal();

    private ProjectManager() {
        factories.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent e) {
                ProjectManager.this.clearNonProjectCache();
            }
        });
    }

    public static ProjectManager getDefault() {
        return DEFAULT;
    }

    public static Mutex mutex() {
        return MUTEX;
    }

    void reset() {
        this.dir2Proj.clear();
        this.modifiedProjects.clear();
        this.proj2Factory.clear();
    }

    public void deleteProject(Project p, FileObject dir) throws IOException {
        System.out.println("In delete project ");
        if (this.isModified(p)) {
            System.out.println("In delete project : The project was modified");
            this.saveProject(p);
        }
        System.out.println("In delete project : project saved");
        this.dir2Proj.put(dir, LoadStatus.NO_SUCH_PROJECT.wrap());
        System.out.println("In delete project : dir3proj is modified");
        System.out.println("In delete project : modified projects are being removed");
        this.modifiedProjects.remove(p);
        System.out.println("In delete project : modified projects are removed");
        this.proj2Factory.remove(p);
        System.out.println("In delete project : removed projects are from projec2factory");
    }

    public Project findProject(final FileObject projectDirectory) throws IOException, IllegalArgumentException {
        if (projectDirectory == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to findProject");
        }
        if (!projectDirectory.isFolder()) {
            throw new IllegalArgumentException("Attempted to pass a non-directory to findProject: " + projectDirectory);
        }
        try {
            return (Project)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Project>(){

                /*
                 * Exception decompiling
                 */
                public Project run() throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private Project createProject(FileObject dir) throws IOException {
        assert (dir != null);
        assert (dir.isFolder());
        assert (ProjectManager.mutex().isReadAccess());
        ProjectStateImpl state = new ProjectStateImpl();
        for (ProjectFactory factory : factories.allInstances()) {
            Project p = factory.loadProject(dir, state);
            if (p == null) continue;
            if (TIMERS.isLoggable(Level.FINE)) {
                LogRecord rec = new LogRecord(Level.FINE, "Project");
                rec.setParameters(new Object[]{p});
                TIMERS.log(rec);
            }
            this.proj2Factory.put(p, factory);
            state.attach(p);
            return p;
        }
        return null;
    }

    public boolean isProject(final FileObject projectDirectory) throws IllegalArgumentException {
        if (projectDirectory == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to isProject");
        }
        if (!projectDirectory.isFolder()) {
            if (projectDirectory.isValid()) {
                throw new IllegalArgumentException("Attempted to pass a non-directory to isProject: " + projectDirectory);
            }
            return false;
        }
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Boolean run() {
                Boolean bl;
                boolean resetLP;
                block17: {
                    Boolean bl2;
                    block16: {
                        Map map = ProjectManager.this.dir2Proj;
                        synchronized (map) {
                            Union2 o;
                            do {
                                if (!LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)(o = (Union2)ProjectManager.this.dir2Proj.get(projectDirectory)))) continue;
                                try {
                                    ProjectManager.this.dir2Proj.wait();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            } while (LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)o));
                            assert (!LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)o));
                            if (LoadStatus.NO_SUCH_PROJECT.is((Union2<Reference<Project>, LoadStatus>)o)) {
                                return false;
                            }
                            if (o != null) {
                                return true;
                            }
                            ProjectManager.this.dir2Proj.put(projectDirectory, LoadStatus.LOADING_PROJECT.wrap());
                        }
                        resetLP = false;
                        try {
                            boolean p = ProjectManager.this.checkForProject(projectDirectory);
                            Map map2 = ProjectManager.this.dir2Proj;
                            synchronized (map2) {
                                resetLP = true;
                                ProjectManager.this.dir2Proj.notifyAll();
                                if (p) {
                                    ProjectManager.this.dir2Proj.put(projectDirectory, LoadStatus.SOME_SUCH_PROJECT.wrap());
                                    bl2 = true;
                                    // MONITOREXIT @DISABLED, blocks:[2, 6, 15] lbl33 : MonitorExitStatement: MONITOREXIT : var3_6
                                    Object var7_9 = null;
                                    if (resetLP) return bl2;
                                    if ($assertionsDisabled || LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)((Union2)ProjectManager.this.dir2Proj.get(projectDirectory)))) break block16;
                                    throw new AssertionError();
                                }
                                ProjectManager.this.dir2Proj.put(projectDirectory, LoadStatus.NO_SUCH_PROJECT.wrap());
                                bl = false;
                            }
                            break block17;
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            if (resetLP) throw throwable;
                            assert (LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)((Union2)ProjectManager.this.dir2Proj.get(projectDirectory))));
                            ProjectManager.this.dir2Proj.remove(projectDirectory);
                            throw throwable;
                        }
                    }
                    ProjectManager.this.dir2Proj.remove(projectDirectory);
                    return bl2;
                }
                Object var7_10 = null;
                if (resetLP) return bl;
                assert (LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)((Union2)ProjectManager.this.dir2Proj.get(projectDirectory))));
                ProjectManager.this.dir2Proj.remove(projectDirectory);
                return bl;
            }
        });
    }

    private boolean checkForProject(FileObject dir) {
        assert (dir != null);
        assert (dir.isFolder()) : dir;
        assert (ProjectManager.mutex().isReadAccess());
        for (ProjectFactory factory : factories.allInstances()) {
            if (!factory.isProject(dir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNonProjectCache() {
        Map<FileObject, Union2<Reference<Project>, LoadStatus>> map = this.dir2Proj;
        synchronized (map) {
            this.dir2Proj.values().removeAll(Arrays.asList(LoadStatus.NO_SUCH_PROJECT.wrap(), LoadStatus.SOME_SUCH_PROJECT.wrap()));
        }
    }

    public Set<Project> getModifiedProjects() {
        return (Set)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Set<Project>>(){

            public Set<Project> run() {
                return new HashSet<Project>(ProjectManager.this.modifiedProjects);
            }
        });
    }

    public boolean isModified(final Project p) throws IllegalArgumentException {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Map map = ProjectManager.this.dir2Proj;
                synchronized (map) {
                    if (!ProjectManager.this.proj2Factory.containsKey(p)) {
                        System.out.println("In is modified project : throwing exception : was already deleted");
                        throw new IllegalArgumentException("Project " + p + " not created by " + ProjectManager.this + " or was already deleted");
                    }
                }
                return ProjectManager.this.modifiedProjects.contains(p);
            }
        });
    }

    public void saveProject(final Project p) throws IOException, IllegalArgumentException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (ProjectManager.this.removedProjects.contains(p)) {
                        return null;
                    }
                    if (!ProjectManager.this.proj2Factory.containsKey(p)) {
                        System.out.println("In save project : throwing exception : was already deleted");
                        throw new IllegalArgumentException("Project " + p + " not created by " + ProjectManager.this + " or was already deleted");
                    }
                    if (ProjectManager.this.modifiedProjects.contains(p)) {
                        ProjectFactory f = (ProjectFactory)ProjectManager.this.proj2Factory.get(p);
                        System.out.println("project factory i =" + f.getClass());
                        f.saveProject(p);
                        LOG.log(Level.FINE, "saveProject({0})", p.getProjectDirectory());
                        ProjectManager.this.modifiedProjects.remove(p);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            if (!p.getProjectDirectory().canWrite()) {
                throw new IOException("Project folder is not writeable.");
            }
            throw (IOException)e.getException();
        }
    }

    public void saveAllProjects() throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    Iterator it = ProjectManager.this.modifiedProjects.iterator();
                    while (it.hasNext()) {
                        Project p = (Project)it.next();
                        ProjectFactory f = (ProjectFactory)ProjectManager.this.proj2Factory.get(p);
                        assert (f != null) : p;
                        f.saveProject(p);
                        LOG.log(Level.FINE, "saveProject({0})", p.getProjectDirectory());
                        it.remove();
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public boolean isValid(final Project p) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Map map = ProjectManager.this.dir2Proj;
                synchronized (map) {
                    return ProjectManager.this.proj2Factory.containsKey(p);
                }
            }
        });
    }

    static /* synthetic */ ThreadLocal access$100(ProjectManager x0) {
        return x0.loadingThread;
    }

    static /* synthetic */ Project access$300(ProjectManager x0, FileObject x1) throws IOException {
        return x0.createProject(x1);
    }

    static /* synthetic */ FileChangeListener access$400(ProjectManager x0) {
        return x0.projectDeletionListener;
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fe) {
            Map map = ProjectManager.this.dir2Proj;
            synchronized (map) {
                ProjectManager.this.dir2Proj.remove(fe.getFile());
            }
        }
    }

    private final class ProjectStateImpl
    implements ProjectState {
        private Project p;

        private ProjectStateImpl() {
        }

        void attach(Project p) {
            assert (p != null);
            assert (this.p == null);
            this.p = p;
        }

        public void markModified() {
            assert (this.p != null);
            LOG.log(Level.FINE, "markModified({0})", this.p.getProjectDirectory());
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    if (!ProjectManager.this.proj2Factory.containsKey(ProjectStateImpl.this.p)) {
                        throw new IllegalStateException("An attempt to call ProjectState.markModified on a deleted project: " + ProjectStateImpl.this.p.getProjectDirectory());
                    }
                    ProjectManager.this.modifiedProjects.add(ProjectStateImpl.this.p);
                    return null;
                }
            });
        }

        public void notifyDeleted() throws IllegalStateException {
            assert (this.p != null);
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    if (ProjectManager.this.proj2Factory.get(ProjectStateImpl.this.p) == null) {
                        throw new IllegalStateException("An attempt to call notifyDeleted more than once. Project: " + ProjectStateImpl.this.p.getProjectDirectory());
                    }
                    ProjectManager.this.dir2Proj.remove(ProjectStateImpl.this.p.getProjectDirectory());
                    ProjectManager.this.proj2Factory.remove(ProjectStateImpl.this.p);
                    ProjectManager.this.modifiedProjects.remove(ProjectStateImpl.this.p);
                    ProjectManager.this.removedProjects.add(ProjectStateImpl.this.p);
                    Collection col = Lookup.getDefault().lookupAll(FileOwnerQueryImplementation.class);
                    for (FileOwnerQueryImplementation impl : col) {
                        if (!(impl instanceof SimpleFileOwnerQueryImplementation)) continue;
                        ((SimpleFileOwnerQueryImplementation)impl).resetLastFoundReferences();
                    }
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoadStatus {
        NO_SUCH_PROJECT,
        SOME_SUCH_PROJECT,
        LOADING_PROJECT;


        public boolean is(Union2<Reference<Project>, LoadStatus> o) {
            return o != null && o.hasSecond() && o.second() == this;
        }

        public Union2<Reference<Project>, LoadStatus> wrap() {
            return Union2.createSecond((Object)((Object)this));
        }
    }
}

